/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.BuildCommand;
import chemaxon.marvin.modelling.build.BuildCommandBase;
import chemaxon.marvin.modelling.build.BuildSequence;
import chemaxon.marvin.modelling.build.fafuse.FuseBuilder;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.myMolecule;

public class DirectFragmentBuildCommand
extends BuildCommand {
    myMolecule mol;
    myMolecule origmol;
    FuseBuilder builder;
    FuseBuilder.CleanParams actualParam;
    FuseBuilder.CleanPreferences cleanPref = null;
    BuildSequence.Build cmd = null;
    boolean cleanFailed = false;
    int[] selAtoms;
    int[] anchAtoms;
    boolean firstInvoke = true;
    boolean fallbackDoneToSFAST = false;
    boolean coordinatesGenerated = false;

    @Override
    BuildSequence.Build getCommand() {
        return this.cmd;
    }

    @Override
    boolean hasDirectBuildChildFailed() {
        return this.getState() == 2 && (this.getCoordinates() == null || this.getCoordinates().length == 0);
    }

    public DirectFragmentBuildCommand(BuildCommand parentCommand, CleanSettings settings, BuildSequence.Build cmd, debugPrintout debug) {
        super(settings);
        this.setParentCommand(parentCommand);
        this.cmd = cmd;
        this.actualParam = null;
        this.cleanPref = new FuseBuilder.CleanPreferences();
        this.selAtoms = cmd.getAtoms();
        this.anchAtoms = cmd.getAnchAtoms();
        this.origmol = cmd.getMol();
        if (debug != null) {
            debug.incLevel("Direct fragment build init");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Direct fragment build init");
        }
        this.mol = this.getFragment().getFragMol();
        if (debug != null) {
            debug.printBC("Molecule");
            this.mol.printout(debug);
        }
        this.builder = new FuseBuilder(this.mol, this.getFragment().getStereo());
        if (debug != null) {
            debug.decLevel();
            this.mol.placeApplet("Fragment");
        }
        this.disableFallback();
    }

    @Override
    void initProgressMonitor() {
    }

    private int invokeClean(int expectedConfs) {
        int ret = 0;
        int tracerid = -1;
        if (CleanArgs.cltracer != null) {
            tracerid = CleanArgs.cltracer.getNodeID();
            CleanArgs.cltracer.incDetail(10);
        }
        debugPrintout debug = CleanArgs.getDebug();
        ret = 2;
        while ((this.actualParam = this.cleanPref.iterateActualParam(this.actualParam, expectedConfs)) != null) {
            if (debug != null) {
                debug.printB("New iteration");
            }
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("New iteration on parameters");
                CleanArgs.verbose("Invoke makeCoords2()");
            }
            int cleanRes = this.builder.makeCoords2(this.actualParam, null, this.cleanSettings, true);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("MakeCoords2() returned with " + cleanRes);
            }
            if (debug != null && debug.getWillPrint()) {
                debug.printB("Cleaner result:");
                switch (cleanRes) {
                    case 1: {
                        debug.println("OK.");
                        debug.println("Max conf count reached: " + this.builder.isMaxConfCountReached());
                        break;
                    }
                    case 2: {
                        debug.println("FAILED.");
                        break;
                    }
                    case 3: {
                        debug.println("CANCELLED.");
                    }
                }
                debug.println("Max conf count reached: " + this.builder.isMaxConfCountReached());
            }
            ret = cleanRes;
            if (cleanRes == 2 && this.builder.isMaxConfCountReached()) continue;
            break;
        }
        if (debug != null) {
            debug.printB("Return status=" + ret);
        }
        if (CleanArgs.cltracer != null) {
            CleanArgs.cltracer.decDetail(tracerid);
        }
        return ret;
    }

    @Override
    myMolecule getOrigMol() {
        return this.origmol;
    }

    @Override
    int invokeBuild(int expectedConformers, BuildCommandBase.BuildEffort effort) {
        int clstate;
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("invokeBuild in direct fragment build");
        }
        if (this.cleanFailed) {
            return 2;
        }
        if (this.fallbackDoneToSFAST) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Fallback done to S{fast}=true; return state fail");
            }
            return 2;
        }
        if (CleanArgs.verboseLevel > 0) {
            CleanArgs.verbose("Invoking direct build.");
        }
        if ((clstate = this.invokeBuild_0(expectedConformers, effort)) == 1) {
            this.coordinatesGenerated = true;
        }
        if (clstate == 2) {
            this.cleanFailed = true;
        }
        if (clstate == 1 || clstate == 3) {
            return clstate;
        }
        return 2;
    }

    int invokeBuild_0(int expectedConformers, BuildCommandBase.BuildEffort effort) {
        if (this.firstInvoke) {
            this.firstInvoke = false;
        }
        this.builder.setOptimizationLimit(0.01);
        if (this.builder.getLastResult() != 0 && !this.builder.isMaxConfCountReached()) {
            return 2;
        }
        if (CleanArgs.verboseLevel > 0) {
            CleanArgs.verboseInc("Incoking Direct fragment build  - method invokeClean()");
        }
        int clstate = this.invokeClean(expectedConformers);
        if (CleanArgs.verboseLevel > 0) {
            CleanArgs.verboseDec("returned:" + clstate);
        }
        switch (clstate) {
            case 1: {
                this.registerCoordinates(this.builder.getCoordinates());
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        System.err.println("ERROR: wrong return state from invokeClean()");
        return 2;
    }
}

