/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.math.discrete.PermutationIterator;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.Iterator;

public class FindSubstitutions
implements Iterator {
    Molecule m;
    int[] frag1Atoms;
    int[] frag2Atoms;
    int[] commons;
    int[] frag1Subst;
    double[][][] frag1Coords;
    double[][][] frag2Coords;
    int[] mLabels = null;
    int[][] cTab = null;
    int[][] centers;
    int[][] centerInd;
    BitSet isCommon;
    BitSet isFrag1;
    BitSet isFrag2;
    BitSet isSubst;
    boolean topologyMode = true;
    boolean dummyMode = false;
    int[][] storedPermutations = null;
    int[] frag1Inv = null;
    PermutationIterator[] allPermutations;
    PermIter centerIt;
    SubstFrag result = new SubstFrag();
    int counter = 0;

    public FindSubstitutions(Molecule m, int[] frag1Atoms, int[] commons, int[] frag1Subst, double[][][] frag1Coords) {
        this.m = m;
        if (frag1Subst == null || frag1Subst.length < 2) {
            this.frag1Atoms = frag1Atoms;
            this.dummyMode = true;
        } else {
            this.frag1Atoms = frag1Atoms;
        }
        this.frag2Atoms = null;
        this.commons = commons;
        this.frag1Subst = frag1Subst;
        this.frag1Coords = frag1Coords;
        this.frag2Coords = null;
        this.init();
    }

    public FindSubstitutions(Molecule m, int[] frag1Atoms, int[] frag2Atoms, int[] commons, int[] frag1Subst, double[][][] frag1Coords, double[][][] frag2Coords) {
        this.m = m;
        this.dummyMode = frag1Subst == null || frag1Subst.length < 2;
        this.frag1Atoms = frag1Atoms;
        this.frag2Atoms = frag2Atoms;
        this.commons = commons;
        this.frag1Subst = frag1Subst;
        this.frag1Coords = frag1Coords;
        this.frag2Coords = frag2Coords;
        this.init();
    }

    BitSet fillBits(int len, int[] elements) {
        BitSet bSet = new BitSet(len);
        for (int i = 0; i < elements.length; ++i) {
            bSet.set(elements[i]);
        }
        return bSet;
    }

    void init() {
        this.cTab = this.m.getCtab();
        this.mLabels = new int[this.cTab.length];
        this.m.getGrinv(this.mLabels);
        this.isCommon = this.fillBits(this.m.getAtomCount(), this.commons);
        this.isFrag1 = this.fillBits(this.m.getAtomCount(), this.frag1Atoms);
        if (this.frag2Atoms != null) {
            this.isFrag2 = this.fillBits(this.m.getAtomCount(), this.frag2Atoms);
            this.topologyMode = false;
        }
        this.isSubst = this.fillBits(this.m.getAtomCount(), this.frag1Subst);
        int nCenter = 0;
        for (int i = 0; i < this.commons.length; ++i) {
            int iAt = this.commons[i];
            int nSubst = 0;
            for (int j = 0; j < this.cTab[iAt].length; ++j) {
                int jAt = this.cTab[iAt][j];
                if (!this.isFrag1.get(jAt)) {
                    System.err.println("Consistency error in FindSustitutions.");
                }
                if (!this.isSubst.get(jAt)) continue;
                ++nSubst;
            }
            if (nSubst <= true) continue;
            ++nCenter;
        }
        if (nCenter == 0) {
            this.dummyMode = true;
        } else {
            int i;
            this.centers = new int[nCenter][];
            this.centerInd = new int[nCenter][];
            this.allPermutations = new PermutationIterator[nCenter];
            this.storedPermutations = new int[nCenter][];
            int iCenter = 0;
            for (i = 0; i < this.commons.length; ++i) {
                int iAt = this.commons[i];
                int nSubst = 0;
                for (int j = 0; j < this.cTab[iAt].length; ++j) {
                    int jAt = this.cTab[iAt][j];
                    if (!this.isSubst.get(jAt)) continue;
                    ++nSubst;
                }
                if (nSubst <= true) continue;
                this.centers[iCenter] = new int[nSubst];
                this.allPermutations[iCenter] = new PermutationIterator(nSubst);
                this.centerInd[iCenter] = this.allPermutations[iCenter].next();
                int iSubst = 0;
                for (int j = 0; j < this.cTab[iAt].length; ++j) {
                    int jAt = this.cTab[iAt][j];
                    if (!this.isSubst.get(jAt)) continue;
                    this.centers[iCenter][iSubst] = jAt;
                    ++iSubst;
                }
                ++iCenter;
            }
            this.frag1Inv = new int[this.cTab.length];
            for (i = 0; i < this.frag1Inv.length; ++i) {
                this.frag1Inv[i] = -1;
            }
            for (i = 0; i < this.frag1Atoms.length; ++i) {
                this.frag1Inv[this.frag1Atoms[i]] = i;
            }
            this.centerIt = new PermIter();
            this.dummyMode = false;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.dummyMode) {
            return this.counter == 0;
        }
        return this.centerIt.hasNext();
    }

    public Object next() {
        if (this.dummyMode) {
            ++this.counter;
        } else {
            this.centerIt.next();
            for (int i = 0; i < this.centers.length; ++i) {
                for (int j = 0; j < this.centers[i].length; ++j) {
                    int cAt = this.centers[i][this.centerInd[i][j]];
                    int indx = this.frag1Inv[this.centers[i][j]];
                    this.frag1Atoms[indx] = cAt;
                }
            }
        }
        this.result.frag1Atoms = this.frag1Atoms;
        this.result.frag1Coords = this.frag1Coords;
        this.result.frag2Atoms = this.frag2Atoms;
        this.result.frag2Coords = this.frag2Coords;
        return this.result;
    }

    @Override
    public void remove() {
    }

    class PermIter
    implements Iterator {
        PermIter() {
        }

        @Override
        public boolean hasNext() {
            return FindSubstitutions.this.allPermutations[0].hasNext();
        }

        public Object next() {
            int nPerm = FindSubstitutions.this.allPermutations.length;
            int iPerm = nPerm - 1;
            while (!FindSubstitutions.this.allPermutations[iPerm].hasNext()) {
                --iPerm;
            }
            if (iPerm != nPerm - 1) {
                for (int i = iPerm + 1; i < nPerm; ++i) {
                    FindSubstitutions.this.allPermutations[i].reset();
                }
            }
            FindSubstitutions.this.centerInd[iPerm] = FindSubstitutions.this.allPermutations[iPerm].next();
            return FindSubstitutions.this.centerInd;
        }

        @Override
        public void remove() {
        }
    }

    public class SubstFrag {
        public int[] frag1Atoms;
        public int[] frag2Atoms;
        public double[][][] frag1Coords;
        public double[][][] frag2Coords;
    }
}

