/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.BuildCommand;
import chemaxon.marvin.modelling.build.BuildCommandBase;
import chemaxon.marvin.modelling.build.BuildCommandProxy;
import chemaxon.marvin.modelling.build.BuildSequence;
import chemaxon.marvin.modelling.build.DirectFragmentBuildCommand;
import chemaxon.marvin.modelling.build.FragFragFuseBuildCommand;
import chemaxon.marvin.modelling.build.OABuildCommand;
import chemaxon.marvin.modelling.debug.SimpleVerbosePrinter;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.diag.Instrumentation;
import chemaxon.marvin.modelling.interfacing.CalculationAbortedException;
import chemaxon.marvin.modelling.interfacing.CalculationFailedException;
import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.CxnMoleculeInput;
import chemaxon.marvin.modelling.interfacing.MultipleConformerResult;
import chemaxon.marvin.modelling.interfacing.MultipleConformersResultImpl;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.struc.MultiConformerImpl;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.myMolecule;
import java.util.Vector;

public class FragClean {
    static ThreadLocal<Vector<BuildCommand>> proxyTargetsTL = new ThreadLocal<Vector<BuildCommand>>(){

        @Override
        protected Vector<BuildCommand> initialValue() {
            return new Vector<BuildCommand>();
        }
    };

    public static MultipleConformerResult startCleanOnSingleFragment(CalculationInput in, CleanSettings settings, boolean invokeSingle) throws CalculationFailedException, CalculationAbortedException {
        CxnMoleculeInput moli = (CxnMoleculeInput)in;
        Fragment frag = moli.getSelMolFrag(true, settings);
        StereoCriteriaList stereo = frag.getStereo();
        VerbosePrinter vp = settings.getVerbosePrinter("startCleanOnSingleFragment()");
        debugPrintout debug = CleanArgs.getDebug();
        FragClean.getProxyTargets().clear();
        int genConfCount = settings.getGeneratedConformerCount();
        int reportedConfCount = settings.getReportedConformerCount();
        if (invokeSingle) {
            reportedConfCount = 1;
        }
        if (vp != null) {
            vp.print("Init fragment build tree");
        }
        if (debug != null) {
            debug.incLevel("Init fragment build tree");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verboseInc("Stereo requirements for fragment");
            if (stereo != null) {
                for (int j = 0; j < stereo.getSize(); ++j) {
                    CleanArgs.verbose(stereo.get(j).toString());
                }
            }
            CleanArgs.verboseDec("");
        }
        if (debug != null) {
            if (debug != null) {
                debug.println("Debug null " + (CleanArgs.getDebug() == null));
            }
            myMolecule mol = frag.getFragMol();
            mol.placeApplet("Molecule");
            if (debug != null) {
                debug.println("Debug null " + (CleanArgs.getDebug() == null));
            }
            debug.incLevel("Molecule details");
            if (debug != null) {
                debug.println("Debug null " + (CleanArgs.getDebug() == null));
            }
            mol.printout(debug);
            if (debug != null) {
                debug.println("Debug null " + (CleanArgs.getDebug() == null));
            }
            debug.decLevel();
        }
        if (debug != null) {
            debug.println("Invoke BuildSequence constructor");
        }
        BuildSequence seq = new BuildSequence(frag.getFragMol(), stereo, settings, true);
        if (debug != null) {
            debug.printBC("Build seq -> build tree");
        }
        BuildCommand cmd = FragClean.createRootBuildCommand(seq.getTree(), settings, frag.getFragMol(), debug);
        SimpleVerbosePrinter cap = settings.getVerbosePrinter(CleanSettings.Verbosers.CONFANAL);
        if (cap.isVerbosityLevelEnabled(1)) {
            cmd.setVerbosePrinter(cap);
        }
        if (debug != null) {
            debug.decLevel();
        }
        if (Clean3D.OPT_DEBUG_SKIPBUILD) {
            throw new CalculationFailedException();
        }
        if (debug != null) {
            debug.printBC("Start cleaning");
        }
        cmd.canFallFAST = true;
        cmd.setUseHBonds(true);
        cmd.setMinRMSD(settings.getFinalRMSDLimit());
        cmd.setDenergyLimit(settings.getFinalDEnergy());
        cmd.setOptLimit(settings.getOptLimitFinaloptValue());
        if (debug != null) {
            debug.println("Invoke startBuild in subtree");
        }
        BuildCommandBase.BuildEffort ef = new BuildCommandBase.BuildEffort(false, false, false, false, settings.getCanceller());
        int laststate = cmd.build(genConfCount, false, false, true, ef.HEAVYEST);
        if (laststate == 3) {
            throw new CalculationAbortedException();
        }
        if (laststate == 2) {
            throw new CalculationFailedException();
        }
        if (laststate == 1 && settings.isOptionHyperfineGiven()) {
            laststate = cmd.doHyperfine();
        }
        MultiConformerImpl mi = new MultiConformerImpl();
        mi.setCoordinates(cmd.getCoordinates());
        mi.setEnergies(cmd.getEnergies());
        mi.sortByEnergy();
        double[][][] c = mi.getCoordinates();
        int[] alist = cmd.getAtomList();
        double[][][] cp = new double[c.length][][];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = new double[c[i].length][];
            if (c[i].length != alist.length) {
                throw new UnsupportedOperationException();
            }
            for (int j = 0; j < cp[i].length; ++j) {
                cp[i][alist[j]] = c[i][j];
            }
        }
        double[] e = mi.getEnergies();
        int storedcount = c.length;
        if (reportedConfCount > 0) {
            storedcount = Math.min(reportedConfCount, cp.length);
        }
        MultipleConformersResultImpl ret = new MultipleConformersResultImpl(in, cp, e, moli.getAtomCount(), storedcount);
        if (vp != null) {
            vp.close();
        }
        return ret;
    }

    public static Vector<BuildCommand> getProxyTargets() {
        return proxyTargetsTL.get();
    }

    static BuildCommand createProxyBuildCommand(BuildCommand parent, CleanSettings settings, BuildSequence.ProxyBuild cmd, myMolecule mol, debugPrintout debug) {
        if (debug != null) {
            debug.println("Cerate Proxy");
        }
        BuildSequence.Build tc = cmd.getBase();
        BuildCommand bc = null;
        Vector<BuildCommand> proxyTargets = FragClean.getProxyTargets();
        for (int i = 0; i < proxyTargets.size(); ++i) {
            if (!proxyTargets.get(i).getCommand().equals(tc)) continue;
            bc = proxyTargets.get(i);
            break;
        }
        if (bc == null) {
            bc = FragClean.createBuildCommand(null, settings, tc, mol, debug);
            proxyTargets.add(bc);
        }
        BuildCommandProxy ret = new BuildCommandProxy(parent, bc, cmd);
        return ret;
    }

    static BuildCommand createDirectBuildCommand(BuildCommand parent, CleanSettings settings, BuildSequence.BuildFrag cmd, myMolecule mol, debugPrintout debug) {
        if (cmd.getOtherCommand() != null) {
            if (debug != null) {
                debug.println("Fragment query");
                cmd.printout(debug, mol);
            }
            return cmd.getOtherCommand();
        }
        DirectFragmentBuildCommand ret = new DirectFragmentBuildCommand(parent, settings, cmd, debug);
        return ret;
    }

    static BuildCommand createFuseBuildCommand(BuildCommand parent, CleanSettings settings, BuildSequence.BuildFuse cmd, myMolecule mol, debugPrintout debug) {
        int[] oa = cmd.getResolvedOA();
        int[][] ghosts = cmd.getGhostBonds();
        BuildCommand ret = null;
        if (oa != null && oa.length > 0 || ghosts != null && ghosts.length > 0) {
            if (debug != null) {
                debug.println("Resolve overlapping anch/ghost bonds");
            }
            if (settings.getInst() != null) {
                settings.getInst().addFlag(new Instrumentation.OABuildCommandFoundFlag());
            }
            ret = new OABuildCommand(parent, settings, cmd);
        } else {
            ret = new FragFragFuseBuildCommand(parent, settings, cmd, mol, debug);
        }
        return ret;
    }

    public static BuildCommand createBuildCommand(BuildCommand parent, CleanSettings settings, BuildSequence.Build cmd, myMolecule mol, debugPrintout debug) {
        if (BuildSequence.BuildFrag.class.isInstance(cmd)) {
            return FragClean.createDirectBuildCommand(parent, settings, (BuildSequence.BuildFrag)cmd, mol, debug);
        }
        if (BuildSequence.BuildFuse.class.isInstance(cmd)) {
            BuildSequence.BuildFuse f = (BuildSequence.BuildFuse)cmd;
            while (f.getRedirect() != null) {
                f = f.getRedirect();
            }
            return FragClean.createFuseBuildCommand(parent, settings, f, mol, debug);
        }
        if (BuildSequence.SimpleBuild.class.isInstance(cmd)) {
            return ((BuildSequence.SimpleBuild)cmd).getOtherCommand();
        }
        return FragClean.createProxyBuildCommand(parent, settings, (BuildSequence.ProxyBuild)cmd, mol, debug);
    }

    public static BuildCommand createRootBuildCommand(BuildSequence.Build cmd, CleanSettings settings, myMolecule mol, debugPrintout debug) {
        if (debug != null) {
            debug.printB("Create root build command");
            debug.print("<UL><LI>");
        }
        BuildCommand ret = FragClean.createBuildCommand(null, settings, cmd, mol, debug);
        if (debug != null) {
            debug.print("</UL>");
        }
        FragClean.getProxyTargets().clear();
        return ret;
    }
}

