/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.build.BuildCommand;
import chemaxon.marvin.modelling.build.BuildCommandBase;
import chemaxon.marvin.modelling.build.BuildSequence;
import chemaxon.marvin.modelling.build.FindSubstitutions;
import chemaxon.marvin.modelling.build.FragFragFuseBuildCommand;
import chemaxon.marvin.modelling.build.FuseFragments;
import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modelling.debug.Printouts;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.JQuatFit;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.struc.ConformerEquivalenceUtils;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.U;
import chemaxon.math.discrete.PermutationIterator;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.Vector;

public class FragFragFuser {
    boolean dontStore = true;
    double[][][] coords = null;
    myMolecule m;
    int[] frag1atoms;
    int[] frag2atoms;
    int[] resatoms;
    int[] fuseatoms;
    int[] anchors1;
    int[] anchors2;
    int[] anchors;
    int[] involved1;
    int[] involved2;
    int[][] involvedLists = null;
    int[][] matchList = null;
    double[][][] coords1;
    double[][][] coords2;
    boolean multiFit = false;
    Vector frg1CoordsVec = new Vector();
    Vector frg2CoordsVec = new Vector();
    Vector fusedCoordsVec = new Vector();
    double bestFit = -1.0;
    int frg1actualCoord = -1;
    int frg1CoordSize = 0;
    boolean frg1Failed = false;
    boolean frg1FailedFlag = false;
    BuildCommandBase.BuildEffort frg1FailedEffort = null;
    int frg2actualCoord = -1;
    int frg2CoordSize = 0;
    boolean frg2Failed = false;
    boolean frg2FailedFlag = false;
    BuildCommandBase.BuildEffort frg2FailedEffort = null;
    int actualFusedCoord = 0;
    int lastReportedFusedCoord = -1;
    boolean frg1Requested = false;
    BitSet parityCenters = null;
    int nParities = 0;
    int[][] matchParityDef = null;
    Molecule frg1Mol = null;
    Molecule frg2Mol = null;
    Molecule resMol = null;
    boolean singleAtomFuse = false;
    int[][] singleAtomFusePositions = null;
    boolean partialSuccess = false;
    double fitLimitSc = 7.0;
    double fitLimit = 0.01;
    BuildCommand frag1cmd = null;
    BuildCommand frag2cmd = null;
    FragFragFuseBuildCommand hostcmd = null;

    public FragFragFuser(BuildCommand frag1cmd, BuildCommand frag2cmd, FragFragFuseBuildCommand hostcmd, BitSet parityCenters) {
        debugPrintout debug;
        int i;
        int i2;
        this.frag1cmd = frag1cmd;
        this.frag2cmd = frag2cmd;
        this.hostcmd = hostcmd;
        this.m = hostcmd.getOrigMol();
        this.frag1atoms = frag1cmd.getAtomList();
        this.frag2atoms = frag2cmd.getAtomList();
        this.resatoms = hostcmd.getAtomList();
        BuildSequence.BuildFuse cmd = (BuildSequence.BuildFuse)hostcmd.getCommand();
        this.fuseatoms = cmd.getFuseAtoms();
        this.anchors1 = cmd.getAnc1();
        this.anchors2 = cmd.getAnc2();
        this.anchors = cmd.getAnchAtoms();
        this.parityCenters = parityCenters;
        this.involvedLists = new int[2][this.m.a];
        for (i2 = 0; i2 < this.involvedLists[0].length; ++i2) {
            this.involvedLists[0][i2] = -1;
            this.involvedLists[1][i2] = -1;
        }
        for (i2 = 0; i2 < this.frag1atoms.length; ++i2) {
            this.involvedLists[0][this.frag1atoms[i2]] = i2;
        }
        for (i2 = 0; i2 < this.frag2atoms.length; ++i2) {
            this.involvedLists[1][this.frag2atoms[i2]] = i2;
        }
        int nInvolved = 0;
        for (i = 0; i < this.involvedLists[0].length; ++i) {
            if (this.involvedLists[0][i] < 0 || this.involvedLists[1][i] < 0) continue;
            ++nInvolved;
        }
        this.matchList = new int[2][nInvolved];
        nInvolved = 0;
        for (i = 0; i < this.involvedLists[0].length; ++i) {
            if (this.involvedLists[0][i] < 0 || this.involvedLists[1][i] < 0) continue;
            this.matchList[0][nInvolved] = this.involvedLists[0][i];
            this.matchList[1][nInvolved] = this.involvedLists[1][i];
            ++nInvolved;
        }
        this.involved1 = this.matchList[0];
        this.involved2 = this.matchList[1];
        this.frg1Mol = frag1cmd.getFragment().getFragMol().getOriginalMolCopy();
        this.frg2Mol = frag2cmd.getFragment().getFragMol().getOriginalMolCopy();
        this.resMol = hostcmd.getFragment().getFragMol().getOriginalMolCopy();
        if (this.frg1Mol.getAtomCount() == this.resMol.getAtomCount() || this.frg2Mol.getAtomCount() == this.resMol.getAtomCount()) {
            this.singleAtomFusePositions = this.checkSingleAtomFuse();
            this.singleAtomFuse = this.singleAtomFusePositions != null;
        }
        this.nParities = 0;
        if (!this.singleAtomFuse) {
            int[] centers = new int[this.involved1.length];
            MolAtom[] frg1Atoms = this.frg1Mol.getAtomArray();
            for (int i3 = 0; i3 < this.involved1.length; ++i3) {
                int nConnected = 0;
                for (int j = 0; j < this.involved1.length; ++j) {
                    if (i3 == j || !frg1Atoms[this.involved1[i3]].isBoundTo(frg1Atoms[this.involved1[j]])) continue;
                    ++nConnected;
                }
                if (nConnected != 3 && nConnected != 4) continue;
                centers[this.nParities] = i3;
                ++this.nParities;
            }
            if (this.nParities > 0) {
                this.matchParityDef = new int[this.nParities][4];
                block7: for (int k = 0; k < this.nParities; ++k) {
                    int i4;
                    this.matchParityDef[k][0] = i4 = centers[k];
                    int nConnected = 0;
                    for (int j = 0; j < this.involved1.length; ++j) {
                        if (i4 == j) continue;
                        if (frg1Atoms[this.involved1[i4]].isBoundTo(frg1Atoms[this.involved1[j]])) {
                            this.matchParityDef[k][++nConnected] = j;
                        }
                        if (nConnected == 3) continue block7;
                    }
                }
            }
        }
        if ((debug = CleanArgs.getDebug()) != null) {
            debug.incLevel("FragFragFuser constructor invoked");
            this.m.placeApplet("The original structure");
            this.m.placeApplets("The descriptor tables", new String[]{U.sel(this.frag1atoms), U.sel(frag1cmd.getCommand().getNonAnchAtoms()), U.sel(this.anchors1), U.sel(this.frag2atoms), U.sel(frag2cmd.getCommand().getNonAnchAtoms()), U.sel(this.anchors2), U.sel(this.resatoms), U.sel(this.fuseatoms), U.sel(this.anchors), U.sel(U.collectSets(parityCenters))}, new String[]{"Frag1 atoms", "Frag1 non anchors", "Anchors in frag1", "Frag2 atoms", "Frag2 non anchors", "Anchors in frag2", "Fused fragment atoms", "Common (fuse) atoms", "Anchors in fused", "Parity centers"});
            debug.incLevel("Frag1 mol");
            frag1cmd.getFragment().getFragMol().printout(debug);
            debug.decLevel();
            debug.incLevel("Frag2 mol");
            frag2cmd.getFragment().getFragMol().printout(debug);
            debug.decLevel();
            debug.decLevel();
        }
    }

    boolean isPartialSuccess() {
        return this.partialSuccess;
    }

    int invokeBuild(int expectedConformers, BuildCommandBase.BuildEffort effort) {
        boolean newConformersFound = false;
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.printB("FragFragFuser.invokeBuild()");
            debug.printBC("nextFuses()");
        }
        this.actualFusedCoord = this.lastReportedFusedCoord;
        int state = 1;
        while (state == 1 && this.actualFusedCoord - this.lastReportedFusedCoord == 0) {
            int estConfs = (int)Math.ceil(Math.sqrt(expectedConformers));
            if (estConfs < 1) {
                estConfs = 1;
            }
            estConfs = 1;
            state = this.nextFuse(estConfs, effort);
        }
        if (debug != null) {
            // empty if block
        }
        int nReport = this.actualFusedCoord - this.lastReportedFusedCoord;
        if (state == 3) {
            return state;
        }
        if (nReport > 0) {
            this.coords = new double[nReport][][];
            double[] energies = new double[nReport];
            FuseCoord frg = (FuseCoord)this.fusedCoordsVec.elementAt(this.lastReportedFusedCoord + 1);
            int indStore = 0;
            for (int i = 1; i <= nReport; ++i) {
                int indx = this.lastReportedFusedCoord + i;
                frg = (FuseCoord)this.fusedCoordsVec.elementAt(indx);
                this.coords[indStore] = frg.coord;
                ++indStore;
            }
            if (this.dontStore) {
                this.fusedCoordsVec = new Vector();
                this.actualFusedCoord = -1;
            }
            this.lastReportedFusedCoord = this.actualFusedCoord;
            this.hostcmd.registerCoordinates(this.coords);
            return 1;
        }
        return 2;
    }

    public FragFragFuser(myMolecule m, int[] frag1atoms, int[] frag2atoms, int[] resatoms, int[] fuseatoms, int[] anchors1, int[] anchors2, int[] anchors, double[][][] coords1, double[][][] coords2) {
        this.anchors = anchors;
        this.anchors1 = anchors1;
        this.anchors2 = anchors2;
        this.coords1 = (double[][][])coords1.clone();
        this.coords2 = (double[][][])coords2.clone();
        this.frag1atoms = frag1atoms;
        this.frag2atoms = frag2atoms;
        this.fuseatoms = fuseatoms;
        this.m = m;
        this.resatoms = resatoms;
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            String s;
            int j;
            int i;
            debug.incLevel("FragFragFuser constructor invoked");
            m.placeApplet("The original structure");
            m.placeApplets("The descriptor tables", new String[]{U.sel(frag1atoms), U.sel(frag2atoms), U.sel(resatoms), U.sel(fuseatoms), U.sel(anchors1), U.sel(anchors2), U.sel(anchors)}, new String[]{"Frag1 atoms", "Frag2 atoms", "Fused fragment atoms", "Common (fuse) atoms", "Anchors in frag1", "Anchors in frag2", "Anchors in fused"});
            Printouts.place3DApplet("Frag1 (anchors/commons)", m.getOriginalMolCopy(), frag1atoms, anchors1, fuseatoms, coords1, anchors1);
            Printouts.place3DApplet("Frag2 (anchors/commons)", m.getOriginalMolCopy(), frag2atoms, anchors2, fuseatoms, coords2, anchors2);
            debug.incLevel("Frag1 coordinates");
            debug.Tstart();
            debug.Trow();
            debug.TprintBC("Atom");
            for (i = 0; i < coords1.length; ++i) {
                debug.TprintB("Conf " + i);
            }
            for (i = 0; i < coords1[0].length; ++i) {
                debug.Trow();
                debug.TprintBC("" + i);
                for (j = 0; j < coords1.length; ++j) {
                    s = TextUtils.formatNumber(coords1[j][i][0]) + "<BR>" + TextUtils.formatNumber(coords1[j][i][1]) + "<BR>" + TextUtils.formatNumber(coords1[j][i][2]);
                    debug.Tprint(s);
                }
            }
            debug.Tstop();
            debug.decLevel();
            debug.incLevel("Frag2 coordinates");
            debug.Tstart();
            debug.Trow();
            debug.TprintBC("Atom");
            for (i = 0; i < coords2.length; ++i) {
                debug.TprintB("Conf " + i);
            }
            for (i = 0; i < coords2[0].length; ++i) {
                debug.Trow();
                debug.TprintBC("" + i);
                for (j = 0; j < coords2.length; ++j) {
                    s = TextUtils.formatNumber(coords2[j][i][0]) + "<BR>" + TextUtils.formatNumber(coords2[j][i][1]) + "<BR>" + TextUtils.formatNumber(coords2[j][i][2]);
                    debug.Tprint(s);
                }
            }
            debug.Tstop();
            debug.decLevel();
            debug.decLevel();
        }
    }

    private int nextFuse(int estConfs, BuildCommandBase.BuildEffort effort) {
        boolean doNextFuse = false;
        boolean success = false;
        this.partialSuccess = false;
        int[] inv1 = this.involved1;
        int[] inv2 = this.involved2;
        if (this.singleAtomFuse) {
            inv1 = this.singleAtomFusePositions[0];
            inv2 = this.singleAtomFusePositions[1];
        }
        Runtime rt = Runtime.getRuntime();
        long used_memory = rt.totalMemory() - rt.freeMemory();
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Check overrides " + this.frg1FailedFlag + " " + this.frg2FailedFlag);
            if (this.frg1FailedFlag && this.frg1FailedEffort != null) {
                CleanArgs.verbose(this.frg1FailedEffort.toString());
                CleanArgs.verbose(effort.toString());
            }
        }
        if (this.frg1FailedFlag && this.frg1FailedEffort != null && this.frg1FailedEffort.isNarrowerThan(effort)) {
            this.frg1FailedFlag = false;
            this.frg1FailedEffort = null;
            this.frg1Requested = false;
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Override failed 1");
            }
        }
        if (this.frg2FailedFlag && this.frg2FailedEffort != null && this.frg2FailedEffort.isNarrowerThan(effort)) {
            this.frg2FailedFlag = false;
            this.frg2FailedEffort = null;
            this.frg1Requested = true;
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Override failed 2");
            }
        }
        while (!this.frg1Failed || !this.frg2Failed) {
            int p;
            boolean parityOK;
            int k;
            FuseCoord frg;
            int j;
            int nStore;
            if (CleanArgs.doVerbose(2)) {
                CleanArgs.verbose("Loop in nextFuse." + this.frg1actualCoord + " " + this.frg1CoordSize + " " + this.frg1CoordsVec.size() + " " + this.frg2actualCoord + " " + this.frg2CoordSize + " " + this.frg2CoordsVec.size() + " " + this.frg1Requested + " " + this.frg1Failed + " " + this.frg2Failed);
            }
            if (this.frg1actualCoord == this.frg1CoordsVec.size() - 1 && this.frg2actualCoord == this.frg2CoordsVec.size() - 1 && success) {
                return 1;
            }
            if (this.hostcmd.isCancelled()) {
                if (CleanArgs.verboseLevel > 0) {
                    CleanArgs.verbose("Fragment was cancelled...");
                }
                return 3;
            }
            if (success && 2L * (rt.totalMemory() - rt.freeMemory() - used_memory) > rt.totalMemory() - used_memory) {
                if (CleanArgs.verboseLevel > 0) {
                    CleanArgs.verbose("Calling garbage collector...");
                }
                rt.gc();
                used_memory = Math.min(rt.totalMemory() - rt.freeMemory(), used_memory);
            }
            if (success && (this.fusedCoordsVec.size() >= 81 || 2L * (rt.totalMemory() - rt.freeMemory() - used_memory) > rt.totalMemory() - used_memory)) {
                if (this.fusedCoordsVec.size() < 81 && CleanArgs.verboseLevel > 0) {
                    CleanArgs.verbose("Used memory is: " + (rt.totalMemory() - rt.freeMemory()) + " of " + rt.totalMemory());
                    CleanArgs.verbose("Reporing " + this.fusedCoordsVec.size() + " conformer(s).");
                }
                this.partialSuccess = true;
                return 1;
            }
            if (this.frg1Requested) {
                ++this.frg2actualCoord;
                if (this.frg2actualCoord >= this.frg2CoordSize) {
                    this.frg2actualCoord = this.frg2CoordSize++;
                    this.frg1actualCoord = -1;
                    this.frg1Requested = false;
                    if (this.frg2CoordSize <= this.frg2CoordsVec.size()) continue;
                    if (this.frg2CoordsVec.size() != 0 && this.frg1CoordSize < this.frg1CoordsVec.size()) {
                        this.frg2actualCoord = -1;
                        this.frg2CoordSize = this.frg2CoordsVec.size();
                        this.frg1actualCoord = this.frg1CoordSize++;
                        this.frg1Requested = true;
                        continue;
                    }
                    int state = 0;
                    if (!this.frg2Failed) {
                        state = this.frag2cmd.build(estConfs, effort);
                        if (state != 1) {
                            this.frg2FailedFlag = true;
                            this.frg2FailedEffort = effort;
                        }
                    } else {
                        state = 2;
                    }
                    if (state == 3) {
                        return 3;
                    }
                    if (state == 1) {
                        this.coords2 = this.frag2cmd.getMoreCoordinates();
                        for (int i = 0; i < this.coords2.length; ++i) {
                            double[][][] fuseCoords = ConformerEquivalenceUtils.getFuseCoordinatePositions(this.frag2cmd.getFragment().getFragMol().getOriginalMolCopy(), this.coords2[i], inv2);
                            if (fuseCoords == null) {
                                if (this.frg2CoordsVec.size() != 0) continue;
                                return 2;
                            }
                            int[] refParities = null;
                            nStore = 0;
                            for (j = 0; j < fuseCoords.length; ++j) {
                                frg = new FuseCoord();
                                frg.m = this.frag2cmd.getFragment().getFragMol().getOriginalMolCopy();
                                frg.coord = fuseCoords[j];
                                if (this.nParities > 0) {
                                    if (refParities == null && this.parityCenters != null && this.frg2CoordsVec.size() > 0) {
                                        FuseCoord refFrg = (FuseCoord)this.frg2CoordsVec.elementAt(0);
                                        refParities = refFrg.actualParities;
                                    }
                                    frg.actualParities = new int[this.nParities];
                                    for (k = 0; k < this.nParities; ++k) {
                                        frg.actualParities[k] = FragFragFuser.generalizedParity(frg.coord[this.matchList[1][this.matchParityDef[k][0]]], frg.coord[this.matchList[1][this.matchParityDef[k][1]]], frg.coord[this.matchList[1][this.matchParityDef[k][2]]], frg.coord[this.matchList[1][this.matchParityDef[k][3]]]);
                                        if (frg.actualParities[k] == 0 || FragFragFuser.usefulParity(frg, this.matchList[1][this.matchParityDef[k][0]])) continue;
                                        frg.actualParities[k] = 0;
                                    }
                                    if (refParities != null) {
                                        parityOK = true;
                                        for (p = 0; p < this.nParities; ++p) {
                                            if (frg.actualParities[p] * refParities[p] >= 0 || !this.parityCenters.get(this.frag2atoms[this.matchList[1][this.matchParityDef[p][0]]])) continue;
                                            parityOK = false;
                                            break;
                                        }
                                        if (!parityOK) continue;
                                    }
                                }
                                ++nStore;
                                this.frg2CoordsVec.addElement(frg);
                            }
                        }
                        continue;
                    }
                    if (this.frg2CoordsVec.size() == 0) {
                        return 2;
                    }
                    --this.frg2CoordSize;
                    this.frg2Failed = true;
                    this.frg2FailedEffort = effort;
                    if (this.frg1Failed) continue;
                    this.frg2actualCoord = -1;
                    this.frg1actualCoord = this.frg1CoordSize - 1;
                    continue;
                }
            } else {
                ++this.frg1actualCoord;
                if (this.frg1actualCoord >= this.frg1CoordSize) {
                    this.frg1actualCoord = this.frg1CoordSize++;
                    this.frg2actualCoord = -1;
                    this.frg1Requested = true;
                    if (this.frg1CoordSize <= this.frg1CoordsVec.size()) continue;
                    if (this.frg1CoordsVec.size() != 0 && this.frg2CoordSize < this.frg2CoordsVec.size()) {
                        this.frg1actualCoord = -1;
                        this.frg1CoordSize = this.frg1CoordsVec.size();
                        this.frg2actualCoord = this.frg2CoordSize++;
                        this.frg1Requested = false;
                        continue;
                    }
                    int state = 0;
                    if (!this.frg1Failed) {
                        state = this.frag1cmd.build(estConfs, effort);
                        if (state != 1) {
                            this.frg1FailedFlag = true;
                            this.frg1FailedEffort = effort;
                        }
                    } else {
                        state = 2;
                    }
                    if (state == 3) {
                        return 3;
                    }
                    if (state == 1) {
                        this.coords1 = this.frag1cmd.getMoreCoordinates();
                        for (int i = 0; i < this.coords1.length; ++i) {
                            double[][][] fuseCoords = ConformerEquivalenceUtils.getFuseCoordinatePositions(this.frag1cmd.getFragment().getFragMol().getOriginalMolCopy(), this.coords1[i], inv1);
                            if (fuseCoords == null) {
                                if (this.frg1CoordsVec.size() != 0) continue;
                                return 2;
                            }
                            int[] refParities = null;
                            nStore = 0;
                            for (j = 0; j < fuseCoords.length; ++j) {
                                frg = new FuseCoord();
                                frg.m = this.frag1cmd.getFragment().getFragMol().getOriginalMolCopy();
                                frg.coord = fuseCoords[j];
                                if (this.nParities > 0) {
                                    if (refParities == null && this.parityCenters != null && this.frg1CoordsVec.size() > 0) {
                                        FuseCoord refFrg = (FuseCoord)this.frg1CoordsVec.elementAt(0);
                                        refParities = refFrg.actualParities;
                                    }
                                    frg.actualParities = new int[this.nParities];
                                    for (k = 0; k < this.nParities; ++k) {
                                        frg.actualParities[k] = FragFragFuser.generalizedParity(frg.coord[this.matchList[0][this.matchParityDef[k][0]]], frg.coord[this.matchList[0][this.matchParityDef[k][1]]], frg.coord[this.matchList[0][this.matchParityDef[k][2]]], frg.coord[this.matchList[0][this.matchParityDef[k][3]]]);
                                        if (frg.actualParities[k] == 0 || FragFragFuser.usefulParity(frg, this.matchList[0][this.matchParityDef[k][0]])) continue;
                                        frg.actualParities[k] = 0;
                                    }
                                    if (refParities != null) {
                                        parityOK = true;
                                        for (p = 0; p < this.nParities; ++p) {
                                            if (frg.actualParities[p] * refParities[p] >= 0 || !this.parityCenters.get(this.frag1atoms[this.matchList[0][this.matchParityDef[p][0]]])) continue;
                                            parityOK = false;
                                            break;
                                        }
                                        if (!parityOK) continue;
                                    }
                                }
                                ++nStore;
                                this.frg1CoordsVec.addElement(frg);
                            }
                        }
                        continue;
                    }
                    if (this.frg1CoordsVec.size() == 0) {
                        return 2;
                    }
                    --this.frg1CoordSize;
                    this.frg1Failed = true;
                    this.frg1FailedEffort = effort;
                    if (this.frg2Failed) continue;
                    this.frg1actualCoord = -1;
                    this.frg2actualCoord = this.frg2CoordSize - 1;
                    continue;
                }
            }
            FuseCoord frg1 = (FuseCoord)this.frg1CoordsVec.elementAt(this.frg1actualCoord);
            FuseCoord frg2 = (FuseCoord)this.frg2CoordsVec.elementAt(this.frg2actualCoord);
            if (this.nParities > 0) {
                for (int i = 0; i < this.nParities; ++i) {
                    if (frg1.actualParities[i] * frg2.actualParities[i] >= 0) continue;
                    doNextFuse = true;
                    break;
                }
                if (doNextFuse) {
                    doNextFuse = false;
                    continue;
                }
            }
            FuseCoord resFrg = new FuseCoord();
            resFrg.coord = new double[this.resatoms.length][3];
            resFrg.m = this.hostcmd.getFragment().getFragMol().getOriginalMolCopy();
            resFrg.fitQuality = this.singleAtomFuse ? this.makeSingleAtomFuse((FuseCoord)this.frg1CoordsVec.elementAt(this.frg1actualCoord), (FuseCoord)this.frg2CoordsVec.elementAt(this.frg2actualCoord), resFrg, inv1, inv2, this.frg1Mol.getAtom(inv1[0]).getAtno() == 1) : this.makeFuse((FuseCoord)this.frg1CoordsVec.elementAt(this.frg1actualCoord), (FuseCoord)this.frg2CoordsVec.elementAt(this.frg2actualCoord), resFrg);
            if (this.bestFit == -1.0 || resFrg.fitQuality < this.bestFit && resFrg.fitQuality > this.fitLimit) {
                this.bestFit = Math.max(resFrg.fitQuality, this.fitLimit);
                for (int i = this.lastReportedFusedCoord + 1; i <= this.actualFusedCoord; ++i) {
                    FuseCoord chkFrg = (FuseCoord)this.fusedCoordsVec.elementAt(i);
                    if (!(chkFrg.fitQuality > this.fitLimitSc * this.bestFit)) continue;
                    this.fusedCoordsVec.removeElementAt(i);
                    if (CleanArgs.verboseLevel > 1) {
                        System.err.println("Remove fit!!! " + chkFrg.fitQuality + " > " + this.fitLimitSc * this.bestFit);
                    }
                    --i;
                    --this.actualFusedCoord;
                }
                ++this.actualFusedCoord;
                this.fusedCoordsVec.addElement(resFrg);
                success = true;
            } else if (resFrg.fitQuality > this.fitLimitSc * this.bestFit) {
                if (CleanArgs.verboseLevel > 1) {
                    System.err.println("Wrong fit: " + resFrg.fitQuality + " > " + this.fitLimitSc * this.bestFit);
                }
                if (!success) {
                    continue;
                }
            } else {
                ++this.actualFusedCoord;
                this.fusedCoordsVec.addElement(resFrg);
                success = true;
            }
            if (this.frg1actualCoord != this.frg1CoordsVec.size() - 1 || this.frg2actualCoord != this.frg2CoordsVec.size() - 1 || !success) continue;
            return 1;
        }
        return 2;
    }

    private double makeSingleAtomFuse(FuseCoord frg1, FuseCoord frg2, FuseCoord resFrg, int[] inv1, int[] inv2, boolean first) {
        double[][] coord = null;
        double[][] coord2 = null;
        int at1 = -1;
        int at1C = -1;
        int at2 = -1;
        int at2C = -1;
        int ind = 1;
        if (first) {
            ind = 0;
            coord = U.clone(frg1.coord);
            coord2 = frg2.coord;
            at1 = inv1[0];
            at1C = inv1[1];
            at2 = inv2[0];
            at2C = inv2[1];
        } else {
            coord = U.clone(frg2.coord);
            coord2 = frg1.coord;
            at1 = inv2[0];
            at1C = inv2[1];
            at2 = inv1[0];
            at2C = inv1[1];
        }
        this.setBondLength(coord[at1], coord[at1C], coord2[at2], coord2[at2C]);
        for (int i = 0; i < this.resatoms.length; ++i) {
            int iAt = this.involvedLists[ind][this.resatoms[i]];
            resFrg.coord[i][0] = coord[iAt][0];
            resFrg.coord[i][1] = coord[iAt][1];
            resFrg.coord[i][2] = coord[iAt][2];
        }
        return 0.0;
    }

    private double makeFuse(FuseCoord frg1, FuseCoord frg2, FuseCoord resFrg) {
        int i;
        double[][] coord1 = U.clone(frg1.coord);
        double[][] coord2 = U.clone(frg2.coord);
        double[][] weight = new double[][]{new double[coord1.length], new double[coord2.length]};
        for (i = 0; i < weight[0].length; ++i) {
            weight[0][i] = 0.5;
        }
        for (i = 0; i < weight[1].length; ++i) {
            weight[1][i] = 0.5;
        }
        int[][] cTab1 = frg1.m.getCtab();
        int[][] cTab2 = frg2.m.getCtab();
        for (int i2 = 0; i2 < this.matchList[0].length; ++i2) {
            int at1 = this.matchList[0][i2];
            int at2 = this.matchList[1][i2];
            int at1Type = frg1.m.getAtom(at1).getAtno();
            int at2Type = frg2.m.getAtom(at2).getAtno();
            if (at1Type == 1 && at1Type != at2Type && cTab1[this.matchList[0][i2]].length == 1) {
                int at1C = cTab1[at1][0];
                int at2C = this.involvedLists[1][this.frag1atoms[at1C]];
                weight[0][at1] = 0.0;
                weight[1][at2] = 1.0;
                this.setBondLength(coord1[at1], coord1[at1C], coord2[at2], coord2[at2C]);
            }
            if (at2Type != 1 || at2Type == at1Type || cTab2[this.matchList[1][i2]].length != 1) continue;
            int at2C = cTab2[at2][0];
            int at1C = this.involvedLists[0][this.frag2atoms[at2C]];
            weight[1][at2] = 0.0;
            weight[0][at1] = 1.0;
            this.setBondLength(coord2[at2], coord2[at2C], coord1[at1], coord1[at1C]);
        }
        JQuatFit qf = new JQuatFit(coord1);
        double fit = qf.quatfit(coord2, this.matchList);
        for (int i3 = 0; i3 < this.resatoms.length; ++i3) {
            int iAt1 = this.involvedLists[0][this.resatoms[i3]];
            int iAt2 = this.involvedLists[1][this.resatoms[i3]];
            if (iAt1 >= 0 && iAt2 >= 0) {
                resFrg.coord[i3][0] = coord1[iAt1][0] * weight[0][iAt1] + coord2[iAt2][0] * weight[1][iAt2];
                resFrg.coord[i3][1] = coord1[iAt1][1] * weight[0][iAt1] + coord2[iAt2][1] * weight[1][iAt2];
                resFrg.coord[i3][2] = coord1[iAt1][2] * weight[0][iAt1] + coord2[iAt2][2] * weight[1][iAt2];
                continue;
            }
            if (iAt1 >= 0) {
                resFrg.coord[i3][0] = coord1[iAt1][0];
                resFrg.coord[i3][1] = coord1[iAt1][1];
                resFrg.coord[i3][2] = coord1[iAt1][2];
                continue;
            }
            resFrg.coord[i3][0] = coord2[iAt2][0];
            resFrg.coord[i3][1] = coord2[iAt2][1];
            resFrg.coord[i3][2] = coord2[iAt2][2];
        }
        if (CleanArgs.doVerbose(2)) {
            ErrPrint.errPrint("Fragment #0:", frg1.m, coord1);
            ErrPrint.errPrint("Fragment #1:", frg2.m, coord2);
            ErrPrint.errPrint("Fragment #0:", resFrg.m, resFrg.coord);
        }
        return fit;
    }

    void setBondLength(double[] c1, double[] cC1, double[] c2, double[] cC2) {
        double[] b = new double[c1.length];
        double l1 = 0.0;
        double l2 = 0.0;
        for (int i = 0; i < c1.length; ++i) {
            b[i] = c1[i] - cC1[i];
            l1 += b[i] * b[i];
            l2 += (c2[i] - cC2[i]) * (c2[i] - cC2[i]);
        }
        double sc = Math.sqrt(l2 / l1);
        for (int i = 0; i < c1.length; ++i) {
            c1[i] = cC1[i] + sc * b[i];
        }
    }

    int[] inverseIndeces(int len, int[] ind) {
        int i;
        int[] inverseInd = new int[len];
        for (i = 0; i < len; ++i) {
            inverseInd[i] = -1;
        }
        for (i = 0; i < ind.length; ++i) {
            inverseInd[ind[i]] = i;
        }
        return inverseInd;
    }

    int[][] substIndeces(int[][] cTab, int[] fragAtoms, int[] inverseInd, int[] anchors) {
        int i;
        int[][] sIndeces = null;
        Vector<int[]> substVec = new Vector<int[]>();
        BitSet selected = new BitSet(cTab.length);
        for (i = 0; i < fragAtoms.length; ++i) {
            selected.set(fragAtoms[i]);
        }
        for (i = 0; i < anchors.length; ++i) {
            int iA = anchors[i];
            int a0 = inverseInd[iA];
            int nNeighbors = 0;
            int a1 = -1;
            for (int j = 0; j < cTab[iA].length; ++j) {
                int jA = cTab[iA][j];
                if (!selected.get(jA)) continue;
                ++nNeighbors;
                a1 = inverseInd[jA];
            }
            if (nNeighbors != true) continue;
            int[] indPair = new int[]{a1, a0};
            substVec.add(indPair);
        }
        sIndeces = new int[substVec.size()][4];
        for (i = 0; i < substVec.size(); ++i) {
            int[] indPair = (int[])substVec.get(i);
            sIndeces[i][0] = indPair[0];
            sIndeces[i][1] = indPair[1];
        }
        return sIndeces;
    }

    void fillRestSubst(int[][] substInd, int[] fragAtoms, int[] inverseOther) {
        for (int i = 0; i < substInd.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                int s;
                int a = substInd[i][j];
                int mA = fragAtoms[a];
                substInd[i][j + 2] = s = inverseOther[mA];
            }
        }
    }

    int fillCommon(int shift, int[] common, int[] inverseInd1, int[] inverseInd2, int[][] commonPairs) {
        for (int i = 0; i < common.length; ++i) {
            int a0 = inverseInd1[common[i]];
            int a1 = inverseInd2[common[i]];
            commonPairs[0] = U.appendUnique(commonPairs[0], a0);
            commonPairs[1] = U.appendUnique(commonPairs[1], a1);
        }
        return shift + commonPairs[0].length;
    }

    public boolean doFuse() {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("doFuse() method");
        }
        if (debug != null) {
            debug.println("do magic here...");
        }
        int[][] cTab = this.m.getCtab();
        int[][] subst1 = null;
        int[][] subst2 = null;
        int[] frag1atomsSave = this.frag1atoms;
        int[] frag2atomsSave = this.frag2atoms;
        Vector<double[][]> coordStore = new Vector<double[][]>();
        Printouts.place3DApplet("Frag1 before FindSubstitutions (anchors/commons)", this.m.getOriginalMolCopy(), this.frag1atoms, this.anchors1, this.fuseatoms, this.coords1, this.anchors1);
        FindSubstitutions findTopologyOKFrags = new FindSubstitutions(this.m.getOriginalMolCopy(), this.frag1atoms, this.fuseatoms, this.anchors1, this.coords1);
        if (debug != null) {
            debug.println("findTopologyOKFrags.dummyMode: " + findTopologyOKFrags.dummyMode);
            if (!findTopologyOKFrags.dummyMode) {
                debug.println("findTopologyOKFrags.centers.length: " + findTopologyOKFrags.centers.length);
            }
        }
        while (findTopologyOKFrags.hasNext()) {
            FindSubstitutions.SubstFrag s1Frag = (FindSubstitutions.SubstFrag)findTopologyOKFrags.next();
            this.frag1atoms = s1Frag.frag1Atoms;
            this.coords1 = s1Frag.frag1Coords;
            int[] frag1Ind = this.inverseIndeces(cTab.length, this.frag1atoms);
            Printouts.place3DApplet("Frag2 before FindSubstitutions (anchors/commons)", this.m.getOriginalMolCopy(), this.frag2atoms, this.anchors2, this.fuseatoms, this.coords2, this.anchors2);
            FindSubstitutions findGeomOKFrags = new FindSubstitutions(this.m.getOriginalMolCopy(), this.frag2atoms, this.frag1atoms, this.fuseatoms, this.anchors2, this.coords2, this.coords1);
            while (findGeomOKFrags.hasNext()) {
                int i;
                int j;
                int i2;
                int commonLen = 0;
                FindSubstitutions.SubstFrag s2Frag = (FindSubstitutions.SubstFrag)findGeomOKFrags.next();
                this.frag1atoms = s2Frag.frag2Atoms;
                this.coords1 = s2Frag.frag2Coords;
                this.frag2atoms = s2Frag.frag1Atoms;
                this.coords2 = s2Frag.frag1Coords;
                Printouts.place3DApplet("Frag1 FindSubstitutions (anchors/commons)", this.m.getOriginalMolCopy(), this.frag1atoms, this.anchors1, this.fuseatoms, this.coords1, this.anchors1);
                Printouts.place3DApplet("Frag2 FindSubstitutions (anchors/commons)", this.m.getOriginalMolCopy(), this.frag2atoms, this.anchors2, this.fuseatoms, this.coords2, this.anchors2);
                int[] frag2Ind = this.inverseIndeces(cTab.length, this.frag2atoms);
                if (this.anchors1 != null) {
                    subst1 = this.substIndeces(cTab, this.frag1atoms, frag1Ind, this.anchors1);
                    this.fillRestSubst(subst1, this.frag1atoms, frag2Ind);
                    if (debug != null) {
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("Subst#");
                        for (i2 = 0; i2 < 4; ++i2) {
                            debug.TprintBC("" + i2);
                        }
                        for (i2 = 0; i2 < subst1.length; ++i2) {
                            debug.Trow();
                            debug.TprintBC("" + i2);
                            for (j = 0; j < 4; ++j) {
                                debug.Tprint("" + subst1[i2][j]);
                            }
                        }
                        debug.Tstop();
                        Printouts.place3DApplet("frag1 before subst", this.m.getOriginalMolCopy(), this.frag1atoms, this.coords1);
                    }
                    FuseFragments.doSubstitutions(this.coords1, this.coords2[0], subst1);
                    if (debug != null) {
                        Printouts.place3DApplet("frag1 after subst", this.m.getOriginalMolCopy(), this.frag1atoms, this.coords1);
                    }
                }
                if (this.anchors2 != null) {
                    subst2 = this.substIndeces(cTab, this.frag2atoms, frag2Ind, this.anchors2);
                    this.fillRestSubst(subst2, this.frag2atoms, frag1Ind);
                    if (debug != null) {
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("Subst2#");
                        for (i2 = 0; i2 < 4; ++i2) {
                            debug.TprintBC("" + i2);
                        }
                        for (i2 = 0; i2 < subst2.length; ++i2) {
                            debug.Trow();
                            debug.TprintBC("" + i2);
                            for (j = 0; j < 4; ++j) {
                                debug.Tprint("" + subst2[i2][j]);
                            }
                        }
                        debug.Tstop();
                        Printouts.place3DApplet("frag2 before subst", this.m.getOriginalMolCopy(), this.frag2atoms, this.coords2);
                    }
                    FuseFragments.doSubstitutions(this.coords2, this.coords1[0], subst2);
                    if (debug != null) {
                        Printouts.place3DApplet("frag2 after subst", this.m.getOriginalMolCopy(), this.frag2atoms, this.coords2);
                    }
                }
                int[][] common = new int[2][0];
                for (int i3 = 0; i3 < common[0].length; ++i3) {
                    common[0][i3] = -1;
                    common[1][i3] = -1;
                }
                int shift = 0;
                shift = this.fillCommon(shift, this.fuseatoms, frag1Ind, frag2Ind, common);
                if (debug != null) {
                    debug.println("common #1:");
                    debug.printVector(common[0]);
                    debug.printVector(common[1]);
                }
                if (this.anchors1 != null) {
                    shift = this.fillCommon(shift, this.anchors1, frag1Ind, frag2Ind, common);
                    if (debug != null) {
                        debug.println("common #2:");
                        debug.printVector(common[0]);
                        debug.printVector(common[1]);
                    }
                }
                if (this.anchors2 != null) {
                    shift = this.fillCommon(shift, this.anchors2, frag1Ind, frag2Ind, common);
                    if (debug != null) {
                        debug.println("common #3:");
                        debug.printVector(common[0]);
                        debug.printVector(common[1]);
                    }
                }
                commonLen = shift;
                double[][][] coordsTmp = FuseFragments.simpleFit(this.coords1, this.coords2, common, this.multiFit);
                if (debug != null) {
                    Printouts.place3DApplet("frag1 after qFit", this.m.getOriginalMolCopy(), this.frag1atoms, this.coords1, this.anchors1);
                    Printouts.place3DApplet("frag2 after qFit", this.m.getOriginalMolCopy(), this.frag2atoms, this.coords2, this.anchors2);
                }
                int[] tmpInd = new int[this.frag2atoms.length];
                BitSet commonFlag = new BitSet(this.frag2atoms.length);
                for (int i4 = 0; i4 < common[1].length; ++i4) {
                    commonFlag.set(common[1][i4]);
                }
                int indx = 0;
                for (int i5 = 0; i5 < tmpInd.length; ++i5) {
                    tmpInd[i5] = -1;
                    if (commonFlag.get(i5)) continue;
                    tmpInd[i5] = indx + this.frag1atoms.length;
                    ++indx;
                }
                int[] resInd = new int[this.resatoms.length];
                for (i = 0; i < this.resatoms.length; ++i) {
                    if (frag1Ind[this.resatoms[i]] != -1) {
                        resInd[i] = frag1Ind[this.resatoms[i]];
                        continue;
                    }
                    int ind1 = frag2Ind[this.resatoms[i]];
                    resInd[i] = tmpInd[ind1];
                }
                if (debug != null) {
                    debug.println("fuseAtoms");
                    debug.printVector(this.fuseatoms);
                    debug.println("frag1:");
                    debug.printVector(this.frag1atoms);
                    debug.println("frag1 inverse:");
                    debug.printVector(frag1Ind);
                    debug.println("anchors1:");
                    debug.printVector(this.anchors1);
                    debug.println("frag1 common:");
                    debug.printVector(common[0]);
                    debug.println("frag2:");
                    debug.printVector(this.frag2atoms);
                    debug.println("frag2 inverse:");
                    debug.printVector(frag2Ind);
                    debug.println("anchors2:");
                    debug.printVector(this.anchors2);
                    debug.println("frag2 common:");
                    debug.printVector(common[1]);
                    debug.println("result:");
                    debug.printVector(this.resatoms);
                    debug.println("tmpInd:");
                    debug.printVector(tmpInd);
                    debug.println("resInd:");
                    debug.printVector(resInd);
                }
                if (coordsTmp[0].length != this.resatoms.length) {
                    System.err.println("Consistency error in FragFragFuser:" + coordsTmp[0].length + "!=" + this.resatoms.length);
                }
                for (i = 0; i < coordsTmp.length; ++i) {
                    double[][] cRes = new double[coordsTmp[0].length][];
                    for (int j2 = 0; j2 < this.resatoms.length; ++j2) {
                        cRes[j2] = coordsTmp[i][resInd[j2]];
                    }
                    coordStore.add(cRes);
                }
            }
        }
        this.coords = new double[coordStore.size()][][];
        for (int i = 0; i < coordStore.size(); ++i) {
            this.coords[i] = (double[][])coordStore.get(i);
        }
        Printouts.place3DApplet("Fused results)", this.m.getOriginalMolCopy(), this.resatoms, this.anchors1, this.fuseatoms, this.coords, this.anchors2);
        this.frag1atoms = frag1atomsSave;
        this.frag2atoms = frag2atomsSave;
        if (debug != null) {
            debug.decLevel();
        }
        return true;
    }

    public double[][][] getCoords() {
        return this.coords;
    }

    static int generalizedParity(double[] c1, double[] c2, double[] c3, double[] c4) {
        double v2Len;
        int res = 0;
        double small = 1.0E-15;
        double[] v1 = V.minus(c2, c1);
        double[] v2 = V.minus(c3, c1);
        double[] v3 = V.minus(c4, c1);
        double v1Len = Math.sqrt(V.dot(v1));
        double sc = v1Len * (v2Len = Math.sqrt(V.dot(v2)));
        if (sc < small) {
            return res;
        }
        double s = V.dot(v1, v2) / sc;
        if (Math.abs(s) > 0.9) {
            return res;
        }
        double[] vv = V.vectProd(V.scale(v1, 1.0 / v1Len, v1), V.scale(v2, 1.0 / v2Len, v2));
        double v3Len = Math.sqrt(V.dot(v3));
        double dRes = V.dot(vv, v3) / v3Len;
        if (Math.abs(dRes) < 0.1) {
            return res;
        }
        res = dRes > 0.0 ? 1 : -1;
        return res;
    }

    static boolean usefulParity(FuseCoord frg, int iAt) {
        Molecule m = frg.m;
        int[][] cTab = m.getCtab();
        if (cTab[iAt].length != 4) {
            return false;
        }
        PermutationIterator p = new PermutationIterator(4);
        while (p.hasNext()) {
            int ap2;
            int[] ligands = p.next();
            for (int j = 0; j < 4; ++j) {
                ligands[j] = cTab[iAt][ligands[j]];
            }
            int ap1 = FragFragFuser.generalizedParity(frg.coord[iAt], frg.coord[ligands[0]], frg.coord[ligands[1]], frg.coord[ligands[2]]);
            if (ap1 * (ap2 = FragFragFuser.generalizedParity(frg.coord[iAt], frg.coord[ligands[0]], frg.coord[ligands[1]], frg.coord[ligands[3]])) == -1) continue;
            return false;
        }
        return true;
    }

    private int[][] checkSingleAtomFuse() {
        Molecule[] m = new Molecule[]{this.frg1Mol, this.frg2Mol};
        int[][][] cTabs = new int[][][]{m[0].getCtab(), m[1].getCtab()};
        int[][] position0 = null;
        int[][] position1 = null;
        int count0 = 0;
        int count1 = 0;
        for (int i = 0; i < this.matchList[0].length; ++i) {
            int j;
            MolAtom[] atoms = new MolAtom[]{m[0].getAtom(this.matchList[0][i]), m[1].getAtom(this.matchList[1][i])};
            if (atoms[0].getAtno() == 1 && cTabs[0][this.matchList[0][i]].length == 1 && atoms[1].getAtno() != 1 && cTabs[1][this.matchList[1][i]].length == 1) {
                position0 = new int[2][2];
                for (j = 0; j < 2; ++j) {
                    position0[j][0] = this.matchList[j][i];
                    position0[j][1] = cTabs[j][this.matchList[j][i]][0];
                }
                ++count0;
            }
            if (atoms[1].getAtno() != 1 || cTabs[1][this.matchList[1][i]].length != 1 || atoms[0].getAtno() == 1 || cTabs[0][this.matchList[0][i]].length != 1) continue;
            position1 = new int[2][2];
            for (j = 0; j < 2; ++j) {
                position1[j][0] = this.matchList[j][i];
                position1[j][1] = cTabs[j][this.matchList[j][i]][0];
            }
            ++count1;
        }
        if (count0 == 1 && this.frg1Mol.getAtomCount() == this.resMol.getAtomCount()) {
            return position0;
        }
        if (count1 == 1 && this.frg2Mol.getAtomCount() == this.resMol.getAtomCount()) {
            return position1;
        }
        return null;
    }

    class FuseCoord {
        public Molecule m = null;
        public double[][] coord = null;
        public double fitQuality = 0.0;
        public double energy = 0.0;
        public int[] actualParities = null;

        FuseCoord() {
        }
    }
}

