/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.calculations.clean.Optimization;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.FragmentAtomFinalItem;
import chemaxon.marvin.modelling.build.FragmentAtomFuseItem;
import chemaxon.marvin.modelling.build.FragmentStore;
import chemaxon.marvin.modelling.build.FuseCommandSequence;
import chemaxon.marvin.modelling.build.WishList;
import chemaxon.marvin.modelling.build.WishListItem;
import chemaxon.marvin.modelling.debug.CleanDebug;
import chemaxon.marvin.modelling.debug.Printouts;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.M;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.linalg.multiDim;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.IntegerBuffer;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import chemaxon.marvin.modelling.util.U;
import chemaxon.marvin.modelling.util.myList;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.BitSet;

public class FragmentAtomFuseStore {
    public FragmentStore frags = null;
    public FuseCommandSequence seq = null;
    public WishList wl = null;
    public int[] fragmentAtomList = null;
    public int[] atomToFragmentA = null;
    public int[] finalCoordArrayAtoms = null;
    public int conformers = 0;
    public int atomNo;
    public int fragNo;
    public int maxVariants = 0;
    public myList nodes = null;
    public myList finals = null;
    private Fragment frag = null;

    public double getDistanceM(WishListItem w, int c, FragmentAtomFuseItem a) {
        return w.getDistanceM(c, this.frags.coords[a.confNo], null, this.frags.seq.mol, this.frags.getMetric(a.confNo, w.getTargetAtom()), this.atomToFragmentA);
    }

    public double[] getFragmentMetric(FragmentAtomFuseItem aup) {
        return this.frags.getMetric(aup.confNo, this.fragmentAtomList[0]);
    }

    public double[] getAtomCoord(int a1, FragmentAtomFuseItem aup) {
        int afnum = this.atomToFragmentA[a1];
        if (afnum < 0) {
            return null;
        }
        int d = 0;
        double[] r = new double[d += this.frags.dims[aup.confNo][a1]];
        for (int i = 0; i < this.frags.dims[aup.confNo][a1]; ++i) {
            r[i] = this.frags.coords[aup.confNo].getV(a1, i);
        }
        return r;
    }

    public int proximityCheck(FragmentAtomFuseItem aup, double[] acoord, double mres, WishList wl, BitSet msp, BitSet cp, BitSet mp, double[] mc, debugPrintout debug) {
        int i;
        int i2;
        if (debug != null) {
            debug.incLevel("Proximity check invoked");
            debug.printBC("Proximity check");
        }
        if (acoord == null) {
            acoord = aup.coord;
        }
        if (cp != null) {
            for (i2 = 0; i2 < this.fragmentAtomList.length; ++i2) {
                cp.clear(i2);
            }
        }
        if (mp != null) {
            for (i2 = 0; i2 < this.fragmentAtomList.length; ++i2) {
                mp.clear(i2);
            }
        }
        if (mc != null) {
            if (mc.length < this.fragmentAtomList.length) {
                System.err.println("CONSISTENCY: mc vector too sort.");
            }
            for (i2 = 0; i2 < this.fragmentAtomList.length; ++i2) {
                mc[i2] = 0.0;
            }
        }
        int ret = 0;
        if (msp == null) {
            msp = new BitSet(this.fragmentAtomList.length);
        } else {
            for (i = 0; i < this.fragmentAtomList.length; ++i) {
                msp.clear(i);
            }
        }
        if (debug != null) {
            debug.printBC("Fill and check metrid set pattern");
        }
        int pw = aup.getProcessedWishes();
        for (i = 0; i < pw; ++i) {
            int fan;
            int ta;
            WishListItem w;
            int wn = aup.getProcessedWish(i);
            if (wn < 0) {
                System.err.println("CONSISTENCY: WN<0 in proximity check.");
            }
            if ((w = wl.getWish(wn)) == null) {
                System.err.println("CONSISTENCY: w == null in proximity check.");
            }
            if ((ta = w.getTargetAtom()) < 0 || ta >= this.atomToFragmentA.length) {
                System.err.println("CONSISTENCY: target atom out of range.");
            }
            if ((fan = this.atomToFragmentA[ta]) < 0) {
                System.err.println("CONSISTENCY: target atom is not in the fragment!");
            }
            msp.set(fan);
            double mreq = this.getDistanceM(w, aup.getChoice(i), aup);
            double mpres = V.dotUsingMetric(V.minus(this.getAtomCoord(ta, aup), acoord), aup.base.getM()) + mres;
            if (mc != null) {
                mc[fan] = mreq - mpres;
            }
            if (Math.abs(mreq - mpres) > 1.0E-4) {
                ret |= 2;
                if (mp != null) {
                    mp.set(fan);
                }
            }
            if (debug == null) continue;
            debug.Tstart();
            debug.Trow();
            debug.TprintBC(3, "Processed wish:");
            debug.Trow();
            debug.Tprint("");
            debug.TprintBC("#");
            debug.Tprint("" + i);
            debug.Trow();
            debug.Tprint("");
            debug.TprintBC("Target atom");
            debug.Tprint("" + ta);
            debug.Trow();
            debug.Tprint("");
            debug.TprintBC("Fragment atom");
            debug.Tprint("" + fan);
            debug.Trow();
            debug.Tprint("");
            debug.TprintBC("Mreq");
            debug.Tprint("" + mreq);
            debug.Trow();
            debug.Tprint("");
            debug.TprintBC("Mpres");
            debug.Tprint("" + mpres);
            debug.Tstop();
            debug.println("");
        }
        if (debug != null) {
            debug.printBC("Check proximity");
        }
        for (i = 0; i < this.fragmentAtomList.length; ++i) {
            double mpres;
            if (msp.get(i) || !((mpres = V.dotUsingMetric(V.minus(this.getAtomCoord(this.fragmentAtomList[i], aup), acoord), aup.base.getM()) + mres) < Clean3D.OPT_CP_MINMET)) continue;
            ret |= 1;
            if (mc != null) {
                mc[i] = Clean3D.OPT_CP_MINMET - mpres;
            }
            if (cp != null) {
                cp.set(i);
            }
            if (!(mpres < 1.0E-4)) continue;
            ret |= 4;
        }
        if (debug != null) {
            debug.decLevel();
        }
        return ret;
    }

    public FragmentAtomFuseStore(FragmentStore fstore, FuseCommandSequence seq, WishList wishl, int anum, int fnum, int varno) {
        this.nodes = new myList(varno);
        this.finals = new myList(varno);
        this.frags = fstore;
        this.seq = seq;
        this.wl = wishl;
        this.atomNo = anum;
        this.fragNo = fnum;
        this.maxVariants = varno;
        this.fragmentAtomList = seq.getAtomsForCommand(this.fragNo);
        this.atomToFragmentA = seq.getAtomsToFragAtomsTable(this.fragmentAtomList);
        if (this.fragmentAtomList.length > 0) {
            this.conformers = this.frags.confs[this.fragmentAtomList[0]];
        }
    }

    public void initStore(boolean Hin2, boolean Hin3) {
        for (int i = 0; i < this.conformers; ++i) {
            FragmentAtomFuseItem li = new FragmentAtomFuseItem(i, this.wl.getSize());
            li.Hin2Hgroup = Hin2;
            li.Hin3Hgroup = Hin3;
            this.nodes.add(li);
            li.storeID = this.nodes.size() - 1;
        }
    }

    public int[] getFinalCoordArrayAtoms() {
        if (this.finalCoordArrayAtoms != null) {
            return this.finalCoordArrayAtoms;
        }
        int fragatoms = this.fragmentAtomList.length;
        int[] ret = new int[fragatoms + 1];
        for (int i = 0; i < fragatoms; ++i) {
            ret[i] = this.fragmentAtomList[i];
        }
        ret[ret.length - 1] = this.atomNo;
        this.finalCoordArrayAtoms = ret;
        return ret;
    }

    private void fillMoleculeFragmentCoordinates(FragmentAtomFinalItem a, int c, double[] v) {
        int[] ap = this.getFinalCoordArrayAtoms();
        if (ap.length * 3 != v.length) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < ap.length; ++i) {
            int j;
            int an = this.atomToFragmentA[ap[i]];
            double[] co = null;
            co = an < 0 ? this.getFinalAtomCoord(a, c) : this.getFinalFragmentCoord(a, c, an);
            for (j = 0; j < 3 && j < co.length; ++j) {
                v[3 * i + j] = co[j];
            }
            for (j = co.length; j < 3; ++j) {
                v[3 * i + j] = 0.0;
            }
        }
    }

    public void fillMoleculeFragmentCoordinates(FragmentAtomFinalItem a, int c, myMolecule m) {
        double[] v = new double[3 * this.getFinalCoordArrayAtoms().length];
        this.fillMoleculeFragmentCoordinates(a, c, v);
        for (int i = 0; i < v.length; ++i) {
            m.coord[i / 3][i % 3] = v[i];
        }
    }

    public Fragment getFragment(StereoCriteriaList molstereo, CleanSettings settings) {
        if (this.frag == null) {
            debugPrintout debug = CleanArgs.getDebug();
            int[] fca = this.getFinalCoordArrayAtoms();
            int[] fcainv = U.genInverse(fca, this.frags.seq.mol.a);
            if (debug != null) {
                debug.incLevel("Construct stereo");
                debug.println("finalCoordArrayAtoms: " + U.sel(fca));
                debug.println("fcainv: " + U.sel(fcainv));
            }
            StereoCriteriaList fragstereo = molstereo.cloneWithProjection(fcainv, null, null, debug);
            if (debug != null) {
                debug.decLevel();
            }
            this.frag = new Fragment(this.frags.seq.mol, fca, null, fragstereo, settings);
        }
        return this.frag;
    }

    public double[][] getFinalCoordArray(FragmentAtomFinalItem a, int c) {
        int fragatoms = this.fragmentAtomList.length;
        int dims = this.getFinalAtomDim(a);
        double[][] ret = new double[fragatoms + 1][dims];
        for (int i = 0; i < fragatoms; ++i) {
            V.copyV(ret[i], this.getFinalFragmentCoord(a, c, i));
        }
        V.copyV(ret[ret.length - 1], this.getFinalAtomCoord(a, c));
        return ret;
    }

    public double[][] getFinalCoordArray3D(FragmentAtomFinalItem a, int c) {
        int fragatoms = this.fragmentAtomList.length;
        int dims = 3;
        double[][] ret = new double[fragatoms + 1][3];
        for (int i = 0; i < fragatoms; ++i) {
            V.copyV(ret[i], this.getFinalFragmentCoord(a, c, i));
        }
        double[] v = this.getFinalAtomCoord(a, c);
        if (v.length != 3) {
            System.err.println("Non3D structure");
        }
        V.copyV(ret[ret.length - 1], v);
        return ret;
    }

    public double getFinalMetridSum(FragmentAtomFinalItem a, int c) {
        double[] M2 = this.getFinalMetric(a);
        double[][] ca = this.getFinalCoordArray(a, c);
        double sum = 0.0;
        for (int a1 = 0; a1 < ca.length; ++a1) {
            for (int a2 = a1 + 1; a2 < ca.length; ++a2) {
                double m = V.dotUsingMetric(V.minus(ca[a1], ca[a2]), M2);
                sum += m;
            }
        }
        return sum;
    }

    public int getFinalSize() {
        return this.finals.size();
    }

    public int getSize() {
        return this.nodes.size();
    }

    public FragmentAtomFinalItem getFinal(int i) {
        return (FragmentAtomFinalItem)this.finals.get(i);
    }

    public FragmentAtomFinalItem getLastFinal() {
        return this.getFinal(this.getFinalSize() - 1);
    }

    public int getFuseSystemRealDim(FragmentAtomFuseItem aup) {
        int maxd = -1;
        for (int i = -1; i < this.fragmentAtomList.length; ++i) {
            double[] c = null;
            c = i == -1 ? aup.getCoordinates() : this.frags.getCoordinate(aup.confNo, this.fragmentAtomList[i]);
            int d = 0;
            for (int j = 0; j < c.length; ++j) {
                if (c[j] == 0.0) continue;
                d = j;
            }
            if (d <= maxd) continue;
            maxd = d;
        }
        return maxd + 1;
    }

    public double[] getFinalAtomCoord(FragmentAtomFinalItem a, int c) {
        FragmentAtomFuseItem aup = this.get(a.no);
        switch (a.state) {
            case 1: {
                return aup.getCoordinates();
            }
            case 2: {
                return V.plus(aup.getCoordinates(), a.orthoBase.linearCombine(a.orthoC.getV(c)));
            }
            case 3: 
            case 4: {
                int i;
                double[] ret = new double[aup.dim + a.extrac.getD()];
                double[] ac = aup.getCoordinates();
                for (i = 0; i < aup.dim; ++i) {
                    ret[i] = ac[i];
                }
                for (i = 0; i < a.extrac.getD(); ++i) {
                    ret[aup.dim + i] = (double)(a.state == 4 && c == 1 ? -1 : 1) * a.extraAtomC[i];
                }
                return ret;
            }
            case 5: {
                return a.optimizedC[a.optimizedC.length - 1];
            }
        }
        return null;
    }

    public int getFinalAtomDim(FragmentAtomFinalItem a) {
        FragmentAtomFuseItem aup = this.get(a.no);
        switch (a.state) {
            case 1: 
            case 2: {
                return aup.dim;
            }
            case 3: 
            case 4: {
                return aup.dim + a.extrac.getD();
            }
            case 5: {
                return a.optimizedM.length;
            }
        }
        return -1;
    }

    public double[] getFinalFragmentCoord(FragmentAtomFinalItem a, int c, int n) {
        FragmentAtomFuseItem aup = this.get(a.no);
        switch (a.state) {
            case 1: 
            case 2: {
                return this.frags.getCoordinate(aup.confNo, this.fragmentAtomList[n]);
            }
            case 3: 
            case 4: {
                int i;
                double[] ret = new double[aup.dim + a.extrac.getD()];
                double[] fc = this.frags.coords[aup.confNo].getV(this.fragmentAtomList[n]);
                for (i = 0; i < aup.dim; ++i) {
                    ret[i] = fc[i];
                }
                for (i = 0; i < a.extrac.getD(); ++i) {
                    ret[aup.dim + i] = (double)(a.state == 4 && c == 1 ? -1 : 1) * a.extrac.getV(n, i);
                }
                return ret;
            }
            case 5: {
                return a.optimizedC[n];
            }
        }
        return null;
    }

    public double[] getFinalFragmentCoord(FragmentAtomFinalItem a, int c, int n, multiDim s) {
        FragmentAtomFuseItem aup = this.get(a.no);
        switch (a.state) {
            case 1: 
            case 2: {
                double[] ret = new double[aup.dim];
                double[] fc = s.getV(n);
                for (int i = 0; i < aup.dim; ++i) {
                    ret[i] = fc[i];
                }
                return ret;
            }
            case 3: 
            case 4: {
                int i;
                double[] ret = new double[aup.dim + a.extrac.getD()];
                double[] fc = s.getV(n);
                for (i = 0; i < aup.dim; ++i) {
                    ret[i] = fc[i];
                }
                for (i = 0; i < a.extrac.getD(); ++i) {
                    ret[aup.dim + i] = (double)(a.state == 4 && c == 1 ? -1 : 1) * a.extrac.getV(n, i);
                }
                return ret;
            }
            case 5: {
                return a.optimizedC[n];
            }
        }
        return null;
    }

    public double[] getFinalMetric(FragmentAtomFinalItem a) {
        FragmentAtomFuseItem aup = this.get(a.no);
        switch (a.state) {
            case 1: 
            case 2: {
                return aup.base.getM();
            }
            case 3: 
            case 4: {
                int i;
                double[] ret = new double[aup.dim + a.extrac.getD()];
                double[] mv = aup.base.getM();
                for (i = 0; i < aup.dim; ++i) {
                    ret[i] = mv[i];
                }
                for (i = 0; i < a.extrac.getD(); ++i) {
                    ret[aup.dim + i] = a.extrac.getM(i);
                }
                return ret;
            }
            case 5: {
                return a.optimizedM;
            }
        }
        return null;
    }

    public FragmentAtomFuseItem get(int i) {
        return (FragmentAtomFuseItem)this.nodes.get(i);
    }

    public static void mPlace1D(double mres, int n, double[] mcorr, multiDim newc, double[] acoord) {
        double beta;
        newc.n = n;
        newc.d = 1;
        if (mres > 0.0) {
            newc.putM(0, 1.0);
        } else {
            newc.putM(0, -1.0);
        }
        double alpha = (double)(-1 / (n + 1)) * Math.sqrt(Math.abs(mres));
        acoord[0] = beta = Math.sqrt(Math.abs(mres)) + alpha;
        for (int i = 0; i < n; ++i) {
            newc.putV(i, 0, alpha);
        }
    }

    public static void mPlace2D(double mres, int n, double[] mcorr, multiDim newc, double[] acoord) {
        newc.n = n;
        newc.d = 2;
        newc.putM(0, 1.0);
        newc.putM(1, -1.0);
        if (Math.abs(mres) < 1.0E-4) {
            double alpha = 0.0;
            for (int i = 0; i < n; ++i) {
                double d = mcorr[i];
                alpha += d * d;
            }
            double p = Math.sqrt(Math.sqrt(alpha)) / 2.0;
            double q = mres / (4.0 * p);
            acoord[0] = p + q;
            acoord[1] = p - q;
            for (int i = 0; i < n; ++i) {
                double x = mcorr[i] / (4.0 * p);
                newc.putV(i, 0, -x);
                newc.putV(i, 1, x);
            }
        } else {
            double q = 0.0;
            for (int i = 0; i < n; ++i) {
                double d = mcorr[i] - mres;
                q += d * d;
            }
            q /= 16.0;
            q = Math.sqrt(Math.sqrt(q));
            double p = mres / (4.0 * q);
            acoord[0] = p + q;
            acoord[1] = p - q;
            for (int i = 0; i < n; ++i) {
                double x = mcorr[i] / (4.0 * p);
                newc.putV(i, 0, -x);
                newc.putV(i, 1, x);
            }
        }
    }

    public void writeFusingConformer(String fname, FragmentAtomFuseItem aup, double[] modC, int[] modCI) {
        int ret = -1;
        try {
            Molecule m = new Molecule();
            this.seq.mol.getOriginalMolCopy().clonecopy(m);
            for (int i = m.getBondCount() - 1; i >= 0; --i) {
                int ba1 = m.indexOf(m.getBond(i).getAtom1());
                int ba2 = m.indexOf(m.getBond(i).getAtom2());
                if ((ba1 == this.atomNo || this.atomToFragmentA[ba1] != -1) && (ba2 == this.atomNo || this.atomToFragmentA[ba2] != -1)) continue;
                m.removeBond(m.getBond(i));
            }
            PrintStream ps = new PrintStream(new FileOutputStream(fname, true));
            double[] ffn = this.frags.getCoordinate(aup.confNo, this.fragmentAtomList[0]);
            double xUnknown = ffn[0];
            double yUnknown = ffn.length > 1 ? ffn[1] : 0.0;
            double zUnknown = ffn.length > 2 ? ffn[2] : 0.0;
            for (int i = 0; i < this.seq.mol.a; ++i) {
                MolAtom a = m.getAtom(i);
                if (i != this.atomNo && this.atomToFragmentA[i] == -1) {
                    a.setX(xUnknown);
                    a.setY(yUnknown);
                    a.setZ(zUnknown);
                    continue;
                }
                double[] ac = null;
                ac = modCI == null || modCI[i] == -1 ? (i == this.atomNo ? aup.getCoordinates() : this.frags.getCoordinate(aup.confNo, i)) : new double[]{modC[modCI[i]], modC[modCI[i] + 1], modC[modCI[i] + 2]};
                a.setX(ac[0]);
                a.setY(ac.length > 1 ? ac[1] : 0.0);
                a.setZ(ac.length > 2 ? ac[2] : 0.0);
            }
            m.setDim(3);
            ps.print(m.toFormat("mol"));
        }
        catch (Exception e) {
            System.err.println("Exception in debug code");
            e.printStackTrace();
        }
    }

    public void writeFusingConformerApplet(debugPrintout debug, FragmentAtomFuseItem aup, String prefix, String sel, String msg, double[] modC, int[] modCI, CleanDebug.MolAppletRecorder rec) {
        prefix = CleanDebug.getNewStringID();
        String fname = prefix + "_conf.mol";
        this.writeFusingConformer("DEBUG/struc/" + fname, aup, modC, modCI);
        String desc = "D: " + aup.dim + " Mres=" + aup.d2res + " Ready: " + aup.getReady();
        if (rec != null) {
            rec.add(fname, sel, desc);
        }
        Printouts.placeApplet(new String[]{fname}, msg, new String[]{desc}, new String[]{sel}, 1, "Show fusing", debug);
    }

    public int writeConformer(String fname, FragmentAtomFinalItem fin, int cno) {
        int ret = -1;
        try {
            Molecule m = new Molecule();
            Molecule om = this.seq.mol.getOriginalMolCopy();
            om.clonecopy(m);
            for (int i = m.getBondCount() - 1; i >= 0; --i) {
                int ba1 = m.indexOf(m.getBond(i).getAtom1());
                int ba2 = m.indexOf(m.getBond(i).getAtom2());
                if ((ba1 == this.atomNo || this.atomToFragmentA[ba1] != -1) && (ba2 == this.atomNo || this.atomToFragmentA[ba2] != -1)) continue;
                m.removeBond(m.getBond(i));
            }
            PrintStream ps = new PrintStream(new FileOutputStream(fname, true));
            double[] ffn = this.getFinalFragmentCoord(fin, cno, 0);
            double xUnknown = ffn[0];
            double yUnknown = ffn.length > 1 ? ffn[1] : 0.0;
            double zUnknown = ffn.length > 2 ? ffn[2] : 0.0;
            for (int i = 0; i < this.seq.mol.a; ++i) {
                MolAtom a = m.getAtom(i);
                if (i != this.atomNo && this.atomToFragmentA[i] == -1) {
                    a.setX(xUnknown);
                    a.setY(yUnknown);
                    a.setZ(zUnknown);
                    continue;
                }
                double[] ac = i == this.atomNo ? this.getFinalAtomCoord(fin, cno) : this.getFinalFragmentCoord(fin, cno, this.atomToFragmentA[i]);
                a.setX(ac[0]);
                a.setY(ac.length > 1 ? ac[1] : 0.0);
                a.setZ(ac.length > 2 ? ac[2] : 0.0);
            }
            m.setDim(3);
            ps.print(m.toFormat("mol"));
            ret = this.getFinalAtomDim(fin);
        }
        catch (Exception e) {
            System.err.println("Exception when writing conformer: " + e.getMessage());
            e.printStackTrace();
        }
        return ret;
    }

    public int getTargetConfNo(FragmentAtomFinalItem fin) {
        return this.get((int)fin.no).confNo;
    }

    public void writeFinalConformersApplet(debugPrintout debug, String sel, String msg) {
        this.writeFinalConformersApplet(debug, null, sel, msg);
    }

    public void writeFinalConformersApplet(debugPrintout debug, String prefix, String sel, String msg) {
        int confCount = 0;
        for (int i = 0; i < this.getFinalSize(); ++i) {
            confCount += this.getFinal(i).getSelections();
        }
        debug = CleanArgs.getDebug();
        if (debug == null) {
            return;
        }
        String[] mfnames = new String[confCount];
        String[] desc = new String[confCount];
        String[] sels = new String[confCount];
        prefix = CleanDebug.getNewStringID();
        int i = 0;
        for (int f = 0; f < this.getFinalSize(); ++f) {
            FragmentAtomFinalItem fin = this.getFinal(f);
            for (int c = 0; c < fin.getSelections(); ++c) {
                mfnames[i] = prefix + "_conf" + i + ".mol";
                int d = this.writeConformer("DEBUG/struc/" + mfnames[i], fin, c);
                desc[i] = "Fin#: " + f + " c: " + c + " D=" + d + " targ.conf.: " + this.getTargetConfNo(fin);
                sels[i] = sel;
                ++i;
            }
        }
        Printouts.placeApplet(mfnames, msg, desc, sels, confCount, "Show fragments", debug);
    }

    public FragmentAtomFinalItem finalizeAtom(int n) {
        this.get(n).setReady(true);
        FragmentAtomFinalItem ret = new FragmentAtomFinalItem(n);
        this.finals.add(ret);
        return ret;
    }

    public FragmentAtomFinalItem finalizeAtom(int n, multiDim extrac, double[] extraac, boolean plusminus) {
        this.get(n).setReady(true);
        FragmentAtomFinalItem ret = new FragmentAtomFinalItem(n, extrac, extraac, plusminus);
        this.finals.add(ret);
        return ret;
    }

    public FragmentAtomFinalItem finalizeAtom(int n, multiDim orthoB, multiDim v) {
        this.get(n).setReady(true);
        FragmentAtomFinalItem ret = new FragmentAtomFinalItem(n, orthoB, v);
        this.finals.add(ret);
        return ret;
    }

    public void mergeFinalAtoms(int nc, int[] selA, int[] selC, double[] denergy, debugPrintout debug) {
        if (debug != null) {
            int i;
            debug.incLevel("Merging finals");
            debug.Tstart();
            debug.Trow();
            debug.TprintBC(1 + nc, "Parameters:");
            debug.Trow();
            debug.TprintB("New conformer count:");
            debug.Tprint(nc, "" + nc);
            debug.Trow();
            debug.TprintB("Conformer:");
            for (i = 0; i < nc; ++i) {
                debug.TprintBC("" + i);
            }
            debug.Trow();
            debug.TprintB("Finalized atom:");
            for (i = 0; i < nc; ++i) {
                debug.Tprint("" + selA[i]);
            }
            debug.Trow();
            debug.TprintB("Choice:");
            for (i = 0; i < nc; ++i) {
                debug.Tprint("" + selC[i]);
            }
            debug.Trow();
            debug.TprintB("Denergy:");
            for (i = 0; i < nc; ++i) {
                debug.Tprint("" + (denergy == null ? "N/A" : debugPrintout.formatNumber(denergy[i])));
            }
            debug.Tstop();
        }
        int newConfN = Math.min(selA.length, Math.min(selC.length, nc));
        if (denergy != null) {
            this.frags.denergy = new double[newConfN];
            for (int i = 0; i < newConfN; ++i) {
                this.frags.denergy[i] = denergy[i];
            }
        }
        int oldConfN = this.frags.confs[this.fragmentAtomList[0]];
        multiDim[] tmp = new multiDim[oldConfN];
        int[] cfdims = new int[oldConfN];
        for (int i = 0; i < tmp.length; ++i) {
            cfdims[i] = this.frags.dims[i][this.fragmentAtomList[0]];
            tmp[i] = new multiDim(this.fragmentAtomList.length, this.frags.dims[i][this.fragmentAtomList[0]]);
            for (int n = 0; n < this.fragmentAtomList.length; ++n) {
                tmp[i].putV(n, this.frags.getCoordinate(i, this.fragmentAtomList[n]));
                if (cfdims[i] == this.frags.dims[i][this.fragmentAtomList[n]]) continue;
                System.err.println("CONSISTENCY: merge dimensionality incosistence");
            }
        }
        for (int ano = 0; ano < newConfN; ++ano) {
            if (debug != null) {
                debug.printHR();
                debug.println("Place new conformer # " + ano);
            }
            FragmentAtomFinalItem fin = this.getFinal(selA[ano]);
            FragmentAtomFuseItem aup = this.get(fin.no);
            int tc = aup.confNo;
            multiDim c = tmp[tc];
            multiDim m = this.frags.coords[ano];
            int cfdim = cfdims[tc];
            int nfdim = this.getFinalAtomDim(fin);
            if (debug != null) {
                debug.println("Old target dimensionality " + cfdim);
                debug.println("New dimensionality " + nfdim);
                debug.println("Atom under place " + this.atomNo);
            }
            m.putV(this.atomNo, this.getFinalAtomCoord(fin, selC[ano]));
            this.frags.dims[ano][this.atomNo] = nfdim;
            this.frags.confs[this.atomNo] = newConfN;
            double[] newM = this.getFinalMetric(fin);
            if (debug != null) {
                debug.println("Final metric:");
                debug.printVector(newM);
            }
            for (int i = 0; i < nfdim; ++i) {
                this.frags.setMetric(ano, this.atomNo, i, newM[i]);
            }
            for (int a = 0; a < this.fragmentAtomList.length; ++a) {
                double[] coord = this.getFinalFragmentCoord(fin, selC[ano], a, c);
                for (int d = 0; d < nfdim; ++d) {
                    m.putV(this.fragmentAtomList[a], d, coord[d]);
                    this.frags.setMetric(ano, this.fragmentAtomList[a], d, newM[d]);
                }
                this.frags.dims[ano][this.fragmentAtomList[a]] = nfdim;
                this.frags.confs[this.fragmentAtomList[a]] = newConfN;
            }
        }
        if (debug != null) {
            debug.decLevel();
        }
    }

    public static class FinalDescriptorArray {
        public FinalDescriptor[] fda = null;
        public int valids = -1;

        public FinalDescriptorArray(int n, int[] selA, int[] selC, int[] opts) {
            this.fda = new FinalDescriptor[n];
            for (int i = 0; i < n; ++i) {
                this.fda[i] = new FinalDescriptor(selA[i], selC[i], opts == null ? -1 : opts[i]);
            }
            this.valids = n;
        }

        public FinalDescriptorArray(FragmentAtomFuseStore store) {
            int finalSelectionSum = 0;
            for (int i = 0; i < store.getFinalSize(); ++i) {
                finalSelectionSum += store.getFinal(i).getSelections();
            }
            int n = 0;
            this.fda = new FinalDescriptor[finalSelectionSum];
            for (int i = 0; i < store.getFinalSize(); ++i) {
                for (int j = 0; j < store.getFinal(i).getSelections(); ++j) {
                    this.fda[n++] = new FinalDescriptor(i, j, -1);
                }
            }
            this.valids = n;
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null) {
                debug.println("Check for overlapped atoms");
            }
            for (int i = 0; i < this.valids; ++i) {
                double[][] c = store.getFinalCoordArray(store.getFinal(this.fda[i].fn), this.fda[i].fs);
                boolean collision = false;
                for (int j = 0; j < c.length - 1; ++j) {
                    double d = Math.abs(c[j][0] - c[c.length - 1][0]) + Math.abs(c[j][1] - c[c.length - 1][1]) + Math.abs(c[j][2] - c[c.length - 1][2]);
                    if (!(d < 0.001)) continue;
                    if (debug != null) {
                        debug.println("Valid " + i + " has collision");
                    }
                    collision = true;
                    break;
                }
                if (!collision) continue;
                FinalDescriptor[] fdanew = new FinalDescriptor[this.valids - 1];
                int k = 0;
                for (int j = 0; j < fdanew.length; ++j) {
                    if (k == i) {
                        // empty if block
                    }
                    int n2 = ++k;
                    ++k;
                    fdanew[j] = this.fda[n2];
                }
                this.fda = fdanew;
                --this.valids;
            }
        }

        public boolean checkDihedrals(double[][] cai, double[][] caj, int[][] bat, int[][] ctab, debugPrintout debug) {
            for (int i = 0; i < bat.length; ++i) {
                int a1 = bat[0][i];
                int a2 = bat[1][i];
                for (int j = 0; j < ctab[a1].length; ++j) {
                    int a0 = ctab[a1][j];
                    for (int k = 0; k < ctab[a2].length; ++k) {
                        double dfi;
                        int a3 = ctab[a2][k];
                        if (a0 == a3) continue;
                        double fi1 = WishListItem.calcDihedralAngle(cai[a0], cai[a1], cai[a2], cai[a3]);
                        double fi2 = WishListItem.calcDihedralAngle(caj[a0], caj[a1], caj[a2], caj[a3]);
                        for (dfi = fi1 - fi2; dfi > 180.0; dfi -= 360.0) {
                        }
                        while (dfi < -180.0) {
                            dfi += 360.0;
                        }
                        if (!(dfi > 20.0)) continue;
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("Failed dihedral: " + a0 + "-" + a1 + "-" + a2 + "-" + a3 + " fi1: " + fi1 + " fi2: " + fi2 + " dfi " + dfi);
                        }
                        return false;
                    }
                }
            }
            return true;
        }

        public void removeStructure(int n) {
            this.fda[n] = null;
        }

        public void compactRemoveds() {
            int lv = 0;
            int i = 0;
            while (i < this.valids) {
                while (lv < this.valids && this.fda[lv] != null) {
                    ++lv;
                }
                for (i = lv; i < this.valids && this.fda[i] == null; ++i) {
                }
                if (i >= this.valids) continue;
                this.fda[lv] = this.fda[i];
                this.fda[i] = null;
            }
            this.valids = lv;
        }

        public boolean isDistancesOK(double[] a1, double[] a2, double[] b1, double[] b2, boolean useShortClip, StringBuffer s) {
            double dev;
            double d0 = a1[0] - a2[0];
            double d1 = a1[1] - a2[1];
            double d2 = a1[2] - a2[2];
            double da = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            double e0 = b1[0] - b2[0];
            double e1 = b1[1] - b2[1];
            double e2 = b1[2] - b2[2];
            double db = Math.sqrt(e0 * e0 + e1 * e1 + e2 * e2);
            if ((!useShortClip || da < 4.0 || db < 4.0) && (dev = 1000.0 * Math.abs(da - db) / Math.max(da, db)) > 20.0) {
                if (s != null) {
                    s.append("da:" + debugPrintout.formatNumber(da) + " db:" + debugPrintout.formatNumber(db) + " dev: " + debugPrintout.formatNumber(dev));
                }
                return false;
            }
            return true;
        }

        public static boolean findBigTetrahedron(double[][] ca, IntegerBuffer n1, IntegerBuffer n2, IntegerBuffer n3, IntegerBuffer n4) {
            double maxm = -1.0;
            int ma1 = 0;
            int ma2 = 0;
            for (int a1 = 0; a1 < ca.length; ++a1) {
                for (int a2 = a1 + 1; a2 < ca.length; ++a2) {
                    double m = V.dot(V.minus(ca[a1], ca[a2]));
                    if (!(m > maxm)) continue;
                    maxm = m;
                    ma1 = a1;
                    ma2 = a2;
                }
            }
            n1.v = ma1;
            n2.v = ma2;
            double[] a = V.minus(ca[ma2], ca[ma1]);
            double dota = V.dot(a);
            double lenRec = 1.0 / Math.sqrt(dota);
            double[] anorm = V.dot(lenRec, a);
            int ma3 = -1;
            double maxbd = -1.0;
            double[] mb = null;
            for (int k = 0; k < ca.length; ++k) {
                double[] b;
                double bd;
                if (k == ma1 || k == ma2 || !((bd = V.dot(b = V.minus(ca[k], ca[ma1])) - M.sqr(V.dot(anorm, b))) > maxbd)) continue;
                maxbd = bd;
                ma3 = k;
                mb = b;
            }
            n3.v = ma3;
            double[] vp = V.vectProd(a, mb);
            double dotvp = V.dot(vp);
            double sqdotvp = Math.sqrt(dotvp);
            double recsqdotvp = 1.0 / sqdotvp;
            double[] vpnorm = V.dot(recsqdotvp, vp);
            double maxsvp = 0.0;
            int ma4 = -1;
            for (int k = 0; k < ca.length; ++k) {
                double[] c;
                double dotc;
                double sqdotc;
                double recsqdotc;
                double[] cnorm;
                double sp;
                if (k == ma1 || k == ma2 || k == ma3 || !(Math.abs(sp = V.dot(vpnorm, cnorm = V.dot(recsqdotc = 1.0 / (sqdotc = Math.sqrt(dotc = V.dot(c = V.minus(ca[k], ca[ma1])))), c))) > maxsvp)) continue;
                maxsvp = Math.abs(sp);
                ma4 = k;
            }
            n4.v = ma4;
            return maxsvp > 0.005;
        }

        public boolean deepCheck(double[][] cai, double[][] caj, int[][] bat, int[][] ctab, boolean useShortClip, debugPrintout debug) {
            if (!this.checkDihedrals(cai, caj, bat, ctab, debug)) {
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Dihedrals failed.");
                }
                return false;
            }
            IntegerBuffer n1 = new IntegerBuffer();
            IntegerBuffer n2 = new IntegerBuffer();
            IntegerBuffer n3 = new IntegerBuffer();
            IntegerBuffer n4 = new IntegerBuffer();
            if (FinalDescriptorArray.findBigTetrahedron(cai, n1, n2, n3, n4)) {
                double p1 = WishListItem.calcGeneralParity(cai[n1.v], cai[n2.v], cai[n3.v], cai[n4.v]);
                double p2 = WishListItem.calcGeneralParity(caj[n1.v], caj[n2.v], caj[n3.v], caj[n4.v]);
                if (debug != null && debug.getWillPrint()) {
                    debug.println("The big tetrahedron: " + n1.v + " " + n2.v + " " + n1.v + " " + n4.v);
                    debug.println("General parities: " + p1 + " " + p2);
                }
                if (p1 * p2 < -0.1) {
                    return false;
                }
            }
            for (int k = 1; k < cai.length; ++k) {
                for (int l = 0; l < k; ++l) {
                    StringBuffer s;
                    StringBuffer stringBuffer = s = debug != null && debug.getWillPrint() ? new StringBuffer() : null;
                    if (this.isDistancesOK(cai[k], cai[l], caj[k], caj[l], useShortClip, s)) continue;
                    if (s != null) {
                        debug.println("Mismatch. a1: " + k + " a2: " + l + " " + s.toString());
                    }
                    return false;
                }
            }
            return true;
        }

        public void removeNANs(FragmentAtomFuseStore store, myMolecule molfrag, debugPrintout debug) {
            if (debug != null) {
                debug.printBC("Remove NANs");
            }
            for (int i = 0; i < this.valids; ++i) {
                double d;
                if (this.fda[i] == null || !Double.isInfinite(d = this.fda[i].denergy) && !Double.isNaN(d)) continue;
                this.removeStructure(i);
                if (debug == null) continue;
                debug.println("Remove " + i);
            }
        }

        public void removeDuplicates(FragmentAtomFuseStore store, myMolecule molfrag, debugPrintout debug, String samesuffix, boolean useShortClipping, CleanSettings settings) {
            if (settings.OPT_stopper_equivalences != null) {
                settings.OPT_stopper_equivalences.start();
            }
            this.removeDuplicates_0(store, molfrag, debug, samesuffix, useShortClipping, settings);
            if (settings.OPT_stopper_equivalences != null) {
                settings.OPT_stopper_equivalences.stop();
            }
        }

        public void removeDuplicates_0(FragmentAtomFuseStore store, myMolecule molfrag, debugPrintout debug, String samesuffix, boolean useShortClipping, CleanSettings settings) {
            int i;
            int i2;
            int j;
            int j2;
            int g1;
            int i3;
            int i4;
            int j3;
            int i5;
            boolean doDebug = debug != null && debug.getWillPrint();
            SimpleCanceller canceller = settings.getCanceller();
            if (doDebug) {
                debug.printBC("Remove duplicate structures");
                debug.incLevel("Set up Grinv groups");
            }
            if (doDebug) {
                Molecule pm = myMolecule.constructMolecule(molfrag);
                molfrag.writeMoleculeApplet(pm, debug, null, "Show fragment", "msg", null);
            }
            int[] atoms = store.getFinalCoordArrayAtoms();
            int[] gGrinvValue = new int[atoms.length];
            int eqGroups = 0;
            int[] gItemCount = new int[atoms.length];
            if (molfrag.a != atoms.length) {
                System.err.println("Consistency error in removeDuplicates()");
            }
            for (int i6 = 0; i6 < molfrag.a; ++i6) {
                int j4;
                for (j4 = 0; j4 < eqGroups && gGrinvValue[j4] != molfrag.grinv[i6]; ++j4) {
                }
                if (j4 < eqGroups) {
                    int n = j4;
                    gItemCount[n] = gItemCount[n] + 1;
                    continue;
                }
                ++eqGroups;
                int n = j4;
                gItemCount[n] = gItemCount[n] + 1;
                gGrinvValue[j4] = molfrag.grinv[i6];
            }
            int[][] gItems = new int[eqGroups][];
            for (i5 = 0; i5 < eqGroups; ++i5) {
                gItems[i5] = new int[gItemCount[i5]];
                gItemCount[i5] = 0;
            }
            for (i5 = 0; i5 < molfrag.a; ++i5) {
                int j5;
                for (j5 = 0; j5 < eqGroups && gGrinvValue[j5] != molfrag.grinv[i5]; ++j5) {
                }
                if (j5 < eqGroups) {
                    gItems[j5][gItemCount[j5]] = i5;
                    int n = j5;
                    gItemCount[n] = gItemCount[n] + 1;
                    continue;
                }
                System.err.println("Error in handling grinv groups.");
            }
            if (doDebug) {
                debug.printB("Eqgroups before sort");
                debug.Tstart();
                debug.Trow();
                debug.TprintBC("Group#");
                debug.TprintBC("Atoms in group");
                for (i5 = 0; i5 < eqGroups; ++i5) {
                    debug.Trow();
                    debug.TprintBC("" + i5);
                    String s = "";
                    for (j3 = 0; j3 < gItemCount[i5]; ++j3) {
                        s = s + gItems[i5][j3] + " ";
                    }
                    debug.Tprint(s);
                }
                debug.Tstop();
            }
            int[] atomToGroup = new int[molfrag.a];
            for (i4 = 0; i4 < gItems.length; ++i4) {
                for (j3 = 0; j3 < gItems[i4].length; ++j3) {
                    atomToGroup[gItems[i4][j3]] = i4;
                }
            }
            if (doDebug) {
                debug.printB("Atom to EQgroup association");
                debug.Tstart();
                debug.Trow();
                debug.TprintBC("Atom");
                for (i4 = 0; i4 < molfrag.a; ++i4) {
                    debug.TprintC("" + i4);
                }
                debug.Trow();
                debug.TprintBC("EQgroup");
                for (i4 = 0; i4 < molfrag.a; ++i4) {
                    debug.TprintC("" + atomToGroup[i4]);
                }
                debug.Tstop();
            }
            int[][] eqgb = new int[gItems.length][gItems.length];
            for (i3 = 0; i3 < molfrag.b; ++i3) {
                int a1 = molfrag.bat[0][i3];
                g1 = atomToGroup[a1];
                int a2 = molfrag.bat[1][i3];
                int g2 = atomToGroup[a2];
                if (g1 == g2) continue;
                eqgb[g1][g2] = 4;
                eqgb[g2][g1] = 4;
            }
            for (i3 = 0; i3 < molfrag.a; ++i3) {
                for (j2 = 0; j2 < molfrag.ctab[i3].length; ++j2) {
                    int a1 = molfrag.ctab[i3][j2];
                    g1 = atomToGroup[a1];
                    for (int k = j2 + 1; k < molfrag.ctab[i3].length; ++k) {
                        int a2 = molfrag.ctab[i3][k];
                        int g2 = atomToGroup[a2];
                        if (g1 == g2) continue;
                        eqgb[g1][g2] = eqgb[g1][g2] | 2;
                        eqgb[g2][g1] = eqgb[g2][g1] | 2;
                    }
                }
            }
            for (i3 = 0; i3 < molfrag.b; ++i3) {
                int aX = molfrag.bat[0][i3];
                int aY = molfrag.bat[1][i3];
                for (int j6 = 0; j6 < molfrag.ctab[aX].length; ++j6) {
                    int a1 = molfrag.ctab[aX][j6];
                    int g12 = atomToGroup[a1];
                    for (int k = 0; k < molfrag.ctab[aY].length; ++k) {
                        int a2 = molfrag.ctab[aY][k];
                        int g2 = atomToGroup[a2];
                        if (g12 == g2) continue;
                        eqgb[g12][g2] = eqgb[g12][g2] | 1;
                        eqgb[g2][g12] = eqgb[g2][g12] | 1;
                    }
                }
            }
            if (doDebug) {
                debug.printB("EQgroups bond matrix");
                debug.Tstart();
                debug.Trow();
                debug.TprintBC("");
                for (i3 = 0; i3 < gItems.length; ++i3) {
                    debug.TprintC("" + i3);
                }
                for (i3 = 0; i3 < gItems.length; ++i3) {
                    debug.Trow();
                    debug.TprintC("" + i3);
                    for (j2 = 0; j2 < gItems.length; ++j2) {
                        debug.TprintC("" + eqgb[i3][j2]);
                    }
                }
                debug.Tstop();
            }
            int[] groupseq = new int[gItems.length];
            int groupseqp = 0;
            boolean[] placed = new boolean[gItems.length];
            for (int i7 = 0; i7 < gItems.length; ++i7) {
                placed[i7] = false;
                if (gItems[i7].length != 1) continue;
                placed[i7] = true;
                groupseq[groupseqp++] = i7;
            }
            while (groupseqp < gItems.length) {
                int gc = -1;
                int gcs = 9999;
                int maxgb = -1;
                for (int i8 = 0; i8 < gItems.length; ++i8) {
                    if (placed[i8]) continue;
                    int siz = gItems[i8].length;
                    int gb = 0;
                    for (j = 0; j < groupseqp; ++j) {
                        if (eqgb[i8][groupseq[j]] <= gb) continue;
                        gb = eqgb[i8][groupseq[j]];
                    }
                    if (gb <= maxgb && (gb != maxgb || gcs <= siz)) continue;
                    maxgb = gb;
                    gcs = siz;
                    gc = i8;
                }
                placed[gc] = true;
                groupseq[groupseqp++] = gc;
            }
            int[][] gItemsTmp = gItems;
            int[] gItemCountTmp = gItemCount;
            gItems = new int[gItemsTmp.length][];
            gItemCount = new int[gItemCount.length];
            for (i2 = 0; i2 < gItems.length; ++i2) {
                gItems[i2] = gItemsTmp[groupseq[i2]];
                gItemCount[i2] = gItemCountTmp[groupseq[i2]];
            }
            if (doDebug) {
                debug.printB("Eqgroups after sort");
                debug.Tstart();
                debug.Trow();
                debug.TprintBC("Group#");
                debug.TprintBC("Atoms in group");
                for (i2 = 0; i2 < eqGroups; ++i2) {
                    debug.Trow();
                    debug.TprintBC("" + i2);
                    String s = "";
                    for (int j7 = 0; j7 < gItemCount[i2]; ++j7) {
                        s = s + gItems[i2][j7] + " ";
                    }
                    debug.Tprint(s);
                }
                debug.Tstop();
                debug.decLevel();
            }
            int[][] P = new int[eqGroups][];
            for (int k = 0; k < eqGroups; ++k) {
                P[k] = new int[gItemCount[k]];
            }
            for (i = 1; i < this.valids; ++i) {
                FragmentAtomFinalItem fini = null;
                double[][] cai = null;
                for (j = 0; j < i; ++j) {
                    if (this.fda[j] == null || this.fda[i] == null || !(Math.abs(this.fda[i].denergy - this.fda[j].denergy) < 10.0)) continue;
                    if (fini == null) {
                        fini = store.getFinal(this.fda[i].fn);
                        cai = store.getFinalCoordArray3D(fini, this.fda[i].fs);
                    }
                    FragmentAtomFinalItem finj = store.getFinal(this.fda[j].fn);
                    double[][] caj = store.getFinalCoordArray3D(finj, this.fda[j].fs);
                    String label = "Comp: " + i + "-" + j;
                    if (doDebug) {
                        debug.incLevel(label);
                    }
                    int gp = 0;
                    int gep = 0;
                    P[gp][gep] = 0;
                    int outerLoopState = 0;
                    if (canceller != null && canceller.isCancelled()) {
                        return;
                    }
                    while (outerLoopState == 0) {
                        int k;
                        int k2;
                        int innerLoop1State = 0;
                        while (innerLoop1State == 0) {
                            if (canceller != null && canceller.isCancelled()) {
                                return;
                            }
                            if (doDebug) {
                                int l;
                                debug.printB("Check permutation at gp=" + gp + " gep=" + gep);
                                debug.Tstart();
                                debug.Trow();
                                debug.TprintB("EQgroup #");
                                for (k2 = 0; k2 <= gp; ++k2) {
                                    debug.TprintBC(k2 == gp ? gep + 1 : P[k2].length, "" + k2);
                                }
                                debug.Trow();
                                debug.TprintB("Atom in i");
                                for (k2 = 0; k2 <= gp; ++k2) {
                                    for (l = 0; l < (k2 == gp ? gep + 1 : P[k2].length); ++l) {
                                        debug.TprintC("" + gItems[k2][P[k2][l]]);
                                    }
                                }
                                debug.Trow();
                                debug.TprintB("Atom in j");
                                for (k2 = 0; k2 < P.length; ++k2) {
                                    for (l = 0; l < (k2 == gp ? gep + 1 : P[k2].length); ++l) {
                                        debug.TprintC("" + gItems[k2][l]);
                                    }
                                }
                                debug.Tstop();
                            }
                            boolean match = true;
                            int a1i = gItems[gp][P[gp][gep]];
                            int a1j = gItems[gp][gep];
                            for (k = 0; match && k <= gp; ++k) {
                                for (int l = 0; match && l < (k == gp ? gep : P[k].length); ++l) {
                                    StringBuffer s;
                                    int a2i = gItems[k][P[k][l]];
                                    int a2j = gItems[k][l];
                                    StringBuffer stringBuffer = s = debug != null && debug.getWillPrint() ? new StringBuffer() : null;
                                    if (this.isDistancesOK(cai[a1i], cai[a2i], caj[a1j], caj[a2j], useShortClipping, s)) continue;
                                    match = false;
                                    if (s == null) continue;
                                    debug.println("Mismatch. a1i: " + a1i + " a2i: " + a2i + " a1j: " + a1j + " a2j: " + a2j + " " + s.toString());
                                }
                            }
                            if (!match) {
                                innerLoop1State = 2;
                                break;
                            }
                            if (gp == P.length - 1 && gep == P[gp].length - 1) {
                                innerLoop1State = 1;
                                break;
                            }
                            if (gep == P[gp].length - 1) {
                                gep = 0;
                                P[++gp][gep] = 0;
                                continue;
                            }
                            P[gp][++gep] = 0;
                            boolean ok = true;
                            block40: do {
                                ok = true;
                                for (int k3 = 0; k3 < gep; ++k3) {
                                    if (P[gp][gep] != P[gp][k3]) continue;
                                    ok = false;
                                    int[] nArray = P[gp];
                                    int n = gep;
                                    nArray[n] = nArray[n] + 1;
                                    continue block40;
                                }
                            } while (!ok);
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            return;
                        }
                        if (innerLoop1State == 1) {
                            int k4;
                            if (doDebug) {
                                debug.printHR();
                                debug.println("Entering deep check");
                                debug.println("Permutation table:");
                                debug.Tstart();
                                debug.Trow();
                                debug.TprintB("EQgroup #");
                                for (k2 = 0; k2 < P.length; ++k2) {
                                    debug.TprintBC(P[k2].length, "" + k2);
                                }
                                debug.Trow();
                                debug.TprintB("Atom in i");
                                for (k2 = 0; k2 < P.length; ++k2) {
                                    for (int l = 0; l < P[k2].length; ++l) {
                                        debug.TprintC("" + gItems[k2][P[k2][l]]);
                                    }
                                }
                                debug.Trow();
                                debug.TprintB("Atom in j");
                                for (k2 = 0; k2 < P.length; ++k2) {
                                    for (int l = 0; l < P[k2].length; ++l) {
                                        debug.TprintC("" + gItems[k2][l]);
                                    }
                                }
                                debug.Tstop();
                            }
                            int[] ipt = new int[cai.length];
                            for (k4 = 0; k4 < ipt.length; ++k4) {
                                ipt[k4] = k4;
                            }
                            for (k4 = 0; k4 < P.length; ++k4) {
                                for (int l = 0; l < P[k4].length; ++l) {
                                    ipt[gItems[k4][l]] = gItems[k4][P[k4][l]];
                                }
                            }
                            double[][] caiPermutated = new double[cai.length][];
                            for (int k5 = 0; k5 < cai.length; ++k5) {
                                caiPermutated[k5] = cai[ipt[k5]];
                            }
                            if (this.deepCheck(caiPermutated, caj, molfrag.bat, molfrag.ctab, useShortClipping, debug)) {
                                outerLoopState = 1;
                                break;
                            }
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            return;
                        }
                        int innerLoop2State = 0;
                        while (innerLoop2State == 0) {
                            if (canceller != null && canceller.isCancelled()) {
                                return;
                            }
                            boolean canIncr = true;
                            boolean ok = true;
                            block52: do {
                                ok = false;
                                boolean bl = canIncr = canIncr && gep < P[gp].length - 1 && P[gp][gep] < P[gp].length - 1;
                                if (!canIncr) continue;
                                ok = true;
                                int[] nArray = P[gp];
                                int n = gep;
                                nArray[n] = nArray[n] + 1;
                                for (k = 0; k < gep; ++k) {
                                    if (P[gp][k] != P[gp][gep]) continue;
                                    ok = false;
                                    continue block52;
                                }
                            } while (!ok && canIncr);
                            if (canIncr) {
                                innerLoop2State = 2;
                                break;
                            }
                            if (gp == 0 && gep == 0) {
                                innerLoop2State = 1;
                                break;
                            }
                            if (gep == 0) {
                                gep = P[--gp].length - 1;
                                continue;
                            }
                            --gep;
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            return;
                        }
                        if (innerLoop2State != true) continue;
                        outerLoopState = 2;
                        break;
                    }
                    if (canceller != null && canceller.isCancelled()) {
                        return;
                    }
                    if (outerLoopState == 1) {
                        if (doDebug) {
                            debug.printBC(" MATCH");
                            label = label + "MATCH, remove " + i;
                        }
                        this.removeStructure(i);
                    }
                    if (!doDebug) continue;
                    if (outerLoopState == 1) {
                        debug.decLevel(label);
                        continue;
                    }
                    debug.decLevel();
                }
            }
            if (doDebug) {
                debug.println("End of eqcheck");
                for (i = 0; i < this.valids; ++i) {
                    debug.println("fda[ " + i + " ] is " + (this.fda[i] == null ? "null" : "not null"));
                }
            }
            this.compactRemoveds();
        }

        public void fillProxOK(FragmentAtomFuseStore store, myMolecule molf, debugPrintout debug) {
            int i;
            if (debug != null && !debug.getWillPrint()) {
                debug = null;
            }
            if (debug != null) {
                debug.printB("Fill proximity OK fields");
            }
            boolean[][] atoms13 = new boolean[molf.a][molf.a];
            int[][] CTAB = molf.getCtab();
            for (i = 0; i < molf.a; ++i) {
                for (int j = 0; j < CTAB[i].length; ++j) {
                    for (int k = 0; k < CTAB[i].length; ++k) {
                        atoms13[CTAB[i][j]][CTAB[i][k]] = true;
                    }
                }
            }
            for (i = 0; i < this.valids; ++i) {
                if (debug != null) {
                    debug.printB("Check: final item: " + this.fda[i].fn + " sel: " + this.fda[i].fs);
                }
                FragmentAtomFinalItem fin = store.getFinal(this.fda[i].fn);
                store.fillMoleculeFragmentCoordinates(fin, this.fda[i].fs, molf);
                boolean failed = false;
                for (int j = 0; j < molf.a; ++j) {
                    for (int k = j + 1; k < molf.a; ++k) {
                        if (molf.bonds[j][k] != -1) continue;
                        double M2 = V.dot(V.minus(molf.coord[j], molf.coord[k]));
                        if (Double.isInfinite(M2) || Double.isNaN(M2)) {
                            failed = true;
                            if (debug == null || !debug.getWillPrint()) continue;
                            debug.printB("Failed: " + j + "-" + k + "; M=" + M2);
                            continue;
                        }
                        double mlimit = 2.0;
                        if (molf.anum[j] == 1 && molf.anum[k] == 1) {
                            mlimit = 1.0;
                        }
                        if (atoms13[j][k] && mlimit > 1.0 && (molf.anum[j] == 1 || molf.anum[k] == 1)) {
                            mlimit = 1.5;
                        }
                        if (!(M2 < mlimit)) continue;
                        failed = true;
                        if (debug == null || !debug.getWillPrint()) continue;
                        debug.printB("Failed: " + j + "-" + k + "; M=" + M2 + " limit=" + mlimit + " Atoms13=" + atoms13[j][k]);
                    }
                }
                this.fda[i].proximityOK = !failed;
            }
        }

        public void fillStereoOk(FragmentAtomFuseStore store, myMolecule molf, Fragment frag, debugPrintout debug, CleanSettings settings) {
            int i;
            if (debug != null && debug.getWillPrint()) {
                debug.printB("Fill stereoOK and Dreiding energy fields");
                debug.incLevel("Molecule fragment:");
                molf.printout(debug);
                debug.decLevel();
                debug.println("Init force dield");
            }
            for (i = 0; i < this.valids; ++i) {
                boolean str;
                if (debug != null && debug.getWillPrint()) {
                    debug.printB("Check: final item: " + this.fda[i].fn + " sel: " + this.fda[i].fs);
                }
                FragmentAtomFinalItem fin = store.getFinal(this.fda[i].fn);
                double[][] c = store.getFinalCoordArray3D(fin, this.fda[i].fs);
                if (debug != null && debug.getWillPrint()) {
                    debug.incLevel("Check stereo");
                }
                boolean bl = str = frag.checkStereo(c, false, 0.1, debug) == 1;
                if (debug != null && debug.getWillPrint()) {
                    debug.decLevel();
                }
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Stereo OK:" + str);
                }
                this.fda[i].stereook = str;
                this.fda[i].denergy = frag.calcDreiding(c, false);
            }
            for (i = 0; i < this.valids; ++i) {
                this.fda[i].listpos = 0;
                for (int j = 0; j < this.valids; ++j) {
                    if (i == j || !(this.fda[j].denergy <= this.fda[i].denergy)) continue;
                    ++this.fda[i].listpos;
                }
            }
        }

        public int getn() {
            return this.valids;
        }

        public int[] getSelA() {
            int[] ret = new int[this.valids];
            for (int i = 0; i < this.valids; ++i) {
                ret[i] = this.fda[i].fn;
            }
            return ret;
        }

        public int[] getSelC() {
            int[] ret = new int[this.valids];
            for (int i = 0; i < this.valids; ++i) {
                ret[i] = this.fda[i].fs;
            }
            return ret;
        }

        public double[] getDreidingE() {
            double[] ret = new double[this.valids];
            for (int i = 0; i < this.valids; ++i) {
                ret[i] = this.fda[i].denergy;
            }
            return ret;
        }

        public void swapItems(int i, int j) {
            FinalDescriptor tmp = this.fda[i];
            this.fda[i] = this.fda[j];
            this.fda[j] = tmp;
        }

        public void SortByStereoOK() {
            for (int i = 0; i < this.valids; ++i) {
                if (U.isDoubleOK(this.fda[i].denergy)) continue;
                System.err.println("Invalid energy in SortByStereoOk()");
            }
            Optimization.quickSort(0, this.valids - 1, new Optimization.Sortable(){

                @Override
                public boolean isGreater(int i, int j) {
                    boolean invei = !U.isDoubleOK(FinalDescriptorArray.this.fda[i].denergy);
                    boolean invej = !U.isDoubleOK(FinalDescriptorArray.this.fda[j].denergy);
                    boolean swapInvalidE = invei && !invej;
                    boolean swap_stereo = !FinalDescriptorArray.this.fda[i].stereook && FinalDescriptorArray.this.fda[j].stereook;
                    boolean same_stereo = FinalDescriptorArray.this.fda[i].stereook == FinalDescriptorArray.this.fda[j].stereook;
                    boolean swap_prox = !FinalDescriptorArray.this.fda[i].proximityOK && FinalDescriptorArray.this.fda[j].proximityOK;
                    boolean same_prox = FinalDescriptorArray.this.fda[i].proximityOK == FinalDescriptorArray.this.fda[j].proximityOK;
                    boolean swap_energy = same_stereo && same_prox && FinalDescriptorArray.this.fda[i].denergy > FinalDescriptorArray.this.fda[j].denergy;
                    return swap_stereo || swap_prox || swap_energy;
                }

                @Override
                public void swap(int i, int j) {
                    FinalDescriptorArray.this.swapItems(i, j);
                }
            });
        }

        public void ClipStereoNOK(boolean acceptStereoNOK) {
            if (this.fda[0].stereook) {
                int i;
                for (i = 0; i < this.valids && this.fda[i].stereook; ++i) {
                }
                this.valids = i;
            } else if (!acceptStereoNOK) {
                this.valids = 0;
            }
        }

        public void ClipProxNOK() {
            if (this.fda[0].proximityOK) {
                int i;
                for (i = 0; i < this.valids && this.fda[i].proximityOK; ++i) {
                }
                this.valids = i;
            } else {
                this.valids = 0;
            }
        }

        public void printout(debugPrintout debug) {
            if (debug != null && debug.getWillPrint()) {
                debug.Tstart();
                FinalDescriptor.printoutHeaderRow(debug);
                for (int i = 0; i < this.valids; ++i) {
                    this.fda[i].printoutRow(i, debug);
                }
                debug.Tstop();
            }
        }
    }

    public static class FinalDescriptor
    implements Serializable {
        public int fn = -1;
        public int fs = -1;
        public double denergy = 0.0;
        public boolean stereook = false;
        public boolean proximityOK = false;
        public int listpos = -1;
        public int optSteps = -1;

        public FinalDescriptor(int n, int s, int os) {
            this.fn = n;
            this.fs = s;
            this.optSteps = os;
        }

        public static void printoutHeaderRow(debugPrintout debug) {
            debug.Trow();
            debug.TprintBC("Final descriptors");
            debug.Trow();
            debug.TprintBC("#");
            debug.TprintBC("Final no");
            debug.TprintBC("Final sel");
            debug.TprintBC("Energy");
            debug.TprintBC("Stereo OK");
            debug.TprintBC("prox OK");
            debug.TprintBC("Opt steps");
            debug.TprintBC("List pos.");
        }

        public void printoutRow(int i, debugPrintout debug) {
            debug.Trow();
            debug.TprintBC("" + i);
            debug.TprintC("" + this.fn);
            debug.TprintC("" + this.fs);
            debug.TprintC(debugPrintout.formatNumber(this.denergy));
            debug.TprintC("" + this.stereook);
            debug.TprintC("" + this.proximityOK);
            debug.TprintC("" + this.optSteps);
            debug.TprintC("" + this.listpos);
        }
    }
}

