/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.common.util.IntVector;
import chemaxon.core.util.BondTable;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modules.CommonStructureSearch;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.util.BitSet;
import java.util.Vector;

public class FragmentMine {
    static final int SINGLE_BOND = 1;
    static final int H = 1;
    static final int ANY = 131;
    public Vector fragVec = null;
    public boolean centerMine = false;
    static String format = "sdf";
    static String myPath = null;
    static boolean fileMode = true;
    static boolean doClean = false;
    static boolean storeNewFragments = false;
    FFilter filter = new FFilter("." + format);
    IntVector headFragments = new IntVector();
    String ext = "";

    public FragmentMine() {
        this.fragVec = new Vector();
    }

    public FragmentMine(String path) {
        myPath = path;
        this.fragVec = new Vector();
        this.read(path);
        if (this.fragVec.size() > 0) {
            Fragment frag = (Fragment)this.fragVec.elementAt(0);
            this.centerMine = frag.mol.getAtomCount() == 1;
        }
    }

    SearchTarget makeTarget(SearchTarget target) {
        int i;
        int i2;
        System.err.println("Enter makeTarget:");
        Molecule m = target.original;
        int[] atomList = target.atomList;
        if (m == null) {
            return null;
        }
        IntVector aVec = new IntVector(atomList.length);
        BitSet commonFlag = new BitSet();
        for (int i3 = 0; i3 < atomList.length; ++i3) {
            commonFlag.set(atomList[i3]);
            aVec.addElement(atomList[i3]);
        }
        int[] aList = (int[])atomList.clone();
        Molecule mFrag = m.cloneMolecule();
        int[][] cTab = mFrag.getCtab();
        BondTable bTab = mFrag.getBondTable();
        MolBond[] bonds = mFrag.getBondArray();
        if (aList.length == 1) {
            int iAt = aList[0];
            for (i2 = 0; i2 < cTab[iAt].length; ++i2) {
                aVec.addElement(cTab[iAt][i2]);
                commonFlag.set(cTab[iAt][i2]);
            }
            aList = new int[aVec.size()];
            aVec.copyInto(aList);
        }
        for (i = 0; i < mFrag.getAtomCount(); ++i) {
            mFrag.getAtom(i).setSelected(true);
        }
        for (i = 0; i < aList.length; ++i) {
            int jAt = aList[i];
            mFrag.getAtom(jAt).setSelected(false);
        }
        boolean addedAtom = true;
        while (addedAtom) {
            addedAtom = false;
            int[] cInd = new int[mFrag.getAtomCount()];
            for (int i4 = 0; i4 < aList.length; ++i4) {
                int iAt = aList[i4];
                for (int j = 0; j < cTab[iAt].length; ++j) {
                    int jAt = cTab[iAt][j];
                    mFrag.getAtom(jAt).setSelected(false);
                    boolean specialBond = bonds[bTab.getBondIndex(iAt, jAt)].getType() != 1 && bonds[bTab.getBondIndex(iAt, jAt)].getType() != 4;
                    boolean isBridged = false;
                    for (int k = 0; k < cTab[jAt].length; ++k) {
                        int kAt = cTab[jAt][k];
                        isBridged = isBridged || !mFrag.getAtom(kAt).isSelected() && !commonFlag.get(kAt);
                    }
                    int n = jAt;
                    cInd[n] = cInd[n] + 1;
                    if (commonFlag.get(jAt) || cInd[jAt] <= 1 && !specialBond && !isBridged) continue;
                    mFrag.getAtom(jAt).setSelected(false);
                    aVec.addElement(jAt);
                    commonFlag.set(jAt);
                    addedAtom = true;
                }
            }
            if (!addedAtom) continue;
            aList = new int[aVec.size()];
            aVec.copyInto(aList);
        }
        for (i2 = 0; i2 < aList.length; ++i2) {
            int iAt = aList[i2];
            for (int j = 0; j < cTab[iAt].length; ++j) {
                int jAt = cTab[iAt][j];
                if (commonFlag.get(jAt)) continue;
                mFrag.getAtom(jAt).setAtno(1);
                mFrag.getAtom(jAt).setCharge(0);
                mFrag.getAtom(jAt).setRadical(0);
                if (!mFrag.getAtom(jAt).isSelected()) continue;
                System.err.println("Consistency error in makeTarget.");
                throw new UnsupportedOperationException("makeTarget");
            }
        }
        aVec.sort();
        aList = new int[aVec.size()];
        aVec.copyInto(aList);
        int j = 0;
        while (j < mFrag.getAtomCount()) {
            if (mFrag.getAtom(j).isSelected()) {
                mFrag.removeAtom(j);
                continue;
            }
            ++j;
        }
        mFrag.hydrogenize(false);
        target.target = mFrag;
        aList = new int[aVec.size()];
        aVec.copyInto(aList);
        target.targetList = aList;
        return target;
    }

    public SearchTarget findFragment(Molecule m, int[] atomList) {
        SearchTarget target = new SearchTarget(m, atomList);
        target = this.makeTarget(target);
        if ((target = this.lookForAFragment(target)) != null && target.match != null && target.match.children == null) {
            return target;
        }
        return null;
    }

    public Fragment findFragment(Molecule m) {
        SearchTarget target = new SearchTarget();
        target.target = m;
        Fragment frag = this.lookForAFragment((SearchTarget)target).match;
        if (frag == null || frag.children == null) {
            return frag;
        }
        return null;
    }

    public boolean addFragment(Molecule m, int[] atomList) {
        Molecule mT = this.makeTarget((SearchTarget)(FragmentMine)this.new SearchTarget((Molecule)m, (int[])atomList)).target;
        return this.addFragment(mT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addFragment(Molecule m) {
        boolean ok = true;
        int parentIndex = this.fragVec.size();
        Fragment headFrag = this.lookForAFragment(m);
        if (headFrag != null) {
            if (headFrag.children == null) {
                return false;
            }
            if (headFrag.parent != -1) {
                System.err.println("Consistency error in addFragment.");
                ErrPrint.errPrint("Not added fragment:", m);
                ErrPrint.errPrint("Partial match found in addFragment:", headFrag.mol);
                return false;
            }
            parentIndex = this.fragVec.indexOf(headFrag);
        } else {
            Molecule headM = m.cloneMolecule();
            headM.setDim(0);
            headM.hydrogenize(false);
            for (int i = 0; i < headM.getAtomCount(); ++i) {
                headM.getAtom(i).setAtno(131);
            }
            headFrag = new Fragment(headM, -1, new IntVector());
            parentIndex = this.fragVec.size();
            this.headFragments.addElement(parentIndex);
            this.fragVec.addElement(headFrag);
        }
        Molecule storeM = m.cloneMolecule();
        storeM.setDim(0);
        storeM.hydrogenize(false);
        Fragment storeFrag = new Fragment(storeM, parentIndex, new IntVector());
        parentIndex = this.fragVec.size();
        headFrag.children.addElement(parentIndex);
        this.fragVec.add(storeFrag);
        Molecule mol3D = m.cloneMolecule();
        if (mol3D.getDim() != 3) {
            mol3D.setDim(0);
            mol3D.hydrogenize(true);
        }
        if (mol3D.getDim() != 3 && doClean) {
            try {
                mol3D.clean(3, "S{conformers}[acceptfault][timestamp]");
                System.err.println("Clean done.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Fragment frag3D = new Fragment(mol3D, parentIndex, null);
        parentIndex = this.fragVec.size();
        storeFrag.children.addElement(parentIndex);
        this.fragVec.add(frag3D);
        headFrag = this.lookForAFragment(m);
        if (headFrag != null && headFrag.children == null) {
            System.err.println("Adding fragment was succesful: " + this.fragVec.size());
            if (this.fragVec.size() % 1000 == 0) {
                System.err.println("Storing fragments: " + this.fragVec.size());
                this.write();
            }
            return true;
        }
        ErrPrint.errPrint("Adding fragment failed:", m);
        this.dump();
        this.unLinkFragment(this.fragVec.size() - 1);
        return false;
    }

    public boolean unLinkFragment(int index) {
        boolean ok = true;
        Fragment frag = (Fragment)this.fragVec.elementAt(index);
        int childIndex = index;
        int parentIndex = frag.parent;
        boolean bl = ok = this.removeIfLastElement(this.fragVec, index) && ok;
        while (parentIndex != -1) {
            frag = (Fragment)this.fragVec.elementAt(parentIndex);
            frag.children.removeElement(childIndex);
            childIndex = parentIndex;
            parentIndex = frag.parent;
            if (frag.children != null && frag.children.size() != 0) continue;
            this.removeIfLastElement(this.fragVec, parentIndex);
        }
        return true;
    }

    private boolean removeIfLastElement(Vector V2, int index) {
        boolean ok;
        boolean bl = ok = index == this.fragVec.size() - 1;
        if (ok) {
            V2.removeElementAt(index);
        }
        return ok;
    }

    int getCenterIndx(Molecule m) {
        Object mX = null;
        int maxNeighbor = 0;
        int maxAt = 0;
        int[][] cTab = m.getCtab();
        for (int i = 0; i < m.getAtomCount(); ++i) {
            if (cTab[i].length <= maxNeighbor) continue;
            maxNeighbor = cTab[i].length;
            maxAt = i;
        }
        return maxAt;
    }

    Molecule getCenter(Molecule m) {
        int[][] cTab = m.getCtab();
        int maxAt = this.getCenterIndx(m);
        Molecule mX = null;
        if (maxAt >= 0) {
            MolAtom a = m.getAtom(maxAt);
            mX = new Molecule();
            mX.add(a);
            mX.getAtom(0).setImplicitHcount(cTab[maxAt].length);
        }
        return mX;
    }

    Fragment lookForAFragment(Molecule m) {
        if (m == null) {
            return null;
        }
        SearchTarget sTarget = new SearchTarget();
        sTarget.original = m;
        sTarget.target = m;
        sTarget.targetList = new int[m.getAtomCount()];
        for (int i = 0; i < sTarget.targetList.length; ++i) {
            sTarget.targetList[i] = i;
        }
        sTarget.atomList = (int[])sTarget.targetList.clone();
        if ((sTarget = this.lookForAFragment(sTarget)) == null) {
            return null;
        }
        return sTarget.match;
    }

    SearchTarget lookForAFragment(SearchTarget sTarget) {
        long t0 = System.currentTimeMillis();
        if (sTarget == null || sTarget.target == null) {
            return null;
        }
        Molecule m = sTarget.target;
        CommonStructureSearch css = new CommonStructureSearch();
        css.setIgnoreCharge(true);
        css.setIgnoreQueryProperties(false);
        css.setTarget(m);
        int[] headList = new int[this.headFragments.size()];
        this.headFragments.copyInto(headList);
        sTarget = this.findMatchingFragment(sTarget, headList, css);
        long t1 = System.currentTimeMillis();
        return sTarget;
    }

    SearchTarget findMatchingFragment(SearchTarget target, int[] fragmentList, CommonStructureSearch css) {
        boolean matchMode = false;
        boolean matchFound = true;
        int querySize = 0;
        Molecule tMol = null;
        for (int i = 0; i < fragmentList.length; ++i) {
            matchMode = false;
            Fragment frag = (Fragment)this.fragVec.elementAt(fragmentList[i]);
            tMol = target.target;
            if (!matchMode && frag.children == null) {
                matchMode = true;
                tMol = target.target.cloneMolecule();
                tMol.hydrogenize(true);
            }
            if (frag.mol.getAtomCount() != tMol.getAtomCount()) continue;
            css.setQuery(frag.mol);
            css.setTarget(tMol);
            querySize = tMol.getAtomCount();
            if (matchMode) {
                boolean bl = matchFound = css.search() && css.getResultSize() == querySize && querySize == frag.mol.getAtomCount();
                if (matchFound) {
                    css.setQuery(tMol);
                    css.setTarget(frag.mol);
                }
            } else {
                matchFound = tMol.getAtomCount() == frag.mol.getAtomCount();
            }
            int[] tmpList = null;
            int j = 0;
            try {
                boolean found = false;
                if (!matchFound || !css.search() || css.getResultSize() != querySize) continue;
                if (matchMode) {
                    frag.count();
                    target.match = frag;
                    int[] tmpLH = css.getResult();
                    tmpList = new int[target.target.getAtomCount()];
                    for (int iA = 0; iA < tmpList.length; ++iA) {
                        tmpList[iA] = tmpLH[iA];
                    }
                    target.matchList = new int[frag.mol.getAtomCount()];
                    for (j = 0; j < target.matchList.length; ++j) {
                        target.matchList[j] = -1;
                    }
                    for (j = 0; j < tmpList.length; ++j) {
                        target.matchList[tmpList[j]] = target.targetList[j];
                    }
                    css.setTarget(target.target);
                    return target;
                }
                int[] childrenInd = new int[frag.children.size()];
                frag.children.copyInto(childrenInd);
                this.findMatchingFragment(target, childrenInd, css);
                if (target.match != null) {
                    return target;
                }
                if (frag.parent != -1) continue;
                target.match = frag;
                continue;
            }
            catch (Exception e) {
                System.err.println("Error in findMAtchingFragment (return SearchTarget):");
                e.printStackTrace();
                String errMessage = e.getMessage();
                System.err.println("Error message: " + errMessage);
                if (errMessage == "Queue overflow.") {
                    return null;
                }
                ErrPrint.errPrintAtomList("tmpList", tmpList);
                ErrPrint.errPrintAtomList("targetList", target.targetList);
                ErrPrint.errPrintAtomList("matchList", target.matchList);
                System.err.println("Actual index is: " + j);
                ErrPrint.errPrint("target.original", target.original);
                ErrPrint.errPrint("target.target:", target.target);
                ErrPrint.errPrint("frag.mol:", frag.mol);
                throw new UnsupportedOperationException("makeTarget");
            }
        }
        return target;
    }

    public void read(String path) {
        if (fileMode) {
            this.readSingleFile(path);
        } else {
            File fil = new File(path);
            if (fil.exists() && fil.isDirectory()) {
                File[] fList = fil.listFiles(this.filter);
                for (int i = 0; i < fList.length; ++i) {
                    int indx = this.readFragment(fList[i], -1);
                    if (indx < 0) continue;
                    this.headFragments.addElement(indx);
                }
            }
        }
    }

    int readFragment(File fil, int indToParent) {
        if (fil.isDirectory()) {
            return -1;
        }
        Fragment frag = new Fragment();
        frag.mol = FragmentMine.getMolecule(fil);
        int myIndex = this.fragVec.size();
        this.fragVec.addElement(frag);
        String childrenDir = frag.mol.getProperty("CHILDREN_DIR");
        Object s = null;
        if (childrenDir != null) {
            frag.children = new IntVector();
            File dir = new File(childrenDir);
            if (dir.exists() && dir.isDirectory()) {
                File[] fList = dir.listFiles(this.filter);
                for (int i = 0; i < fList.length; ++i) {
                    int childIndex = this.readFragment(fList[i], myIndex);
                    if (childIndex < 0) continue;
                    frag.children.addElement(childIndex);
                }
            }
        }
        this.fragVec.set(myIndex, frag);
        return myIndex;
    }

    public boolean write() {
        return this.write(myPath);
    }

    public boolean write(String path) {
        if (fileMode) {
            return this.writeSingleFile(path);
        }
        boolean ok = true;
        File fil = new File(path);
        File pDir = fil.getParentFile();
        if (pDir.exists() && (fil.exists() && fil.isDirectory() || fil.mkdir())) {
            for (int i = 0; i < this.headFragments.size(); ++i) {
                ok = ok && this.writeFragment(path, this.headFragments.elementAt(i), i);
            }
        }
        return ok;
    }

    boolean writeFragment(String path, int myIndex, int myID) {
        Fragment frag = (Fragment)this.fragVec.elementAt(myIndex);
        if (frag.children != null) {
            frag.mol.setDim(0);
        }
        String childrenDir = path + File.separator + "Children_" + String.valueOf(myID);
        if (frag.children != null) {
            frag.mol.setProperty("CHILDREN_DIR", childrenDir);
        }
        frag.mol.setProperty("COUNTER", String.valueOf(frag.counter));
        File fil = new File(path + File.separator + "fragment_" + String.valueOf(myID) + "." + format);
        boolean ok = FragmentMine.putMolecule(fil, frag.mol);
        if (childrenDir != null && ok) {
            File dir = new File(childrenDir);
            if (frag.children != null && (dir.exists() && dir.isDirectory() || dir.mkdir())) {
                for (int i = 0; i < frag.children.size(); ++i) {
                    int childIndex = frag.children.elementAt(i);
                    ok = ok && this.writeFragment(childrenDir, childIndex, i);
                }
            }
        } else {
            System.err.println("I/O erro in writeFragment.");
        }
        this.fragVec.set(myIndex, frag);
        return ok;
    }

    public void dump() {
        for (int i = 0; i < this.fragVec.size(); ++i) {
            Fragment frag = (Fragment)this.fragVec.elementAt(i);
            Molecule m = frag.mol;
            if (frag.children != null) {
                int[] children = new int[frag.children.size()];
                frag.children.copyInto(children);
                m.setPropertyObject("CHILDREN", children);
            }
            m.setProperty("CHILDREN_DIR", null);
            m.setProperty("PARENT", String.valueOf(frag.parent));
            m.setProperty("COUNTER", String.valueOf(frag.counter));
            System.out.print(m.toFormat("sdf"));
        }
    }

    public boolean writeSingleFile(String path) {
        File outFil = new File(path + "." + format);
        MolExporter molExp = null;
        boolean ok = true;
        try {
            FileOutputStream fo = new FileOutputStream(outFil);
            molExp = new MolExporter(fo, format);
            for (int i = 0; i < this.fragVec.size(); ++i) {
                Fragment frag = (Fragment)this.fragVec.elementAt(i);
                Molecule m = frag.mol;
                m.setProperty("CHILDREN_DIR", null);
                m.setProperty("PARENT", String.valueOf(frag.parent));
                m.setProperty("COUNTER", String.valueOf(frag.counter));
                molExp.write(m);
            }
            molExp.close();
        }
        catch (Exception e) {
            ok = false;
            System.err.println(e.getMessage());
        }
        return ok;
    }

    public boolean readSingleFile(String path) {
        String inpName = path + "." + format;
        MolImporter molImp = null;
        boolean ok = true;
        try {
            molImp = new MolImporter(inpName);
            Molecule m = null;
            int indx = 0;
            while ((m = FragmentMine.getNextMolecule(molImp)) != null) {
                int parent = Integer.parseInt(m.getProperty("PARENT"));
                Fragment frag = new Fragment(m, parent, null);
                this.fragVec.addElement(frag);
                if (parent != -1) {
                    frag = (Fragment)this.fragVec.elementAt(parent);
                    if (frag.children == null) {
                        frag.children = new IntVector();
                    }
                    frag.children.addElement(indx);
                } else {
                    this.headFragments.addElement(indx);
                }
                ++indx;
            }
        }
        catch (Exception e) {
            ok = false;
            System.err.println(e.getMessage());
        }
        return ok;
    }

    static String getFullName(File fil) {
        try {
            return fil.getCanonicalPath();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    static Molecule getMolecule(File fil) {
        Molecule m = null;
        try {
            MolImporter molImp = new MolImporter(fil.getCanonicalPath());
            m = molImp.read();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return m;
    }

    static boolean putMolecule(File fil, Molecule m) {
        try {
            FileOutputStream fo = new FileOutputStream(fil);
            MolExporter molExp = new MolExporter(fo, format);
            molExp.write(m);
            molExp.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    static Molecule getNextMolecule(MolImporter mI) {
        Molecule m = null;
        try {
            m = mI.read();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            m = null;
        }
        return m;
    }

    public class Fragment {
        int parent = -1;
        IntVector children = null;
        Molecule mol = null;
        int counter = 0;

        public Fragment(Molecule m, int indexToParent, IntVector indexesToChildren) {
            this.parent = indexToParent;
            this.children = indexesToChildren;
            Object parentMap = null;
            this.mol = m.cloneMolecule();
        }

        Fragment() {
        }

        public void count() {
            ++this.counter;
        }
    }

    public class SearchTarget {
        public Molecule original;
        public int[] atomList;
        public Molecule target;
        public int[] targetList;
        public Fragment match;
        public int[] matchList;
        public Vector matchVec = null;

        SearchTarget() {
            this.original = null;
            this.atomList = null;
            this.matchList = null;
        }

        SearchTarget(Molecule original, int[] atomList) {
            this.original = original;
            this.atomList = atomList;
            this.matchList = null;
        }
    }

    public class FFilter
    implements FileFilter {
        public FFilter(String extension) {
            FragmentMine.this.ext = extension;
        }

        @Override
        public boolean accept(File fil) {
            String name = fil.getName();
            int indx = name.length() - FragmentMine.this.ext.length();
            return name.lastIndexOf(FragmentMine.this.ext) == indx;
        }
    }
}

