/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.build.FuseCommandSequence;
import chemaxon.marvin.modelling.build.WishListItem;
import chemaxon.marvin.modelling.debug.CleanDebug;
import chemaxon.marvin.modelling.debug.Printouts;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.linalg.multiDim;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class FragmentStore {
    public FuseCommandSequence seq;
    public int atoms = 0;
    public int multi = 0;
    public double[] denergy = null;
    public multiDim[] coords = null;
    public multiDim metric = null;
    public int[] confs = null;
    public int[][] dims = null;
    public int[] fcmd = null;
    public int maxDim = 3;

    public double[][][] getCoordinateArray(int[] fragatoms) {
        int confct = this.confs[fragatoms[0]];
        for (int i = 0; i < fragatoms.length; ++i) {
            if (confct == this.confs[fragatoms[i]]) continue;
            System.err.println("Consystency error in FragmentStore: conformer count mismatch");
        }
        double[][][] ret = new double[confct][fragatoms.length][3];
        for (int i = 0; i < confct; ++i) {
            for (int j = 0; j < fragatoms.length; ++j) {
                for (int k = 0; k < 3; ++k) {
                    ret[i][j][k] = this.coords[i].getV(fragatoms[j], k);
                    if (this.dims[i][fragatoms[j]] >= k) continue;
                    ret[i][j][k] = 0.0;
                }
            }
        }
        return ret;
    }

    public int writeConformer(String fname, int cno) {
        int ret = 0;
        try {
            int j;
            Molecule m = new Molecule();
            this.seq.mol.getOriginalMolCopy().clonecopy(m);
            for (int i = m.getBondCount() - 1; i >= 0; --i) {
                int ba1 = m.indexOf(m.getBond(i).getAtom1());
                int ba2 = m.indexOf(m.getBond(i).getAtom2());
                if (this.fcmd[ba1] >= 0 && this.fcmd[ba1] == this.fcmd[ba2]) continue;
                m.removeBond(m.getBond(i));
            }
            PrintStream ps = new PrintStream(new FileOutputStream(fname, true));
            String fmt = "mol";
            if (fname.endsWith(".sdf")) {
                fmt = "sdf";
            }
            int n = j = cno == -1 ? 0 : cno;
            while (cno == -1 ? j < this.confs[this.seq.OP1_Ref[0]] : j == cno) {
                double maxx = this.coords[j].getV(0, 0);
                for (int i = 1; i < this.seq.mol.a; ++i) {
                    double x = this.coords[j].getV(i, 0);
                    if (!(maxx < x)) continue;
                    maxx = x;
                }
                double xUnknown = this.coords[j].getV(0, 0);
                double yUnknown = this.dims[j][0] < 2 ? 0.0 : this.coords[j].getV(0, 1);
                double zUnknown = this.dims[j][0] < 2 ? 0.0 : this.coords[j].getV(0, 2);
                for (int i = 0; i < this.seq.mol.a; ++i) {
                    MolAtom a = m.getAtom(i);
                    int d = this.dims[j][i];
                    if (this.fcmd[i] < 0) {
                        a.setX(xUnknown);
                        a.setY(yUnknown);
                        a.setZ(zUnknown);
                        a.setAtno(1);
                        continue;
                    }
                    if (d > ret) {
                        ret = d;
                    }
                    a.setX(this.coords[j].getV(i, 0));
                    a.setY(d < 2 ? 0.0 : this.coords[j].getV(i, 1));
                    a.setZ(d < 3 ? 0.0 : this.coords[j].getV(i, 2));
                }
                m.setDim(3);
                ps.print(m.toFormat(fmt));
                ++j;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    public double[] getEnergyArray() {
        double[] ret = new double[this.confs[0]];
        if (this.denergy != null) {
            for (int i = 0; i < this.confs[0]; ++i) {
                ret[i] = this.denergy[i];
            }
        }
        return ret;
    }

    public double[][][] getCoordArray() {
        double[][][] ret = new double[this.confs[0]][this.atoms][3];
        for (int i = 0; i < this.confs[0]; ++i) {
            for (int j = 0; j < this.atoms; ++j) {
                double[] c = this.getCoordinate(i, j);
                for (int k = 0; k < 3; ++k) {
                    ret[i][j][k] = c[k];
                }
            }
        }
        return ret;
    }

    public void writeAllConformers(String fname) {
        this.writeConformer(fname, -1);
    }

    public void writeConformersApplet(String sel, String msg) {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug == null) {
            return;
        }
        int confCount = this.confs[this.seq.OP1_Ref[0]];
        String[] mfnames = new String[confCount];
        String[] desc = new String[confCount];
        String[] sels = new String[confCount];
        String prefix = CleanDebug.getNewStringID();
        for (int i = 0; i < confCount; ++i) {
            mfnames[i] = prefix + "_conf" + i + ".sdf";
            int maxd = this.writeConformer("DEBUG/struc/" + mfnames[i], i);
            desc[i] = "C: " + i + " (maxD=" + maxd + ")";
            sels[i] = sel;
        }
        Printouts.placeApplet(mfnames, msg, desc, sels, confCount, "Show fragments", debug);
    }

    public void printOut(debugPrintout debug) {
        if (debug != null && debug.getWillPrint()) {
            int i;
            int maxconf = 0;
            for (i = 0; i < this.atoms; ++i) {
                if (this.confs[i] <= maxconf) continue;
                maxconf = this.confs[i];
            }
            debug.incLevel("State of fragment store");
            debug.println("<CENTER><B>Static info</B></CENTER>");
            debug.println("atoms=  " + this.atoms);
            debug.println("multi=  " + this.multi);
            debug.println("maxDim= " + this.maxDim);
            debug.printBC("Dreiding energy");
            if (this.denergy == null) {
                debug.printB("N/A");
            } else {
                debug.Tstart();
                debug.Trow();
                debug.TprintBC("Conformer:");
                for (i = 0; i < this.denergy.length; ++i) {
                    debug.TprintBC("" + i);
                }
                debug.Trow();
                debug.TprintBC("Energy:");
                for (i = 0; i < this.denergy.length; ++i) {
                    debug.TprintBC(debugPrintout.formatNumber(this.denergy[i]));
                }
                debug.Tstop();
            }
            debug.println("<CENTER><B>Atom-based info info</B></CENTER>");
            debug.print("<TABLE border=1>");
            debug.print("<TR><TD rowspan=3><B>Atom</B></TD rowspan=3><TD rowspan=3><B>Confs</B></TD><TD rowspan=3><B>FCMD</TD><TD colspan=" + maxconf + "><B>Coordinates</B></TD></TR>");
            debug.print("<TR><TD colspan=" + maxconf + "><B>Metric vector</B></TD></TR>");
            debug.print("<TR>");
            for (i = 0; i < maxconf; ++i) {
                debug.print("<TD>" + i + "</TD>");
            }
            debug.print("</TR>");
            for (int a = 0; a < this.atoms; ++a) {
                int j;
                int i2;
                debug.print("<TR><TD rowspan=2>" + a + "</TD><TD rowspan=2>" + this.confs[a] + "</TD><TD rowspan=2>" + this.fcmd[a] + "</TD>");
                for (i2 = 0; i2 < this.confs[a]; ++i2) {
                    debug.print("<TD><TT>" + this.dims[i2][a] + "D </TT>");
                    for (j = 0; j < this.dims[i2][a]; ++j) {
                        debug.print(debugPrintout.formatNumber(this.coords[i2].getV(a, j)) + " ");
                    }
                    debug.print("</TD>");
                }
                debug.print("</TR>");
                debug.print("<TR>");
                for (i2 = 0; i2 < this.confs[a]; ++i2) {
                    debug.print("<TD><TT>" + this.dims[i2][a] + "D </TT>");
                    for (j = 0; j < this.dims[i2][a]; ++j) {
                        debug.print(debugPrintout.formatNumber(this.metric.getV(i2 * this.atoms + a, j)) + " ");
                    }
                    debug.print("</TD>");
                }
                debug.print("</TR>");
            }
            debug.print("</TABLE>");
            debug.decLevel();
        }
    }

    public void printInnerCoordinates(debugPrintout debug) {
        int c1no;
        int a2n;
        int i;
        debug.incLevel("Inner coordinates");
        int maxconfs = 0;
        for (i = 0; i < this.atoms; ++i) {
            if (this.confs[i] <= maxconfs) continue;
            maxconfs = this.confs[i];
        }
        debug.println("<B><CENTER>Bond length</CENTER></B>");
        debug.Tstart();
        debug.Trow();
        debug.TprintBC(2, 1, "#");
        debug.TprintBC(2, 1, "Atom1");
        debug.TprintBC(2, 1, "Atom2");
        debug.TprintBC(2, 1, "Type");
        debug.TprintBC(1, maxconfs, "length");
        debug.Trow();
        for (i = 0; i < maxconfs; ++i) {
            debug.TprintBC(i + "");
        }
        for (int b = 0; b < this.seq.mol.b; ++b) {
            int a1n = this.seq.mol.bat[0][b];
            a2n = this.seq.mol.bat[1][b];
            if (this.fcmd[a1n] != this.fcmd[a2n] || this.fcmd[a1n] < 0) continue;
            debug.Trow();
            debug.TprintBC("" + b);
            debug.TprintC("" + a1n);
            debug.TprintC("" + a2n);
            debug.TprintC("" + this.seq.mol.bdesc[b]);
            for (int i2 = 0; i2 < this.confs[a1n]; ++i2) {
                double[] a1 = this.getCoordinate(i2, a1n);
                double[] a2 = this.getCoordinate(i2, a2n);
                double[] m = this.getMetric(i2, a1n);
                double l = Math.sqrt(Math.abs(V.dotUsingMetric(V.minus(a1, a2), m)));
                debug.Tprint(debugPrintout.formatNumber(l));
            }
        }
        debug.Tstop();
        debug.println("<B><CENTER>Bond angles</CENTER></B>");
        debug.Tstart();
        debug.Trow();
        debug.TprintBC(2, 1, "Atom1");
        debug.TprintBC(2, 1, "Atom2");
        debug.TprintBC(2, 1, "Atom3");
        debug.TprintBC(2, 1, "Flags<SUB>Atom2</SUB>");
        debug.TprintBC(1, maxconfs, "Angle");
        debug.Trow();
        for (i = 0; i < maxconfs; ++i) {
            debug.TprintBC(i + "");
        }
        for (int a2n2 = 0; a2n2 < this.seq.mol.a; ++a2n2) {
            for (c1no = 0; c1no < this.seq.mol.ctab[a2n2].length - 1; ++c1no) {
                for (int c2no = c1no + 1; c2no < this.seq.mol.ctab[a2n2].length; ++c2no) {
                    int a1n = this.seq.mol.ctab[a2n2][c1no];
                    int a3n = this.seq.mol.ctab[a2n2][c2no];
                    if (this.fcmd[a1n] != this.fcmd[a2n2] || this.fcmd[a2n2] != this.fcmd[a3n] || this.fcmd[a1n] < 0) continue;
                    debug.Trow();
                    debug.TprintBC("" + a1n);
                    debug.TprintBC("" + a2n2);
                    debug.TprintBC("" + a3n);
                    debug.TprintC("" + this.seq.mol.atomFlag[a2n2]);
                    for (int i3 = 0; i3 < this.confs[a1n]; ++i3) {
                        double[] a1 = this.getCoordinate(i3, a1n);
                        double[] a2 = this.getCoordinate(i3, a2n2);
                        double[] a3 = this.getCoordinate(i3, a3n);
                        double[] m = this.getMetric(i3, a1n);
                        double l12 = Math.sqrt(Math.abs(V.dotUsingMetric(V.minus(a1, a2), m)));
                        double l23 = Math.sqrt(Math.abs(V.dotUsingMetric(V.minus(a2, a3), m)));
                        double l13 = Math.sqrt(Math.abs(V.dotUsingMetric(V.minus(a1, a3), m)));
                        double a = Math.acos((l12 * l12 + l23 * l23 - l13 * l13) / (2.0 * l12 * l23));
                        debug.Tprint(debugPrintout.formatNumber(a * 180.0 / Math.PI));
                    }
                }
            }
        }
        debug.Tstop();
        debug.println("<B><CENTER>Dihedral angles</CENTER></B>");
        debug.Tstart();
        debug.Trow();
        debug.TprintBC(2, 1, "Atom1");
        debug.TprintBC(2, 1, "Atom2");
        debug.TprintBC(2, 1, "Atom3");
        debug.TprintBC(2, 1, "Atom4");
        debug.TprintBC(1, maxconfs, "Angle");
        debug.Trow();
        for (i = 0; i < maxconfs; ++i) {
            debug.TprintBC(i + "");
        }
        for (int a1n = 0; a1n < this.seq.mol.a; ++a1n) {
            for (c1no = 0; c1no < this.seq.mol.ctab[a1n].length; ++c1no) {
                a2n = this.seq.mol.ctab[a1n][c1no];
                for (int c2no = 0; c2no < this.seq.mol.ctab[a2n].length; ++c2no) {
                    int a3n = this.seq.mol.ctab[a2n][c2no];
                    if (a3n == a1n) continue;
                    for (int c3no = 0; c3no < this.seq.mol.ctab[a3n].length; ++c3no) {
                        int a4n = this.seq.mol.ctab[a3n][c3no];
                        if (a4n == a2n || this.fcmd[a1n] != this.fcmd[a2n] || this.fcmd[a2n] != this.fcmd[a3n] || this.fcmd[a3n] != this.fcmd[a4n] || this.fcmd[a1n] < 0) continue;
                        debug.Trow();
                        debug.TprintBC("" + a1n);
                        debug.TprintBC("" + a2n);
                        debug.TprintBC("" + a3n);
                        debug.TprintBC("" + a4n);
                        for (int i4 = 0; i4 < this.confs[a1n]; ++i4) {
                            double[] a1 = this.getCoordinate(i4, a1n);
                            double[] a2 = this.getCoordinate(i4, a2n);
                            double[] a3 = this.getCoordinate(i4, a3n);
                            double[] a4 = this.getCoordinate(i4, a4n);
                            debug.Tprint(debugPrintout.formatNumber(WishListItem.calcDihedralAngle(a1, a2, a3, a4)));
                        }
                    }
                }
            }
        }
        debug.Tstop();
        debug.println("<B><CENTER>Full inner distance matrix</CENTER></B>");
        debug.Tstart();
        debug.Trow();
        debug.TprintBC(2, 1, "Atom1");
        debug.TprintBC(2, 1, "Atom2");
        debug.TprintBC(1, this.confs[0], "Metrid/distance");
        debug.Trow();
        for (i = 0; i < maxconfs; ++i) {
            debug.TprintBC(i + "");
        }
        for (i = 0; i < this.atoms; ++i) {
            for (int j = i + 1; j < this.atoms; ++j) {
                if (this.fcmd[i] != this.fcmd[j] || this.fcmd[i] < 0) continue;
                debug.Trow();
                debug.TprintBC("" + i);
                debug.TprintBC("" + j);
                if (this.fcmd[i] != this.fcmd[j]) continue;
                for (int f = 0; f < this.confs[i]; ++f) {
                    double[] a1 = this.getCoordinate(f, i);
                    double[] a2 = this.getCoordinate(f, j);
                    double[] m = this.getMetric(f, i);
                    double l = V.dotUsingMetric(V.minus(a1, a2), m);
                    debug.Tprint(debugPrintout.formatNumber(l) + " (" + debugPrintout.formatNumber(Math.sqrt(Math.abs(l))) + ")");
                }
            }
        }
        debug.Tstop();
        debug.decLevel();
    }

    public void updateFcmd(int cmd) {
        int i;
        int[] fragAtoms;
        if (this.seq.OP_Type[cmd] == -1) {
            this.fcmd[this.seq.OP1_Ref[cmd]] = cmd;
            this.fcmd[this.seq.OP2_Ref[cmd]] = cmd;
            return;
        }
        if (this.seq.OP_Type[cmd] == -2) {
            this.fcmd[this.seq.OP1_Ref[cmd]] = cmd;
            fragAtoms = this.seq.getAtomsForCommand(this.seq.OP2_Ref[cmd]);
            for (i = 0; i < fragAtoms.length; ++i) {
                this.fcmd[fragAtoms[i]] = cmd;
            }
        }
        if (this.seq.OP_Type[cmd] == -3) {
            fragAtoms = this.seq.getAtomsForCommand(this.seq.OP1_Ref[cmd]);
            for (i = 0; i < fragAtoms.length; ++i) {
                this.fcmd[fragAtoms[i]] = cmd;
            }
            fragAtoms = this.seq.getAtomsForCommand(this.seq.OP2_Ref[cmd]);
            for (i = 0; i < fragAtoms.length; ++i) {
                this.fcmd[fragAtoms[i]] = cmd;
            }
        }
    }

    public double[] getMetric(int c, int a) {
        double[] ret = new double[this.dims[c][a]];
        int mv = c * this.atoms + a;
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.metric.getV(mv, i);
        }
        return ret;
    }

    public void setMetric(int c, int a, int d, double m) {
        this.metric.putV(c * this.atoms + a, d, m);
    }

    public int getConformerCount(int stepno) {
        return this.confs[this.seq.getAnAtomFromFragment(stepno)];
    }

    public double[] getCoordinate(int pConformer, int pAtom) {
        double[] ret = new double[this.dims[pConformer][pAtom]];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.coords[pConformer].getV(pAtom, i);
        }
        return ret;
    }

    public FragmentStore(FuseCommandSequence s, int m) {
        int i;
        this.seq = s;
        this.atoms = this.seq.mol.a;
        this.multi = m;
        this.coords = new multiDim[this.multi];
        for (i = 0; i < this.multi; ++i) {
            this.coords[i] = new multiDim(this.atoms, 3);
        }
        this.metric = new multiDim(this.atoms * this.multi, this.coords[0].getMaxDim());
        this.confs = new int[this.atoms];
        this.dims = new int[this.multi][this.atoms];
        this.fcmd = new int[this.atoms];
        for (i = 0; i < this.atoms; ++i) {
            this.confs[i] = 0;
            for (int j = 0; j < this.multi; ++j) {
                this.dims[j][i] = 0;
            }
            this.fcmd[i] = -1;
        }
    }
}

