/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.build.FragmentAtomFinalItem;
import chemaxon.marvin.modelling.build.FragmentAtomFuseItem;
import chemaxon.marvin.modelling.build.FragmentAtomFuseStore;
import chemaxon.marvin.modelling.build.FragmentStore;
import chemaxon.marvin.modelling.build.FuseCommandSequence;
import chemaxon.marvin.modelling.build.FuseStep;
import chemaxon.marvin.modelling.build.WishList;
import chemaxon.marvin.modelling.build.WishListItem;
import chemaxon.marvin.modelling.debug.CleanDebug;
import chemaxon.marvin.modelling.debug.Tracer;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.M;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.struc.myMoleculeConstants;
import chemaxon.marvin.modelling.util.ProgressMonitor;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import chemaxon.marvin.modelling.util.U;

public class FuseBuilder {
    public static final int MAKECOORDS_OK = 1;
    public static final int MAKECOORDS_FAILED = 2;
    public static final int MAKECOORDS_CANCELLED = 3;
    myMolecule mol = null;
    StereoCriteriaList stereo = null;
    int lastResult = 0;
    double[][][] lastCoords = null;
    double[] lastEnergy = null;
    private boolean maxConfCountReached = false;
    private boolean overrideOptimizationLimit = false;
    private double overridenOptimizationLimit = -1.0;
    FuseCommandSequence seq = null;

    public void setOverridenOptimizationLimit(double l) {
        this.overrideOptimizationLimit = true;
        this.overridenOptimizationLimit = l;
    }

    public double[] getEnergies() {
        return this.lastEnergy;
    }

    public double[][][] getCoordinates() {
        return this.lastCoords;
    }

    public double[][] getCoordinates(int confid) {
        return this.lastCoords[confid];
    }

    public int getAtomCount() {
        return this.mol.a;
    }

    public int getConfCount() {
        return this.lastCoords.length;
    }

    public FuseBuilder(myMolecule mol, StereoCriteriaList stereo) {
        this.mol = mol;
        this.stereo = stereo;
    }

    public int getLastResult() {
        return this.lastResult;
    }

    public int makeCoords2(CleanParams cparams, ProgressMonitor pmon, CleanSettings settings, boolean doConfAnal) {
        if (settings.OPT_stopper_Fusebuilder_makecoords != null) {
            settings.OPT_stopper_Fusebuilder_makecoords.start();
        }
        this.lastResult = 0;
        int ret = 0;
        if (this.mol.a == 0) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Empty structure");
            }
            this.lastResult = 1;
            this.lastCoords = null;
            this.lastEnergy = null;
            ret = 1;
        } else if (this.mol.a == 1) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("One-atom structure");
            }
            this.mol.coord[0][0] = 0.0;
            this.mol.coord[0][1] = 0.0;
            this.mol.coord[0][2] = 0.0;
            this.lastResult = 1;
            this.lastCoords = new double[1][1][3];
            this.lastEnergy = new double[1];
            ret = 1;
        } else {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verboseInc("Entering method makeCoords2_0()");
            }
            ret = this.makeCoords2_0(cparams, pmon, settings, doConfAnal);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verboseDec("Method makeCoords2_0() returned with " + ret);
            }
            this.lastResult = ret;
        }
        if (settings.OPT_stopper_Fusebuilder_makecoords != null) {
            settings.OPT_stopper_Fusebuilder_makecoords.stop();
        }
        return ret;
    }

    int makeCoords2_0(CleanParams cparams, ProgressMonitor pmon, CleanSettings settings, boolean doConfAnal) {
        debugPrintout debug = CleanArgs.getDebug();
        this.maxConfCountReached = false;
        SimpleCanceller canceller = settings.getCanceller();
        if (canceller != null && canceller.isCancelled()) {
            this.lastResult = 3;
            return 3;
        }
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("Parameters");
            cparams.printout(debug);
            debug.decLevel();
            debug.println("doConfAnal=" + doConfAnal);
            if (this.stereo != null) {
                this.stereo.printout(debug, this.mol);
            } else {
                debug.println("Stereo = null");
            }
        }
        if (this.seq == null) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Construct FuseCommandSequence");
            }
            this.seq = new FuseCommandSequence(this.mol, this.stereo, debug, 3);
        }
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("Given molecule");
            this.mol.printout(debug);
            debug.decLevel();
            debug.incLevel("Generated sequence:");
            this.seq.printout(debug);
            debug.decLevel();
        }
        if (canceller != null && canceller.isCancelled()) {
            this.lastResult = 3;
            return 3;
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Construct FragmentStore for " + cparams.OPT_CP_FRAGMULTI_MAX);
        }
        FragmentStore frags = new FragmentStore(this.seq, cparams.OPT_CP_FRAGMULTI_MAX);
        if (debug != null && debug.getWillPrint()) {
            debug.printBC("Start fusing");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Start fusing");
        }
        if (pmon != null) {
            pmon.init(this.seq.cmds);
            pmon.set(0);
        }
        if (!Clean3D.OPT_DEBUG_SKIPBUILD) {
            for (int currentFuseStep = 0; currentFuseStep < this.seq.cmds; ++currentFuseStep) {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Fuse step " + currentFuseStep);
                }
                String summaryString = "";
                long timeBeforeStep = System.currentTimeMillis();
                if (canceller != null && canceller.isCancelled()) {
                    this.lastResult = 3;
                    return 3;
                }
                if (debug != null && debug.getWillPrint()) {
                    debug.printHR();
                }
                if (this.seq.OP_Type[currentFuseStep] == -1) {
                    this.doAtomAtomFusingStep(this.seq, frags, debug, currentFuseStep);
                }
                if (this.seq.OP_Type[currentFuseStep] == -2) {
                    int i;
                    int ii;
                    int i2;
                    int i3;
                    int i4;
                    int atomToPlace;
                    int i5;
                    int a1 = this.seq.OP1_Ref[currentFuseStep];
                    int f1 = this.seq.OP2_Ref[currentFuseStep];
                    boolean fuseStepClassification = false;
                    int tmp_trace_fusestep = 0;
                    if (CleanArgs.cltracer != null) {
                        tmp_trace_fusestep = CleanArgs.cltracer.getNodeID();
                        CleanArgs.cltracer.incDetail(5, Tracer.getNewIntID());
                        debug = CleanArgs.getDebug();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("Fuse atom " + a1);
                        debug.println("To fragment " + f1);
                        debug.printHR();
                        debug.println("<CENTER><B>Initialization</B></CENTER>");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Generate wishlists info");
                    }
                    WishList wishl = new WishList(this.mol, a1, f1, frags, debug);
                    wishl.saveParticipants();
                    if (debug != null && debug.getWillPrint()) {
                        debug.decLevel();
                    }
                    int SUMMARY_RICT = 0;
                    int SUMMARY_NEWD = 0;
                    int SUMMARY_OPT = 0;
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Whistlist generated:");
                        wishl.printout();
                        debug.decLevel();
                    }
                    if (canceller != null && canceller.isCancelled()) {
                        this.lastResult = 3;
                        return 3;
                    }
                    FragmentAtomFuseStore store = new FragmentAtomFuseStore(frags, this.seq, wishl, a1, f1, frags.multi * 12);
                    Fragment currentFuseStepFrag = store.getFragment(this.stereo, settings);
                    int[] fragatoms = this.seq.getAtomsForCommand(f1);
                    FuseStep fuseStep = new FuseStep(this.mol, fragatoms, a1);
                    fuseStep.setBaseFragmentCoordinates(frags.getCoordinateArray(fragatoms));
                    if (debug != null && debug.getWillPrint()) {
                        fuseStep.getBaseFrag(settings).placeApplet("Base fragment 2D");
                        fuseStep.getBaseFrag(settings).getFragMol().place3DApplets("Base Fragment 3D", fuseStep.getBaseFragmentCoordinates(), null);
                    }
                    boolean Hin2 = false;
                    boolean Hin3 = false;
                    if (debug != null) {
                        debug.incLevel("Look for Hin2/3 hack");
                    }
                    if (this.mol.anum[a1] == 1 && this.mol.ctab[a1].length == 1) {
                        if (debug != null) {
                            debug.println("This is an H atom with 1 neighbor");
                        }
                        int Hcount = 0;
                        int base = this.mol.ctab[a1][0];
                        for (int i6 = 0; i6 < this.mol.ctab[base].length; ++i6) {
                            if (this.mol.anum[this.mol.ctab[base][i6]] != 1 || this.mol.ctab[this.mol.ctab[base][i6]].length != 1 || (this.mol.bdesc[this.mol.blist[base][i6]] & 1) == 0) continue;
                            ++Hcount;
                        }
                        if (debug != null) {
                            debug.println("Hcount=" + Hcount);
                        }
                        if (Hcount == 2) {
                            Hin2 = true;
                        }
                        if (Hcount == 3 && this.mol.ctab[base].length == 4) {
                            Hin3 = true;
                        }
                    }
                    if (debug != null) {
                        debug.decLevel();
                    }
                    store.initStore(Hin2, Hin3);
                    if (this.seq.OP_Flags[currentFuseStep] == 3) {
                        boolean in3_4_ring = false;
                        for (i5 = 0; i5 < this.seq.mol.atomToRing[a1].length; ++i5) {
                            if (this.seq.mol.SSSR[this.seq.mol.atomToRing[a1][i5]].length >= 5) continue;
                            in3_4_ring = true;
                        }
                        if (!in3_4_ring) {
                            if (debug != null && debug.getWillPrint()) {
                                debug.incLevel("Make wish group:");
                            }
                            wishl.groupByTarget(debug, store);
                            if (debug != null && debug.getWillPrint()) {
                                debug.decLevel();
                                debug.incLevel("Wishlist after");
                                wishl.printout();
                                debug.decLevel();
                            }
                        }
                    }
                    if (CleanArgs.cltracer != null) {
                        CleanArgs.cltracer.changeTaskID(6);
                        debug = CleanArgs.cltracer.getDebug();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printHR();
                        debug.println("<CENTER><B>Start atom placement</B></CENTER>");
                        debug.printBC("ROUND I: triangulations (and in-space place)");
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("#");
                        debug.TprintBC("Conf");
                        debug.TprintBC("Ready");
                        debug.TprintBC("Optreq");
                        debug.TprintBC("Fin.");
                    }
                    for (atomToPlace = 0; atomToPlace < store.getSize(); ++atomToPlace) {
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.Trow();
                        }
                        FragmentAtomFuseItem atom = store.get(atomToPlace);
                        if (debug != null && debug.getWillPrint()) {
                            debug.TprintBC("" + atomToPlace);
                            debug.print("<TD><CENTER>");
                            debug.incLevel("" + atom.confNo);
                            debug.print("</CENTER></TD>");
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("<CENTER><B>Start triangulation</B></CENTER>");
                        }
                        atom.doTriangulation(wishl, store, debug);
                        atom.doInSpacePlacement(store, wishl, debug);
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.TprintC("" + atom.getReady());
                        }
                        if (atom.getReady()) {
                            if (debug != null && debug.getWillPrint()) {
                                debug.TprintBC("" + store.getLastFinal().isOptRequired());
                            }
                            FragmentAtomFinalItem fin = store.getLastFinal();
                            if (debug != null && debug.getWillPrint()) {
                                debug.print("<TD><CENTER>");
                            }
                            if (debug != null && debug.getWillPrint()) {
                                debug.incLevel("" + (store.getFinalSize() - 1));
                            }
                            if (debug != null && debug.getWillPrint()) {
                                fin.printout(debug);
                            }
                            if (debug != null && debug.getWillPrint()) {
                                debug.decLevel();
                            }
                            if (debug == null || !debug.getWillPrint()) continue;
                            debug.print("</CENTER></TD>");
                            continue;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.TprintBC("");
                        }
                        if (debug == null || !debug.getWillPrint()) continue;
                        debug.TprintBC("");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.Tstop();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printBC("ROUND II: Place +/- mres in space");
                    }
                    for (atomToPlace = 0; atomToPlace < store.getSize(); ++atomToPlace) {
                        FragmentAtomFuseItem atom = store.get(atomToPlace);
                        if (atom.getReady()) continue;
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Step: " + atomToPlace);
                        }
                        atom.placeMresInSpace(store, debug);
                        if (debug == null || !debug.getWillPrint()) continue;
                        debug.decLevel();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printBC("ROUND II-2: try RICT finalization");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Create list");
                    }
                    FragmentAtomFuseItem.RICTdescList rdl = new FragmentAtomFuseItem.RICTdescList(store);
                    rdl.fillRMSDs(store, wishl, frags);
                    rdl.sortByRMSD();
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("RICT list");
                        rdl.printout(debug);
                        debug.decLevel();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("RICT list after clip");
                        rdl.printout(debug);
                        debug.decLevel();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printBC("ROUND II-2: try RICT finalization");
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("A#");
                        debug.TprintBC("Conf");
                        debug.TprintBC("Success");
                    }
                    for (i5 = 0; i5 < rdl.valids; ++i5) {
                        int steps;
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        int atomToPlace2 = rdl.it[i5].a;
                        FragmentAtomFuseItem atom = store.get(atomToPlace2);
                        if (atom.getReady()) continue;
                        if (debug != null && debug.getWillPrint()) {
                            debug.Trow();
                            debug.TprintBC("" + atomToPlace2);
                            debug.TprintBC("" + atom.confNo);
                            debug.print("<TD><CENTER>");
                            debug.incLevel("xxxx");
                        }
                        rdl.it[i5].steps = steps = atom.doRICT(this.seq, frags, store, wishl, debug);
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel("" + (atom.getReady() ? "in " + steps : "-"));
                            debug.print("</CENTER></TD>");
                        }
                        if (!atom.getReady()) continue;
                        ++SUMMARY_RICT;
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.Tstop();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("RICT list after RICTS");
                        rdl.printout(debug);
                        debug.decLevel();
                    }
                    if (store.getFinalSize() == 0) {
                        if (CleanArgs.cltracer != null) {
                            CleanArgs.cltracer.reportError(5, "Makecoords failed");
                            CleanArgs.cltracer.decDetail(tmp_trace_fusestep);
                            debug = CleanArgs.getDebug();
                        }
                        this.lastResult = 2;
                        return 2;
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("Atom candidates placed.");
                    }
                    if (CleanArgs.cltracer != null) {
                        CleanArgs.cltracer.changeTaskID(7);
                        debug = CleanArgs.getDebug();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printHR();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printBC("Selection");
                        debug.incLevel("Merged candidates");
                        for (i5 = 0; i5 < store.getFinalSize(); ++i5) {
                            debug.incLevel(i5 + "Merged candidate");
                            store.getFinal(i5).printout(debug);
                            debug.decLevel();
                        }
                        debug.decLevel();
                        frags.writeConformersApplet(null, "State of fragment store");
                        store.writeFinalConformersApplet(debug, "" + a1, "All merged final items");
                    }
                    int maxConfNo = 1;
                    boolean doRing = false;
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("OP flag: " + this.seq.OP_Flags[currentFuseStep]);
                    }
                    switch (this.seq.OP_Flags[currentFuseStep]) {
                        case 1: 
                        case 4: {
                            maxConfNo = cparams.OPT_CP_FRAGMULTI_CHAIN;
                            if (debug == null || !debug.getWillPrint()) break;
                            debug.println("Chain multiplicity:" + maxConfNo);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 5: {
                            doRing = true;
                            int nextRingClose = -1;
                            for (int i7 = currentFuseStep + 1; i7 < this.seq.cmds; ++i7) {
                                if (this.seq.OP_Flags[i7] != 3) continue;
                                nextRingClose = i7 - currentFuseStep;
                                break;
                            }
                            maxConfNo = nextRingClose > 0 && nextRingClose < 5 ? cparams.OPT_CP_FRAGMULTI_RINGBEFORECLOSE : cparams.OPT_CP_FRAGMULTI_RING;
                            if (debug == null || !debug.getWillPrint()) break;
                            debug.println("Ring multiplicity:" + maxConfNo + " Next ring close: " + nextRingClose);
                        }
                    }
                    boolean useRingCloseHeuristic = false;
                    int rn = 0;
                    int[] a2 = null;
                    int[] npb = null;
                    int[] plb = null;
                    int[] rca = null;
                    int[] rcafc = null;
                    double[] bestd = null;
                    double[] mind = null;
                    double[] maxd = null;
                    if (this.seq.OP_Flags[currentFuseStep] == 2 || this.seq.OP_Flags[currentFuseStep] == 3 || this.seq.OP_Flags[currentFuseStep] == 5) {
                        int i8;
                        useRingCloseHeuristic = true;
                        if (debug != null && debug.getWillPrint()) {
                            debug.printHR();
                            debug.printBC("Ring close look ahead");
                        }
                        double bnd = -1.0;
                        rn = this.mol.rings[a1];
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("Rings: " + rn);
                        }
                        a2 = new int[rn];
                        npb = new int[rn];
                        plb = new int[rn];
                        rca = new int[rn];
                        rcafc = new int[rn];
                        bestd = new double[rn];
                        mind = new double[rn];
                        maxd = new double[rn];
                        if (debug != null && debug.getWillPrint()) {
                            debug.printB("Run through rings");
                        }
                        for (int cr = 0; cr < rn; ++cr) {
                            int a_2;
                            int a_1;
                            int a_0;
                            int ar;
                            int cri = this.mol.atomToRing[a1][cr];
                            if (debug != null && debug.getWillPrint()) {
                                debug.println("Ring: " + cr + " (SSSR #:" + cri + ")");
                            }
                            boolean a2fw = store.atomToFragmentA[this.mol.atomToRingNextP[a1][cr]] == -1;
                            rca[cr] = a1;
                            rcafc[cr] = this.seq.ATOM_Ref[rca[cr]];
                            int[] nexta = new int[4];
                            int nextap = 0;
                            int i9 = a1;
                            do {
                                if (nextap < nexta.length) {
                                    nexta[nextap++] = i9;
                                }
                                ar = 0;
                                while (this.mol.atomToRing[i9][ar] != cri) {
                                    ++ar;
                                }
                                i9 = a2fw ? this.mol.atomToRingNextP[i9][ar] : this.mol.atomToRingPrevP[i9][ar];
                                int n = cr;
                                npb[n] = npb[n] + 1;
                                if (rcafc[cr] >= this.seq.ATOM_Ref[i9]) continue;
                                rca[cr] = i9;
                                rcafc[cr] = this.seq.ATOM_Ref[rca[cr]];
                            } while (store.atomToFragmentA[i9] == -1 && i9 != a1);
                            a2[cr] = i9;
                            while (i9 != a1) {
                                ar = 0;
                                while (this.mol.atomToRing[i9][ar] != cri) {
                                    ++ar;
                                }
                                i9 = a2fw ? this.mol.atomToRingNextP[i9][ar] : this.mol.atomToRingPrevP[i9][ar];
                                int n = cr;
                                plb[n] = plb[n] + 1;
                            }
                            if (plb[cr] == 0 || npb[cr] == 0) {
                                if (debug != null && debug.getWillPrint()) {
                                    debug.println("No metrid preference");
                                }
                                bestd[cr] = -1.0;
                                mind[cr] = -1.0;
                                maxd[cr] = -1.0;
                                continue;
                            }
                            if (npb[cr] == 1) {
                                if (debug != null && debug.getWillPrint()) {
                                    debug.println("Ring closed, no metrid preference");
                                }
                                bestd[cr] = -1.0;
                                mind[cr] = -1.0;
                                maxd[cr] = -1.0;
                                continue;
                            }
                            if (npb[cr] == 2) {
                                if (debug != null && debug.getWillPrint()) {
                                    debug.println("Bond angle preference");
                                }
                                a_0 = a1;
                                a_1 = rca[cr];
                                a_2 = a2[cr];
                                if (debug != null && debug.getWillPrint()) {
                                    debug.println("   angle: " + a_0 + " " + a_1 + " " + a_2);
                                }
                                double bl1 = this.seq.mol.getBlen(a_0, a_1);
                                double bl2 = this.seq.mol.getBlen(a_1, a_2);
                                double fi = this.seq.mol.getBangl(a_0, a_1, a_2);
                                bestd[cr] = Math.sqrt(M.sqr(bl1) + M.sqr(bl2) - 2.0 * bl1 * bl2 * Math.cos(M.deg2rad(fi)));
                                mind[cr] = 0.7 * bestd[cr];
                                maxd[cr] = 1.3 * bestd[cr];
                                if (debug == null || !debug.getWillPrint()) continue;
                                debug.println("   params: a0-a1-a2:" + a_0 + "-" + a_1 + "-" + a_2 + " bl1,bl2:" + bl1 + "," + bl2 + " fi:" + fi);
                                debug.println("   result: " + mind[cr] + ":" + bestd[cr] + ":" + maxd[cr]);
                                continue;
                            }
                            if (npb[cr] == 3) {
                                if (debug != null && debug.getWillPrint()) {
                                    debug.println("Torsion preference");
                                }
                                a_0 = nexta[0];
                                a_1 = nexta[1];
                                a_2 = nexta[2];
                                int a_3 = a2[cr];
                                double bl1 = this.seq.mol.getBlen(a_0, a_1);
                                double bl2 = this.seq.mol.getBlen(a_1, a_2);
                                double bl3 = this.seq.mol.getBlen(a_2, a_3);
                                double fi1 = this.seq.mol.getBangl(a_0, a_1, a_2);
                                double fi2 = this.seq.mol.getBangl(a_1, a_2, a_3);
                                mind[cr] = WishListItem.calcTorsion14MD(bl1 * 0.9, bl2 * 0.9, bl3 * 0.9, fi1 * 0.9, fi2 * 0.9, 0.0);
                                double fi_opt = 60.0;
                                if ((this.seq.mol.ringflags[cri] & myMoleculeConstants.R_AROMATIC) != 0) {
                                    if (debug != null && debug.getWillPrint()) {
                                        debug.println("Aromatic!");
                                    }
                                    fi_opt = 0.0;
                                }
                                bestd[cr] = WishListItem.calcTorsion14MD(bl1, bl2, bl3, fi1, fi2, fi_opt);
                                maxd[cr] = WishListItem.calcTorsion14MD(bl1 * 1.1, bl2 * 1.1, bl3 * 1.1, fi1 > 165.0 ? 180.0 : fi1 * 1.1, fi2 > 165.0 ? 180.0 : fi2 * 1.1, 180.0);
                                continue;
                            }
                            if (debug != null && debug.getWillPrint()) {
                                debug.println("General chord estimation preference");
                            }
                            mind[cr] = 1.0;
                            bestd[cr] = 1.0 * (double)(plb[cr] + npb[cr]) * Math.sin(Math.PI * (double)npb[cr] / (double)(npb[cr] + plb[cr])) / Math.PI;
                            maxd[cr] = (double)npb[cr] * 1.3 + 2.0;
                        }
                        useRingCloseHeuristic = false;
                        for (i8 = 0; i8 < rn; ++i8) {
                            if (bestd[i8] == -1.0) continue;
                            useRingCloseHeuristic = true;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.Tstart();
                            debug.Trow();
                            debug.TprintBC(5, "Ring close heuristic");
                            debug.Trow();
                            debug.TprintBC("#");
                            debug.TprintBC("a2");
                            debug.TprintBC("npb");
                            debug.TprintBC("plb");
                            debug.TprintBC("rca");
                            debug.TprintBC("rcafc");
                            debug.TprintBC("mind");
                            debug.TprintBC("bestd");
                            debug.TprintBC("maxd");
                            for (i8 = 0; i8 < rn; ++i8) {
                                debug.Trow();
                                debug.Tprint("" + i8);
                                debug.Tprint("" + a2[i8]);
                                debug.Tprint("" + npb[i8]);
                                debug.Tprint("" + plb[i8]);
                                debug.Tprint("" + rca[i8]);
                                debug.Tprint("" + rcafc[i8]);
                                debug.Tprint(debugPrintout.formatNumber(mind[i8]));
                                debug.Tprint(debugPrintout.formatNumber(bestd[i8]));
                                debug.Tprint(debugPrintout.formatNumber(maxd[i8]));
                            }
                            debug.Tstop();
                            debug.printHR();
                        }
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printHR();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Init Dreiding energy calculations");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Create molecule fragment");
                    }
                    myMolecule molf = new myMolecule(store.getFinalCoordArrayAtoms(), null, this.seq.mol, debug);
                    if (debug != null && debug.getWillPrint()) {
                        debug.decLevel();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Molecule fragment");
                        molf.printout(debug);
                        debug.decLevel();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Invoke Dreiding constructor");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.decLevel();
                    }
                    if (canceller != null && canceller.isCancelled()) {
                        this.lastResult = 3;
                        return 3;
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printHR();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Build selection tables");
                    }
                    int confs = store.getSize();
                    FragmentAtomFuseStore.FinalDescriptorArray tmpDArray = new FragmentAtomFuseStore.FinalDescriptorArray(store);
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Created final descriptors");
                        tmpDArray.printout(debug);
                        debug.decLevel();
                    }
                    int n = 0;
                    int finalSelectionSum = tmpDArray.valids;
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("Total items: " + finalSelectionSum);
                    }
                    int[] tmpA = tmpDArray.getSelA();
                    int[] tmpC = tmpDArray.getSelC();
                    int[] tmpD = new int[finalSelectionSum];
                    boolean[] tmpCfault = new boolean[finalSelectionSum];
                    int[] tmpTC = new int[finalSelectionSum];
                    double[] tmpM = new double[finalSelectionSum];
                    boolean[] ricted = new boolean[finalSelectionSum];
                    double[] denergy = new double[finalSelectionSum];
                    boolean[] stereoOK = new boolean[finalSelectionSum];
                    boolean[] optreq = new boolean[finalSelectionSum];
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Fill selection table");
                    }
                    int a = 0;
                    n = 0;
                    FragmentAtomFuseStore f_store = store;
                    for (n = 0; n < finalSelectionSum; ++n) {
                        boolean str;
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        a = tmpA[n];
                        i4 = tmpC[n];
                        FragmentAtomFinalItem fin = store.getFinal(a);
                        int f_i = i4;
                        if (debug != null && debug.getWillPrint()) {
                            debug.printB("n: fin=" + a + " sel=" + i4);
                        }
                        store.fillMoleculeFragmentCoordinates(fin, i4, molf);
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("molf for Dreiding");
                            molf.printout(debug);
                            debug.decLevel();
                        }
                        double[][] coord = store.getFinalCoordArray(fin, i4);
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Invoke Dreiding energy");
                        }
                        denergy[n] = currentFuseStepFrag.calcDreiding(coord);
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Check stereo");
                        }
                        boolean bl = str = currentFuseStepFrag.checkStereo(coord, false, 0.1, debug) == 1;
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel("Stereo OK:" + str);
                        }
                        stereoOK[n] = str;
                        tmpD[n] = store.getFinalAtomDim(fin);
                        tmpTC[n] = store.get((int)fin.no).confNo;
                        boolean bl2 = ricted[n] = store.get((int)fin.no).state == 3;
                        if (currentFuseStep == this.seq.cmds - 1) {
                            fin.setOptRequired(i4);
                        }
                        optreq[n] = fin.isOptRequired(i4);
                        if (useRingCloseHeuristic) {
                            tmpM[n] = 0.0;
                            for (int j = 0; j < rn; ++j) {
                                if (!(bestd[j] > 0.0)) continue;
                                double[] v = V.minus(store.getFinalAtomCoord(fin, i4), store.getFinalFragmentCoord(fin, i4, store.atomToFragmentA[a2[j]]));
                                double dist = V.dotUsingMetric(v, store.getFinalMetric(fin));
                                int n2 = n;
                                tmpM[n2] = tmpM[n2] - M.sqr(dist - M.sqr(bestd[j]));
                                if (!(dist > M.sqr(maxd[j])) && !(dist < M.sqr(mind[j]))) continue;
                                tmpCfault[n] = true;
                            }
                        }
                        if (tmpCfault[n]) continue;
                        tmpM[n] = -denergy[n];
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.decLevel();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Selection table");
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("line");
                        debug.TprintBC("#");
                        debug.TprintBC("Sel");
                        debug.TprintBC("Target Conf");
                        debug.TprintBC("Dim");
                        debug.TprintBC("Close fault");
                        debug.TprintBC("M<SUP>2</SUP>SUM");
                        debug.TprintBC("RICTED");
                        debug.TprintBC("Dreiding E");
                        debug.TprintBC("Stereo OK");
                        debug.TprintBC("Opt req");
                        for (i4 = 0; i4 < tmpA.length; ++i4) {
                            debug.Trow();
                            debug.Tprint("" + i4);
                            debug.Tprint("" + tmpA[i4]);
                            debug.Tprint("" + tmpC[i4]);
                            debug.Tprint("" + tmpTC[i4]);
                            debug.Tprint("" + tmpD[i4]);
                            debug.Tprint("" + tmpCfault[i4]);
                            debug.Tprint(TextUtils.formatNumber(tmpM[i4]));
                            debug.Tprint("" + ricted[i4]);
                            debug.Tprint(TextUtils.formatNumber(denergy[i4]));
                            debug.Tprint("" + stereoOK[i4]);
                            debug.Tprint("" + optreq[i4]);
                        }
                        debug.Tstop();
                        debug.decLevel();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Sort selection table");
                    }
                    boolean swap = true;
                    int swap_end = tmpA.length - 1;
                    while (swap) {
                        swap = false;
                        for (int i10 = 0; i10 < swap_end; ++i10) {
                            boolean swap_energy;
                            if (canceller != null && canceller.isCancelled()) {
                                this.lastResult = 3;
                                return 3;
                            }
                            boolean swap_dimension = tmpD[i10] > tmpD[i10 + 1] && tmpD[i10] > 3;
                            boolean same_D = tmpD[i10] == tmpD[i10 + 1];
                            boolean swap_stereo = same_D && !stereoOK[i10] && stereoOK[i10 + 1];
                            boolean same_stereo = stereoOK[i10] == stereoOK[i10 + 1];
                            boolean swap_closefault = same_D && same_stereo && tmpCfault[i10] && !tmpCfault[i10 + 1];
                            boolean same_closeOK = tmpCfault[i10] == tmpCfault[i10 + 1];
                            boolean bl = swap_energy = same_D && same_closeOK && same_stereo && tmpM[i10] < tmpM[i10 + 1];
                            if (!swap_dimension && !swap_closefault && !swap_stereo && !swap_energy) continue;
                            swap = true;
                            int tmp = tmpD[i10];
                            tmpD[i10] = tmpD[i10 + 1];
                            tmpD[i10 + 1] = tmp;
                            tmp = tmpA[i10];
                            tmpA[i10] = tmpA[i10 + 1];
                            tmpA[i10 + 1] = tmp;
                            tmp = tmpC[i10];
                            tmpC[i10] = tmpC[i10 + 1];
                            tmpC[i10 + 1] = tmp;
                            double tmp2 = tmpM[i10];
                            tmpM[i10] = tmpM[i10 + 1];
                            tmpM[i10 + 1] = tmp2;
                            tmp2 = denergy[i10];
                            denergy[i10] = denergy[i10 + 1];
                            denergy[i10 + 1] = tmp2;
                            boolean tmp3 = tmpCfault[i10];
                            tmpCfault[i10] = tmpCfault[i10 + 1];
                            tmpCfault[i10 + 1] = tmp3;
                            tmp3 = ricted[i10];
                            ricted[i10] = ricted[i10 + 1];
                            ricted[i10 + 1] = tmp3;
                            tmp3 = stereoOK[i10];
                            stereoOK[i10] = stereoOK[i10 + 1];
                            stereoOK[i10 + 1] = tmp3;
                            tmp3 = optreq[i10];
                            optreq[i10] = optreq[i10 + 1];
                            optreq[i10 + 1] = tmp3;
                        }
                    }
                    if (canceller != null && canceller.isCancelled()) {
                        this.lastResult = 3;
                        return 3;
                    }
                    boolean setnonricted = false;
                    for (int i11 = tmpA.length - 1; i11 >= 0; --i11) {
                        if (setnonricted) {
                            ricted[i11] = false;
                            continue;
                        }
                        if (ricted[i11] || !stereoOK[i11] || tmpCfault[i11]) continue;
                        setnonricted = true;
                    }
                    int conf3Dno = 0;
                    int noclosefault = 0;
                    int nonricted3D = 0;
                    int stereoOKs = 0;
                    int energyOK = 0;
                    for (i3 = 0; i3 < tmpA.length; ++i3) {
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (tmpD[i3] <= 3 && conf3Dno == i3) {
                            ++conf3Dno;
                        }
                        if (!tmpCfault[i3] && stereoOK[i3] && noclosefault == i3) {
                            ++noclosefault;
                        }
                        if (!(ricted[i3] && optreq[i3] || tmpD[i3] > 3 || !stereoOK[i3] || nonricted3D != i3)) {
                            ++nonricted3D;
                        }
                        if (stereoOK[i3] && i3 == stereoOKs) {
                            ++stereoOKs;
                        }
                        if (i3 < 4) {
                            ++energyOK;
                            continue;
                        }
                        if (energyOK <= maxConfNo) {
                            if (!(denergy[i3] - denergy[3] < 2000.0)) continue;
                            ++energyOK;
                            continue;
                        }
                        this.maxConfCountReached = true;
                        if (!(denergy[i3] - denergy[3] < 500.0)) continue;
                        ++energyOK;
                    }
                    if (stereoOKs == 0 && !cparams.ACCEPT_STEREO_NOK) {
                        if (CleanArgs.cltracer != null) {
                            CleanArgs.cltracer.reportError(5, "Makecoords failed - no stereo ok");
                            CleanArgs.cltracer.decDetail(tmp_trace_fusestep);
                            debug = CleanArgs.cltracer.getDebug();
                        }
                        this.lastResult = 2;
                        return 2;
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Counts:");
                        debug.println("conf3Dno=" + conf3Dno);
                        debug.println("noclosefault=" + noclosefault);
                        debug.println("nonricted3D=" + nonricted3D);
                        debug.println("stereoOKs=" + stereoOKs);
                        debug.println("energyOK=" + energyOK);
                        debug.incLevel("Sorted selection table");
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("line");
                        debug.TprintBC("#");
                        debug.TprintBC("Sel");
                        debug.TprintBC("Target Conf");
                        debug.TprintBC("Dim");
                        debug.TprintBC("Close fault");
                        debug.TprintBC("M<SUP>2</SUP>SUM");
                        debug.TprintBC("RICTED");
                        debug.TprintBC("StereoOK");
                        debug.TprintBC("opt req");
                        for (i3 = 0; i3 < tmpA.length; ++i3) {
                            debug.Trow();
                            debug.Tprint("" + i3);
                            debug.Tprint("" + tmpA[i3]);
                            debug.Tprint("" + tmpC[i3]);
                            debug.Tprint("" + tmpTC[i3]);
                            debug.Tprint("" + tmpD[i3]);
                            debug.Tprint("" + tmpCfault[i3]);
                            debug.Tprint(TextUtils.formatNumber(tmpM[i3]));
                            debug.Tprint("" + ricted[i3]);
                            debug.Tprint("" + stereoOK[i3]);
                            debug.Tprint("" + optreq[i3]);
                        }
                        debug.Tstop();
                        debug.decLevel();
                    }
                    int valids = 0;
                    for (valids = 0; valids < tmpA.length; ++valids) {
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (conf3Dno > 0 && valids == conf3Dno || nonricted3D > 0 && valids == nonricted3D || stereoOKs > 0 && valids == stereoOKs || energyOK > 0 && valids == energyOK) break;
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printHR();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Diagonal sort");
                    }
                    int[] slp = new int[store.conformers];
                    for (int i12 = 0; i12 < slp.length; ++i12) {
                        slp[i12] = i12;
                    }
                    int[] slc = new int[valids];
                    for (int i13 = 0; i13 < valids; ++i13) {
                        int n3 = tmpTC[i13];
                        slp[n3] = slp[n3] + 1;
                    }
                    int[] dpt = new int[valids];
                    for (i2 = 0; i2 < valids; ++i2) {
                        dpt[i2] = i2;
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Initial diagonal permution");
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("line");
                        debug.TprintBC("#");
                        debug.TprintBC("Sel");
                        debug.TprintBC("Target Conf");
                        debug.TprintBC("Dim");
                        debug.TprintBC("Close fault");
                        debug.TprintBC("M<SUP>2</SUP>SUM");
                        debug.TprintBC("dpt");
                        debug.TprintBC("slc");
                        ii = 0;
                        while (ii < valids) {
                            i = ii++;
                            debug.Trow();
                            debug.Tprint("" + i);
                            debug.Tprint("" + tmpA[i]);
                            debug.Tprint("" + tmpC[i]);
                            debug.Tprint("" + tmpTC[i]);
                            debug.Tprint("" + tmpD[i]);
                            debug.Tprint("" + tmpCfault[i]);
                            debug.Tprint(TextUtils.formatNumber(tmpM[i]));
                            debug.Tprint("" + dpt[i]);
                            debug.Tprint("" + slc[i]);
                        }
                        debug.Tstop();
                        debug.decLevel();
                    }
                    swap = true;
                    swap_end = valids - 1;
                    while (swap) {
                        swap = false;
                        for (i2 = 0; i2 < swap_end; ++i2) {
                            if (slc[i2] <= slc[i2 + 1] && (slc[i2] != slc[i2 + 1] || tmpTC[dpt[i2]] <= tmpTC[dpt[i2 + 1]])) continue;
                            int j = slc[i2];
                            slc[i2] = slc[i2 + 1];
                            slc[i2 + 1] = j;
                            j = dpt[i2];
                            dpt[i2] = dpt[i2 + 1];
                            dpt[i2 + 1] = j;
                            swap = true;
                        }
                        --swap_end;
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("Permutated table");
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("line");
                        debug.TprintBC("Selection table row");
                        debug.TprintBC("#");
                        debug.TprintBC("Sel");
                        debug.TprintBC("Target Conf");
                        debug.TprintBC("Dim");
                        debug.TprintBC("Close fault");
                        debug.TprintBC("M<SUP>2</SUP>SUM");
                        debug.TprintBC("slc");
                        for (ii = 0; ii < valids; ++ii) {
                            i = dpt[ii];
                            debug.Trow();
                            debug.Tprint("" + ii);
                            debug.Tprint("" + i);
                            debug.Tprint("" + tmpA[i]);
                            debug.Tprint("" + tmpC[i]);
                            debug.Tprint("" + tmpTC[i]);
                            debug.Tprint("" + tmpD[i]);
                            debug.Tprint("" + tmpCfault[i]);
                            debug.Tprint(TextUtils.formatNumber(tmpM[i]));
                            debug.Tprint("" + slc[ii]);
                        }
                        debug.Tstop();
                        debug.decLevel();
                    }
                    int[] selA = new int[maxConfNo];
                    int[] selC = new int[maxConfNo];
                    for (n = 0; n < selA.length && n < tmpA.length && n < valids; ++n) {
                        selA[n] = tmpA[dpt[n]];
                        selC[n] = tmpC[dpt[n]];
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printHR();
                        debug.printB("State:");
                        frags.printOut(debug);
                        frags.printInnerCoordinates(debug);
                        debug.println("Max conf: " + maxConfNo);
                        debug.println("Final candidates: " + confs);
                        debug.println("Valid conformers: " + valids);
                        debug.println("Conformer storage: " + tmpA.length);
                        debug.println("Selected conformers: " + n);
                        debug.printHR();
                        debug.println("Check for optimization");
                    }
                    int norig = n;
                    if (currentFuseStep == this.seq.cmds - 1 && !doConfAnal) {
                        if (n > 1) {
                            n = 1;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.printB("Set conformer count to 1.");
                        }
                    }
                    boolean noOptimize = true;
                    for (int i14 = 0; i14 < norig; ++i14) {
                        if (!store.getFinal((int)selA[i14]).opt_required) continue;
                        noOptimize = false;
                    }
                    double[] de = null;
                    if (!noOptimize) {
                        FragmentAtomFuseStore.FinalDescriptorArray poda = new FragmentAtomFuseStore.FinalDescriptorArray(norig, selA, selC, null);
                        poda.fillStereoOk(store, molf, currentFuseStepFrag, debug, settings);
                        if (debug != null && debug.getWillPrint()) {
                            debug.printB("Opt. required!");
                            debug.incLevel("Init final descriptors");
                            poda.printout(debug);
                            debug.decLevel();
                        }
                        double e0 = denergy[dpt[0]];
                        boolean on = false;
                        boolean ready = false;
                        int cp = 0;
                        CleanDebug.MolAppletRecorder optrec = null;
                        if (debug != null && debug.getWillPrint()) {
                            optrec = new CleanDebug.MolAppletRecorder("Optimization states", "Optimization states");
                        }
                        if (debug == null || debug.getWillPrint()) {
                            // empty if block
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        StereoCriteriaList.PhantomAtomList pal = this.stereo.constructPhantomAtomList(currentFuseStepFrag.getAtomList());
                        Fragment currentFuseStepFragWithPhantoms = new Fragment(pal.extendMol(currentFuseStepFrag.getFragMol().getOriginalMolCopy()), settings);
                        double[][] coordsWithPhantoms = null;
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("Phantom atom list constructed");
                            pal.printout(debug);
                            currentFuseStepFragWithPhantoms.placeApplet("Frgament with phantoms");
                            debug.println("Optimization loop for " + n);
                        }
                        int[] optsteps = new int[norig];
                        int[] edgeno = new int[norig];
                        for (cp = 0; cp < n; ++cp) {
                            optsteps[cp] = -1;
                            if (debug != null && debug.getWillPrint()) {
                                debug.println("Optimization for " + cp);
                            }
                            FragmentAtomFinalItem fin = store.getFinal(selA[cp]);
                            if ((this.seq.OP_Flags[currentFuseStep] != 2 || (this.seq.OP_Desc[currentFuseStep] & 2) != 0) && fin.isOptRequired(selC[cp])) {
                                ready = false;
                                int i15 = cp;
                                if (debug != null && debug.getWillPrint()) {
                                    debug.printB("Optimize selection " + i15);
                                }
                                if (debug != null && debug.getWillPrint()) {
                                    debug.println("Get coordinates");
                                }
                                double[] M2 = store.getFinalMetric(fin);
                                double[][] c = store.getFinalCoordArray(fin, selC[i15]);
                                if (coordsWithPhantoms == null) {
                                    coordsWithPhantoms = pal.getExtendedCoordinates(c);
                                } else {
                                    pal.fillExtendedCoordinates(c, coordsWithPhantoms);
                                }
                                if (debug != null && debug.getWillPrint()) {
                                    currentFuseStepFrag.getFragMol().place3DApplet("Coordinates", c);
                                    currentFuseStepFragWithPhantoms.getFragMol().place3DApplet("With phantoms", coordsWithPhantoms);
                                }
                                int limitToUse = CleanArgs.OPT_LIMITS_PREOPT;
                                if (currentFuseStep == this.seq.cmds - 1) {
                                    limitToUse = doConfAnal ? CleanArgs.OPT_LIMITS_LASTOPTCA : CleanArgs.OPT_LIMITS_LASTOPT;
                                }
                                double optLimit = CleanArgs.OPT_LIMITS_VALUES[limitToUse];
                                if (this.overrideOptimizationLimit) {
                                    optLimit = this.overridenOptimizationLimit;
                                }
                                for (int ii2 = 1; ii2 < coordsWithPhantoms.length; ++ii2) {
                                    for (int jj = 0; jj < ii2; ++jj) {
                                        if (!(V.vectLenSquare(coordsWithPhantoms[ii2], coordsWithPhantoms[jj]) < 0.001)) continue;
                                        double[] dArray = coordsWithPhantoms[ii2];
                                        dArray[0] = dArray[0] + 0.1;
                                    }
                                }
                                currentFuseStepFragWithPhantoms.optimizeDreiding(coordsWithPhantoms, optLimit);
                                if (debug != null && debug.getWillPrint()) {
                                    currentFuseStepFragWithPhantoms.getFragMol().place3DApplet("After opt with phantoms", coordsWithPhantoms);
                                }
                                double[] newM = new double[]{1.0, 1.0, 1.0};
                                double[][] newC = new double[c.length][3];
                                U.copyToFirstItems(coordsWithPhantoms, newC);
                                int lastOptimizeSteps = 1;
                                if (canceller != null && canceller.isCancelled()) {
                                    this.lastResult = 3;
                                    return 3;
                                }
                                if (norig > n) {
                                    boolean str;
                                    if (debug != null && debug.getWillPrint()) {
                                        debug.incLevel("Stereo check");
                                    }
                                    boolean bl = str = currentFuseStepFrag.checkStereo(newC, false, 0.1, debug) == 1;
                                    if (debug != null && debug.getWillPrint()) {
                                        debug.decLevel();
                                    }
                                    if (debug != null && debug.getWillPrint()) {
                                        debug.println("Stereo OK:" + str);
                                    }
                                    boolean proxfailed = false;
                                    for (int j = 0; j < molf.a; ++j) {
                                        for (int k = j + 1; k < molf.a; ++k) {
                                            if (molf.bonds[j][k] != -1) continue;
                                            double Me = V.dot(V.minus(newC[j], newC[k]));
                                            double mlimit = 2.0;
                                            if (molf.anum[j] == 1 && molf.anum[k] == 1) {
                                                mlimit = 1.0;
                                            }
                                            if (!(Me < mlimit)) continue;
                                            proxfailed = true;
                                        }
                                    }
                                    if (debug != null && debug.getWillPrint()) {
                                        debug.println("Proximity failed: " + proxfailed);
                                    }
                                    if (!str || proxfailed) {
                                        ++n;
                                    }
                                }
                                FragmentAtomFinalItem newfin = new FragmentAtomFinalItem(fin.no, newC, newM);
                                int newfinindex = store.finals.add(newfin);
                                ++SUMMARY_OPT;
                                selA[i15] = store.finals.size() - 1;
                                selC[i15] = 0;
                                optsteps[i15] = lastOptimizeSteps;
                                continue;
                            }
                            if (debug == null || !debug.getWillPrint()) continue;
                            debug.println(" Optimization delayed...");
                        }
                        if (optrec != null) {
                            optrec.placeButtonApplet(debug);
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.printBC("Stereo backcheck");
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Init final descriptors");
                        }
                        FragmentAtomFuseStore.FinalDescriptorArray da = new FragmentAtomFuseStore.FinalDescriptorArray(n, selA, selC, optsteps);
                        if (debug != null && debug.getWillPrint()) {
                            da.printout(debug);
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Stereo check");
                        }
                        da.fillStereoOk(store, molf, currentFuseStepFrag, debug, settings);
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (!cparams.ACCEPT_STEREO_NOK && currentFuseStep == this.seq.cmds - 1) {
                            if (debug != null && debug.getWillPrint()) {
                                debug.incLevel("Proximity check");
                            }
                            da.fillProxOK(store, molf, debug);
                            if (debug != null && debug.getWillPrint()) {
                                debug.decLevel();
                            }
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("After stereo and proximity check");
                            da.printout(debug);
                            debug.decLevel();
                        }
                        da.SortByStereoOK();
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("After stereook sort");
                        }
                        if (debug != null && debug.getWillPrint()) {
                            da.printout(debug);
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        da.ClipStereoNOK(cparams.ACCEPT_STEREO_NOK);
                        if (!cparams.ACCEPT_STEREO_NOK && currentFuseStep == this.seq.cmds - 1) {
                            da.ClipProxNOK();
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("After clipping stereo (and proximity) NOK");
                            da.printout(debug);
                            debug.decLevel();
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Remove NANs");
                        }
                        da.removeNANs(store, molf, debug);
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Remove duplicates");
                        }
                        da.removeDuplicates(store, molf, debug, null, false, settings);
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("After removed duplicates");
                            da.printout(debug);
                            debug.decLevel();
                        }
                        n = da.getn();
                        selA = da.getSelA();
                        selC = da.getSelC();
                        de = da.getDreidingE();
                        if (n == 0) {
                            if (CleanArgs.cltracer != null) {
                                CleanArgs.cltracer.reportError(5, "Makecoords failed");
                                CleanArgs.cltracer.decDetail(tmp_trace_fusestep);
                                debug = CleanArgs.getDebug();
                            }
                            this.lastResult = 2;
                            return 2;
                        }
                    } else {
                        if (debug != null && debug.getWillPrint()) {
                            debug.printBC("No optimization");
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("Remove duplicateds");
                        }
                        FragmentAtomFuseStore.FinalDescriptorArray da = new FragmentAtomFuseStore.FinalDescriptorArray(n, selA, selC, null);
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Fill stereoOK and energy");
                        }
                        da.fillStereoOk(store, molf, currentFuseStepFrag, debug, settings);
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Filled table");
                        }
                        if (debug != null && debug.getWillPrint()) {
                            da.printout(debug);
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("Remove duplicates");
                        }
                        da.removeDuplicates(store, molf, debug, null, true, settings);
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (canceller != null && canceller.isCancelled()) {
                            this.lastResult = 3;
                            return 3;
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.incLevel("After remove");
                        }
                        if (debug != null && debug.getWillPrint()) {
                            da.printout(debug);
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.decLevel();
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("New n: " + n);
                        }
                        n = da.getn();
                        selA = da.getSelA();
                        selC = da.getSelC();
                        de = da.getDreidingE();
                        if (n == 0) {
                            if (CleanArgs.cltracer != null) {
                                CleanArgs.cltracer.reportError(5, "Makecoords failed");
                                CleanArgs.cltracer.decDetail(tmp_trace_fusestep);
                                debug = CleanArgs.getDebug();
                            }
                            this.lastResult = 2;
                            return 2;
                        }
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printHR();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Do merge");
                    }
                    store.mergeFinalAtoms(n, selA, selC, de, debug);
                    frags.updateFcmd(currentFuseStep);
                    if (debug != null && debug.getWillPrint()) {
                        frags.printOut(debug);
                        frags.printInnerCoordinates(debug);
                    }
                    if (CleanArgs.cltracer != null) {
                        CleanArgs.cltracer.decDetail(tmp_trace_fusestep);
                        debug = CleanArgs.getDebug();
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("Confs: <B>" + store.conformers + "</B>");
                        debug.println("Finals: <B>" + store.getFinalSize() + "</B>");
                        debug.println("Mergeds: <B>" + frags.confs[a1] + "</B>");
                        switch (this.seq.OP_Flags[currentFuseStep]) {
                            case 1: {
                                debug.println("<B>Chain</B>");
                                break;
                            }
                            case 5: {
                                debug.println("<B>Ringset center</B>");
                                break;
                            }
                            case 4: {
                                debug.println("<B>Interring BB</B>");
                                break;
                            }
                            case 3: {
                                debug.println("<B>Ring close</B>");
                                break;
                            }
                            case 2: {
                                debug.println("<B>Ring</B>");
                            }
                        }
                        if (SUMMARY_RICT != 0) {
                            debug.println("RICTs: " + SUMMARY_RICT);
                        }
                        if (SUMMARY_NEWD != 0) {
                            debug.println("NEWDs: " + SUMMARY_NEWD);
                        }
                        if (SUMMARY_OPT != 0) {
                            debug.println("OPTs: " + SUMMARY_OPT);
                        }
                    }
                    if (canceller != null && canceller.isCancelled()) {
                        this.lastResult = 3;
                        return 3;
                    }
                }
                if (this.seq.OP_Type[currentFuseStep] == -3) {
                    int f1 = this.seq.OP1_Ref[currentFuseStep];
                    int f2 = this.seq.OP2_Ref[currentFuseStep];
                    if (debug != null && debug.getWillPrint()) {
                        debug.incLevel("FUSE step " + currentFuseStep + " F " + f1 + " - F " + f2);
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("NOT IMPLEMENTED.");
                    }
                    if (debug != null && debug.getWillPrint()) {
                        frags.printInnerCoordinates(debug);
                    }
                    if (debug != null && debug.getWillPrint()) {
                        frags.printOut(debug);
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.decLevel();
                    }
                }
                String sel = null;
                if (this.seq.OP_Type[currentFuseStep] == -2) {
                    sel = "" + this.seq.OP1_Ref[currentFuseStep];
                }
                if (CleanArgs.cltracer != null) {
                    CleanArgs.cltracer.changeTaskID(4, currentFuseStep);
                    CleanArgs.getDebug();
                }
                if (CleanArgs.cltracer != null && CleanArgs.cltracer.getVisualisationState() && debug != null && debug.getWillPrint()) {
                    frags.writeConformersApplet(sel, "State of fragment store after fuseStep <B>" + currentFuseStep + "</B>:");
                }
                long timeNow = System.currentTimeMillis();
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Last step time: " + (timeNow - timeBeforeStep));
                }
                if (pmon == null) continue;
                pmon.set(currentFuseStep + 1);
            }
        }
        if (debug != null && debug.getWillPrint()) {
            debug.printHR();
            debug.println("Fuse sequence processed");
            frags.printOut(debug);
            frags.printInnerCoordinates(debug);
        }
        if (!cparams.ACCEPT_STEREO_NOK) {
            boolean blerror = false;
            for (int i = 0; i < this.seq.mol.b; ++i) {
                int a1 = this.seq.mol.bat[0][i];
                int a2 = this.seq.mol.bat[1][i];
                double desBLen = this.seq.mol.blen[i];
                double m = V.dot(V.minus(frags.getCoordinate(0, a1), frags.getCoordinate(0, a2)));
                if (!(m > desBLen * desBLen * 4.0)) continue;
                System.err.println("Metrid (bond) mismatch: " + a1 + " " + a2);
                if (CleanArgs.cltracer != null) {
                    CleanArgs.cltracer.reportError(5, "Makecoords failed - bond length error");
                }
                this.lastResult = 2;
                return 2;
            }
        }
        this.lastCoords = frags.getCoordArray();
        this.lastEnergy = frags.getEnergyArray();
        for (int i = 0; i < this.mol.a; ++i) {
            this.mol.coord[i][0] = frags.coords[0].getV(i, 0);
            this.mol.coord[i][1] = frags.coords[0].getV(i, 1);
            this.mol.coord[i][2] = frags.coords[0].getV(i, 2);
        }
        this.lastResult = 1;
        return 1;
    }

    private void doAtomAtomFusingStep(FuseCommandSequence seq, FragmentStore frags, debugPrintout debug, int step) {
        if (seq.OP_Type[step] != -1) {
            throw new UnsupportedOperationException("Not an atom-atom fuse step");
        }
        int a1 = seq.OP1_Ref[step];
        int a2 = seq.OP2_Ref[step];
        int e = seq.mol.bonds[a1][a2];
        double l = 1.5;
        if (e >= 0) {
            l = seq.mol.blen[e];
        }
        frags.confs[a1] = 1;
        frags.confs[a2] = 1;
        frags.dims[0][a1] = 3;
        frags.dims[0][a2] = 3;
        frags.updateFcmd(step);
        frags.coords[0].putV(a1, 0, 0.0);
        frags.coords[0].putV(a1, 1, 0.0);
        frags.coords[0].putV(a1, 2, 0.0);
        frags.coords[0].putV(a2, 0, l);
        frags.coords[0].putV(a2, 1, 0.0);
        frags.coords[0].putV(a2, 2, 0.0);
        frags.setMetric(0, a1, 0, 1.0);
        frags.setMetric(0, a1, 1, 1.0);
        frags.setMetric(0, a1, 2, 1.0);
        frags.setMetric(0, a2, 0, 1.0);
        frags.setMetric(0, a2, 1, 1.0);
        frags.setMetric(0, a2, 2, 1.0);
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("FUSE step " + step + " A " + a1 + " - A " + a2);
            debug.println("Bond number: " + e);
            debug.println("Bond length: " + l);
            debug.println("A " + a1 + " - A " + a2);
            frags.printOut(debug);
            frags.printInnerCoordinates(debug);
            debug.decLevel();
        }
    }

    public boolean isMaxConfCountReached() {
        return this.maxConfCountReached;
    }

    public static class CleanParams
    implements Cloneable {
        public int OPT_CP_FRAGMULTI_MAX = 50;
        public int OPT_CP_FRAGMULTI_RINGBEFORECLOSE = 50;
        public int OPT_CP_FRAGMULTI_RING = 50;
        public int OPT_CP_FRAGMULTI_CHAIN = 20;
        public boolean ACCEPT_STEREO_NOK = false;

        public void setAllConfCount(int c) {
            this.OPT_CP_FRAGMULTI_CHAIN = c;
            this.OPT_CP_FRAGMULTI_MAX = c;
            this.OPT_CP_FRAGMULTI_RING = c;
            this.OPT_CP_FRAGMULTI_RINGBEFORECLOSE = c;
        }

        public int getMaxConfCount() {
            return this.OPT_CP_FRAGMULTI_MAX;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception e) {
                return null;
            }
        }

        public void printout(debugPrintout debug) {
            debug.printB("CleanParams:");
            debug.println("FRAGMULTI CHAIN: " + this.OPT_CP_FRAGMULTI_CHAIN);
            debug.println("FRAGMULTI RING: " + this.OPT_CP_FRAGMULTI_RING);
            debug.println("FRAGMULTI RING before close: " + this.OPT_CP_FRAGMULTI_RINGBEFORECLOSE);
            debug.println("Accept stereo NOK: " + this.ACCEPT_STEREO_NOK);
        }
    }

    public static class CleanPreferences {
        int initialConformersCount = CleanArgs.OPT_FUSEBUILD_DEFAULT_INIT_CONFCOUNT;
        int conformerMultiplication = 3;
        int maxConfCount = CleanArgs.OPT_FUSEBUILD_DEFAULT_MAX_CONFCOUNT;

        public CleanParams iterateActualParam(CleanParams param, int expectedConformerCount) {
            CleanParams newp = null;
            if (param == null) {
                newp = new CleanParams();
                int ct = this.initialConformersCount;
                if (ct < expectedConformerCount) {
                    ct = expectedConformerCount;
                }
                if (ct >= this.maxConfCount) {
                    ct = this.maxConfCount;
                }
                newp.setAllConfCount(ct);
            } else {
                int ct = param.getMaxConfCount();
                if (ct >= this.maxConfCount) {
                    return null;
                }
                if ((ct *= this.conformerMultiplication) < expectedConformerCount) {
                    ct = expectedConformerCount;
                }
                if (ct >= this.maxConfCount) {
                    ct = this.maxConfCount;
                }
                newp = new CleanParams();
                newp.setAllConfCount(ct);
            }
            return newp;
        }
    }
}

