/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.core.util.BondTable;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.JQuatFit;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.BitSet;

public class FuseFragments
implements CallbackIface {
    int[][] fusePairs = null;
    int[][] subst1Pairs = null;
    int[][] subst2Pairs = null;
    int[][] addedPairs = null;
    double[][][] multiCoord1 = null;
    double[][][] multiCoord2 = null;
    double[][][] fusedMultiCoord = null;
    boolean prepareMultiCoord = false;
    double fitRMS;
    Molecule m1 = null;
    Molecule m2 = null;
    Molecule fusedMolecule = null;

    public FuseFragments(Molecule mol1, int[] f1List, Molecule mol2, int[] f2List) {
        this.setupFuseFragments(mol1, f1List, null, mol2, f2List, null);
    }

    public FuseFragments(Molecule mol1, int[] f1List, int[][] s1List, Molecule mol2, int[] f2List, int[][] s2List) {
        this.setupFuseFragments(mol1, f1List, s1List, mol2, f2List, s2List);
    }

    public FuseFragments(Molecule mol1, int[] f1List, int[][] s1List, Molecule mol2, int[] f2List, int[][] s2List, double[][][] mC1, double[][][] mC2) {
        this.setupFuseFragments(mol1, f1List, s1List, mol2, f2List, s2List);
        this.multiCoord1 = (double[][][])mC1.clone();
        this.multiCoord2 = (double[][][])mC2.clone();
    }

    public FuseFragments(Molecule mol1, int[] f1List, int[][] s1List, Molecule mol2, int[] f2List, int[][] s2List, double[][][] mC1, double[][][] mC2, boolean prepareMulti) {
        this.setupFuseFragments(mol1, f1List, s1List, mol2, f2List, s2List);
        this.multiCoord1 = (double[][][])mC1.clone();
        this.multiCoord2 = (double[][][])mC2.clone();
        this.prepareMultiCoord = prepareMulti;
    }

    @Override
    public Object callback(String request, Object arg) {
        if (this.fusedMolecule == null) {
            this.fuseFragments();
        }
        if (request != null) {
            if (request == "fusedMolecule") {
                return this.fusedMolecule;
            }
            System.err.println("Unknown request in FuseFragments.callback.");
        }
        return null;
    }

    void setupFuseFragments(Molecule mol1, int[] f1List, int[][] s1List, Molecule mol2, int[] f2List, int[][] s2List) {
        if (f1List.length == f2List.length) {
            int j;
            int i;
            this.m1 = mol1.cloneMolecule();
            this.m2 = mol2.cloneMolecule();
            int fuseLength = 0;
            if (s1List != null) {
                fuseLength = s1List.length;
            }
            if (s2List != null) {
                fuseLength += s2List.length;
            }
            this.fusePairs = new int[2][fuseLength += f1List.length];
            int iShift = 0;
            if (s1List != null) {
                this.subst1Pairs = new int[s1List.length][];
                block8: for (i = 0; i < s1List.length; ++i) {
                    this.subst1Pairs[i] = new int[s1List[i].length];
                    for (j = 0; j < s2List[i].length; ++j) {
                        this.subst1Pairs[i][j] = s1List[i][j];
                    }
                    switch (s1List[i].length) {
                        case 2: {
                            this.fusePairs[0][i] = s1List[i][0];
                            this.fusePairs[1][i] = s1List[i][1];
                            continue block8;
                        }
                        case 4: {
                            this.fusePairs[0][i] = s1List[i][1];
                            this.fusePairs[1][i] = s1List[i][3];
                            continue block8;
                        }
                    }
                }
                iShift = this.subst1Pairs.length;
            }
            if (s2List != null) {
                this.subst2Pairs = new int[s2List.length][];
                block10: for (i = 0; i < s2List.length; ++i) {
                    this.subst2Pairs[i] = new int[s2List[i].length];
                    for (j = 0; j < s2List[i].length; ++j) {
                        this.subst2Pairs[i][j] = s2List[i][j];
                    }
                    switch (s2List[i].length) {
                        case 2: {
                            this.fusePairs[0][iShift + i] = s2List[i][0];
                            this.fusePairs[1][iShift + i] = s2List[i][1];
                            continue block10;
                        }
                        case 4: {
                            this.fusePairs[0][iShift + i] = s2List[i][1];
                            this.fusePairs[1][iShift + i] = s2List[i][3];
                            continue block10;
                        }
                    }
                }
                iShift += this.subst2Pairs.length;
            }
            for (i = 0; i < f1List.length; ++i) {
                this.fusePairs[0][iShift + i] = f1List[i];
                this.fusePairs[1][iShift + i] = f2List[i];
            }
        }
    }

    public Molecule getFusedMolecule() {
        if (this.fusedMolecule == null) {
            this.fuseFragments();
        }
        return this.fusedMolecule;
    }

    void doSubstitutions(Molecule base, Molecule subst, int[][] substPairs) {
        for (int i = 0; i < substPairs.length; ++i) {
            MolAtom sAtAt;
            MolAtom bAtAt;
            int sAtInd;
            int bAtInd;
            if (substPairs[i].length == 4) {
                bAtInd = substPairs[i][1];
                sAtInd = substPairs[i][3];
                bAtAt = base.getAtom(bAtInd);
                sAtAt = subst.getAtom(sAtInd);
                MolAtom bAtAt1 = base.getAtom(substPairs[i][0]);
                MolAtom sAtAt1 = subst.getAtom(substPairs[i][0]);
                double bBLen = Math.sqrt((sAtAt.getX() - sAtAt1.getX()) * (sAtAt.getX() - sAtAt1.getX()) + (sAtAt.getY() - sAtAt1.getY()) * (sAtAt.getY() - sAtAt1.getY()) + (sAtAt.getZ() - sAtAt1.getZ()) * (sAtAt.getZ() - sAtAt1.getZ()));
                double sBLen = Math.sqrt((bAtAt.getX() - bAtAt1.getX()) * (bAtAt.getX() - bAtAt1.getX()) + (bAtAt.getY() - bAtAt1.getY()) * (bAtAt.getY() - bAtAt1.getY()) + (bAtAt.getZ() - bAtAt1.getZ()) * (bAtAt.getZ() - bAtAt1.getZ()));
                if (bBLen > 0.0) {
                    double sc = sBLen / bBLen;
                    bAtAt.setX((1.0 - sc) * bAtAt1.getX() + sc * bAtAt.getX());
                    bAtAt.setY((1.0 - sc) * bAtAt1.getY() + sc * bAtAt.getY());
                    bAtAt.setZ((1.0 - sc) * bAtAt1.getZ() + sc * bAtAt.getZ());
                }
            } else {
                bAtInd = substPairs[i][0];
                sAtInd = substPairs[i][1];
                bAtAt = base.getAtom(bAtInd);
                sAtAt = subst.getAtom(sAtInd);
            }
            double x = bAtAt.getX();
            double y = bAtAt.getX();
            double z = bAtAt.getX();
            bAtAt.set(sAtAt);
            bAtAt.setXYZ(x, y, z);
        }
    }

    public static double[][][] doSubstitutions(double[][][] baseCoords, double[][] substCoords, int[][] substPairs) {
        for (int i = 0; i < substPairs.length; ++i) {
            if (substPairs[i].length != 4) continue;
            int bAt0 = substPairs[i][0];
            int bAt1 = substPairs[i][1];
            int sAt0 = substPairs[i][2];
            int sAt1 = substPairs[i][3];
            double sBLen = Math.sqrt(V.dot(V.minus(substCoords[sAt1], substCoords[sAt0])));
            for (int j = 0; j < baseCoords.length; ++j) {
                double[] baseBond = V.minus(baseCoords[j][bAt1], baseCoords[j][bAt0]);
                double bBLen = Math.sqrt(V.dot(baseBond));
                if (!(bBLen > 0.0)) continue;
                double sc = sBLen / bBLen;
                V.plus(baseCoords[j][bAt0], V.scale(baseBond, sc, baseBond), baseCoords[j][bAt1]);
            }
        }
        return baseCoords;
    }

    static double[][] pairFit(double[][] reference, double[][] fit, int[][] fitPairs, double[][] result) {
        int i;
        int len = reference.length + fit.length - fitPairs[0].length;
        if (result == null) {
            result = new double[len][3];
        }
        JQuatFit qFit = new JQuatFit(reference);
        double fitQuality = qFit.quatfit(fit, fitPairs);
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.println("Pair fit quality:" + fitQuality);
            debug.println("Lengths: " + reference.length + " " + fit.length + " " + fitPairs[0].length);
        }
        for (i = 0; i < reference.length; ++i) {
            result[i][0] = reference[i][0];
            result[i][1] = reference[i][1];
            result[i][2] = reference[i][2];
        }
        for (i = 0; i < fitPairs[0].length; ++i) {
            int iResult;
            int iBase = iResult = fitPairs[0][i];
            int iFit = fitPairs[1][i];
            double sc = 0.5;
            result[iResult] = V.scale(V.plus(reference[iBase], fit[iFit], result[iResult]), sc, result[iResult]);
        }
        BitSet commonFlag = new BitSet(fit.length);
        for (int i2 = 0; i2 < fitPairs[1].length; ++i2) {
            commonFlag.set(fitPairs[1][i2]);
        }
        int indx = reference.length;
        for (int i3 = 0; i3 < fit.length; ++i3) {
            if (commonFlag.get(i3)) continue;
            result[indx][0] = fit[i3][0];
            result[indx][1] = fit[i3][1];
            result[indx][2] = fit[i3][2];
            ++indx;
        }
        return result;
    }

    public static double[][][] simpleFit(double[][][] baseCoords, double[][][] fuseCoords, int[][] fusePairs, boolean multiFit) {
        int nAtoms = baseCoords[0].length + fuseCoords[0].length - fusePairs[0].length;
        double[][][] result = null;
        if (multiFit) {
            int i;
            JQuatFit qFit = new JQuatFit(baseCoords[0]);
            int[][] fusePairs0 = new int[][]{fusePairs[0], fusePairs[0]};
            for (i = 1; i < baseCoords.length; ++i) {
                qFit.quatfit(baseCoords[i], fusePairs0);
            }
            for (i = 0; i < fuseCoords.length; ++i) {
                qFit.quatfit(fuseCoords[i], fusePairs);
            }
            return FuseFragments.fillMultiCoord(baseCoords, fuseCoords, fusePairs);
        }
        result = new double[baseCoords.length * fuseCoords.length][nAtoms][3];
        for (int i = 0; i < baseCoords.length; ++i) {
            int ij0 = i * fuseCoords.length;
            for (int j = 0; j < fuseCoords.length; ++j) {
                int ij = ij0 + j;
                result[ij] = FuseFragments.pairFit(baseCoords[i], fuseCoords[j], fusePairs, result[ij]);
            }
        }
        return result;
    }

    void fuseFragments() {
        if (this.fusePairs != null) {
            int i;
            int i2;
            int[][] tmpPairs;
            int nAt1 = this.m1.getAtomCount();
            int nAt2 = this.m1.getAtomCount();
            double[][] coords1 = new double[nAt1][3];
            double[][] coords2 = new double[nAt2][3];
            if (this.multiCoord1 != null) {
                for (int i3 = 0; i3 < nAt1; ++i3) {
                    coords1[i3][0] = this.m1.getAtom(i3).getX();
                    coords1[i3][1] = this.m1.getAtom(i3).getY();
                    coords1[i3][2] = this.m1.getAtom(i3).getZ();
                }
                JQuatFit qFit1 = new JQuatFit(coords1);
                tmpPairs = new int[][]{this.fusePairs[0], this.fusePairs[0]};
                for (i2 = 0; i2 < this.multiCoord1.length; ++i2) {
                    qFit1.quatfit(this.multiCoord1[i2], tmpPairs);
                }
            }
            if (this.multiCoord2 != null) {
                for (int i4 = 0; i4 < nAt2; ++i4) {
                    coords1[i4][0] = this.m2.getAtom(i4).getX();
                    coords1[i4][1] = this.m2.getAtom(i4).getY();
                    coords1[i4][2] = this.m2.getAtom(i4).getZ();
                }
                JQuatFit qFit2 = new JQuatFit(coords1);
                tmpPairs = new int[][]{this.fusePairs[1], this.fusePairs[1]};
                for (i2 = 0; i2 < this.multiCoord2.length; ++i2) {
                    qFit2.quatfit(this.multiCoord2[i2], tmpPairs);
                }
            }
            if (this.subst2Pairs != null) {
                this.doSubstitutions(this.m2, this.fusedMolecule, this.subst2Pairs);
            }
            if (this.subst1Pairs != null) {
                this.doSubstitutions(this.fusedMolecule, this.m2, this.subst1Pairs);
            }
            for (i = 0; i < nAt1; ++i) {
                coords1[i][0] = this.m1.getAtom(i).getX();
                coords1[i][1] = this.m1.getAtom(i).getY();
                coords1[i][2] = this.m1.getAtom(i).getZ();
            }
            for (i = 0; i < nAt2; ++i) {
                coords2[i][0] = this.m2.getAtom(i).getX();
                coords2[i][1] = this.m2.getAtom(i).getY();
                coords2[i][2] = this.m2.getAtom(i).getZ();
            }
            if (this.multiCoord1 != null) {
                for (i = 0; i < this.multiCoord1.length; ++i) {
                    for (int j = 0; j < this.fusePairs[0].length; ++j) {
                        this.multiCoord1[i][this.fusePairs[0][j]][0] = coords1[this.fusePairs[0][j]][0];
                        this.multiCoord1[i][this.fusePairs[0][j]][1] = coords1[this.fusePairs[0][j]][1];
                        this.multiCoord1[i][this.fusePairs[0][j]][2] = coords1[this.fusePairs[0][j]][2];
                    }
                }
            }
            if (this.multiCoord2 != null) {
                for (i = 0; i < this.multiCoord2.length; ++i) {
                    for (int j = 0; j < this.fusePairs[0].length; ++j) {
                        this.multiCoord2[i][this.fusePairs[0][j]][0] = coords2[this.fusePairs[0][j]][0];
                        this.multiCoord2[i][this.fusePairs[0][j]][1] = coords2[this.fusePairs[0][j]][1];
                        this.multiCoord2[i][this.fusePairs[0][j]][2] = coords2[this.fusePairs[0][j]][2];
                    }
                }
            }
            JQuatFit qFit = new JQuatFit(coords1);
            qFit.quatfit(coords2, this.fusePairs);
            this.fitRMS = qFit.q[0];
            for (int i5 = 0; i5 < nAt2; ++i5) {
                this.m2.getAtom(i5).setXYZ(coords2[i5][0], coords2[i5][1], coords2[i5][2]);
            }
            this.fusedMolecule = this.m1;
            if (this.multiCoord1 != null) {
                int[][] tmpPairs2 = new int[][]{this.fusePairs[0], this.fusePairs[0]};
                for (i2 = 0; i2 < this.multiCoord1.length; ++i2) {
                    qFit.quatfit(this.multiCoord1[i2], tmpPairs2);
                }
            }
            if (this.multiCoord2 != null) {
                int[][] tmpPairs3 = new int[][]{this.fusePairs[1], this.fusePairs[1]};
                for (i2 = 0; i2 < this.multiCoord1.length; ++i2) {
                    qFit.quatfit(this.multiCoord2[i2], tmpPairs3);
                }
            }
            for (int ii = 0; ii < this.fusePairs[0].length; ++ii) {
                int i1 = this.fusePairs[0][ii];
                int i22 = this.fusePairs[1][ii];
                double x = (coords1[i1][0] + coords2[i22][0]) / 2.0;
                double y = (coords1[i1][1] + coords2[i22][1]) / 2.0;
                double z = (coords1[i1][2] + coords2[i22][2]) / 2.0;
                coords1[i1][0] = x;
                coords1[i1][1] = y;
                coords1[i1][2] = z;
                this.fusedMolecule.getAtom(i1).setXYZ(x, y, z);
            }
            if (this.multiCoord1 != null && this.multiCoord2 != null) {
                for (int i6 = 0; i6 < this.multiCoord1.length; ++i6) {
                    for (int j = 0; j < this.fusePairs[0].length; ++j) {
                        this.multiCoord1[i6][this.fusePairs[0][j]][0] = coords1[this.fusePairs[0][j]][0];
                        this.multiCoord1[i6][this.fusePairs[0][j]][1] = coords1[this.fusePairs[0][j]][1];
                        this.multiCoord1[i6][this.fusePairs[0][j]][2] = coords1[this.fusePairs[0][j]][2];
                    }
                }
            }
            BitSet fusedAtomFlag = new BitSet(nAt2);
            for (i2 = 0; i2 < this.fusePairs[1].length; ++i2) {
                fusedAtomFlag.set(this.fusePairs[1][i2]);
            }
            int[][] m2CTab = this.m2.getCtab();
            BondTable m2BTab = this.m2.getBondTable();
            if (this.addedPairs == null) {
                this.addedPairs = new int[nAt2 - this.fusePairs[0].length][2];
                int addCounter = 0;
                for (int i7 = 0; i7 < this.fusePairs[1].length; ++i7) {
                    int baseAt = this.fusePairs[0][i7];
                    int fusedAt = this.fusePairs[1][i7];
                    addCounter = this.addConnectedAtoms(this.fusedMolecule, this.m2, baseAt, fusedAt, m2CTab, m2BTab, fusedAtomFlag, this.addedPairs, addCounter);
                }
            }
            for (int i8 = 0; i8 < this.addedPairs.length; ++i8) {
                System.err.println("Pair " + i8 + " " + this.addedPairs[i8][0] + " " + this.addedPairs[i8][1]);
            }
            if (this.multiCoord1 != null && this.multiCoord2 == null) {
                this.multiCoord2 = new double[][][]{coords2};
            }
            if (this.prepareMultiCoord && this.multiCoord1 != null) {
                this.fusedMultiCoord = FuseFragments.fillMultiCoord(this.multiCoord1, this.multiCoord2, this.addedPairs);
            }
        }
    }

    static double[][][] fillMultiCoord(double[][][] mC1, double[][][] mC2, int[][] aP) {
        return FuseFragments.fillMultiCoord(mC1, mC2, aP, null);
    }

    static double[][][] fillMultiCoord(double[][][] mC1, double[][][] mC2, int[][] aP, double[][][] fC) {
        if (fC == null) {
            fC = new double[mC1.length * mC2.length][mC1[0].length + aP.length][3];
        }
        for (int i = 0; i < mC1.length; ++i) {
            for (int j = 0; j < mC2.length; ++j) {
                int k;
                int ij = i * mC1.length + j;
                for (k = 0; k < mC1[0].length; ++k) {
                    fC[ij][k][0] = mC1[i][k][0];
                    fC[ij][k][1] = mC1[i][k][1];
                    fC[ij][k][2] = mC1[i][k][2];
                }
                for (k = 0; k < aP.length; ++k) {
                    fC[ij][aP[k][0]][0] = mC2[j][aP[k][1]][0];
                    fC[ij][aP[k][0]][1] = mC2[j][aP[k][1]][1];
                    fC[ij][aP[k][0]][2] = mC2[j][aP[k][1]][2];
                }
            }
        }
        return fC;
    }

    int addConnectedAtoms(Molecule baseMolecule, Molecule fuseMolecule, int bAt, int sAt, int[][] fCTab, BondTable fBTab, BitSet fusedFlags, int[][] addedPairs, int addCounter) {
        for (int i = 0; i < fCTab[sAt].length; ++i) {
            int addAt = fCTab[sAt][i];
            if (fusedFlags.get(addAt)) continue;
            int indLastAtom = this.fusedMolecule.getAtomCount();
            fusedFlags.set(addAt);
            baseMolecule.add(fuseMolecule.getAtom(addAt));
            baseMolecule.getAtom(indLastAtom).set(fuseMolecule.getAtom(addAt));
            addedPairs[addCounter][0] = indLastAtom;
            addedPairs[addCounter][1] = addAt;
            ++addCounter;
            int indLastBond = baseMolecule.getBondCount();
            int nFound = -1;
            int addBond = fBTab.getBondIndex(sAt, addAt);
            baseMolecule.add(fuseMolecule.getBond(addBond).cloneBond(baseMolecule.getAtom(bAt), baseMolecule.getAtom(indLastAtom)));
            addCounter = this.addConnectedAtoms(baseMolecule, fuseMolecule, indLastAtom, addAt, fCTab, fBTab, fusedFlags, addedPairs, addCounter);
        }
        return addCounter;
    }

    public double getFitRMS() {
        if (this.fusedMolecule == null) {
            this.fuseFragments();
        }
        return this.fitRMS;
    }

    public double[][][] getMultiCoord() {
        if (this.fusedMultiCoord != null) {
            return this.fusedMultiCoord;
        }
        return FuseFragments.fillMultiCoord(this.multiCoord1, this.multiCoord2, this.addedPairs, null);
    }

    public double[][][] getMultiCoord(double[][][] multiCoord) {
        return FuseFragments.fillMultiCoord(this.multiCoord1, this.multiCoord2, this.addedPairs, multiCoord);
    }
}

