/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.BuildCommand;
import chemaxon.marvin.modelling.build.BuildCommandBase;
import chemaxon.marvin.modelling.build.BuildSequence;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.myMolecule;

public class PermutateBuildCommand
extends BuildCommand {
    BuildCommand baseCommand = null;
    BuildSequence.SimpleBuild cmd = null;
    int[] baseperm = null;

    @Override
    boolean hasDirectBuildChildFailed() {
        return this.baseCommand.hasDirectFragmentBuildChildFailed_0();
    }

    public PermutateBuildCommand(BuildCommand base, CleanSettings settings, myMolecule topmol, int[] baseperm, boolean disableStereo) {
        super(settings);
        int i;
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.printB("PermutateBuildCommand constructor");
            debug.println("baseperm");
            debug.printVector(baseperm);
            topmol.placeApplet("topmol");
        }
        this.baseCommand = base;
        this.baseperm = baseperm;
        int[] baseAtoms = base.getCommand().getAtoms();
        int[] baseAnchs = base.getCommand().getAnchAtoms();
        int[] baseNAnch = base.getCommand().getNonAnchAtoms();
        int[] bi = base.getCommand().getAtomsInv();
        int[] atoms = new int[baseAtoms.length];
        int[] anchs = new int[baseAnchs.length];
        int[] nanch = new int[baseNAnch.length];
        for (i = 0; i < atoms.length; ++i) {
            atoms[i] = baseperm[baseAtoms[i]];
        }
        for (i = 0; i < anchs.length; ++i) {
            anchs[i] = baseperm[baseAnchs[i]];
        }
        for (i = 0; i < nanch.length; ++i) {
            nanch[i] = baseperm[baseNAnch[i]];
        }
        this.cmd = new BuildSequence.SimpleBuild(atoms, anchs, nanch, topmol, base.getCommand().getWholeStereo());
        this.cmd.setOtherCommand(this);
        if (disableStereo) {
            this.cmd.setEmptyStereo();
        }
        if (debug != null) {
            this.getFragment().getFragMol().placeApplet("Fragment mol");
        }
    }

    @Override
    void initProgressMonitor() {
        throw new UnsupportedOperationException();
    }

    @Override
    myMolecule getOrigMol() {
        return this.getCommand().getMol();
    }

    @Override
    BuildSequence.Build getCommand() {
        return this.cmd;
    }

    @Override
    int invokeBuild(int expectedConformerCount, BuildCommandBase.BuildEffort effort) {
        int ret = this.baseCommand.build(expectedConformerCount, effort);
        if (ret == 1) {
            this.registerCoordinates(this.baseCommand.getMoreCoordinates());
        }
        return ret;
    }
}

