/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build.fafuse;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.calculations.clean.Optimization;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.build.fafuse.FragmentAtomFinalItem;
import chemaxon.marvin.modelling.build.fafuse.FragmentAtomFuseStore;
import chemaxon.marvin.modelling.build.fafuse.FragmentStore;
import chemaxon.marvin.modelling.build.fafuse.FuseCommandSequence;
import chemaxon.marvin.modelling.build.fafuse.WishList;
import chemaxon.marvin.modelling.build.fafuse.WishListItem;
import chemaxon.marvin.modelling.debug.CleanDebug;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.M;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.linalg.multiDim;
import chemaxon.marvin.modelling.linalg.subSpace;
import chemaxon.marvin.modelling.util.U;
import java.io.Serializable;
import java.util.BitSet;

public class FragmentAtomFuseItem {
    public int storeID = -1;
    public int confNo = -1;
    public int dim = 0;
    public double[] coord = null;
    public multiDim base = null;
    public double d2res = 0.0;
    public int nextWish = 0;
    public int nextChoice = 0;
    public int reTry = -1;
    public int reTryChoice = 0;
    public int wlSize = 0;
    public int[][] choicelog = null;
    public int wishTypeToProcess = -1;
    public boolean toRefine = false;
    public boolean ready = false;
    public boolean checkProximity3D = false;
    public static final int S_INITIATED = 1;
    public static final int S_TRIANGULATION_DONE = 2;
    public static final int S_RICTED = 3;
    public int state = 0;
    public boolean Hin3Hgroup = false;
    public boolean Hin2Hgroup = false;

    public void printOut(debugPrintout debug) {
        if (debug != null && debug.getWillPrint()) {
            debug.println("Store id: " + this.storeID);
            debug.println("<B>H in 3:</B> " + this.Hin3Hgroup);
            debug.println("<B>H in 2:</B> " + this.Hin2Hgroup);
            debug.println("<CENTER><B>Geometry</B></CENTER>");
            debug.println("d2res: " + this.d2res);
            debug.println("Dimensionality: " + this.dim);
            debug.println("Coordinates:");
            debug.printVector(this.coord);
            debug.println("base:");
            this.base.printDebug(debug);
            debug.println("<CENTER><B>Choice/Wish log</B></CENTER>");
            debug.print("<TABLE><TR><TD><CENTER><B>Step</B></CENTER></TD><TD><CENTER><B>Wish</B></CENTER></TD><TD><CENTER><B>Choice</B></CENTER></TD></TR>");
            for (int i = 0; i < this.choicelog[0].length; ++i) {
                debug.print("<TR><TD><B>" + i + "</B></TD><TD>" + this.choicelog[0][i] + "</TD><TD>" + this.choicelog[1][i] + "</TD></TR>");
            }
            debug.print("</TABLE>");
            debug.println("<CENTER><B>Wish management</B></CENTER>");
            debug.println("nextwish: " + this.nextWish);
            debug.println("next choice: " + this.nextChoice);
            debug.println("wishtype to process: " + this.wishTypeToProcess);
            debug.println("wlsize: " + this.wlSize);
            debug.println("<CENTER><B>ReTry management</B></CENTER>");
            debug.println("retry flag: " + this.reTry);
            debug.println("retry choice: " + this.reTryChoice);
            debug.println("<CENTER><B>Administrative</B></CENTER>");
            debug.println("Target conformer: " + this.confNo);
            debug.println("torefine: " + this.toRefine);
            debug.println("ready: " + this.ready);
            debug.println("chk prox 3D: " + this.checkProximity3D);
            String statestring = "N/A";
            switch (this.state) {
                case 1: {
                    statestring = "INITIATED";
                    break;
                }
                case 3: {
                    statestring = "RICTEDD";
                    break;
                }
                case 2: {
                    statestring = "TRIANGULATION DONE";
                }
            }
            debug.println("State = " + this.state + " (" + statestring + ")");
        }
    }

    public FragmentAtomFuseItem(int c, int s) {
        this.confNo = c;
        this.wlSize = s;
        this.coord = new double[5];
        this.dim = 0;
        this.base = new multiDim(5, 5);
        this.choicelog = new int[2][6];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.choicelog[0].length; ++j) {
                this.choicelog[i][j] = -1;
            }
        }
        this.state = 1;
    }

    public void setCoordinates(double[] x) {
        if (x.length > this.coord.length) {
            this.coord = new double[x.length + 3];
        }
        for (int i = 0; i < x.length; ++i) {
            this.coord[i] = x[i];
        }
        this.dim = x.length;
    }

    public double[] getCoordinates() {
        int i;
        double[] ret = new double[this.dim];
        for (i = 0; i < this.dim && i < this.coord.length; ++i) {
            ret[i] = this.coord[i];
        }
        while (i < this.dim) {
            ret[i] = 0.0;
            ++i;
        }
        return ret;
    }

    public void setWishType(int t) {
        this.wishTypeToProcess = t;
    }

    public void setD2res(double d) {
        this.d2res = d;
    }

    public void setReady(boolean f) {
        this.ready = f;
    }

    public boolean getReady() {
        return this.ready;
    }

    public boolean isThisStepThePostponed() {
        return this.reTry >= 0 && this.reTry + 1 <= this.nextWish;
    }

    public boolean isPostponed() {
        return this.reTry >= 0;
    }

    public int getWishNoToProcess() {
        if (this.isThisStepThePostponed()) {
            return this.reTry;
        }
        return this.nextWish >= this.wlSize ? -1 : this.nextWish;
    }

    public boolean postponeWish() {
        if (this.reTry >= 0) {
            return false;
        }
        if (this.nextWish == this.wlSize - 1) {
            return false;
        }
        this.reTry = this.nextWish++;
        return true;
    }

    public void incWish(int wt) {
        this.incWish(wt, this.getWishNoToProcess(), this.getChoice());
    }

    public void incWish(int wt, int wn, int ch) {
        int i;
        for (i = 0; i < this.choicelog[0].length && this.choicelog[0][i] != -1; ++i) {
        }
        if (i >= this.choicelog[0].length) {
            int[][] temp = new int[2][2 * this.choicelog[0].length];
            for (i = 0; i < this.choicelog[0].length; ++i) {
                temp[0][i] = this.choicelog[0][i];
                temp[1][i] = this.choicelog[1][i];
            }
            for (int j = i; j < temp[0].length; ++j) {
                temp[0][j] = -1;
                temp[1][j] = -1;
            }
            this.choicelog = temp;
        }
        this.choicelog[0][i] = wn;
        this.choicelog[1][i] = ch;
        if (this.isThisStepThePostponed()) {
            this.reTry = -1;
        } else {
            ++this.nextWish;
            this.nextChoice = 0;
        }
        if (wt > this.wishTypeToProcess) {
            this.wishTypeToProcess = wt;
        }
    }

    public boolean hasMoreWishes() {
        return this.wlSize > this.nextWish;
    }

    public int getProcessedWishes() {
        int i;
        for (i = 0; i < this.choicelog[0].length && this.choicelog[0][i] != -1; ++i) {
        }
        return i;
    }

    public boolean isWishProcessed(int n) {
        for (int i = 0; i < this.choicelog[0].length && this.choicelog[0][i] != -1; ++i) {
            if (this.choicelog[0][i] != n) continue;
            return true;
        }
        return false;
    }

    public int getProcessedWish(int i) {
        if (i < 0 || i >= this.nextWish) {
            return -1;
        }
        return this.choicelog[0][i];
    }

    public void setChoice(int c) {
        if (this.isThisStepThePostponed()) {
            this.reTryChoice = c;
        } else {
            this.nextChoice = c;
        }
    }

    public int getChoice() {
        if (this.isThisStepThePostponed()) {
            return this.reTryChoice;
        }
        return this.nextChoice;
    }

    public int getChoice(int s) {
        return this.choicelog[1][s];
    }

    public FragmentAtomFuseItem cloneWithChoice(int c) {
        int i;
        FragmentAtomFuseItem ret = new FragmentAtomFuseItem(this.confNo, this.wlSize);
        if (this.base != null) {
            if (ret.base == null) {
                ret.base = new multiDim(this.base.getMaxV(), this.base.getMaxDim());
            }
            ret.base.putM(this.base.getM());
            for (i = 0; i < this.base.size(); ++i) {
                ret.base.putV(i, this.base.getV(i));
            }
        }
        if (ret.coord.length < this.coord.length) {
            ret.coord = new double[this.coord.length];
        }
        for (i = 0; i < this.coord.length; ++i) {
            ret.coord[i] = this.coord[i];
        }
        ret.dim = this.dim;
        ret.d2res = this.d2res;
        ret.nextWish = this.nextWish;
        ret.ready = this.ready;
        ret.toRefine = this.toRefine;
        ret.reTry = this.reTry;
        ret.wishTypeToProcess = this.wishTypeToProcess;
        ret.checkProximity3D = this.checkProximity3D;
        ret.Hin2Hgroup = this.Hin2Hgroup;
        ret.Hin3Hgroup = this.Hin3Hgroup;
        if (ret.choicelog[0].length != this.choicelog[0].length) {
            ret.choicelog = new int[2][this.choicelog[0].length];
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < this.choicelog[0].length; ++j) {
                ret.choicelog[i][j] = this.choicelog[i][j];
            }
        }
        ret.nextChoice = this.nextChoice;
        ret.reTryChoice = this.reTryChoice;
        ret.setChoice(c);
        return ret;
    }

    public void doTriangulation(WishList wishl, FragmentAtomFuseStore store, debugPrintout debug) {
        int triangulationState = 0;
        FragmentAtomFuseItem atom = this;
        CleanDebug.MolAppletRecorder triangrec = null;
        if (debug != null && debug.getWillPrint()) {
            triangrec = new CleanDebug.MolAppletRecorder("Triangulation steps", "Triangulation steps");
        }
        while (true) {
            double dXi;
            double[] base_i;
            int i;
            if (debug != null) {
                debug.printB("Triangulation entry");
            }
            if (atom.ready) {
                if (debug == null) break;
                debug.println("Atom ready, break.");
                break;
            }
            if (atom.base.size() == 2) {
                if (debug == null) break;
                debug.println("Atom is ready for mres+/-, break.");
                break;
            }
            if (atom.toRefine) {
                if (debug == null) break;
                debug.println("Refine required, break");
                break;
            }
            if (!atom.hasMoreWishes()) {
                if (debug == null) break;
                debug.println("No more wishes, break.");
                break;
            }
            if (Clean3D.OPT_CP_ONETORSION && atom.wishTypeToProcess >= 3) {
                if (debug == null) break;
                debug.println("One torsion processed, break.");
                break;
            }
            if (Clean3D.OPT_CP_NOTORSIONIFDETERMINED && (Math.abs(atom.d2res) < Clean3D.OPT_CP_EPS || Math.max(3, atom.base.getD()) - 1 <= atom.base.size()) && wishl.getWish((int)atom.getWishNoToProcess()).type == 3 && wishl.getWish((int)atom.getWishNoToProcess()).type == 3) {
                if (debug == null) break;
                debug.println("Structure determined, bond angles processed, break.");
                break;
            }
            if (debug != null && debug.getWillPrint()) {
                debug.printHR();
                debug.incLevel("Atom state:");
                atom.printOut(debug);
                debug.decLevel();
            }
            int currentWishNo = atom.getWishNoToProcess();
            WishListItem currentWish = wishl.getWish(currentWishNo);
            boolean fetchTorsion180AndSkipAppend = false;
            if (CleanArgs.OPT_FUSEBUILD_DOHIN23HACK && this.Hin3Hgroup && currentWish.type == 3 && currentWish.d.length == 2 && currentWish.d[0] == 60.0 && currentWish.d[1] == 180.0) {
                fetchTorsion180AndSkipAppend = true;
                atom.setChoice(1);
            }
            if (debug != null && debug.getWillPrint()) {
                if (fetchTorsion180AndSkipAppend) {
                    debug.printB("Fetch torsion value 180 degree and skip append");
                }
                debug.print("<TABLE border=1><TR><TD colspan=2><CENTER><B>Current Wish</B></CENTER></TD></TR>");
                debug.print("<TR><TD>No:</TD><TD>" + currentWishNo + "</TD></TR>");
                debug.print("<TR><TD>Choice:</TD><TD>" + atom.getChoice() + "</TD></TR>");
                debug.print("<TR><TD>Type:</TD><TD>" + currentWish.getType() + "</TD></TR>");
                debug.print("<TR><TD>Data:</TD><TD>" + debugPrintout.formatNumber(currentWish.d[atom.getChoice()]) + "</TD></TR>");
                debug.print("</TABLE>");
                debug.incLevel("wish");
                currentWish.printout(debug);
                debug.decLevel();
            }
            if (currentWish.d.length - 1 > atom.getChoice() && !fetchTorsion180AndSkipAppend) {
                if (debug != null && debug.getWillPrint()) {
                    debug.incLevel("More choices (append)");
                }
                if (store.maxVariants > store.getSize()) {
                    FragmentAtomFuseItem a = atom.cloneWithChoice(atom.getChoice() + 1);
                    store.nodes.add(a);
                    a.storeID = store.nodes.size() - 1;
                    a.printOut(debug);
                } else if (debug != null && debug.getWillPrint()) {
                    debug.println("Maximum place variant limit reached, no append");
                }
                if (debug != null && debug.getWillPrint()) {
                    debug.decLevel();
                }
            }
            if (atom.nextWish == 0) {
                double[] x = store.frags.getCoordinate(atom.confNo, currentWish.atoms[1]);
                atom.setCoordinates(x);
                atom.setD2res(currentWish.getDistanceM(0, null, null, null, null));
                atom.setWishType(currentWish.type);
                atom.incWish(currentWish.type);
                triangulationState = 1;
                if (debug == null || !debug.getWillPrint()) continue;
                debug.println("Init (neighbor:" + currentWish.atoms[1] + ")");
                debug.incLevel("Atom state after init");
                atom.printOut(debug);
                debug.decLevel();
                store.writeFusingConformerApplet(debug, atom, null, "" + store.atomNo, "Atom state", null, null, triangrec);
                continue;
            }
            if (atom.ready) continue;
            if (debug != null) {
                debug.println("Triangulation step");
            }
            int jno = currentWish.getTargetAtom();
            if (debug != null && debug.getWillPrint()) {
                debug.println("target atom: " + jno);
            }
            if (debug != null && debug.getWillPrint() && CleanArgs.cltracer != null) {
                CleanArgs.cltracer.setExtensiveDebug(true);
                debug.incLevel("Calculating required metrid");
            }
            double Mreq = store.getDistanceM(currentWish, atom.nextChoice, atom);
            if (debug != null && debug.getWillPrint()) {
                if (CleanArgs.cltracer != null) {
                    CleanArgs.cltracer.setExtensiveDebug(false);
                    debug.decLevel();
                }
                debug.println("Required metrid: " + debugPrintout.formatNumber(Mreq));
            }
            if (debug != null) {
                debug.incLevel("Orthogonalisation");
            }
            double[] ortho = V.minus(store.frags.getCoordinate(atom.confNo, jno), atom.getCoordinates());
            if (debug != null && debug.getWillPrint()) {
                debug.println("Initial orthogonal candidate (c_jno - c):");
                debug.printVector(ortho);
            }
            double Mpres = 0.0;
            if (debug != null) {
                debug.println("<CENTER><B>Schmidt orthogonalisation</B></CENTER>");
            }
            for (i = 0; i < atom.base.size(); ++i) {
                base_i = atom.base.getV(i);
                dXi = V.dot(base_i, ortho);
                double baseMi = V.dot(base_i);
                Mpres += M.sqr(dXi) * baseMi;
                V.minusWriteBackToa(ortho, V.dot(baseMi * dXi, base_i));
                if (debug == null || !debug.getWillPrint()) continue;
                debug.println("<B>Process base vector " + i + "</B>");
                debug.println("baseM<sub>i</sub>=" + debugPrintout.formatNumber(baseMi));
                debug.println("dX<sub>i</sub>=" + debugPrintout.formatNumber(dXi));
                debug.println("M<sub>pres</sub>=" + debugPrintout.formatNumber(Mpres));
                debug.println("base_i:");
                debug.printVector(base_i);
                debug.println("new orthogonal candidate:");
                debug.printVector(ortho);
            }
            if (debug != null && debug.getWillPrint()) {
                debug.println("Orthogonal candidate after orthogonalisaton:");
                debug.printVector(ortho);
                debug.println("Backcheck orthogonality");
                for (i = 0; i < atom.base.size(); ++i) {
                    base_i = atom.base.getV(i);
                    dXi = V.dot(base_i, ortho);
                    debug.println("<B>Process base vector " + i + "</B>");
                    debug.println("dX<sub>i</sub>=" + debugPrintout.formatNumber(dXi));
                    if (!(Math.abs(dXi) > 1.0E-4)) continue;
                    System.err.println("Warning! Orthogonalisation mismatch!");
                }
            }
            double Mortho = V.dot(ortho);
            if (debug != null && debug.getWillPrint()) {
                debug.println("M_ortho = " + debugPrintout.formatNumber(Mortho));
            }
            if (debug != null) {
                debug.decLevel();
            }
            if (Math.abs(Mortho) > Clean3D.OPT_CP_MINORTHOCANDIDATE) {
                if (debug != null) {
                    debug.println("nonsingular ortho");
                }
                double l = (atom.d2res - Mreq + Mpres + Mortho) / (2.0 * Mortho);
                V.minusWriteBackToa(atom.coord, V.dot(-l, ortho));
                atom.d2res -= Mortho * M.sqr(l);
                atom.base.putV(atom.base.size(), V.dot(1.0 / Math.sqrt(Math.abs(Mortho)), ortho));
                atom.incWish(currentWish.type);
                triangulationState = 2;
                if (debug == null || !debug.getWillPrint()) continue;
                debug.println("Atom moved.");
                debug.print("<TABLE border=1><TR><TD colspan=2><B><CENTER>Triangulation parameters</CENTER></B></TD></TR>");
                debug.print("<TR><TD><B><CENTER>Data</CENTER></B></TD><TD><B><CENTER>Value</CENTER></B></TD></TR>");
                debug.println("<TR><TD>prev. M<SUB>res</SUB>:</TD><TD>" + debugPrintout.formatNumber(atom.d2res + Mortho * M.sqr(l)) + "</TD></TR>");
                debug.println("<TR><TD>M<SUB>ortho</SUB>:</TD><TD>" + debugPrintout.formatNumber(Mortho) + "</TD></TR>");
                debug.println("<TR><TD>M<SUB>pres</SUB>:</TD><TD>" + debugPrintout.formatNumber(Mpres) + "</TD></TR>");
                debug.println("<TR><TD>M<SUB>req</SUB>:</TD><TD>" + debugPrintout.formatNumber(Mreq) + "</TD></TR>");
                debug.println("<TR><TD>Scale f:</TD><TD>" + debugPrintout.formatNumber(l) + "</TD></TR>");
                debug.println("<TR><TD>M<SUB>res</SUB>:</TD><TD>" + debugPrintout.formatNumber(atom.d2res) + "</TD></TR>");
                debug.println("</TABLE>");
                debug.incLevel("Atom state after move");
                atom.printOut(debug);
                debug.decLevel();
                store.writeFusingConformerApplet(debug, atom, null, "" + store.atomNo, "Atom state", null, null, triangrec);
                debug.printB("Invoke proximity backcheck");
                BitSet mismatch = new BitSet(store.fragmentAtomList.length);
                int pcres = store.proximityCheck(atom, null, atom.d2res, wishl, null, null, mismatch, null, debug);
                debug.println("   results: " + pcres);
                if ((pcres & 2) == 0) continue;
                System.err.println("Triangulation failed!");
                continue;
            }
            if (debug != null) {
                debug.println("Singular orthogonal candidate");
            }
            if (Math.abs(atom.d2res - Mreq - Mpres) < Clean3D.OPT_CP_EPS) {
                atom.incWish(currentWish.type);
                triangulationState = 2;
                continue;
            }
            atom.toRefine = true;
            triangulationState = 3;
        }
        atom.state = 2;
        if (debug != null) {
            debug.printHR();
        }
        if (debug != null) {
            debug.println("<B>Look for required wishes</B>");
        }
        if (debug != null) {
            debug.println("There can be requires wishes");
        }
        boolean wasNeeded = false;
        for (int i = 0; i < wishl.getSize(); ++i) {
            int wtype = wishl.getWish((int)i).type;
            wasNeeded = false;
            switch (wtype) {
                case 1: {
                    wasNeeded = true;
                    if (debug == null) break;
                    debug.println("Needed: BLEN");
                    break;
                }
                case 2: {
                    if (atom.wishTypeToProcess < 2) break;
                    wasNeeded = true;
                    if (debug == null) break;
                    debug.println("Needed: BANGL");
                }
            }
            if (!wasNeeded || atom.isWishProcessed(i)) continue;
            atom.incWish(0, i, 0);
        }
        if (debug != null && debug.getWillPrint()) {
            debug.printHR();
            debug.println("<B>Triangulation finished</B>");
            debug.incLevel("Atom state:");
            atom.printOut(debug);
            debug.decLevel();
            store.writeFusingConformerApplet(debug, atom, null, "" + store.atomNo, "Atom state", null, null, triangrec);
            triangrec.placeButtonApplet(debug);
        }
    }

    public double calcRMSDs(WishList wishl, FragmentStore frags, double[] ret) {
        int i;
        int pwn = this.getProcessedWishes();
        int[] retns = new int[2];
        ret[0] = 0.0;
        ret[1] = 0.0;
        block4: for (i = 0; i < pwn; ++i) {
            WishListItem wli = wishl.getWish(this.getProcessedWish(i));
            double[] a0 = this.getCoordinates();
            double[] a1 = null;
            double[] a2 = null;
            double d = 0.0;
            switch (wli.type) {
                case 1: {
                    a1 = frags.getCoordinate(this.confNo, wli.atoms[1]);
                    d = V.dot(V.minus(a0, a1));
                    ret[0] = ret[0] + M.sqr(Math.sqrt(d) - wli.d[this.getChoice(i)]);
                    retns[0] = retns[0] + 1;
                    continue block4;
                }
                case 2: {
                    a1 = frags.getCoordinate(this.confNo, wli.atoms[1]);
                    a2 = frags.getCoordinate(this.confNo, wli.atoms[2]);
                    d = WishListItem.calcBondAngle(a0, a1, a2);
                    for (d = wli.d[this.getChoice(i)] - d; d > 180.0; d -= 360.0) {
                    }
                    while (d < -180.0) {
                        d += 360.0;
                    }
                    ret[1] = ret[1] + M.sqr(d);
                    retns[1] = retns[1] + 1;
                }
            }
        }
        for (i = 0; i < 2; ++i) {
            ret[i] = retns[i] != 0 ? Math.sqrt(ret[i] / (double)retns[i]) : 0.0;
        }
        return ret[0] + ret[1];
    }

    public void placeMresInSpace(FragmentAtomFuseStore store, debugPrintout debug) {
        FragmentAtomFuseItem atom = this;
        if (this.base.size() == 2 && this.d2res > 1.0E-4) {
            if (debug != null && debug.getWillPrint()) {
                debug.printB("+/- place");
            }
            subSpace s = new subSpace(null);
            s.setBase(this.base);
            s.generateOrthogonalSubspace();
            if (s.ortho.n != 0) {
                if (debug != null && debug.getWillPrint()) {
                    debug.println("In-space orthogonals:");
                    s.ortho.printDebug(debug);
                }
                double l = Math.sqrt(Math.abs(atom.d2res));
                double[] v = s.ortho.getV(0);
                atom.base.putV(2, v);
                FragmentAtomFuseItem atom2 = atom.cloneWithChoice(0);
                atom.coord = V.plus(atom.coord, V.dot(l, v));
                atom2.coord = V.plus(atom2.coord, V.dot(-l, v));
                int cres1 = store.proximityCheck(atom, null, 0.0, store.wl, null, null, null, null, debug);
                int cres2 = store.proximityCheck(atom2, null, 0.0, store.wl, null, null, null, null, debug);
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Proximity check results: " + cres1 + " / " + cres2);
                }
                if (cres1 == cres2) {
                    if (store.maxVariants > store.getSize()) {
                        store.nodes.add(atom2);
                        atom2.storeID = store.nodes.size() - 1;
                    }
                } else if (cres2 < cres1) {
                    atom.coord = atom2.coord;
                }
            }
        } else if (this.d2res <= 1.0E-4 && debug != null && debug.getWillPrint()) {
            debug.println("Atom is fine, d2res is too small to do anything.");
        }
    }

    public int doRICT(FuseCommandSequence seq, FragmentStore frags, FragmentAtomFuseStore store, WishList wishl, debugPrintout debug) {
        if (debug != null && debug.getWillPrint()) {
            debug.printBC("Try RICT");
        }
        FragmentAtomFuseItem atom = this;
        if (Clean3D.OPT_CP_RICTENABLED && atom.dim == 3) {
            int[] f_ovrci;
            int j;
            int i;
            int i2;
            int pwn = atom.getProcessedWishes();
            int twn = 0;
            int pawn = wishl.getPSize();
            for (int i3 = 0; i3 < wishl.getSize(); ++i3) {
                WishListItem w = wishl.getWish(i3);
                if (w.type != 3 || atom.isWishProcessed(i3)) continue;
                ++twn;
            }
            int wn = pwn + twn + pawn;
            if (debug != null && debug.getWillPrint()) {
                debug.println("Total number of processed wishes: " + pwn);
                debug.println("Total number of torsion choices: " + twn);
                debug.println("Total number of participant wishes: " + pawn);
                debug.println("Total number of expected wishes: " + wn);
            }
            int[] wishindex = new int[wn];
            int[] wishcindex = new int[wn];
            int wishindexp = 0;
            for (i2 = 0; i2 < pwn; ++i2) {
                wishindex[wishindexp] = atom.getProcessedWish(i2);
                wishcindex[wishindexp++] = atom.getChoice(i2);
            }
            for (i2 = 0; i2 < pawn; ++i2) {
                wishindex[wishindexp] = -i2 - 1;
                wishcindex[wishindexp++] = 0;
            }
            boolean partialRICT = false;
            for (int i4 = 0; i4 < wishl.getSize(); ++i4) {
                WishListItem w = wishl.getWish(i4);
                if (w.type != 3 || atom.isWishProcessed(i4)) continue;
                wishindex[wishindexp] = i4;
                wishcindex[wishindexp++] = 0;
            }
            final int[][] icd = new int[4 * wn][];
            final double[] icv = new double[4 * wn];
            int icdp = 0;
            final double[] caco = new double[3 * wn + 3];
            int[] ca = new int[seq.mol.a];
            int[] carev = new int[seq.mol.a];
            for (int i5 = 0; i5 < ca.length; ++i5) {
                ca[i5] = -1;
                carev[i5] = -1;
            }
            int cap = 0;
            if (debug != null && debug.getWillPrint()) {
                debug.printBC("Fill inner coordinate descriptors");
            }
            block21: for (i = 0; i < wishindexp; ++i) {
                int cn = wishcindex[i];
                if (debug != null && debug.getWillPrint()) {
                    debug.printB("Process wish #" + wishindex[i] + " Choice: " + cn);
                }
                WishListItem wli = null;
                wli = wishl.getWish(wishindex[i]);
                if (partialRICT && wli.type == 3 || wli.type == 2 && wli.d[cn] == 180.0) {
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Process wish #" + wishindex[i] + " Choice: " + cn + " will be skipped due to a linear bend.");
                    }
                    partialRICT = true;
                    break;
                }
                wli.printout(debug);
                for (j = 0; j < wli.atoms.length; ++j) {
                    if (ca[wli.atoms[j]] != -1) continue;
                    ca[wli.atoms[j]] = cap;
                    carev[cap] = wli.atoms[j];
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("New RICT participant atom: " + wli.atoms[j] + " -> " + cap);
                    }
                    ++cap;
                }
                switch (wli.type) {
                    case 1: {
                        icd[icdp] = new int[3];
                        icd[icdp][0] = 3;
                        icd[icdp][1] = ca[wli.atoms[0]];
                        icd[icdp][2] = ca[wli.atoms[1]];
                        icv[icdp] = wli.d[cn];
                        ++icdp;
                        continue block21;
                    }
                    case 2: {
                        icd[icdp] = new int[4];
                        icd[icdp][0] = 4;
                        icd[icdp][1] = ca[wli.atoms[0]];
                        icd[icdp][2] = ca[wli.atoms[1]];
                        icd[icdp][3] = ca[wli.atoms[2]];
                        icv[icdp] = wli.d[cn] * Math.PI / 180.0;
                        ++icdp;
                        continue block21;
                    }
                    case 3: {
                        double[][] ac = new double[4][];
                        block23: for (int k = 0; k < 4; ++k) {
                            ac[k] = null;
                            switch (wli.coordinfo[k]) {
                                case 2: {
                                    ac[k] = frags.getCoordinate(atom.confNo, wli.atoms[k]);
                                    continue block23;
                                }
                                case 1: {
                                    ac[k] = atom.getCoordinates();
                                }
                            }
                        }
                        double actual = WishListItem.calcDihedralAngle(ac[0], ac[1], ac[2], ac[3]);
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("Actual value: " + actual);
                        }
                        double nearest = 1000.0;
                        for (int k = 0; k < wli.d.length; ++k) {
                            if (!(Math.abs(Math.abs(nearest) - Math.abs(actual)) > Math.abs(Math.abs(actual) - Math.abs(wli.d[k])))) continue;
                            nearest = actual < 0.0 ? -Math.abs(wli.d[k]) : Math.abs(wli.d[k]);
                        }
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("Nearest value: " + nearest);
                        }
                        icd[icdp] = new int[5];
                        icd[icdp][0] = 8;
                        icd[icdp][1] = ca[wli.atoms[0]];
                        icd[icdp][2] = ca[wli.atoms[1]];
                        icd[icdp][3] = ca[wli.atoms[2]];
                        icd[icdp][4] = ca[wli.atoms[3]];
                        icv[icdp] = nearest * Math.PI / 180.0;
                        ++icdp;
                    }
                }
            }
            if (debug != null && debug.getWillPrint()) {
                debug.printBC("Fill cartesian coordinates");
            }
            if (debug != null && debug.getWillPrint()) {
                debug.println("Atoms: " + cap);
            }
            for (i = 0; i < seq.mol.a; ++i) {
                if (ca[i] == -1) continue;
                double[] c = new double[3];
                if (i == store.atomNo) {
                    for (int j2 = 0; j2 < atom.dim; ++j2) {
                        c[j2] = atom.coord[j2];
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Coordinates for AUP");
                    }
                } else {
                    double[] fc = frags.getCoordinate(atom.confNo, i);
                    for (j = 0; j < atom.dim; ++j) {
                        c[j] = fc[j];
                    }
                    if (debug != null && debug.getWillPrint()) {
                        debug.printB("Coordinates for atom " + i);
                    }
                    for (j = 0; j < 3; ++j) {
                        icd[icdp] = new int[2];
                        switch (j) {
                            case 0: {
                                icd[icdp][0] = 16;
                                break;
                            }
                            case 1: {
                                icd[icdp][0] = 17;
                                break;
                            }
                            case 2: {
                                icd[icdp][0] = 18;
                            }
                        }
                        icd[icdp][1] = ca[i];
                        icv[icdp] = c[j];
                        if (debug != null && debug.getWillPrint()) {
                            debug.println("Cartesian coordinate requirement. Atom: " + ca[i] + " c.no.: " + j + " value: " + c[j]);
                        }
                        ++icdp;
                    }
                }
                for (int j3 = 0; j3 < 3; ++j3) {
                    caco[ca[i] * 3 + j3] = c[j3];
                }
            }
            if (debug != null && debug.getWillPrint()) {
                debug.println("Inner coordinates: " + icdp);
            }
            if (debug != null && debug.getWillPrint()) {
                debug.printBC("Invoke RICTStep");
            }
            final int f_cap = cap;
            final int f_icdp = icdp;
            final debugPrintout f_debug = debug != null && debug.getWillPrint() ? debug : null;
            int[] nArray = f_ovrci = f_debug != null ? new int[seq.mol.a] : null;
            if (f_ovrci != null) {
                for (int i6 = 0; i6 < seq.mol.a; ++i6) {
                    f_ovrci[i6] = ca[i6] == -1 ? -1 : 3 * ca[i6];
                }
            }
            final FragmentAtomFuseStore f_store = f_debug != null ? store : null;
            final FragmentAtomFuseItem f_atom = f_debug != null ? atom : null;
            final CleanDebug.MolAppletRecorder f_recorder = f_debug != null ? new CleanDebug.MolAppletRecorder("RICT steps", "RICT steps") : null;
            final int f_a1 = store.atomNo;
            Optimization.RICT rparam = new Optimization.RICT(){

                @Override
                public int getAtomCount() {
                    return f_cap;
                }

                @Override
                public double[] getCartesianCoordinates() {
                    return caco;
                }

                @Override
                public int getDimensionCount() {
                    return 3;
                }

                @Override
                public int getInternalCoordinateCount() {
                    return f_icdp;
                }

                @Override
                public int[][] getInternalCoordinateDescriptors() {
                    return icd;
                }

                @Override
                public double[] getInternalCoordinateValues() {
                    return icv;
                }

                @Override
                public double[] getMetric() {
                    double[] m = new double[]{1.0, 1.0, 1.0};
                    return m;
                }

                @Override
                public void requestStructureWindow() {
                    if (f_debug != null) {
                        f_store.writeFusingConformerApplet(f_debug, f_atom, null, "" + f_a1, "RICT step", caco, f_ovrci, f_recorder);
                    }
                }
            };
            Optimization.RICTStep stepper = new Optimization.RICTStep();
            Optimization.RICTStep.debug = debug;
            if (debug != null && debug.getWillPrint()) {
                debug.println("Cartesian coordinates:");
                debug.printVector(caco);
                debug.incLevel("RICT parameters");
                stepper.printout(rparam, carev, debug);
                debug.decLevel();
            }
            int stepresult = 0;
            if (!partialRICT) {
                try {
                    stepresult = stepper.doSingleAtomStep(rparam);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.println("Exception, result failed");
                    }
                    stepresult = 1;
                }
            } else {
                stepresult = 0;
            }
            if (debug != null) {
                debug.println("Cartesian coordinates:");
                debug.printVector(caco);
                debug.println("Step result: " + stepresult);
                if (f_recorder != null) {
                    f_recorder.placeButtonApplet(debug);
                }
            }
            if (stepresult == 0) {
                double[] mc;
                double[] newac;
                int newpcres;
                if (debug != null) {
                    debug.println("SUCCESS.");
                    debug.println("Invoke new proximity check");
                }
                if (((newpcres = store.proximityCheck(atom, newac = new double[]{caco[0], caco[1], caco[2]}, 0.0, wishl, null, null, null, mc = new double[store.fragmentAtomList.length], debug)) & 4) == 0) {
                    if (debug != null) {
                        debug.println("No <EPS proximity.");
                    }
                    if (debug != null) {
                        debug.println("Backcheck bond lengths.");
                    }
                    boolean failed = false;
                    boolean optreq = false;
                    if ((newpcres & 1) != 0) {
                        optreq = true;
                    } else {
                        for (int i7 = 0; i7 < f_icdp; ++i7) {
                            if ((icd[i7][0] & 0xF) != 3) continue;
                            if (debug != null) {
                                debug.println("Check for ICD# " + i7);
                            }
                            int targeta = carev[icd[i7][2]];
                            if (debug != null) {
                                debug.println("Target atom:" + targeta);
                            }
                            double metridc = mc[store.atomToFragmentA[targeta]];
                            if (debug != null) {
                                debug.println("Metrid correction:" + metridc);
                            }
                            if (!(Math.abs(metridc) > 0.4)) continue;
                            optreq = true;
                            if (debug == null) continue;
                            debug.println("Bond length mismatch: optimization required.");
                        }
                    }
                    if (!failed) {
                        atom.coord[0] = caco[0];
                        atom.coord[1] = caco[1];
                        atom.coord[2] = caco[2];
                        atom.state = 3;
                        store.finalizeAtom(atom.storeID);
                        if (debug != null) {
                            debug.println("Atom finalized.");
                        }
                        if (optreq) {
                            store.getFinal((int)(store.getFinalSize() - 1)).opt_required = true;
                        }
                        return stepper.laststeps;
                    }
                } else if (debug != null) {
                    debug.println("Proximity error.");
                }
            } else if (debug != null) {
                debug.println("FAILED.");
            }
        }
        return -1;
    }

    public void doInSpacePlacement(FragmentAtomFuseStore store, WishList wishl, debugPrintout debug) {
        if (debug != null && debug.getWillPrint()) {
            debug.printBC("Try in-space placement");
        }
        FragmentAtomFuseItem atom = this;
        int maxd = store.getFuseSystemRealDim(atom);
        if (debug != null && debug.getWillPrint()) {
            debug.println("Real D=" + maxd);
        }
        if (!atom.getReady() && atom.d2res > -Clean3D.OPT_CP_EPS) {
            if (debug != null && debug.getWillPrint()) {
                debug.printB("Check for proximity");
            }
            int pcres = store.proximityCheck(atom, null, atom.d2res, wishl, null, null, null, null, debug);
            if (debug != null && debug.getWillPrint()) {
                debug.println("Check result: " + pcres);
            }
            if (!atom.getReady() && Math.abs(atom.d2res) <= Clean3D.OPT_CP_EPS) {
                if (pcres == 0) {
                    store.finalizeAtom(atom.storeID);
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("No proximity/mismatch: placement done.");
                    }
                } else if (pcres == 1) {
                    store.finalizeAtom((int)atom.storeID).opt_required = true;
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("Proximity, no mismatch: done with optreq");
                    }
                }
            }
            if (!atom.getReady() && (pcres == 0 || pcres == 1) && atom.d2res > 0.0 && maxd < 3) {
                if (debug != null && debug.getWillPrint()) {
                    debug.println("Less than 3D structure, open new dimension in D2 or D3");
                }
                if (maxd == 0) {
                    System.err.println("Consistency error: 0D structure.");
                } else if (maxd == 1) {
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("1D structure, place M2RES simply.");
                    }
                    atom.coord[maxd] = Math.sqrt(atom.d2res);
                    store.finalizeAtom(atom.storeID);
                } else {
                    if (debug != null && debug.getWillPrint()) {
                        debug.println("2D structure, place M2RES +/-");
                    }
                    multiDim base = new multiDim(1, 3);
                    base.putV(0, 2, Math.sqrt(atom.d2res));
                    multiDim vv = new multiDim(2, 1);
                    vv.putV(0, 0, 1.0);
                    if (CleanArgs.OPT_FUSEBUILD_DOHIN23HACK && (this.Hin2Hgroup || this.Hin3Hgroup)) {
                        if (debug != null) {
                            debug.printB("Hin2/3 hack: skip (-) place in 2D");
                        }
                    } else {
                        vv.putV(1, 0, -1.0);
                    }
                    store.finalizeAtom(atom.storeID, base, vv);
                }
                if (atom.getReady() && pcres == 1) {
                    store.getFinal((int)(store.getFinalSize() - 1)).opt_required = true;
                }
            }
            if (atom.getReady() && pcres == 1) {
                store.getFinal((int)(store.getFinalSize() - 1)).opt_required = true;
            }
        }
        if (!atom.getReady() && Math.abs(atom.d2res) >= Clean3D.OPT_CP_EPS && atom.base.size() < atom.base.getD() && maxd >= 3) {
            if (debug != null && debug.getWillPrint()) {
                debug.printHR();
            }
            if (debug != null && debug.getWillPrint()) {
                debug.println("<CENTER><B>In space placeme?</B></CENTER>");
            }
            if (debug != null && debug.getWillPrint()) {
                debug.println("Look for bases");
            }
            subSpace s = new subSpace(null);
            s.setBase(atom.base);
            s.generateOrthogonalSubspace();
            if (s.ortho.n != 0) {
                if (debug != null && debug.getWillPrint()) {
                    debug.println("In-space orthogonals:");
                    s.ortho.printDebug(debug);
                }
                int[] flags = new int[2 * s.ortho.n];
                double l = Math.sqrt(Math.abs(atom.d2res));
                double[] c = atom.getCoordinates();
                if (debug != null && debug.getWillPrint()) {
                    debug.Tstart();
                    debug.TprintBC(5, "Results:");
                    debug.Trow();
                    debug.TprintBC("#");
                    debug.TprintBC("Dir");
                    debug.TprintBC(2, "Res");
                    debug.TprintBC("Action");
                    debug.Trow();
                }
                multiDim vect = null;
                FragmentAtomFinalItem fin = null;
                for (int i = 0; i < s.ortho.n; ++i) {
                    for (double sign = -1.0; sign < 1.5; sign += 2.0) {
                        double[] newc = V.plus(c, V.dot(sign * l, s.ortho.getV(i)));
                        int cres = store.proximityCheck(atom, newc, 0.0, wishl, null, null, null, null, debug);
                        if (debug != null && debug.getWillPrint()) {
                            debug.TprintB("" + i);
                            debug.TprintC(sign < 0.0 ? "-" : "+");
                            debug.TprintC("" + cres);
                            String res = "";
                            if (cres == 0) {
                                res = "OK";
                            }
                            if ((cres & 1) != 0) {
                                res = res + "Close ";
                            }
                            if ((cres & 2) != 0) {
                                res = res + "Mismatch ";
                            }
                            if ((cres & 4) != 0) {
                                res = res + "ZeroMetrid";
                            }
                            debug.TprintC(res);
                        }
                        if (cres == 0 || cres == 1) {
                            boolean skipset = false;
                            if (vect == null) {
                                vect = new multiDim(2 * s.ortho.n, s.ortho.n);
                                fin = store.finalizeAtom(atom.storeID, s.ortho, vect);
                                if (debug != null && debug.getWillPrint()) {
                                    debug.Tprint("Alloc and set");
                                }
                            } else {
                                if (debug != null && debug.getWillPrint()) {
                                    debug.Tprint("Set only");
                                }
                                if (CleanArgs.OPT_FUSEBUILD_DOHIN23HACK && (this.Hin2Hgroup || this.Hin3Hgroup)) {
                                    skipset = true;
                                }
                            }
                            if (skipset) {
                                if (debug != null) {
                                    debug.printB("H2/3group hack: skip set after alloc");
                                }
                            } else {
                                vect.putV(vect.n, i, sign * l);
                                if (cres == 1) {
                                    if (debug != null && debug.getWillPrint()) {
                                        debug.Tprint("Set optreq flag");
                                    }
                                    fin.setOptRequired(fin.getSelections() - 1);
                                }
                            }
                        }
                        if (debug == null || !debug.getWillPrint()) continue;
                        debug.Trow();
                    }
                }
                if (debug != null && debug.getWillPrint()) {
                    debug.Tstop();
                }
                if (debug != null && debug.getWillPrint() && fin != null) {
                    debug.incLevel("Final item:");
                    fin.printout(debug);
                    debug.decLevel();
                }
            } else if (debug != null && debug.getWillPrint()) {
                debug.println("No in-space orthogonals.");
            }
        }
    }

    void doNewDPlacement(FragmentAtomFuseStore store, WishList wishl, debugPrintout debug) {
        if (debug != null && debug.getWillPrint()) {
            debug.printBC("Try new Dim placement");
        }
        FragmentAtomFuseItem atom = this;
        if (debug != null && debug.getWillPrint()) {
            debug.printBC("<CENTER><B>Proximity check</B></CENTER>");
        }
        BitSet mismatch = new BitSet(store.fragmentAtomList.length);
        BitSet prox = new BitSet(store.fragmentAtomList.length);
        double[] mcorr = new double[store.fragmentAtomList.length];
        int pcres = store.proximityCheck(atom, null, atom.d2res, wishl, null, prox, mismatch, mcorr, debug);
        if (debug != null && debug.getWillPrint()) {
            debug.incLevel("Proximity check: " + pcres);
            debug.print("<TABLE border=1>");
            debug.print("<TR><TD><B>FragAtom</B></TD><TD><B>Atom</B></TD><TD><B>Mismatch</B></TD><TD><B>Proximity</B></TD><TD><B>Metrid corr.</B></TD></TR>");
            for (int i = 0; i < store.fragmentAtomList.length; ++i) {
                debug.println("<TR><TD>" + i + "</TD><TD>" + store.fragmentAtomList[i] + "</TD><TD>" + mismatch.get(i) + "</TD><TD>" + prox.get(i) + "</TD><TD>" + mcorr[i]);
            }
            debug.print("</TABLE>");
            debug.decLevel();
        }
        multiDim newc = new multiDim(store.fragmentAtomList.length, 2);
        double[] anewc = new double[2];
        if (pcres == 0) {
            FragmentAtomFuseStore.mPlace1D(atom.d2res, store.fragmentAtomList.length, mcorr, newc, anewc);
            if (debug != null && debug.getWillPrint()) {
                debug.incLevel("Invoked 1D placement");
                debug.println("<CENTER><B>Place parameters:</B></CENTER>");
                debug.println("d2res=" + atom.d2res);
                debug.println("<CENTER><B>Place results:</B></CENTER>");
                debug.println("New atom coordinates:");
                debug.printVector(anewc);
                debug.println("New coordinates to concatenate:");
                newc.printDebug(debug);
                debug.decLevel();
            }
            FragmentAtomFinalItem fin = store.finalizeAtom(atom.storeID, newc, anewc, atom.dim == 2);
            if (debug != null && debug.getWillPrint()) {
                debug.incLevel("Final item:");
                fin.printout(debug);
                debug.decLevel();
                debug.println("Atom placement done.");
            }
        } else {
            if (debug != null && debug.getWillPrint()) {
                debug.incLevel("Invoke 2D placement");
            }
            FragmentAtomFuseStore.mPlace2D(atom.d2res, store.fragmentAtomList.length, mcorr, newc, anewc);
            if (debug != null && debug.getWillPrint()) {
                debug.println("<CENTER><B>Place parameters:</B></CENTER>");
                debug.println("d2res=" + atom.d2res);
                debug.println("<CENTER><B>Place results:</B></CENTER>");
                debug.println("New atom coordinates:");
                debug.printVector(anewc);
                debug.println("New coordinates to concatenate:");
                newc.printDebug(debug);
                debug.println("<CENTER><B>Check concatenated coordinates</B></CENTER>");
                debug.println("M<sub>res</sub> placed: " + debugPrintout.formatNumber(newc.metrid(anewc)));
                debug.Tstart();
                debug.Trow();
                debug.TprintBC("Atom");
                debug.TprintBC("New dM");
                debug.TprintBC("Desired");
                debug.TprintBC("diff");
            }
            for (int i = 0; i < newc.n; ++i) {
                if (debug != null && debug.getWillPrint()) {
                    debug.Trow();
                }
                double[] v = V.minus(anewc, newc.getV(i));
                double m = newc.metrid(v);
                if (debug == null || !debug.getWillPrint()) continue;
                debug.Tprint("" + i);
                debug.Tprint("" + debugPrintout.formatNumber(m));
                debug.Tprint("" + debugPrintout.formatNumber(mcorr[i]));
                debug.Tprint("" + debugPrintout.formatNumber(m - mcorr[i]));
            }
            if (debug != null && debug.getWillPrint()) {
                debug.Tstop();
            }
            if (debug != null && debug.getWillPrint()) {
                debug.decLevel();
            }
            FragmentAtomFinalItem fin = store.finalizeAtom(atom.storeID, newc, anewc, false);
            if (debug != null && debug.getWillPrint()) {
                debug.incLevel("Final item:");
                fin.printout(debug);
                debug.decLevel();
            }
        }
    }

    public static class RICTdescList {
        public RICTdescItem[] it = null;
        public int valids = 0;

        public void printout(debugPrintout debug) {
            if (debug != null && debug.getWillPrint()) {
                debug.Tstart();
                RICTdescItem.printoutHeaderRow(debug);
                for (int i = 0; i < this.valids; ++i) {
                    this.it[i].printoutRow(i, debug);
                }
                debug.Tstop();
            }
        }

        public RICTdescList(FragmentAtomFuseStore store) {
            FragmentAtomFuseItem atom;
            int atomToPlace;
            for (atomToPlace = 0; atomToPlace < store.getSize(); ++atomToPlace) {
                atom = store.get(atomToPlace);
                if (atom.getReady()) continue;
                ++this.valids;
            }
            this.it = new RICTdescItem[this.valids];
            this.valids = 0;
            for (atomToPlace = 0; atomToPlace < store.getSize(); ++atomToPlace) {
                atom = store.get(atomToPlace);
                if (atom.getReady()) continue;
                this.it[this.valids++] = new RICTdescItem(atomToPlace, atom);
            }
        }

        public void fillRMSDs(FragmentAtomFuseStore store, WishList wishl, FragmentStore frags) {
            int i;
            for (i = 0; i < this.valids; ++i) {
                double[] ret = new double[2];
                store.get(this.it[i].a).calcRMSDs(wishl, frags, ret);
                this.it[i].RMSD0 = ret[0];
                this.it[i].RMSD1 = ret[1];
            }
            for (i = 0; i < this.valids; ++i) {
                this.it[i].RMSD0p = 0;
                this.it[i].RMSD1p = 0;
                for (int j = 0; j < this.valids; ++j) {
                    if (i == j) continue;
                    if (this.it[j].RMSD0 <= this.it[i].RMSD0) {
                        ++this.it[i].RMSD0p;
                    }
                    if (!(this.it[j].RMSD1 <= this.it[i].RMSD1)) continue;
                    ++this.it[i].RMSD1p;
                }
            }
        }

        public void sortByRMSD() {
            if (this.valids > 1) {
                for (int i = 0; i < this.valids; ++i) {
                    while (!(i <= this.valids || U.isDoubleOK(this.it[i].RMSD0) && U.isDoubleOK(this.it[i].RMSD1))) {
                        --this.valids;
                        this.it[i] = this.it[this.valids];
                    }
                }
            }
            if (this.valids > 1) {
                Optimization.quickSort(0, this.valids - 1, new Optimization.Sortable(){

                    @Override
                    public boolean isGreater(int i, int j) {
                        return RICTdescList.this.it[i].RMSD0 > RICTdescList.this.it[j].RMSD0 || RICTdescList.this.it[i].RMSD0 == RICTdescList.this.it[j].RMSD0 && RICTdescList.this.it[i].RMSD1 > RICTdescList.this.it[j].RMSD1;
                    }

                    @Override
                    public void swap(int i, int j) {
                        RICTdescItem tmp = RICTdescList.this.it[i];
                        RICTdescList.this.it[i] = RICTdescList.this.it[j];
                        RICTdescList.this.it[j] = tmp;
                    }
                });
            }
        }

        public void clipByRMSD() {
            if (this.valids > 1) {
                int i;
                double limit = this.it[0].RMSD0 + 1.0;
                for (i = 0; i < this.valids && this.it[i].RMSD0 < limit; ++i) {
                }
                this.valids = i;
            }
        }
    }

    public static class RICTdescItem
    implements Serializable {
        public int a = -1;
        public int tc = -1;
        public double RMSD0 = -1.0;
        public double RMSD1 = -1.0;
        public int steps = -1;
        public int RMSD0p = -1;
        public int RMSD1p = -1;

        public static void printoutHeaderRow(debugPrintout debug) {
            if (debug != null && debug.getWillPrint()) {
                debug.Trow();
                debug.TprintBC("#");
                debug.TprintBC("atom");
                debug.TprintBC("conf");
                debug.TprintBC("RMSD0");
                debug.TprintBC("RMSD1");
                debug.TprintBC("RMSD0pos");
                debug.TprintBC("RMSD1pos");
                debug.TprintBC("RICT steps");
            }
        }

        public void printoutRow(int n, debugPrintout debug) {
            if (debug != null && debug.getWillPrint()) {
                debug.Trow();
                debug.TprintBC("" + n);
                debug.Tprint("" + this.a);
                debug.Tprint("" + this.tc);
                debug.Tprint(debugPrintout.formatNumber(this.RMSD0));
                debug.Tprint(debugPrintout.formatNumber(this.RMSD1));
                debug.Tprint("" + this.RMSD0p);
                debug.Tprint("" + this.RMSD1p);
                debug.Tprint("" + this.steps);
            }
        }

        public RICTdescItem(int an, FragmentAtomFuseItem atom) {
            this.a = an;
            this.tc = atom.confNo;
        }
    }
}

