/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build.fafuse;

import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.struc.myMoleculeConstants;
import chemaxon.marvin.modelling.util.U;
import java.util.BitSet;

public class FuseCommandSequence {
    public static final int OP_UNDEF = 0;
    public static final int OP_ATOM_ATOM = -1;
    public static final int OP_ATOM_FUSED = -2;
    public static final int OP_FUSED_FUSED = -3;
    public static final int OP_ATOM = -1;
    public static final int OP_FUSED = -2;
    public static final int OPF_CHAINAF = 1;
    public static final int OPF_RINGAF = 2;
    public static final int OPF_RINGCAF = 3;
    public static final int OPF_IRBBAF = 4;
    public static final int OPF_RINGSETCAF = 5;
    public static final int OPD_HOPLAYERA = 1;
    public static final int OPD_HOPLAYERFINAL = 2;
    public myMolecule mol = null;
    public int[] FW_Ref = null;
    public int[] ATOM_Ref = null;
    public int[] setNo = null;
    public int cmds = 0;
    public int[] OP_Type = null;
    public int[] OP1_Ref = null;
    public int[] OP2_Ref = null;
    public int[] OP_Flags = null;
    public int[] OP_Desc = null;

    public int getOp1Type(int cmd) {
        if (this.OP_Type[cmd] == -1 || this.OP_Type[cmd] == -2) {
            return -1;
        }
        if (this.OP_Type[cmd] == -3) {
            return -2;
        }
        return 0;
    }

    public int getOp2Type(int cmd) {
        if (this.OP_Type[cmd] == -1) {
            return -1;
        }
        if (this.OP_Type[cmd] == -2 || this.OP_Type[cmd] == -3) {
            return -2;
        }
        return 0;
    }

    public int getAnAtomFromFragment(int stepno) {
        while (this.getOp1Type(stepno) != -1) {
            if (this.getOp2Type(stepno) == -1) {
                return this.OP2_Ref[stepno];
            }
            stepno = this.OP1_Ref[stepno];
        }
        return this.OP1_Ref[stepno];
    }

    private void getAtomsForCommand(int[] list, int cmd, int[] nextIndex) {
        if (this.getOp1Type(cmd) == -1) {
            int n = nextIndex[0];
            nextIndex[0] = n + 1;
            list[n] = this.OP1_Ref[cmd];
        }
        if (this.getOp2Type(cmd) == -1) {
            int n = nextIndex[0];
            nextIndex[0] = n + 1;
            list[n] = this.OP2_Ref[cmd];
        }
        if (this.getOp1Type(cmd) == -2) {
            this.getAtomsForCommand(list, this.OP1_Ref[cmd], nextIndex);
        }
        if (this.getOp2Type(cmd) == -2) {
            this.getAtomsForCommand(list, this.OP2_Ref[cmd], nextIndex);
        }
    }

    public int[] getAtomsForCommand(int cmd) {
        int[] list = new int[this.setNo[cmd]];
        int[] index = new int[]{0};
        this.getAtomsForCommand(list, cmd, index);
        return list;
    }

    public int[] getAtomsToFragAtomsTable(int[] fragA) {
        int i;
        int[] list = new int[this.mol.a];
        for (i = 0; i < this.mol.a; ++i) {
            list[i] = -1;
        }
        for (i = 0; i < fragA.length; ++i) {
            list[fragA[i]] = i;
        }
        return list;
    }

    public void generateDefSeq(myMolecule m) {
        this.mol = m;
        if (this.mol.a > 1) {
            int f1;
            int i;
            this.cmds = this.mol.a - 1;
            this.OP_Type = new int[this.cmds];
            this.OP1_Ref = new int[this.cmds];
            this.OP2_Ref = new int[this.cmds];
            this.OP_Flags = new int[this.cmds];
            this.OP_Desc = new int[this.cmds];
            this.FW_Ref = new int[this.cmds];
            this.setNo = new int[this.cmds];
            int cmdp = 0;
            this.ATOM_Ref = new int[this.mol.a];
            for (int i2 = 0; i2 < this.cmds; ++i2) {
                this.setNo[i2] = 0;
                this.FW_Ref[i2] = -1;
                this.ATOM_Ref[i2] = 0;
            }
            boolean[] atflag = new boolean[this.mol.a];
            for (int i3 = 0; i3 < atflag.length; ++i3) {
                atflag[i3] = false;
            }
            boolean go = true;
            while (go) {
                go = false;
                for (int i4 = 0; i4 < this.mol.b; ++i4) {
                    if (atflag[this.mol.bat[0][i4]] || atflag[this.mol.bat[1][i4]]) continue;
                    this.OP_Type[cmdp] = -1;
                    this.OP1_Ref[cmdp] = this.mol.bat[0][i4];
                    this.ATOM_Ref[this.mol.bat[0][i4]] = cmdp;
                    this.OP2_Ref[cmdp] = this.mol.bat[1][i4];
                    this.ATOM_Ref[this.mol.bat[1][i4]] = cmdp;
                    this.setNo[cmdp] = 2;
                    ++cmdp;
                    atflag[this.mol.bat[0][i4]] = true;
                    atflag[this.mol.bat[1][i4]] = true;
                    go = true;
                }
            }
            go = true;
            while (go) {
                int a;
                go = false;
                for (a = 0; a < this.mol.a && atflag[a]; ++a) {
                }
                if (a >= this.mol.a) continue;
                int sSetNo = 0;
                int sSetA = 0;
                for (i = 0; i < this.mol.ctab[a].length; ++i) {
                    f1 = this.ATOM_Ref[this.mol.ctab[a][i]];
                    if (f1 < 0) continue;
                    while (this.FW_Ref[f1] != -1) {
                        f1 = this.FW_Ref[f1];
                    }
                    if (sSetA != 0 && sSetA <= this.setNo[f1]) continue;
                    sSetA = this.setNo[f1];
                    sSetNo = f1;
                }
                this.OP_Type[cmdp] = -2;
                this.OP1_Ref[cmdp] = a;
                this.ATOM_Ref[a] = cmdp;
                this.OP2_Ref[cmdp] = sSetNo;
                this.FW_Ref[sSetNo] = cmdp;
                this.setNo[cmdp] = 1 + sSetA;
                ++cmdp;
                atflag[a] = true;
                go = true;
            }
            while (cmdp < this.cmds) {
                int mina = this.mol.a + 10;
                int minf1 = 0;
                int minf2 = 0;
                for (i = 0; i < this.mol.b; ++i) {
                    f1 = this.ATOM_Ref[this.mol.bat[0][i]];
                    while (this.FW_Ref[f1] != -1) {
                        f1 = this.FW_Ref[f1];
                    }
                    int f2 = this.ATOM_Ref[this.mol.bat[1][i]];
                    while (this.FW_Ref[f2] != -1) {
                        f2 = this.FW_Ref[f2];
                    }
                    if (f1 == f2 || this.setNo[f1] + this.setNo[f2] >= mina) continue;
                    mina = this.setNo[f1] + this.setNo[f2];
                    minf1 = f1;
                    minf2 = f2;
                }
                this.OP_Type[cmdp] = -3;
                this.OP1_Ref[cmdp] = minf1;
                this.OP2_Ref[cmdp] = minf2;
                this.FW_Ref[minf1] = cmdp;
                this.FW_Ref[minf2] = cmdp;
                this.setNo[cmdp] = mina;
                ++cmdp;
            }
        }
    }

    public void generateSimplifiedSeq(myMolecule m) {
        this.mol = m;
        if (this.mol.a > 1) {
            this.cmds = this.mol.a - 1;
            this.OP_Type = new int[this.cmds];
            this.OP1_Ref = new int[this.cmds];
            this.OP2_Ref = new int[this.cmds];
            this.OP_Flags = new int[this.cmds];
            this.OP_Desc = new int[this.cmds];
            this.FW_Ref = new int[this.cmds];
            this.setNo = new int[this.cmds];
            int cmdp = 0;
            this.ATOM_Ref = new int[this.mol.a];
            for (int i = 0; i < this.cmds; ++i) {
                this.setNo[i] = 0;
                this.FW_Ref[i] = -1;
                this.ATOM_Ref[i] = 0;
            }
            boolean[] atflag = new boolean[this.mol.a];
            for (int i = 0; i < atflag.length; ++i) {
                atflag[i] = false;
            }
            boolean go = true;
            while (go) {
                for (int i = 0; i < this.mol.b && go; ++i) {
                    if (atflag[this.mol.bat[0][i]] || atflag[this.mol.bat[1][i]]) continue;
                    this.OP_Type[cmdp] = -1;
                    this.OP1_Ref[cmdp] = this.mol.bat[0][i];
                    this.ATOM_Ref[this.mol.bat[0][i]] = cmdp;
                    this.OP2_Ref[cmdp] = this.mol.bat[1][i];
                    this.ATOM_Ref[this.mol.bat[1][i]] = cmdp;
                    this.setNo[cmdp] = 2;
                    ++cmdp;
                    atflag[this.mol.bat[0][i]] = true;
                    atflag[this.mol.bat[1][i]] = true;
                    go = false;
                }
            }
            go = true;
            while (go) {
                int a;
                go = false;
                for (a = 0; a < this.mol.a && atflag[a]; ++a) {
                }
                if (a >= this.mol.a) continue;
                int sSetNo = 0;
                int sSetA = 0;
                for (int i = 0; i < this.mol.ctab[a].length; ++i) {
                    int f1 = this.ATOM_Ref[this.mol.ctab[a][i]];
                    if (f1 < 0) continue;
                    while (this.FW_Ref[f1] != -1) {
                        f1 = this.FW_Ref[f1];
                    }
                    if (sSetA != 0 && sSetA <= this.setNo[f1]) continue;
                    sSetA = this.setNo[f1];
                    sSetNo = f1;
                }
                if (sSetA == 0) continue;
                this.OP_Type[cmdp] = -2;
                this.OP1_Ref[cmdp] = a;
                this.ATOM_Ref[a] = cmdp;
                this.OP2_Ref[cmdp] = sSetNo;
                this.FW_Ref[sSetNo] = cmdp;
                this.setNo[cmdp] = 1 + sSetA;
                ++cmdp;
                atflag[a] = true;
                go = true;
            }
        }
    }

    public FuseCommandSequence(myMolecule m, StereoCriteriaList stereo, debugPrintout debug, int s) {
        if (s == 1) {
            this.generateSimplifiedSeq(m);
        } else if (s == 2) {
            this.generateDefSeq(m);
        } else if (s == 3) {
            this.generateLayeredSimpleSeq(m, stereo, debug);
        }
    }

    public void generateLayeredSimpleSeq(myMolecule m, StereoCriteriaList stereo, debugPrintout debug) {
        boolean doDebug2;
        this.mol = m;
        boolean doDebug = false;
        boolean bl = doDebug2 = debug != null && debug.getWillPrint();
        if (this.mol.a > 1) {
            int i;
            if (doDebug2) {
                debug.incLevel("Sequence generation");
                doDebug = debug.getWillPrint();
            }
            BitSet parspec = stereo.getParityCenters();
            String mfname = "seqgen.mol";
            if (doDebug) {
                m.placeApplet("Given molecule");
            }
            this.cmds = this.mol.a - 1;
            this.OP_Type = new int[this.cmds];
            this.OP1_Ref = new int[this.cmds];
            this.OP2_Ref = new int[this.cmds];
            this.OP_Flags = new int[this.cmds];
            this.OP_Desc = new int[this.cmds];
            this.FW_Ref = new int[this.cmds];
            this.setNo = new int[this.cmds];
            int[] atomflag = new int[this.mol.a];
            int[] chainparam = new int[this.mol.a];
            int[] layerno = new int[this.mol.a];
            int layers = 0;
            boolean hasrings = false;
            int[] atomToStep = new int[this.mol.a];
            int[] stepToAtom = new int[this.mol.a];
            int[] stepToAtomClassification = new int[this.mol.a];
            for (int i2 = 0; i2 < this.mol.a; ++i2) {
                atomToStep[i2] = -1;
                stepToAtom[i2] = -1;
            }
            int step = 0;
            if (doDebug) {
                debug.printBC("Atom classification");
            }
            if (this.mol.SSSR.length > 0) {
                hasrings = true;
            }
            for (int i3 = 0; i3 < this.mol.a; ++i3) {
                switch (this.mol.atomFlag[i3] & 0x3000) {
                    case 12288: {
                        atomflag[i3] = 3;
                        break;
                    }
                    case 4096: {
                        atomflag[i3] = 1;
                        break;
                    }
                    case 8192: {
                        atomflag[i3] = 2;
                    }
                }
                if (atomflag[i3] != 1) continue;
                int nonHneigs = 0;
                boolean pneigh = false;
                for (int j = 0; j < this.mol.ctab[i3].length; ++j) {
                    int ni = this.mol.ctab[i3][j];
                    if (parspec != null && parspec.get(ni)) {
                        pneigh = true;
                    }
                    if ((this.mol.atomFlag[ni] & 0x10) == 0) {
                        pneigh = true;
                    }
                    if (this.mol.anum[ni] == 1) continue;
                    ++nonHneigs;
                }
                if (pneigh) continue;
                if (this.mol.anum[i3] == 1) {
                    chainparam[i3] = 2;
                    continue;
                }
                if (nonHneigs != true) continue;
                chainparam[i3] = 1;
            }
            if (doDebug) {
                String[] sel = new String[1];
                for (int j = 1; j <= 5; ++j) {
                    sel[0] = null;
                    for (int i4 = 0; i4 < this.mol.a; ++i4) {
                        if ((j > 3 || atomflag[i4] != j) && (j <= 3 || atomflag[i4] != 1 || chainparam[i4] != j - 3)) continue;
                        sel[0] = sel[0] == null ? "" + i4 : sel[0] + "," + i4;
                    }
                    String prefix = "";
                    String btnlabel = "";
                    switch (j) {
                        case 1: {
                            prefix = "chains";
                            btnlabel = "chain atoms";
                            break;
                        }
                        case 2: {
                            prefix = "rings";
                            btnlabel = "ring atoms";
                            break;
                        }
                        case 3: {
                            prefix = "ircbb";
                            btnlabel = "inter-ring chain backbones";
                            break;
                        }
                        case 4: {
                            prefix = "chains4";
                            btnlabel = "Chain end atom with no-P SP3 n";
                            break;
                        }
                        case 5: {
                            prefix = "chains5";
                            btnlabel = "H atom with no-P SP3 n";
                        }
                    }
                    m.placeApplets(btnlabel, sel);
                }
                if (this.mol.chainCenterCandidate != -1) {
                    sel = new String[]{"" + this.mol.chainCenterCandidate};
                    m.placeApplets("Chain center candidate", sel);
                }
            }
            if (hasrings) {
                if (doDebug) {
                    debug.printBC("Ring handling: ring placement center");
                }
                if (doDebug) {
                    debug.println("Find ring placement centrum...");
                }
                int centruma = -1;
                int centrumn = -1;
                int centrumr = -1;
                boolean centrumSP2 = false;
                int centrumSP2rneighs = -1;
                int finalScore = -1;
                int[] ringCentrumScore = new int[this.mol.a];
                for (i = 0; i < this.mol.a; ++i) {
                    ringCentrumScore[i] = -1;
                    if (atomflag[i] != 2) continue;
                    int rn = 0;
                    boolean isSP2 = this.mol.isHybSP2(i);
                    int SP2rneighs = 0;
                    for (int j = 0; j < this.mol.ctab[i].length; ++j) {
                        if (atomflag[this.mol.ctab[i][j]] != 2) continue;
                        ++rn;
                        if (!this.mol.isHybSP2(this.mol.ctab[i][j])) continue;
                        ++SP2rneighs;
                    }
                    int Score = 1;
                    int n = i;
                    ringCentrumScore[n] = ringCentrumScore[n] + SP2rneighs * Score;
                    int n2 = i;
                    ringCentrumScore[n2] = ringCentrumScore[n2] + rn * (Score *= 10);
                    Score *= 10;
                    if (isSP2) {
                        int n3 = i;
                        ringCentrumScore[n3] = ringCentrumScore[n3] + Score;
                    }
                    int n4 = i;
                    ringCentrumScore[n4] = ringCentrumScore[n4] + this.mol.rings[i] * (Score *= 10);
                    Score *= 10;
                    if (this.mol.ctab[i].length > 4) {
                        int n5 = i;
                        ringCentrumScore[n5] = ringCentrumScore[n5] + Score;
                    }
                    if (doDebug) {
                        debug.println("Atomic params for " + i + ": " + this.mol.ctab[i].length + " " + rn + " " + SP2rneighs + " " + isSP2);
                    }
                    if (ringCentrumScore[i] <= finalScore) continue;
                    centruma = i;
                    centrumn = rn;
                    centrumr = this.mol.rings[i];
                    centrumSP2 = isSP2;
                    centrumSP2rneighs = SP2rneighs;
                    finalScore = ringCentrumScore[i];
                }
                stepToAtom[step] = centruma;
                atomToStep[stepToAtom[step]] = step;
                layerno[stepToAtom[step]] = ++layers;
                if (doDebug) {
                    debug.println("<B>Step:</B> " + step + " <B>Atom:</B> " + stepToAtom[step]);
                }
                ++step;
                if (doDebug) {
                    String[] sel = new String[]{"" + centruma};
                    m.placeApplets("Ring place centrum", sel);
                }
            } else {
                if (doDebug) {
                    debug.printBC("Chain init");
                }
                if (doDebug) {
                    debug.println("Place chain center candidate");
                }
                stepToAtom[step] = this.mol.chainCenterCandidate;
                atomToStep[stepToAtom[step]] = step;
                layerno[stepToAtom[step]] = ++layers;
                if (doDebug) {
                    debug.println("<B>Step:</B> " + step + " <B>Atom:</B> " + stepToAtom[step]);
                }
                ++step;
            }
            if (doDebug) {
                debug.printBC("Place atom layers");
            }
            int ringToBuild = -1;
            boolean go = true;
            while (go) {
                boolean higherOrderParityCase;
                int j;
                int k;
                int j2;
                int i5;
                go = false;
                int[] layerflags = new int[this.mol.a];
                int maxflag = 0;
                if (doDebug) {
                    debug.printBC("Next layer");
                }
                if (ringToBuild == -1) {
                    int sr = -1;
                    int srns = -1;
                    int srsz = -1;
                    for (i = 0; i < this.mol.SSSR.length; ++i) {
                        int ns = 0;
                        int ps = 0;
                        for (int j3 = 0; j3 < this.mol.SSSR[i].length; ++j3) {
                            if (atomToStep[this.mol.SSSR[i][j3]] == -1) {
                                ++ns;
                                continue;
                            }
                            ++ps;
                        }
                        int sz = ns + ps;
                        if ((sr != -1 || ns <= 0 || ps <= 0) && (sr == -1 || ns <= 0 || ps <= 0 || ns >= srns)) continue;
                        sr = i;
                        srns = ns;
                        srsz = sz;
                    }
                    ringToBuild = sr;
                    if (doDebug) {
                        debug.println("RingToBuild test. RingToBuild = " + ringToBuild + " sr=" + sr + " srns=" + srns);
                    }
                } else {
                    int ns0 = 0;
                    int sz0 = 0;
                    for (i5 = 0; i5 < this.mol.SSSR[ringToBuild].length; ++i5) {
                        if (atomToStep[this.mol.SSSR[ringToBuild][i5]] != -1) continue;
                        ++ns0;
                    }
                    sz0 = this.mol.SSSR[ringToBuild].length;
                    for (i5 = 0; i5 < this.mol.SSSR.length; ++i5) {
                        int ns = 0;
                        int ps = 0;
                        for (int j4 = 0; j4 < this.mol.SSSR[i5].length; ++j4) {
                            if (atomToStep[this.mol.SSSR[i5][j4]] == -1) {
                                ++ns;
                                continue;
                            }
                            ++ps;
                        }
                        if (ns >= ns0 || ns <= 0 || ps <= 0) continue;
                        ns0 = ns;
                        ringToBuild = i5;
                        if (!doDebug) continue;
                        debug.println("Found a better ringToBuld (" + ringToBuild + "), ns: " + ns);
                    }
                }
                if (doDebug) {
                    debug.Tstart();
                    debug.Trow();
                    debug.TprintBC(5, "Neighbor scan");
                    debug.Trow();
                    debug.TprintBC("#");
                    debug.TprintBC("rb");
                    debug.TprintBC("nrb");
                    debug.TprintBC("l6b");
                    debug.TprintBC("l7b");
                    debug.TprintBC("l8b");
                    debug.TprintBC("Flag");
                    debug.TprintBC("RingToBuild");
                    debug.TprintBC("HAS PSPEC 2L neigh.");
                }
                BitSet hopCentral = null;
                BitSet hopLayer = null;
                for (i5 = 0; i5 < this.mol.a; ++i5) {
                    if (atomToStep[i5] != -1) continue;
                    int rb = 0;
                    int nrb = 0;
                    int l6b = 0;
                    int l7b = 0;
                    int l8b = 0;
                    boolean hasSPN2L = false;
                    boolean hasHOPN = false;
                    String s = "";
                    for (j2 = 0; j2 < this.mol.ctab[i5].length; ++j2) {
                        int a1 = this.mol.ctab[i5][j2];
                        s = s + "nno=" + j2 + " (a1:" + a1 + ") ";
                        if (atomToStep[a1] != -1) {
                            int bf = this.mol.bdesc[this.mol.blist[i5][j2]];
                            s = s + "bno=" + this.mol.blist[i5][j2];
                            s = s + "p, bf= " + bf + " ";
                            if ((bf & myMoleculeConstants.B_R_INRING) != 0) {
                                ++rb;
                            } else {
                                ++nrb;
                            }
                            if (parspec != null && parspec.get(a1)) {
                                int pln = 0;
                                for (k = 0; k < this.mol.ctab[a1].length; ++k) {
                                    if (atomToStep[this.mol.ctab[a1][k]] == -1) continue;
                                    ++pln;
                                }
                                if (pln >= 2) {
                                    hasSPN2L = true;
                                }
                            }
                            if (this.mol.ctab[a1].length < 5 && this.mol.anum[a1] <= 10) continue;
                            hasHOPN = true;
                            if (hopCentral == null) {
                                hopCentral = new BitSet(this.mol.a);
                                hopLayer = new BitSet(this.mol.a);
                            }
                            hopCentral.set(a1);
                            continue;
                        }
                        if (layerflags[a1] == 6) {
                            ++l6b;
                            continue;
                        }
                        if (layerflags[a1] == 7) {
                            ++l7b;
                            continue;
                        }
                        if (layerflags[a1] != 8) continue;
                        ++l8b;
                    }
                    if (rb > 0 || nrb > 0) {
                        layerflags[i5] = 1;
                        go = true;
                        if (rb == 0 && nrb == 1 && atomflag[i5] == 1) {
                            layerflags[i5] = 2;
                        } else if (rb == 0 && nrb == 1 && atomflag[i5] == 3) {
                            layerflags[i5] = 3;
                        } else if (rb == 0 && nrb == 1 && atomflag[i5] == 2) {
                            layerflags[i5] = 4;
                        } else if (rb > 1 && nrb == 0 && atomflag[i5] == 2) {
                            layerflags[i5] = 5;
                        } else if (rb == 1 && nrb == 0 && atomflag[i5] == 2) {
                            boolean rtba = false;
                            if (ringToBuild != -1) {
                                for (j = 0; j < this.mol.atomToRing[i5].length; ++j) {
                                    if (this.mol.atomToRing[i5][j] != ringToBuild) continue;
                                    rtba = true;
                                    break;
                                }
                            }
                            if (rtba && l7b == 0) {
                                layerflags[i5] = 7;
                            }
                            if (rtba && l8b == 0) {
                                int nn;
                                if (this.mol.isHybSP2(i5)) {
                                    for (j = 0; j < this.mol.ctab[i5].length; ++j) {
                                        nn = this.mol.ctab[i5][j];
                                        if (atomflag[nn] != 2 || !this.mol.isHybSP2(nn)) continue;
                                        layerflags[i5] = 8;
                                    }
                                } else {
                                    for (j = 0; j < this.mol.ctab[i5].length; ++j) {
                                        nn = this.mol.ctab[i5][j];
                                        if (atomToStep[nn] == -1 || !this.mol.isHybSP2(nn)) continue;
                                        layerflags[i5] = 8;
                                    }
                                }
                            }
                            if (layerflags[i5] != 7 && layerflags[i5] != 8 && l6b == 0) {
                                layerflags[i5] = 6;
                            }
                        }
                        if (hasSPN2L && layerflags[i5] != 5) {
                            layerflags[i5] = 9;
                        }
                        if (hasHOPN) {
                            layerflags[i5] = 10;
                            hopLayer.set(i5);
                        }
                        if (layerflags[i5] > maxflag && maxflag != 5 || layerflags[i5] == 5) {
                            maxflag = layerflags[i5];
                        }
                        if (layerflags[i5] == 1 && rb + l6b <= 1) {
                            System.err.println("WARNING: Consistency error in generateLayeredSimpleSequence()");
                        }
                    }
                    if (!doDebug) continue;
                    debug.Trow();
                    debug.TprintBC("" + i5);
                    debug.Tprint("" + rb);
                    debug.Tprint("" + nrb);
                    debug.Tprint("" + l6b);
                    debug.Tprint("" + l7b);
                    debug.Tprint("" + l8b);
                    debug.Tprint("" + layerflags[i5]);
                    debug.Tprint("" + ringToBuild);
                    debug.Tprint(s);
                    debug.Tprint("" + hasSPN2L);
                }
                if (doDebug) {
                    debug.Tstop();
                }
                if (maxflag == 1) {
                    System.err.println("WARNING: Consistency error in generateLayeredSimpleSequence()");
                }
                if (maxflag == 5 && ringToBuild != -1) {
                    int rtbc = -1;
                    block43: for (i = 0; i < this.mol.a; ++i) {
                        if (layerflags[i] != 5) continue;
                        for (int j5 = 0; j5 < this.mol.atomToRing[i].length; ++j5) {
                            if (this.mol.atomToRing[i][j5] != ringToBuild) continue;
                            rtbc = i;
                            continue block43;
                        }
                    }
                    if (rtbc != -1) {
                        for (i = 0; i < this.mol.a; ++i) {
                            if (i == rtbc) continue;
                            layerflags[i] = 0;
                        }
                    }
                }
                if (maxflag == 2) {
                    int mincp = 10;
                    for (i = 0; i < layerflags.length; ++i) {
                        if (layerflags[i] != 2 || chainparam[i] >= mincp) continue;
                        mincp = chainparam[i];
                    }
                    for (i = 0; i < layerflags.length; ++i) {
                        if (layerflags[i] != 2 || chainparam[i] <= mincp) continue;
                        layerflags[i] = 0;
                    }
                }
                boolean onlyOne = false;
                if (maxflag == 1 || maxflag == 4 || maxflag == 9 || maxflag == 5) {
                    onlyOne = true;
                }
                if (maxflag != 7 && maxflag != 8 && ringToBuild != -1) {
                    ringToBuild = -1;
                    if (doDebug) {
                        debug.println("<B>Disable ringToBuild</B>");
                    }
                }
                if (doDebug) {
                    debug.println("Max flag: " + maxflag);
                    debug.println("OnlyOne: " + onlyOne);
                    debug.println("Layerflags: (1: undefined/2: chain/3:irbb/4:rscenter/5:rc/6:rspan/7:rtbuildspan/8:SP2rtbspan/9:parity ligand/10:higher oredr parity ligand)");
                    debug.printVector(layerflags);
                }
                if (!go) continue;
                if (doDebug) {
                    debug.println("Place atoms");
                }
                ++layers;
                boolean bl2 = higherOrderParityCase = maxflag == 10;
                if (higherOrderParityCase) {
                    int i6;
                    if (doDebug) {
                        debug.printB("HOP ligand sequencing");
                    }
                    int[] hopCenters = U.collectSets(hopCentral);
                    int[] layerAtoms = U.collectSets(hopLayer);
                    BitSet pHopL = new BitSet(this.mol.a);
                    for (int i7 = 0; i7 < hopCenters.length; ++i7) {
                        int ci = hopCenters[i7];
                        for (int j6 = 0; j6 < this.mol.ctab[ci].length; ++j6) {
                            if (atomToStep[this.mol.ctab[ci][j6]] == -1) continue;
                            pHopL.set(this.mol.ctab[ci][j6]);
                        }
                    }
                    int[] placedHopL = U.collectSets(pHopL);
                    if (doDebug) {
                        debug.println("HOP centers");
                        debug.printVector(hopCenters);
                        debug.println("HOP layer");
                        debug.printVector(layerAtoms);
                        debug.println("placed HOP ligands");
                        debug.printVector(placedHopL);
                    }
                    int[][] layerOpposite = new int[layerAtoms.length][];
                    for (i6 = 0; i6 < layerAtoms.length; ++i6) {
                        BitSet tmp = new BitSet(this.mol.a);
                        int la = layerAtoms[i6];
                        for (j = 0; j < hopCenters.length; ++j) {
                            int hc = hopCenters[j];
                            if (this.mol.bonds[la][hc] == -1) continue;
                            int lssp = this.mol.getSSpInfo(hc, la);
                            for (k = 0; k < this.mol.ctab[hc].length; ++k) {
                                int nssp;
                                int n = this.mol.ctab[hc][k];
                                if (n == la || ((nssp = this.mol.getSSpInfo(hc, n)) & lssp & this.mol.getSSp1DMask()) == 0) continue;
                                tmp.set(n);
                            }
                        }
                        layerOpposite[i6] = U.collectSets(tmp);
                    }
                    if (doDebug) {
                        debug.println("Opposites list");
                        debug.Tstart();
                        debug.Trow();
                        debug.TprintBC("#");
                        debug.TprintBC("layer a.");
                        debug.TprintBC("Opposites");
                        for (i6 = 0; i6 < layerOpposite.length; ++i6) {
                            debug.Trow();
                            debug.TprintBC("" + i6);
                            debug.TprintC("" + layerAtoms[i6]);
                            String os = "";
                            for (j2 = 0; j2 < layerOpposite[i6].length; ++j2) {
                                os = os + layerOpposite[i6][j2] + " ";
                            }
                            debug.Tprint(os);
                        }
                        debug.Tstop();
                    }
                    BitSet lplaced = new BitSet(layerAtoms.length);
                    for (int i8 = 0; i8 < layerAtoms.length; ++i8) {
                        int blac = -1;
                        int bpoc = this.mol.a + 1;
                        boolean blacRingclosing = false;
                        boolean bestL10R = false;
                        for (int j7 = 0; j7 < layerAtoms.length; ++j7) {
                            if (atomToStep[layerAtoms[j7]] != -1) continue;
                            int poc = 0;
                            for (int k2 = 0; k2 < layerOpposite[j7].length; ++k2) {
                                if (stepToAtom[layerOpposite[j7][k2]] == -1) continue;
                                ++poc;
                            }
                            boolean L10R = false;
                            if (maxflag == 10 && atomflag[layerAtoms[j7]] == 2) {
                                L10R = true;
                            }
                            boolean ringclosing = false;
                            int cla = layerAtoms[j7];
                            int n = 0;
                            for (int k3 = 0; k3 < this.mol.ctab[cla].length; ++k3) {
                                if (atomToStep[this.mol.ctab[cla][k3]] == -1) continue;
                                ++n;
                            }
                            if (n > 1) {
                                ringclosing = true;
                            }
                            boolean update = false;
                            if (blac == -1) {
                                update = true;
                            }
                            if (L10R && !bestL10R) {
                                update = true;
                            }
                            if (L10R == bestL10R && poc < bpoc) {
                                update = true;
                            }
                            if (!update && !blacRingclosing && ringclosing) {
                                update = true;
                            }
                            if (update && blacRingclosing && !ringclosing) {
                                update = false;
                            }
                            if (!update) continue;
                            blac = layerAtoms[j7];
                            bpoc = poc;
                            bestL10R = L10R;
                            blacRingclosing = ringclosing;
                        }
                        if (blac == -1) {
                            System.err.println("Consistency error in sequencing. ");
                            return;
                        }
                        if (layerflags[blac] != 10) continue;
                        stepToAtomClassification[step] = maxflag;
                        stepToAtom[step] = blac;
                        atomToStep[stepToAtom[step]] = step;
                        layerno[stepToAtom[step]] = layers;
                        int n = step - 1;
                        this.OP_Desc[n] = this.OP_Desc[n] | 1;
                        if (i8 == layerAtoms.length - 1) {
                            int n6 = step - 1;
                            this.OP_Desc[n6] = this.OP_Desc[n6] | 2;
                        }
                        if (doDebug) {
                            debug.println("<B>Step:</B> " + step + " <B>Atom:</B> " + stepToAtom[step]);
                        }
                        ++step;
                    }
                } else {
                    for (int i9 = 0; i9 < this.mol.a; ++i9) {
                        if (layerflags[i9] != maxflag) continue;
                        stepToAtomClassification[step] = maxflag;
                        stepToAtom[step] = i9;
                        atomToStep[stepToAtom[step]] = step;
                        layerno[stepToAtom[step]] = layers;
                        if (doDebug) {
                            debug.println("<B>Step:</B> " + step + " <B>Atom:</B> " + stepToAtom[step]);
                        }
                        ++step;
                        if (!onlyOne) continue;
                        if (!doDebug) break;
                        debug.println("One atom placed, exiting.");
                        break;
                    }
                }
                if (!doDebug) continue;
                String[] sel = new String[]{null, null};
                for (int i10 = 0; i10 < this.mol.a; ++i10) {
                    if (layerno[i10] == layers) {
                        sel[0] = sel[0] == null ? "" + i10 : sel[0] + "," + i10;
                    }
                    if (atomToStep[i10] == -1) continue;
                    sel[1] = sel[1] == null ? "" + i10 : sel[1] + "," + i10;
                }
                m.placeApplets("Show layer " + layers, sel);
            }
            if (doDebug) {
                int i11;
                debug.printHR();
                debug.printBC("Placement sequence done.");
                debug.Tstart();
                debug.Trow();
                debug.TprintBC(this.mol.a + 1, "States");
                debug.Trow();
                debug.TprintBC("Number:");
                for (i11 = 0; i11 < this.mol.a; ++i11) {
                    debug.Tprint("" + i11);
                }
                debug.Trow();
                debug.TprintBC("Atomflag:");
                for (i11 = 0; i11 < this.mol.a; ++i11) {
                    debug.Tprint("" + atomflag[i11]);
                }
                debug.Trow();
                debug.TprintBC("Layerno:");
                for (i11 = 0; i11 < this.mol.a; ++i11) {
                    debug.Tprint("" + layerno[i11]);
                }
                debug.Trow();
                debug.TprintBC("AtomToStep:");
                for (i11 = 0; i11 < this.mol.a; ++i11) {
                    debug.Tprint("" + atomToStep[i11]);
                }
                debug.Trow();
                debug.TprintBC("StepToAtom:");
                for (i11 = 0; i11 < this.mol.a; ++i11) {
                    debug.Tprint("" + stepToAtom[i11]);
                }
                debug.Tstop();
            }
            if (doDebug) {
                String[] sel = new String[layers];
                for (int j = 0; j < layers; ++j) {
                    sel[j] = null;
                    for (int i12 = 0; i12 < this.mol.a; ++i12) {
                        if (layerno[i12] > j + 1) continue;
                        sel[j] = sel[j] == null ? "" + i12 : sel[j] + "," + i12;
                    }
                }
                m.placeApplets("Show final layers", sel);
            }
            if (doDebug) {
                debug.println("Build sequence");
            }
            int cmdp = 0;
            this.ATOM_Ref = new int[this.mol.a];
            for (int i13 = 0; i13 < this.cmds; ++i13) {
                this.setNo[i13] = 0;
                this.FW_Ref[i13] = -1;
                this.ATOM_Ref[i13] = 0;
            }
            int at1 = stepToAtom[0];
            int at2 = stepToAtom[1];
            this.OP_Type[cmdp] = -1;
            this.OP1_Ref[cmdp] = at1;
            this.ATOM_Ref[at1] = cmdp;
            this.OP2_Ref[cmdp] = at2;
            this.ATOM_Ref[at2] = cmdp;
            this.setNo[cmdp] = 2;
            ++cmdp;
            while (cmdp < this.cmds) {
                at1 = stepToAtom[cmdp + 1];
                this.OP_Flags[cmdp] = 1;
                switch (stepToAtomClassification[cmdp + 1]) {
                    case 2: {
                        this.OP_Flags[cmdp] = 1;
                        break;
                    }
                    case 3: {
                        this.OP_Flags[cmdp] = 4;
                        break;
                    }
                    case 4: {
                        this.OP_Flags[cmdp] = 5;
                        break;
                    }
                    case 5: {
                        this.OP_Flags[cmdp] = 3;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.OP_Flags[cmdp] = 2;
                        break;
                    }
                    case 9: 
                    case 10: {
                        switch (atomflag[at1]) {
                            case 2: {
                                this.OP_Flags[cmdp] = 2;
                                break;
                            }
                            case 3: {
                                this.OP_Flags[cmdp] = 4;
                            }
                        }
                        int livebondct = 0;
                        for (int i14 = 0; i14 < this.mol.ctab[at1].length; ++i14) {
                            if (atomToStep[this.mol.ctab[at1][i14]] < 0) continue;
                            ++livebondct;
                        }
                        if (livebondct == 0) {
                            System.err.println("Consistency error: No bonded atom in sequence");
                        } else if (livebondct > 0) {
                            if (this.OP_Flags[cmdp] != 3) {
                                this.OP_Flags[cmdp] = 3;
                            }
                        }
                        int pre = this.OP_Flags[cmdp - 1];
                        int act = this.OP_Flags[cmdp];
                        if (pre == 0 || act != 1 && (act != 4 || pre == 1) && (act != 2 || pre == 1 || pre == 4)) break;
                        this.OP_Flags[cmdp] = pre;
                    }
                }
                this.OP_Type[cmdp] = -2;
                this.OP1_Ref[cmdp] = at1;
                this.ATOM_Ref[at1] = cmdp;
                this.OP2_Ref[cmdp] = cmdp - 1;
                this.FW_Ref[cmdp - 1] = cmdp;
                this.setNo[cmdp] = 1 + this.setNo[cmdp - 1];
                ++cmdp;
            }
            if (doDebug2) {
                debug.decLevel();
            }
        }
    }

    public void printoutRecursion(debugPrintout debug, String prefix, int rootcmd) {
        debug.print("<B>[cmd: " + rootcmd + "] atoms: " + this.setNo[rootcmd] + " fwd ref: " + this.FW_Ref[rootcmd] + "</B> Atom list: ");
        int[] list = this.getAtomsForCommand(rootcmd);
        for (int i = 0; i < list.length; ++i) {
            debug.print(list[i] + " ");
        }
        debug.print("<BR>");
        debug.print(prefix + "......|<BR>");
        if (this.getOp1Type(rootcmd) == -1) {
            debug.print(prefix + "......+-[ATOM] id: " + this.OP1_Ref[rootcmd] + "<BR>");
        }
        if (this.getOp1Type(rootcmd) == -2) {
            debug.print(prefix + "......+-");
            this.printoutRecursion(debug, prefix + "......|", this.OP1_Ref[rootcmd]);
        }
        debug.print(prefix + "......|<BR>");
        if (this.getOp2Type(rootcmd) == -1) {
            debug.print(prefix + "......+-[ATOM] id: " + this.OP2_Ref[rootcmd] + "<BR>");
        }
        if (this.getOp2Type(rootcmd) == -2) {
            debug.print(prefix + "......+-");
            this.printoutRecursion(debug, prefix + ".......", this.OP2_Ref[rootcmd]);
        }
    }

    public void printout(debugPrintout debug) {
        debug.println("Reference sequence:");
        debug.print("<TABLE BORDER=1><TR><TD ROWSPAN = 2 >#</TD><TD COLSPAN=2><CENTER><B>OP1</B></CENTER></TD><TD COLSPAN=2><CENTER><B>OP2</B></CENTER></TD><TD COLSPAN=2><CENTER><B>INFO</B></CENTER></TD><TD ROWSPAN = 2>StepFlag</TD><TD ROWSPAN = 2>StepDesc</TD></TR>");
        debug.print("<TR><TD>Type</TD><TD>Ref</TD><TD>Type</TD><TD>Ref</TD><TD>FW_REF</TD><TD>Atoms</TD></TR>");
        for (int i = 0; i < this.cmds; ++i) {
            String opfs = "";
            switch (this.OP_Flags[i]) {
                case 1: {
                    opfs = "CHAIN atom fuse to fragment";
                    break;
                }
                case 4: {
                    opfs = "INTER RING BACKBONE atom fuse to fragment";
                    break;
                }
                case 2: {
                    opfs = "RING atom fuse to fragment";
                    break;
                }
                case 3: {
                    opfs = "RING CLOSE atom fuse to fragment";
                    break;
                }
                case 5: {
                    opfs = "RINGSET CENTER atom fuse to fragment";
                }
            }
            String opdesc = "";
            if ((this.OP_Desc[i] & 1) != 0) {
                opdesc = opdesc + "HOP layer atom; ";
            }
            if ((this.OP_Desc[i] & 2) != 0) {
                opdesc = opdesc + "HOP layer final; ";
            }
            debug.print("<TR><TD>" + i + "</TD><TD>");
            if (this.getOp1Type(i) == -1) {
                debug.print("A");
            }
            if (this.getOp1Type(i) == -2) {
                debug.print("F");
            }
            debug.print("</TD><TD>" + this.OP1_Ref[i] + "</TD><TD>");
            if (this.getOp2Type(i) == -1) {
                debug.print("A");
            }
            if (this.getOp1Type(i) == -2) {
                debug.print("F");
            }
            debug.print("</TD><TD>" + this.OP2_Ref[i] + "</TD><TD>" + this.FW_Ref[i] + "</TD><TD>" + this.setNo[i] + "</TD>" + "<TD>" + this.OP_Flags[i] + " (" + opfs + ")</TD>" + "<TD>" + this.OP_Desc[i] + " (" + opdesc + ")</TD>" + "</TR>");
        }
        debug.print("</TABLE>");
        debug.println("Atom references:");
        debug.printVector(this.ATOM_Ref);
        debug.println("Glue tree:");
        debug.print("<TT>");
        this.printoutRecursion(debug, "&nbsp;", this.cmds - 1);
        debug.print("</TT>");
    }
}

