/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.build.fafuse;

import chemaxon.calculations.clean.Clean3D;
import chemaxon.marvin.modelling.build.fafuse.FragmentAtomFuseStore;
import chemaxon.marvin.modelling.build.fafuse.FragmentStore;
import chemaxon.marvin.modelling.build.fafuse.WishListItem;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.struc.myMoleculeConstants;
import chemaxon.marvin.modelling.util.myList;

public class WishList {
    public myList wl = null;
    public myList pwl = null;
    public myMolecule mol;
    public debugPrintout debug;
    public int atomNo = 0;
    public int fragNo = 0;
    public FragmentStore frag = null;

    public void groupByTarget(debugPrintout d, FragmentAtomFuseStore store) {
        int nopri;
        if (d != null) {
            d.printBC("Group wishes by target");
            d.println("Find best target");
        }
        int no = -1;
        int neighs = -1;
        for (int i = 0; i < this.getSize(); ++i) {
            WishListItem w = this.getWish(i);
            if (w.type != 1) continue;
            if (d != null) {
                d.println("Check wish:");
                w.printout(d);
            }
            int ta = w.getTargetAtom();
            int pn = 0;
            for (int j = 0; j < this.mol.ctab[ta].length; ++j) {
                if (store.atomToFragmentA[this.mol.ctab[ta][j]] != -1) {
                    ++pn;
                }
                if (no != -1 && pn <= neighs) continue;
                if (d != null) {
                    d.println("New target: " + ta + " with placed neighbors: " + pn);
                }
                no = ta;
                neighs = pn;
            }
        }
        int pri = 0;
        for (nopri = 0; nopri < this.getSize() && this.getWish(nopri).getConnectedAtom() == no; ++nopri) {
        }
        for (pri = nopri; pri < this.getSize() && this.getWish(pri).getConnectedAtom() != no; ++pri) {
        }
        while (nopri < this.getSize() && pri < this.getSize()) {
            this.wl.swap(pri, nopri);
            ++nopri;
            while (nopri < this.getSize() && this.getWish(nopri).getConnectedAtom() == no) {
                ++nopri;
            }
            for (pri = nopri; pri < this.getSize() && this.getWish(pri).getConnectedAtom() != no; ++pri) {
            }
        }
    }

    public WishList(myMolecule m, int a, int f, FragmentStore fs, debugPrintout d) {
        this.mol = m;
        this.atomNo = a;
        this.fragNo = f;
        this.frag = fs;
        if (d != null) {
            if (d.getWillPrint()) {
                this.debug = d;
            }
        } else {
            d = null;
        }
        this.wl = new myList(20);
        this.saveBonds();
        this.saveAngles();
        this.saveTorsions();
    }

    public void saveParticipants() {
        if (this.debug != null) {
            this.debug.printBC("Save participant wishes");
        }
        this.pwl = new myList(20);
        this.saveParticipantAngles();
        this.saveParticipantTorsions();
    }

    public void saveBonds() {
        if (this.debug != null) {
            this.debug.printBC("Look for bonds between " + this.atomNo + " - fragment # " + this.fragNo);
        }
        for (int i = 0; i < this.mol.ctab[this.atomNo].length; ++i) {
            int at_1 = this.mol.ctab[this.atomNo][i];
            if (this.frag.fcmd[at_1] != this.fragNo) continue;
            WishListItem wli = new WishListItem(this.atomNo, at_1, this.mol.getBlen(this.atomNo, at_1));
            this.wl.add(wli);
            if (this.debug == null) continue;
            wli.printout(this.debug);
        }
    }

    public void printoutPermutationTable(int[] no, int[] sp, int Ubase, int M2D, int B2D, int M1D, debugPrintout debug) {
        if (debug != null && debug.getWillPrint()) {
            debug.Tstart();
            debug.Trow();
            debug.TprintBC(1, 7, "Permutation table ");
            debug.Trow();
            debug.TprintBC(2, 1, "NO");
            debug.TprintBC(2, 1, "P");
            debug.TprintBC(2, 1, "Bat");
            debug.TprintBC(2, "2D");
            debug.TprintBC(2, "1D");
            debug.Trow();
            debug.TprintBC("value");
            debug.TprintBC("bits");
            debug.TprintBC("value");
            debug.TprintBC("bits");
            for (int i = 0; i < no.length; ++i) {
                int k;
                debug.Trow();
                debug.TprintBC("" + i);
                debug.TprintBC("" + sp[i]);
                debug.Tprint("" + sp[i] / Ubase);
                debug.Tprint("" + k);
                String s = "";
                int j = 0;
                for (k = (sp[i] & M2D) / B2D; k != 0; k /= 2) {
                    if ((k & 1) != 0) {
                        s = j + " " + s;
                    }
                    ++j;
                }
                debug.Tprint(s);
                debug.Tprint("" + k);
                s = "";
                j = 0;
                for (k = sp[i] & M1D; k != 0; k /= 2) {
                    if ((k & 1) != 0) {
                        s = j + " " + s;
                    }
                    ++j;
                }
                debug.Tprint(s);
            }
            debug.Tstop();
        }
    }

    public boolean isDefinedFor(int a1, int a2) {
        for (int i = 0; i < this.getSize(); ++i) {
            WishListItem w = this.getWish(i);
            if ((a2 != w.getTargetAtom() || a1 != w.atoms[0]) && (a1 != w.getTargetAtom() || a2 != w.atoms[0])) continue;
            return true;
        }
        return false;
    }

    public void saveAngles() {
        WishListItem wli;
        int at_2;
        int j;
        int at_1;
        int i;
        if (this.debug != null) {
            this.debug.printBC("Look for bond angle info between " + this.atomNo + " - fragment # " + this.fragNo);
            this.debug.println("Round1: fill temporary list");
        }
        myList tmpList = new myList(20);
        for (i = 0; i < this.mol.ctab[this.atomNo].length; ++i) {
            at_1 = this.mol.ctab[this.atomNo][i];
            if (this.mol.ctab[at_1].length > 4) continue;
            for (j = 0; j < this.mol.ctab[at_1].length; ++j) {
                at_2 = this.mol.ctab[at_1][j];
                if (at_2 == this.atomNo || this.frag.fcmd[at_2] != this.fragNo || Clean3D.OPT_CP_SKIP_NONPLACED_WISHES && this.frag.fcmd[at_1] != this.fragNo) continue;
                if (!this.isDefinedFor(this.atomNo, at_2)) {
                    wli = new WishListItem(this.atomNo, at_1, at_2, this.frag.fcmd[at_1] == this.fragNo, this.mol.getBangl(this.atomNo, at_1, at_2));
                    tmpList.add(wli);
                    if (this.debug == null) continue;
                    this.debug.println("Add to temporary list:");
                    wli.printout(this.debug);
                    continue;
                }
                if (this.debug == null) continue;
                this.debug.println("There is a defined wish for " + this.atomNo + " - " + at_2 + " metrid.");
            }
        }
        for (i = 0; i < this.mol.ctab[this.atomNo].length; ++i) {
            at_1 = this.mol.ctab[this.atomNo][i];
            if (this.mol.ctab[at_1].length <= 4) continue;
            for (j = 0; j < this.mol.ctab[at_1].length; ++j) {
                at_2 = this.mol.ctab[at_1][j];
                if (at_2 == this.atomNo || this.frag.fcmd[at_2] != this.fragNo || Clean3D.OPT_CP_SKIP_NONPLACED_WISHES && this.frag.fcmd[at_1] != this.fragNo) continue;
                if (!this.isDefinedFor(this.atomNo, at_2)) {
                    wli = new WishListItem(this.atomNo, at_1, at_2, this.frag.fcmd[at_1] == this.fragNo, this.mol.getBangl(this.atomNo, at_1, at_2));
                    tmpList.add(wli);
                    if (this.debug == null) continue;
                    this.debug.println("Add to temporary list:");
                    wli.printout(this.debug);
                    continue;
                }
                if (this.debug == null) continue;
                this.debug.println("There is a defined wish for " + this.atomNo + " - " + at_2 + " metrid.");
            }
        }
        int angles = tmpList.size();
        int[] no = new int[angles];
        int[] sp = new int[angles];
        int Ubase = this.mol.getSSpUnusedBase();
        int M2D = this.mol.getSSp2DMask();
        int M1D = this.mol.getSSp1DMask();
        int B2D = this.mol.getSSp2DBase();
        for (int i2 = 0; i2 < tmpList.size(); ++i2) {
            no[i2] = i2;
            WishListItem wli2 = (WishListItem)tmpList.get(i2);
            sp[i2] = wli2.atoms[1] * Ubase + this.mol.getSSpInfo(wli2.atoms[1], wli2.getTargetAtom());
        }
        if (this.debug != null) {
            this.printoutPermutationTable(no, sp, Ubase, M2D, B2D, M1D, this.debug);
        }
        for (int ius = 1; ius < no.length; ++ius) {
            int i3;
            int cand = -1;
            int nta = 999;
            int n2d = 999;
            int n1d = 999;
            for (i3 = ius; i3 < no.length; ++i3) {
                int cNta = 0;
                int cN2d = 0;
                int cN1d = 0;
                for (int j2 = 0; j2 < ius; ++j2) {
                    if (sp[i3] / Ubase != sp[j2] / Ubase) continue;
                    ++cNta;
                    int ov2Dw = this.mol.calculateOverlap(sp[i3], sp[j2], M2D);
                    int ov1Dw = this.mol.calculateOverlap(sp[i3], sp[j2], M1D);
                    if (cN2d < ov2Dw) {
                        cN2d = ov2Dw;
                    }
                    if (cN1d >= ov1Dw) continue;
                    cN1d = ov1Dw;
                }
                boolean newCandidate = false;
                if (cNta == 0) {
                    newCandidate = true;
                } else if (cN1d < n1d) {
                    newCandidate = true;
                } else if (cN1d == n1d && cN2d < n2d) {
                    newCandidate = true;
                }
                if (!newCandidate) continue;
                cand = i3;
                nta = cNta;
                n1d = cN1d;
                n2d = cN2d;
            }
            i3 = sp[cand];
            sp[cand] = sp[ius];
            sp[ius] = i3;
            i3 = no[cand];
            no[cand] = no[ius];
            no[ius] = i3;
        }
        if (this.debug != null) {
            this.printoutPermutationTable(no, sp, Ubase, M2D, B2D, M1D, this.debug);
        }
        for (int i4 = 0; i4 < no.length; ++i4) {
            this.wl.add((WishListItem)tmpList.get(no[i4]));
        }
    }

    public void saveParticipantAngles() {
        if (this.debug != null) {
            this.debug.printBC("Look for participant bond angle info between " + this.atomNo + " - fragment # " + this.fragNo);
        }
        for (int i = 0; i < this.mol.ctab[this.atomNo].length; ++i) {
            int at_1 = this.mol.ctab[this.atomNo][i];
            for (int j = i + 1; j < this.mol.ctab[this.atomNo].length; ++j) {
                int at_2 = this.mol.ctab[this.atomNo][j];
                if (this.frag.fcmd[at_1] != this.fragNo || this.frag.fcmd[at_2] != this.fragNo) continue;
                WishListItem wli = new WishListItem(at_1, this.atomNo, at_2, this.mol.getBangl(at_1, this.atomNo, at_2));
                this.pwl.add(wli);
                if (this.debug == null) continue;
                this.debug.println("Add to participants list:");
                wli.printout(this.debug);
            }
        }
    }

    public void classifyTorsion(int at_0, int at_1, int at_2, int at_3, int[] ret) {
        int ra3;
        int t = 0;
        boolean hyb1SP3 = this.mol.isHybSP3(at_1);
        boolean hyb2SP3 = this.mol.isHybSP3(at_2);
        boolean ar_0_1 = myMolecule.isSet(this.mol.bdesc[this.mol.bonds[at_0][at_1]], 8);
        boolean ar_1_2 = myMolecule.isSet(this.mol.bdesc[this.mol.bonds[at_1][at_2]], 8);
        boolean ar_2_3 = myMolecule.isSet(this.mol.bdesc[this.mol.bonds[at_2][at_3]], 8);
        boolean cr_1_2 = false;
        boolean csr_1_2 = false;
        boolean cr_1_3 = false;
        boolean csr_1_3 = false;
        boolean cr_2_3 = false;
        boolean csr_2_3 = false;
        for (int ra0 = 0; ra0 < this.mol.rings[at_0]; ++ra0) {
            int r01 = this.mol.atomToRing[at_0][ra0];
            for (int ra1 = 0; ra1 < this.mol.rings[at_1]; ++ra1) {
                if (this.mol.atomToRing[at_1][ra1] != r01) continue;
                for (int ra2 = 0; ra2 < this.mol.rings[at_2]; ++ra2) {
                    if (r01 != this.mol.atomToRing[at_2][ra2]) continue;
                    cr_1_2 = true;
                    if ((this.mol.ringflags[r01] & 2) == 0) continue;
                    csr_1_2 = true;
                }
                for (ra3 = 0; ra3 < this.mol.rings[at_3]; ++ra3) {
                    if (r01 != this.mol.atomToRing[at_3][ra3]) continue;
                    cr_1_3 = true;
                    if ((this.mol.ringflags[r01] & 2) == 0) continue;
                    csr_1_3 = true;
                }
            }
        }
        for (int ra1 = 0; ra1 < this.mol.rings[at_1]; ++ra1) {
            int r12 = this.mol.atomToRing[at_1][ra1];
            for (int ra2 = 0; ra2 < this.mol.rings[at_2]; ++ra2) {
                if (this.mol.atomToRing[at_2][ra2] != r12) continue;
                for (ra3 = 0; ra3 < this.mol.rings[at_3]; ++ra3) {
                    if (r12 != this.mol.atomToRing[at_3][ra3]) continue;
                    cr_2_3 = true;
                    if ((this.mol.ringflags[r12] & 2) == 0) continue;
                    csr_2_3 = true;
                }
            }
        }
        if (this.debug != null) {
            this.debug.printB("Torsion parameters:");
            this.debug.Tstart();
            this.debug.Trow();
            this.debug.TprintBC("Atoms (AUP first):");
            this.debug.TprintC(2, "" + at_0);
            this.debug.TprintC(2, "" + at_1);
            this.debug.TprintC(2, "" + at_2);
            this.debug.TprintC(2, "" + at_3);
            this.debug.Trow();
            this.debug.TprintBC("Is SP3 state:");
            this.debug.TprintC(2, "?");
            this.debug.TprintC(2, "" + hyb1SP3);
            this.debug.TprintC(2, "" + hyb2SP3);
            this.debug.TprintC(2, "?");
            this.debug.Trow();
            this.debug.TprintBC("Bond aromaticity:");
            this.debug.TprintC(1, "");
            this.debug.TprintC(2, "" + ar_0_1);
            this.debug.TprintC(2, "" + ar_1_2);
            this.debug.TprintC(2, "" + ar_2_3);
            this.debug.TprintC(1, "");
            this.debug.Tstop();
            this.debug.Tstart();
            this.debug.Trow();
            this.debug.TprintBC(4, "Common ring flags");
            this.debug.Trow();
            this.debug.TprintBC("Bonds:");
            this.debug.TprintBC("1-2");
            this.debug.TprintBC("1-3");
            this.debug.TprintBC("2-3");
            this.debug.Trow();
            this.debug.TprintBC("Have common ring:");
            this.debug.TprintBC("" + cr_1_2);
            this.debug.TprintBC("" + cr_1_3);
            this.debug.TprintBC("" + cr_2_3);
            this.debug.Trow();
            this.debug.TprintBC("Have common small ring:");
            this.debug.TprintBC("" + csr_1_2);
            this.debug.TprintBC("" + csr_1_3);
            this.debug.TprintBC("" + csr_2_3);
            this.debug.Tstop();
        }
        if (cr_1_3 & ar_0_1 & ar_1_2 & ar_2_3) {
            t = csr_1_3 ? -8 : -7;
        } else if (!hyb1SP3 && hyb2SP3 || hyb1SP3 && !hyb2SP3) {
            t = -3;
        } else if (myMolecule.isSet(this.mol.bdesc[this.mol.bonds[at_1][at_2]], myMoleculeConstants.B_R_INSMALLRING) && cr_1_3) {
            t = -4;
        } else if (hyb1SP3 && hyb2SP3) {
            t = -2;
        } else if (!hyb1SP3 && !hyb2SP3) {
            if (ar_1_2) {
                boolean canCIS = true;
                boolean canTRANS = true;
                boolean canSPAN = false;
                if (!ar_0_1 && !ar_2_3) {
                    canCIS = true;
                    canTRANS = false;
                } else if (ar_0_1 && ar_2_3) {
                    if (cr_1_3) {
                        canCIS = true;
                        canTRANS = false;
                    } else if (cr_1_2 || cr_2_3) {
                        canCIS = false;
                        canTRANS = true;
                        canSPAN = true;
                    } else {
                        canCIS = true;
                        canTRANS = false;
                        canSPAN = true;
                    }
                }
                int ctopt = -1;
                if (canCIS && !canTRANS) {
                    ctopt = canSPAN ? -9 : -5;
                } else if (!canCIS && canTRANS) {
                    ctopt = canSPAN ? -10 : -6;
                }
                t = ctopt;
            } else {
                t = this.mol.isSingle(at_1, at_2) ? -11 : -1;
            }
        }
        int flag = 0;
        if (this.debug != null) {
            this.debug.printB("Assign priority:");
        }
        if (!hyb1SP3 && !hyb2SP3) {
            flag = 1;
            if (this.debug != null) {
                this.debug.println("SP2-SP2");
            }
        }
        if (ar_1_2) {
            flag = 2;
            if (this.debug != null) {
                this.debug.println("Aromatic bond");
            }
        }
        if (cr_1_3) {
            flag = 3;
            if (this.debug != null) {
                this.debug.println("Common ring");
            }
        }
        if (csr_1_3) {
            flag = 4;
            if (this.debug != null) {
                this.debug.println("Common small ring");
            }
        }
        if (cr_1_3 & !hyb1SP3 && !hyb2SP3) {
            flag = 5;
            if (this.debug != null) {
                this.debug.println("Common ring with SP2-SP2");
            }
        }
        if (csr_1_3 & !hyb1SP3 && !hyb2SP3) {
            flag = 6;
            if (this.debug != null) {
                this.debug.println("Common small ring with SP2-SP2");
            }
        }
        if (cr_1_3 & ar_0_1 & ar_1_2 & ar_2_3) {
            flag = 7;
            if (this.debug != null) {
                this.debug.println("Common aromatic ring");
            }
        }
        if (csr_1_3 & ar_0_1 & ar_1_2 & ar_2_3) {
            flag = 8;
            if (this.debug != null) {
                this.debug.println("Common aromatic small ring");
            }
        }
        ret[0] = t;
        ret[1] = flag;
    }

    public void saveTorsions() {
        if (this.debug != null) {
            this.debug.printBC("Look for torsion info between " + this.atomNo + " - fragment # " + this.fragNo);
        }
        for (int i = 0; i < this.mol.ctab[this.atomNo].length; ++i) {
            boolean valid_at_1;
            int at_1 = this.mol.ctab[this.atomNo][i];
            boolean bl = valid_at_1 = !Clean3D.OPT_CP_SKIP_NONPLACED_WISHES || this.frag.fcmd[at_1] == this.fragNo;
            if (!valid_at_1 || !this.mol.isHybSP2(at_1) && !this.mol.isHybSP3(at_1)) continue;
            for (int j = 0; j < this.mol.ctab[at_1].length; ++j) {
                boolean valid_at_2;
                int at_2 = this.mol.ctab[at_1][j];
                boolean bl2 = valid_at_2 = !Clean3D.OPT_CP_SKIP_NONPLACED_WISHES || this.frag.fcmd[at_2] == this.fragNo;
                if (!valid_at_2 || !this.mol.isHybSP2(at_2) && !this.mol.isHybSP3(at_2) || at_2 == this.atomNo) continue;
                for (int k = 0; k < this.mol.ctab[at_2].length; ++k) {
                    int at_3 = this.mol.ctab[at_2][k];
                    if (at_3 == this.atomNo || at_3 == at_1 || this.frag.fcmd[at_3] != this.fragNo) continue;
                    WishListItem wli = null;
                    int[] cl = new int[2];
                    this.classifyTorsion(this.atomNo, at_1, at_2, at_3, cl);
                    wli = new WishListItem(this.atomNo, at_1, at_2, at_3, this.frag.fcmd[at_1] == this.fragNo, this.frag.fcmd[at_2] == this.fragNo, cl[0]);
                    wli.priority = cl[1];
                    this.addWithPriority(wli);
                    if (this.debug == null) continue;
                    this.debug.printB("Wish assigned:");
                    wli.printout(this.debug);
                }
            }
        }
    }

    public void saveParticipantTorsions() {
        if (this.debug != null) {
            this.debug.printBC("Look for participant torsion info between " + this.atomNo + " - fragment # " + this.fragNo);
        }
        for (int i = 0; i < this.mol.ctab[this.atomNo].length; ++i) {
            boolean valid_at_0;
            int at_0 = this.mol.ctab[this.atomNo][i];
            boolean bl = valid_at_0 = this.frag.fcmd[at_0] == this.fragNo;
            if (!valid_at_0) continue;
            int at_1 = this.atomNo;
            for (int j = 0; j < this.mol.ctab[at_1].length; ++j) {
                boolean valid_at_2;
                int at_2 = this.mol.ctab[at_1][j];
                boolean bl2 = valid_at_2 = this.frag.fcmd[at_2] == this.fragNo && at_2 != at_0;
                if (!valid_at_2) continue;
                for (int k = 0; k < this.mol.ctab[at_2].length; ++k) {
                    boolean valid_at_3;
                    int at_3 = this.mol.ctab[at_2][k];
                    boolean bl3 = valid_at_3 = this.frag.fcmd[at_3] == this.fragNo && at_3 != at_0 && at_3 != at_1;
                    if (!valid_at_3) continue;
                    WishListItem wli = null;
                    int[] cl = new int[2];
                    this.classifyTorsion(at_0, at_1, at_2, at_3, cl);
                    wli = new WishListItem(at_0, at_1, at_2, at_3, cl[0]);
                    this.pwl.add(wli);
                    if (this.debug == null) continue;
                    this.debug.printB("Wish assigned:");
                    wli.printout(this.debug);
                }
            }
        }
    }

    public void printout() {
        if (this.debug != null) {
            int i;
            this.debug.printBC("Wish list");
            for (i = 0; i < this.wl.size(); ++i) {
                ((WishListItem)this.wl.get(i)).printout(this.debug);
            }
            if (this.pwl != null) {
                this.debug.printBC("Participants list");
                for (i = 0; i < this.pwl.size(); ++i) {
                    ((WishListItem)this.pwl.get(i)).printout(this.debug);
                }
            }
        }
    }

    public int getSize() {
        return this.wl.size();
    }

    public int getPSize() {
        return this.pwl.size();
    }

    public WishListItem getWish(int n) {
        if (n >= 0) {
            return (WishListItem)this.wl.get(n);
        }
        return (WishListItem)this.pwl.get(-n - 1);
    }

    public WishListItem getPWish(int n) {
        return (WishListItem)this.pwl.get(n);
    }

    public void addWithPriority(WishListItem wli) {
        boolean swap;
        this.wl.add(wli);
        int i = this.wl.size() - 1;
        boolean bl = swap = i > 0;
        while (swap) {
            swap = false;
            WishListItem last = this.getWish(i);
            WishListItem beforelast = this.getWish(i - 1);
            if (last.type != beforelast.type || last.priority <= beforelast.priority) continue;
            swap = true;
            WishListItem tmp = last;
            this.wl.replace(i, beforelast);
            this.wl.replace(i - 1, tmp);
        }
    }
}

