/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.debug;

import chemaxon.marvin.modelling.debug.Printouts;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.util.U;

public class Drawer {
    private StringBuffer out = new StringBuffer(1000);
    private boolean closed = false;
    private int id;

    public Drawer() {
        this.out.append("<?xml version=\"1.0\" ?><cml><MDocument>\n");
        this.id = 1;
    }

    public void addLine(double[] c1, double[] c2) {
        this.out.append("    <MPolyline id=\"o" + this.id++ + "\">\n");
        this.appendMPoint(c1);
        this.appendMPoint(c2);
        this.out.append("    </MPolyline>\n");
    }

    public void addPoints(double[][] c) {
        for (int i = 0; i < c.length; ++i) {
            this.addPoint(c[i]);
        }
    }

    public void addPoint(double[] c) {
        this.out.append("    <MPolyline id=\"o" + this.id++ + "\">\n");
        this.appendMPoint(c);
        this.appendMPoint(c);
        this.out.append("    </MPolyline>\n");
    }

    private void addCross(double[] c, double hl) {
        int i = 0;
        while (i < 3) {
            double[] c1 = U.clone(c);
            double[] c2 = U.clone(c);
            int n = i;
            c1[n] = c1[n] + hl;
            int n2 = i++;
            c2[n2] = c2[n2] - hl;
            this.addLine(c1, c2);
        }
    }

    public void addSmallCross(double[] c) {
        this.addCross(c, 0.2);
    }

    private void appendMPoint(double[] c) {
        this.out.append("        <MPoint x=\"" + c[0] + "\" y=\"" + c[1] + "\" z=\"" + c[2] + "\" />\n");
    }

    private void appendSurroundingRectanglePoints(double[] c, double hl, double shr, double shd, int a1, int a2) {
        int i = -1;
        int j = -1;
        while (true) {
            double[] c2 = U.clone(c);
            int n = a1;
            c2[n] = c2[n] + ((double)i + shr) * hl;
            int n2 = a2;
            c2[n2] = c2[n2] - ((double)j + shd) * hl;
            this.appendMPoint(c2);
            if (i == -1 && j == -1) {
                i = 1;
                j = -1;
                continue;
            }
            if (i == 1 && j == -1) {
                i = 1;
                j = 1;
                continue;
            }
            if (i != 1 || j != 1) break;
            i = -1;
            j = 1;
        }
    }

    public void addPointSmallr(double[] c) {
        this.out.append("    <MRectangle id=\"o" + this.id++ + "\">\n");
        this.appendSurroundingRectanglePoints(c, 0.1, 0.0, 0.0, 0, 1);
        this.out.append("    </MRectangle>\n");
    }

    private void addText(String s, double[] c, int a1, int a2) {
        this.out.append("    <MTextBox id=\"" + this.id++ + "\" toption=\"NOROT\" fontScale=\"5.0\">\n");
        this.out.append("        <Field name=\"text\">" + s + "</Field>\n");
        this.appendSurroundingRectanglePoints(c, 2.0, 1.0, 1.0, a1, a2);
        this.out.append("    </MTextBox>\n");
    }

    public void addPointMedr(double[] c, String l) {
        this.out.append("    <MRectangle id=\"o" + this.id++ + "\">\n");
        this.appendSurroundingRectanglePoints(c, 0.2, 0.0, 0.0, 0, 2);
        this.out.append("    </MRectangle>\n");
        if (l != null) {
            this.addText(l, c, 0, 1);
        }
    }

    public void addPointBigR(double[] c, String l) {
        this.out.append("    <MRectangle id=\"o" + this.id++ + "\">\n");
        this.appendSurroundingRectanglePoints(c, 0.4, 0.0, 0.0, 0, 2);
        this.out.append("    </MRectangle>\n");
        if (l != null) {
            this.addText(l, c, 0, 1);
        }
    }

    public void addVector(double scale, double[] v, double[] start, String l) {
        this.addArrow(start, V.plus(start, V.dot(scale, v)), l);
    }

    public void addArrow(double[] pfrom, double[] pto, String l) {
        this.out.append("    <MPolyline id=\"o" + this.id++ + "\" headLength=\"0.8\" headWidth=\"0.5\">\n");
        this.appendMPoint(pfrom);
        this.appendMPoint(pto);
        this.out.append("    </MPolyline>\n");
        if (l != null) {
            this.addText(l, pto, 0, 1);
        }
    }

    private void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.out.append("</MDocument></cml>\n");
    }

    public void placeApplet(debugPrintout debug, String btnlab) {
        this.close();
        String n = Printouts.storeStructure(this.toString(), null, ".mrv");
        Printouts.placeApplet(new String[]{n}, "msg", null, null, null, 1, btnlab, debug);
    }

    public String toString() {
        if (!this.closed) {
            this.close();
        }
        return this.out.toString();
    }
}

