/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.debug;

import chemaxon.marvin.modelling.mm.MMDiagnosticObserver;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.HashMap;

public class MMDiagnosticObserverImpl
extends MMDiagnosticObserver {
    BitSet disabledTunes = null;
    BitSet collectAssociatedTune = null;
    HashMap collectedTuneInfo = null;

    public void disableTune(int tuneID) {
        if (this.disabledTunes == null) {
            this.disabledTunes = new BitSet();
        }
        this.disabledTunes.set(tuneID);
    }

    public void doCollectAssociatedTunes() {
        if (this.collectAssociatedTune == null) {
            this.collectAssociatedTune = new BitSet();
        }
    }

    @Override
    public boolean isTuneEnabled(int tuneID) {
        if (this.collectAssociatedTune != null) {
            this.collectAssociatedTune.set(tuneID);
        }
        if (this.disabledTunes != null) {
            return !this.disabledTunes.get(tuneID);
        }
        return super.isTuneEnabled(tuneID);
    }

    @Override
    public boolean isTuneEnabled(int tuneID, int iParam1, int iParam2) {
        if (this.collectAssociatedTune != null) {
            if (this.collectedTuneInfo == null) {
                this.collectedTuneInfo = new HashMap();
            }
            String s = iParam1 + ":" + iParam2;
            Integer k = new Integer(tuneID);
            if (this.collectedTuneInfo.containsKey(k)) {
                String kp = (String)this.collectedTuneInfo.get(k);
                s = kp + ":" + s;
                this.collectedTuneInfo.put(k, s);
            } else {
                this.collectedTuneInfo.put(new Integer(tuneID), s);
            }
        }
        return this.isTuneEnabled(tuneID);
    }

    public void fillCollected(Molecule m) {
        if (this.collectAssociatedTune == null) {
            return;
        }
        int max = this.collectAssociatedTune.length();
        for (int i = 0; i <= max; ++i) {
            Integer k;
            if (!this.collectAssociatedTune.get(i)) continue;
            String value = "SET";
            if (this.collectedTuneInfo != null && this.collectedTuneInfo.containsKey(k = new Integer(i))) {
                value = (String)this.collectedTuneInfo.get(k);
            }
            m.setProperty("CLEAN3D.MMTUNE." + MMDiagnosticObserverImpl.getTuneShortName(i), value);
        }
    }
}

