/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.debug;

import chemaxon.marvin.modelling.debug.SimpleVerbosePrinter;

public class StdErrSimpleVerbosePrinter
implements SimpleVerbosePrinter {
    private final String name;
    private final int maxLevel;

    public StdErrSimpleVerbosePrinter(int maxLevel, String name) {
        this.name = name == null ? "" : name;
        this.maxLevel = maxLevel < 0 ? 0 : maxLevel;
    }

    @Override
    public boolean isVerbosityLevelEnabled(int level) throws IllegalArgumentException {
        if (level <= 0) {
            throw new IllegalArgumentException("Negative or zero level " + level + " is invalid.");
        }
        return this.maxLevel >= level;
    }

    @Override
    public int getMaxEnabledLevel() {
        return this.maxLevel;
    }

    @Override
    public void print(int level, String s) throws IllegalArgumentException {
        if (level <= 0) {
            throw new IllegalArgumentException("Negative or zero level " + level + " is invalid.");
        }
        if (level > this.maxLevel) {
            return;
        }
        System.err.print('[');
        System.err.print(this.name);
        System.err.print(':');
        System.err.print(level);
        System.err.print("] ");
        System.err.println(s);
    }
}

