/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.debug;

import chemaxon.core.util.BondTable;
import chemaxon.marvin.modelling.debug.debugPrintHTML;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;

public class debugPrintout {
    int myLevel;
    int debugLevel;
    public String fPrefix;
    debugPrintHTML out;
    boolean echo = false;
    String debugTab = "";
    String open_invocation_stacktrace = "N/A";
    int nextChildNo;
    debugPrintout child = null;
    boolean wasChild = false;
    int currentLevel = 0;
    private int backCheckLevel = 0;
    private int reportedErrors = 0;
    private String firstErrorMessage;
    private String childName;
    private String childURL;
    private String childTarget;
    boolean willPrint = false;

    public int stopDebug() {
        this.println("Debug Stopped at level " + this.currentLevel);
        this.willPrint = false;
        int r = this.debugLevel;
        this.debugLevel = this.currentLevel;
        return r;
    }

    public void startDebug(int r) {
        this.debugLevel = r;
        this.willPrint = this.debugLevel > this.currentLevel;
        this.println("Debug restarted.");
    }

    public debugPrintout() {
        this.fPrefix = "debug";
    }

    public debugPrintout(String fp) {
        this.fPrefix = fp;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevel(int level) {
        this.currentLevel = level;
        this.willPrint = this.debugLevel > this.currentLevel;
    }

    public int beginGroup() {
        this.print("<BR><TABLE BORDER=1  BGCOLOR=\"#F0F0D0\" WIDTH=100%><TR><TD>");
        return 0;
    }

    public void endGroup(int groupID) {
        this.print("</TABLE><BR>");
    }

    public static String getHTMLStackTrace() {
        Throwable tt = new Throwable();
        tt.fillInStackTrace();
        String ret = "<TABLE>";
        StackTraceElement[] ttst = tt.getStackTrace();
        for (int i = 1; i < 20 && i < ttst.length; ++i) {
            String n = ttst[i].getClassName();
            if (n.equalsIgnoreCase("chemaxon.marvin.modules.Clean3D$debugPrintout") || n.indexOf("Tracer") >= 0 || n.indexOf("debugPrint") >= 0) continue;
            ret = ret + "<TR><TD><TT><B>" + ttst[i].getLineNumber() + "</B></TD><TD><TT>" + ttst[i].getMethodName() + "</TT></TD></TR>" + "<TD></TD><TD><TT>" + ttst[i].getClassName() + "</TT></TD></TR>" + "<TD></TD><TD><TT>" + ttst[i].getFileName() + "</TT></TD></TR>";
        }
        ret = ret + "</TABLE>";
        return ret;
    }

    public void init() {
        if (this.out != null) {
            this.out.close();
        }
        this.out = new debugPrintHTML("DEBUG" + File.separator + "htmls" + File.separator + this.fPrefix + ".html");
        this.currentLevel = 0;
        this.willPrint = this.debugLevel > this.currentLevel;
        this.out.println("LEVEL: " + this.myLevel);
        this.open_invocation_stacktrace = debugPrintout.getHTMLStackTrace();
    }

    private void closeChild(String s) {
        boolean bl = this.willPrint = this.debugLevel > this.currentLevel;
        if (s != null) {
            this.childName = s;
        }
        if (this.child != null) {
            this.child.close();
            this.child = null;
            if (this.reportedErrors > 0) {
                this.out.print("<TABLE WIDTH=\"100%\" CELLSPACING=0 CELLPADDING=0><TR><TD bgcolor=\"#ff6666\">");
                this.out.printLink(this.childURL, this.childTarget, this.childName);
                this.out.print("</TD></TR><TR><TD bgcolor=\"#ff6666\">");
                this.out.print("<B>" + this.reportedErrors + " ERROR(s).<B> first:<BR>");
                this.out.print(this.firstErrorMessage);
                this.out.println("</TD></TR></TABLE>");
            } else {
                this.out.printLink(this.childURL, this.childTarget, this.childName);
            }
        }
    }

    public boolean getWillPrint() {
        return this.willPrint;
    }

    public void incLevel(String s) {
        ++this.currentLevel;
        boolean bl = this.willPrint = this.debugLevel > this.currentLevel;
        if (this.debugLevel > this.currentLevel) {
            if (this.child != null) {
                this.child.incLevel(s);
            } else {
                String fnp = this.fPrefix + "_" + this.nextChildNo;
                this.childName = s;
                this.childURL = "../frames/" + fnp + "_frame.html";
                this.childTarget = "frame" + (this.myLevel + 1);
                this.reportedErrors = 0;
                if (this.echo) {
                    System.err.println(this.debugTab + s);
                }
                this.child = new debugPrintout(fnp);
                this.child.setEcho(this.echo);
                this.child.setDebugTab(this.debugTab + "  ");
                this.child.setMyLevel(this.myLevel + 1);
                this.child.init();
                this.child.println("<CENTER><B>" + s + "</CENTER></B>");
                this.child.setDebugLevel(this.debugLevel);
                this.child.setCurrentLevel(0);
                ++this.nextChildNo;
                this.wasChild = true;
            }
        }
        if (this.debugLevel == this.currentLevel && this.out != null) {
            this.out.println("<U>" + s + "</U>");
        }
    }

    public boolean decLevel() {
        return this.decLevel(null);
    }

    public boolean decLevel(String s) {
        boolean bl = this.willPrint = this.debugLevel > this.currentLevel;
        if (this.debugLevel > this.currentLevel) {
            if (this.child != null) {
                if (this.child.decLevel(s)) {
                    this.closeChild(s);
                }
            } else if (this.myLevel == 0) {
                this.println("ERROR! Tried to close top level!");
                this.println(debugPrintout.getHTMLStackTrace());
            } else {
                if (s != null) {
                    this.println("<B>Overriden label: " + s + "</B>");
                }
                this.println("<BR>\n<BR>\n<HR>\nLEVEL OPEN INVOCATION:");
                this.println(this.open_invocation_stacktrace);
                this.println("LEVEL CLOSE INVOCATION:");
                this.println(debugPrintout.getHTMLStackTrace());
                this.close();
                return true;
            }
        }
        if (this.currentLevel > 0) {
            --this.currentLevel;
        }
        return false;
    }

    public void close() {
        boolean bl = this.willPrint = this.debugLevel > this.currentLevel;
        if (this.child != null) {
            this.closeChild(null);
        }
        if (this.out != null) {
            PrintWriter outS;
            this.out.close();
            try {
                FileWriter f = new FileWriter("DEBUG" + File.separator + "frames" + File.separator + this.fPrefix + "_frame.html");
                outS = new PrintWriter((Writer)f, true);
            }
            catch (Exception e) {
                outS = new PrintWriter(System.err);
                outS.println("ERROR! exception: " + e.getMessage());
            }
            if (this.wasChild) {
                outS.println("<HTML><HEAD><TITLE>Automatically generated HTML document</TITLE></HEAD>");
                outS.println("<FRAMESET cols= \"200px, *\" >");
                outS.println("<FRAME src=\"../htmls/" + this.fPrefix + ".html\" name=\"frameTop" + this.myLevel + "\" >");
                outS.println("<FRAME src=\"\" name=\"frame" + (this.myLevel + 1) + "\" >");
                outS.println("</FRAMESET>");
                outS.println("<NOFRAMES>");
                outS.println("<P>This frameset document contains:");
                outS.println("</NOFRAMES>");
                outS.println("</FRAMESET>");
                outS.println("</HTML>");
            } else {
                outS.println("<HTML><HEAD><TITLE>Automatically generated HTML document</TITLE></HEAD>");
                outS.println("<FRAMESET cols= \"*\" >");
                outS.println("<FRAME src=\"../htmls/" + this.fPrefix + ".html\" name=\"frameTop" + this.myLevel + "\" >");
                outS.println("</FRAMESET>");
                outS.println("<NOFRAMES>");
                outS.println("<P>This frameset document contains:");
                outS.println("</NOFRAMES>");
                outS.println("</FRAMESET>");
                outS.println("</HTML>");
            }
            outS.flush();
        }
    }

    public void setLevel(int l) {
        this.currentLevel = l;
        boolean bl = this.willPrint = this.debugLevel > this.currentLevel;
        if (l < this.debugLevel) {
            if (this.myLevel == l) {
                if (this.child != null) {
                    this.closeChild(null);
                }
            } else if (this.child != null) {
                this.child.setLevel(l);
            }
        }
    }

    public void setMyLevel(int l) {
        this.myLevel = l;
    }

    public void setDebugTab(String s) {
        this.debugTab = s;
    }

    public void setDebugLevel(int l) {
        this.debugLevel = l;
        this.willPrint = this.debugLevel > this.currentLevel;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setEcho(boolean e) {
        this.echo = e;
    }

    public void reportError(String s) {
        if (this.child == null) {
            if (this.out != null) {
                this.out.print("<TABLE WIDTH=\"100%\" CELLSPACING=0 CELLPADDING=0><TR><TD bgcolor=\"#ff6666\">");
                this.out.print("<B>ERROR: " + s + "</B>");
                this.out.println("</TD></TR></TABLE>");
            }
            if (this.echo) {
                System.err.println(this.debugTab + "ERROR: " + s);
            }
        } else {
            ++this.reportedErrors;
            if (this.reportedErrors == 1) {
                this.firstErrorMessage = s;
            }
            this.child.reportError(s);
        }
    }

    public PrintWriter getPrintWriter() {
        if (this.child == null) {
            if (this.out != null) {
                return this.out.outS;
            }
        } else {
            return this.child.getPrintWriter();
        }
        return null;
    }

    public void printHR() {
        if (this.debugLevel > this.currentLevel) {
            if (this.child == null) {
                if (this.out != null && this.willPrint) {
                    this.out.printHR();
                }
                if (this.echo) {
                    System.err.println(this.debugTab + "-----------------------------------------------------------------------------------------");
                }
            } else {
                this.child.printHR();
            }
        }
    }

    public void println(String s, boolean putV) {
        this.println(s, putV, null);
    }

    public void println(String s, boolean putV, String detail) {
        if (this.debugLevel > this.currentLevel) {
            if (this.child == null) {
                if (this.out != null && this.willPrint) {
                    this.out.println(s, putV, detail);
                }
                if (this.echo) {
                    System.err.println(this.debugTab + s + "-" + detail);
                }
            } else {
                this.child.println(s, putV, detail);
            }
        }
    }

    public void println(String s) {
        this.println(s, false);
    }

    public void startPrint() {
        if (this.debugLevel > this.currentLevel) {
            if (this.child == null) {
                if (this.echo) {
                    System.err.print(this.debugTab);
                }
            } else {
                this.child.startPrint();
            }
        }
    }

    public void startPrint(String s) {
        if (this.debugLevel > this.currentLevel) {
            if (this.child == null) {
                if (this.echo) {
                    System.err.print(this.debugTab);
                }
            } else {
                this.child.startPrint();
            }
        }
        this.print(s);
    }

    public void print(String s) {
        if (this.debugLevel > this.currentLevel) {
            if (this.child == null) {
                if (this.out != null && this.willPrint) {
                    this.out.print(s);
                }
                if (this.echo) {
                    System.err.print(s);
                }
            } else {
                this.child.print(s);
            }
        }
    }

    public void printBC(String s) {
        this.print("<CENTER><B>" + s + "</B></CENTER>\n");
    }

    public void printB(String s) {
        this.print("<B>" + s + "</B><BR>\n");
    }

    public void Tstart() {
        this.print("<TABLE border=1>");
    }

    public void Tstop() {
        this.print("</TABLE>");
    }

    public void Trow() {
        this.print("<TR>");
    }

    public void Tprint(int r, int c, boolean bo, boolean ce, String s) {
        this.print("<TD");
        if (r != 0) {
            this.print(" rowspan=" + r);
        }
        if (c != 0) {
            this.print(" colspan=" + c);
        }
        this.print(">");
        if (bo) {
            this.print("<b>");
        }
        if (ce) {
            this.print("<center>");
        }
        this.print(s);
        if (ce) {
            this.print("</center>");
        }
        if (bo) {
            this.print("</b>");
        }
        this.print("</TD>");
    }

    public void Tprint(int c, String s) {
        this.Tprint(0, c, false, false, s);
    }

    public void Tprint(String s) {
        this.Tprint(0, 0, false, false, s);
    }

    public void TprintB(String s) {
        this.Tprint(0, 0, true, false, s);
    }

    public void TprintC(String s) {
        this.Tprint(0, 0, false, true, s);
    }

    public void TprintC(int c, String s) {
        this.Tprint(0, c, false, true, s);
    }

    public void TprintBC(int i) {
        this.Tprint(0, 0, true, true, Integer.toString(i));
    }

    public void TprintBC(String s) {
        this.Tprint(0, 0, true, true, s);
    }

    public void TprintBC(int c, String s) {
        this.Tprint(0, c, true, true, s);
    }

    public void TprintBC(int r, int c, String s) {
        this.Tprint(r, c, true, true, s);
    }

    public void println() {
        if (this.debugLevel > this.currentLevel) {
            if (this.child == null) {
                if (this.out != null && this.willPrint) {
                    this.out.println("");
                }
                if (this.echo) {
                    System.err.println();
                }
            } else {
                this.child.println();
            }
        }
    }

    public static String formatNumber(double x) {
        return debugPrintout.formatNumber(7, 3, x);
    }

    public static String formatNumber(int l, int p, double x) {
        if (Double.isNaN(x)) {
            return " NaN ";
        }
        if (x == Double.POSITIVE_INFINITY) {
            return "+INF";
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        int sl = l - 1;
        if (l < 4) {
            sl = 3;
        }
        char[] fs = new char[sl];
        for (int i = 0; i < fs.length; ++i) {
            fs[i] = 48;
        }
        if (p < 0) {
            p = 0;
        }
        if (p > l - 3) {
            p = l - 3;
        }
        if (p != 0) {
            fs[fs.length - p - 1] = 46;
        }
        DecimalFormat myFormatter = new DecimalFormat(String.valueOf(fs));
        String out = (x < 0.0 ? "" : " ") + myFormatter.format(x);
        char[] outc = out.toCharArray();
        if (outc != null) {
            int i = 1;
            while (i < outc.length - 2 && outc[i] == '0' && outc[i + 1] != '.') {
                outc[i++] = 32;
            }
            i = 0;
            while (i < outc.length - 1 && outc[i] == '-' && outc[i + 1] == ' ') {
                outc[i] = 32;
                outc[++i] = 45;
            }
            out = String.valueOf(outc);
        }
        return out;
    }

    public void printMatrix(double[][] mat) {
        if (this.debugLevel > this.currentLevel) {
            if (this.child == null) {
                int j;
                int i;
                int rows = mat.length;
                int cols = 0;
                for (i = 0; i < rows; ++i) {
                    if (cols >= mat[i].length) continue;
                    cols = mat[i].length;
                }
                this.out.println("<TABLE cols=" + cols + ">");
                for (i = 0; i < rows; ++i) {
                    this.out.print("  <TR>");
                    for (j = 0; j < mat[i].length; ++j) {
                        this.out.print("<TD align=\"right\">" + debugPrintout.formatNumber(mat[i][j]) + "</TD>");
                    }
                    this.out.print("</TR>\n");
                }
                this.out.println("</TABLE>");
                if (this.echo) {
                    for (i = 0; i < rows; ++i) {
                        System.err.print(this.debugTab);
                        for (j = 0; j < mat[i].length; ++j) {
                            System.err.print(debugPrintout.formatNumber(mat[i][j]) + " ");
                        }
                        System.err.println();
                    }
                }
            } else {
                this.child.printMatrix(mat);
            }
        }
    }

    public void printMatrix(int[][] mat) {
        if (this.debugLevel > this.currentLevel) {
            if (this.child == null) {
                int j;
                int i;
                int rows = mat.length;
                int cols = 0;
                for (i = 0; i < rows; ++i) {
                    if (cols >= mat[i].length) continue;
                    cols = mat[i].length;
                }
                if (this.out != null) {
                    this.out.println("<TABLE cols=" + cols + ">");
                    for (i = 0; i < rows; ++i) {
                        this.out.print("  <TR>");
                        for (j = 0; j < mat[i].length; ++j) {
                            this.out.print("<TD align=\"right\">" + mat[i][j] + "</TD>");
                        }
                        this.out.print("</TR>\n");
                    }
                    this.out.println("</TABLE>");
                }
                if (this.echo) {
                    for (i = 0; i < rows; ++i) {
                        System.err.print(this.debugTab);
                        for (j = 0; j < mat[i].length; ++j) {
                            System.err.print(mat[i][j] + " ");
                        }
                        System.err.println();
                    }
                }
            } else {
                this.child.printMatrix(mat);
            }
        }
    }

    public void printMatrix(BondTable mat) {
        if (this.debugLevel > this.currentLevel) {
            if (this.child == null) {
                int j;
                int i;
                int rows = mat.getAtomCount();
                int cols = 0;
                for (i = 0; i < rows; ++i) {
                    if (cols >= mat.getAtomCount()) continue;
                    cols = mat.getAtomCount();
                }
                if (this.out != null) {
                    this.out.println("<TABLE cols=" + cols + ">");
                    for (i = 0; i < rows; ++i) {
                        this.out.print("  <TR>");
                        for (j = 0; j < mat.getAtomCount(); ++j) {
                            this.out.print("<TD align=\"right\">" + mat.getBondIndex(i, j) + "</TD>");
                        }
                        this.out.print("</TR>\n");
                    }
                    this.out.println("</TABLE>");
                }
                if (this.echo) {
                    for (i = 0; i < rows; ++i) {
                        System.err.print(this.debugTab);
                        for (j = 0; j < mat.getAtomCount(); ++j) {
                            System.err.print(mat.getBondIndex(i, j) + " ");
                        }
                        System.err.println();
                    }
                }
            } else {
                this.child.printMatrix(mat);
            }
        }
    }

    public void printVector(int[] vect) {
        if (this.debugLevel > this.currentLevel) {
            if (vect == null) {
                this.println("NULL");
                return;
            }
            int[][] mat = new int[1][0];
            mat[0] = vect;
            this.printMatrix(mat);
        }
    }

    public void printVector(double[] vect) {
        if (this.debugLevel > this.currentLevel) {
            double[][] mat = new double[1][0];
            mat[0] = vect;
            this.printMatrix(mat);
        }
    }

    public void printCoord(double[][] coord, double[] metric) {
        if (this.debugLevel > this.currentLevel) {
            double[][] mat = new double[coord.length + 2][0];
            mat[0] = metric;
            for (int i = 0; i < coord.length; ++i) {
                mat[i + 2] = coord[i];
            }
            this.printMatrix(mat);
        }
    }

    public void printCoordEnchanced(double[][] coord, double[] metric, int[] index, int[] flag) {
        if (this.debugLevel > this.currentLevel) {
            if (this.child == null) {
                int j;
                int j2;
                int i;
                int cols;
                int rows = coord.length;
                if (rows > index.length) {
                    rows = index.length;
                }
                if (rows > flag.length) {
                    rows = flag.length;
                }
                if (metric.length > (cols = 0)) {
                    cols = metric.length;
                }
                for (i = 0; i < rows; ++i) {
                    if (cols >= coord[i].length) continue;
                    cols = coord[i].length;
                }
                if (this.out != null) {
                    this.out.print("<TABLE cols=" + (cols + 1) + ">");
                    this.out.print("  <TR><TD></TD>");
                    for (j2 = 0; j2 < metric.length; ++j2) {
                        this.out.print("<TD align=\"right\">" + debugPrintout.formatNumber(metric[j2]) + "</TD>");
                    }
                    this.out.print("</TR>\n");
                    this.out.print("  <TR><TD colspan=" + (cols + 1) + ">&nbsp;</TD></TR>\n");
                    for (i = 0; i < rows; ++i) {
                        if (flag[index[i]] == -1) continue;
                        this.out.print("  <TR>");
                        this.out.print("<TD align=\"right\">" + index[i] + ":</TD>");
                        for (j = 0; j < coord[index[i]].length; ++j) {
                            this.out.print("<TD align=\"right\">" + debugPrintout.formatNumber(coord[index[i]][j]) + "</TD>");
                        }
                        this.out.print("</TR>\n");
                    }
                    this.out.println("</TABLE>");
                }
                if (this.echo) {
                    for (j2 = 0; j2 < metric.length; ++j2) {
                        System.err.print(debugPrintout.formatNumber(metric[j2]) + " ");
                    }
                    System.err.println();
                    System.err.println();
                    for (i = 0; i < rows; ++i) {
                        if (flag[index[i]] == -1) continue;
                        System.err.print(this.debugTab + index[i] + ": ");
                        for (j = 0; j < coord[index[i]].length; ++j) {
                            System.err.print(debugPrintout.formatNumber(coord[index[i]][j]) + " ");
                        }
                        System.err.println();
                    }
                }
            } else {
                this.child.printCoordEnchanced(coord, metric, index, flag);
            }
        }
    }

    public void setBackCheckLevel(int level) {
        this.backCheckLevel = level;
    }

    public int getBackCheckLevel() {
        return this.backCheckLevel;
    }

    public boolean doCheck(int level) {
        return level <= this.backCheckLevel;
    }
}

