/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.edit;

import chemaxon.marvin.alignment.Quaternion;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class DirectedMerge {
    public static double WEIGHT_FOR_THIRD_ATOM = 10.0;
    public static double WEIGHT_FOR_SPANNING = 1.0;
    public static double WEIGHT_FOR_PROX = 1.0;
    public static double VAN_DER_WAALS_RADIUS_SCALE = 0.7;
    private MoleculeGraph fixed;
    private MoleculeGraph fragment;
    private Vector<MyMap> pairs;
    private int max_sweeps = 300;
    private double[] q = new double[4];
    private double[][] u = new double[3][3];
    private double[][] cQ = new double[4][4];
    private double[][] vQ = new double[4][4];
    private double[] dQ = new double[4];
    private double[][] crdFixed;
    private double[][] crdRotate;
    private Visualizer v;
    private double originalDistanceBetweenSecondPair = -1.0;
    private double originalDistanceBetweenThirdPair = -1.0;
    private static final double ZERO = 1.0E-5;

    DirectedMerge(MoleculeGraph fixed, MoleculeGraph fragment) {
        this.fixed = fixed;
        this.fragment = fragment;
        this.crdFixed = DirectedMerge.getCoordniates(fixed);
        this.crdRotate = DirectedMerge.getCoordniates(fragment);
        this.v = new Visualizer();
    }

    public void run() {
        if (this.pairs.size() != 2 && this.pairs.size() != 3) {
            throw new IllegalArgumentException("Exactly two or three pairs must be mapped. Currently: " + this.pairs.size());
        }
        double[] fixedAtom1 = new double[]{this.crdFixed[this.pairs.get((int)0).fixed][0], this.crdFixed[this.pairs.get((int)0).fixed][1], this.crdFixed[this.pairs.get((int)0).fixed][2]};
        this.crdFixed = DirectedMerge.translateCrd(this.crdFixed, fixedAtom1, -1);
        this.show();
        double[] rotatedAtom1 = new double[]{this.crdRotate[this.pairs.get((int)0).fragment][0], this.crdRotate[this.pairs.get((int)0).fragment][1], this.crdRotate[this.pairs.get((int)0).fragment][2]};
        this.crdRotate = DirectedMerge.translateCrd(this.crdRotate, rotatedAtom1, -1);
        this.show();
        this.qtrfit();
        this.rotmol(this.crdRotate, this.u);
        this.show();
        this.originalDistanceBetweenSecondPair = MolGeom.getLength(this.crdRotate[this.pairs.get((int)1).fragment], this.crdFixed[this.pairs.get((int)1).fixed]);
        this.scaleFragmentBy12();
        this.show();
        Function f = new Function();
        if (this.pairs.size() == 3) {
            this.originalDistanceBetweenThirdPair = MolGeom.getLength(this.crdRotate[this.pairs.get((int)2).fragment], this.crdFixed[this.pairs.get((int)2).fixed]);
        }
        this.crdFixed = DirectedMerge.translateCrd(this.crdFixed, fixedAtom1, 1);
        this.crdRotate = DirectedMerge.translateCrd(this.crdRotate, fixedAtom1, 1);
        this.show();
    }

    public double getOriginalDistanceBetweenSecondPair() {
        return this.originalDistanceBetweenSecondPair;
    }

    public double getOriginalDistanceBetweenThirdPair() {
        return this.originalDistanceBetweenThirdPair;
    }

    private void check(MoleculeGraph mg) {
        for (int a = 0; a < mg.getAtomCount(); ++a) {
            int id = mg.getAtom(a).getAtomMap();
            if (id == 0) continue;
            for (int i = a + 1; i < mg.getAtomCount(); ++i) {
                int id2 = mg.getAtom(i).getAtomMap();
                if (id != id2) continue;
                throw new IllegalArgumentException("There are more same atom mapping within the same molecule : " + id);
            }
        }
    }

    public void createPairs(Vector<MolAtom[]> atoms) {
        this.pairs = new Vector(atoms.size());
        for (int i = 0; i < atoms.size(); ++i) {
            MolAtom[] mas = atoms.elementAt(i);
            int pos1 = this.fixed.indexOf(mas[0]);
            int pos2 = this.fragment.indexOf(mas[1]);
            if (pos1 == -1 || pos2 == -1) {
                throw new IllegalArgumentException("Atom not found in molecule");
            }
            this.pairs.add(new MyMap(i, pos1, pos2));
        }
    }

    public void createPairsFromUserMappedAtoms() {
        this.pairs = new Vector(3);
        this.check(this.fixed);
        this.check(this.fragment);
        for (int a = 0; a < this.fixed.getAtomCount(); ++a) {
            int id = this.fixed.getAtom(a).getAtomMap();
            if (id == 0) continue;
            boolean added = false;
            for (int a2 = 0; a2 < this.fragment.getAtomCount(); ++a2) {
                int id2 = this.fragment.getAtom(a2).getAtomMap();
                if (id != id2) continue;
                this.pairs.add(new MyMap(id, a, a2));
                added = true;
            }
            if (added) continue;
            throw new IllegalArgumentException("Cannot find pair for map id: " + id);
        }
        Collections.sort(this.pairs, new Comparator<MyMap>(){

            @Override
            public int compare(MyMap o1, MyMap o2) {
                if (o1.mapID < o2.mapID) {
                    return -1;
                }
                if (o1.mapID > o2.mapID) {
                    return 1;
                }
                throw new IllegalArgumentException("ids equal");
            }
        });
    }

    private static double[][] getCoordniates(MoleculeGraph m) {
        double[][] crd = new double[m.getAtomCount()][3];
        for (int i = 0; i < m.getAtomCount(); ++i) {
            crd[i][0] = m.getAtom(i).getX();
            crd[i][1] = m.getAtom(i).getY();
            crd[i][2] = m.getAtom(i).getZ();
        }
        return crd;
    }

    private static MoleculeGraph putCoordinates(double[][] crd, MoleculeGraph mg) {
        for (int i = 0; i < crd.length; ++i) {
            mg.getAtom(i).setXYZ(crd[i][0], crd[i][1], crd[i][2]);
        }
        return mg;
    }

    private void show() {
        if (this.v != null) {
            this.v.show();
        }
    }

    private double getScale(int pos) {
        double r = this.crdRotate[this.pairs.get((int)1).fragment][pos];
        if (Math.abs(r) < 1.0E-5) {
            return 1.0;
        }
        return this.crdFixed[this.pairs.get((int)1).fixed][pos] / r;
    }

    private double getScaleFactor() {
        double dx1 = this.crdFixed[this.pairs.get((int)1).fixed][0] - this.crdFixed[this.pairs.get((int)0).fixed][0];
        double dy1 = this.crdFixed[this.pairs.get((int)1).fixed][1] - this.crdFixed[this.pairs.get((int)0).fixed][1];
        double dz1 = this.crdFixed[this.pairs.get((int)1).fixed][2] - this.crdFixed[this.pairs.get((int)0).fixed][2];
        double dx2 = this.crdRotate[this.pairs.get((int)1).fragment][0] - this.crdRotate[this.pairs.get((int)0).fragment][0];
        double dy2 = this.crdRotate[this.pairs.get((int)1).fragment][1] - this.crdRotate[this.pairs.get((int)0).fragment][1];
        double dz2 = this.crdRotate[this.pairs.get((int)1).fragment][2] - this.crdRotate[this.pairs.get((int)0).fragment][2];
        double d1 = Math.sqrt(dx1 * dx1 + dy1 * dy1 + dz1 * dz1);
        double d2 = Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
        return d1 / d2;
    }

    private void _scaleFragmentBy12() {
        double rX = this.getScale(0);
        double rY = this.getScale(1);
        double rZ = this.getScale(2);
        for (int i = 0; i < this.crdRotate.length; ++i) {
            this.crdRotate[i][0] = rX * this.crdRotate[i][0];
            this.crdRotate[i][1] = rY * this.crdRotate[i][1];
            this.crdRotate[i][2] = rZ * this.crdRotate[i][2];
        }
    }

    private void scaleFragmentBy12() {
        double lambda = this.getScaleFactor();
        for (int i = 0; i < this.crdRotate.length; ++i) {
            this.crdRotate[i][0] = lambda * this.crdRotate[i][0];
            this.crdRotate[i][1] = lambda * this.crdRotate[i][1];
            this.crdRotate[i][2] = lambda * this.crdRotate[i][2];
        }
    }

    public MoleculeGraph getRotatedFragment() {
        DirectedMerge.putCoordinates(this.crdRotate, this.fragment);
        return this.fragment;
    }

    private static double[][] translateCrd(double[][] crd, double[] o, int sign) {
        for (int i = 0; i < crd.length; ++i) {
            double[] dArray = crd[i];
            dArray[0] = dArray[0] + (double)sign * o[0];
            double[] dArray2 = crd[i];
            dArray2[1] = dArray2[1] + (double)sign * o[1];
            double[] dArray3 = crd[i];
            dArray3[2] = dArray3[2] + (double)sign * o[2];
        }
        return crd;
    }

    private void rotmol(double[][] x, double[][] u) {
        for (int i = 0; i < x.length; ++i) {
            double yx = u[0][0] * x[i][0] + u[1][0] * x[i][1] + u[2][0] * x[i][2];
            double yy = u[0][1] * x[i][0] + u[1][1] * x[i][1] + u[2][1] * x[i][2];
            double yz = u[0][2] * x[i][0] + u[1][2] * x[i][1] + u[2][2] * x[i][2];
            x[i][0] = yx;
            x[i][1] = yy;
            x[i][2] = yz;
        }
    }

    private static void jacobi(double[][] a, double[] d, double[][] v, int nrot) {
        int j;
        int i;
        double small = 1.0E-12;
        double f0 = 0.0;
        double p5 = 0.5;
        double f1 = 1.0;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                v[i][j] = 0.0;
            }
            v[i][i] = 1.0;
            d[i] = a[i][i];
        }
        for (int l = 1; l <= nrot; ++l) {
            double dtemp;
            int k;
            double dnorm = 0.0;
            double onorm = 0.0;
            for (j = 0; j < 4; ++j) {
                dnorm += Math.abs(d[j]);
                for (i = 0; i <= j - 1; ++i) {
                    onorm += Math.abs(a[i][j]);
                }
            }
            if (onorm / dnorm <= 1.0E-12) {
                nrot = l;
                for (j = 0; j < 3; ++j) {
                    k = j;
                    dtemp = d[k];
                    for (i = j + 1; i <= 3; ++i) {
                        if (!(d[i] < dtemp)) continue;
                        k = i;
                        dtemp = d[k];
                    }
                    if (k <= j) continue;
                    d[k] = d[j];
                    d[j] = dtemp;
                    for (i = 0; i < 4; ++i) {
                        dtemp = v[i][k];
                        v[i][k] = v[i][j];
                        v[i][j] = dtemp;
                    }
                }
                return;
            }
            for (j = 1; j < 4; ++j) {
                for (i = 0; i < j; ++i) {
                    double atemp;
                    double t;
                    double b = a[i][j];
                    if (!(Math.abs(b) > 0.0)) continue;
                    double dma = d[j] - d[i];
                    if (Math.abs(dma) + Math.abs(b) <= Math.abs(dma)) {
                        t = b / dma;
                    } else {
                        double q = 0.5 * dma / b;
                        t = 1.0 / (Math.abs(q) + Math.sqrt(1.0 + q * q));
                        if (q < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(t * t + 1.0);
                    double s = t * c;
                    a[i][j] = 0.0;
                    for (k = 0; k < i; ++k) {
                        atemp = c * a[k][i] - s * a[k][j];
                        a[k][j] = s * a[k][i] + c * a[k][j];
                        a[k][i] = atemp;
                    }
                    for (k = i + 1; k < j; ++k) {
                        atemp = c * a[i][k] - s * a[k][j];
                        a[k][j] = s * a[i][k] + c * a[k][j];
                        a[i][k] = atemp;
                    }
                    for (k = j + 1; k < 4; ++k) {
                        atemp = c * a[i][k] - s * a[j][k];
                        a[j][k] = s * a[i][k] + c * a[j][k];
                        a[i][k] = atemp;
                    }
                    for (k = 0; k < 4; ++k) {
                        double vtemp = c * v[k][i] - s * v[k][j];
                        v[k][j] = s * v[k][i] + c * v[k][j];
                        v[k][i] = vtemp;
                    }
                    dtemp = c * c * d[i] + s * s * d[j] - 2.0 * c * s * b;
                    d[j] = s * s * d[i] + c * c * d[j] + 2.0 * c * s * b;
                    d[i] = dtemp;
                }
            }
        }
    }

    private static void q2mat(double[] q, double[][] u) {
        double f2 = 2.0;
        u[0][0] = q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3];
        u[0][1] = 2.0 * (q[1] * q[2] - q[0] * q[3]);
        u[0][2] = 2.0 * (q[1] * q[3] + q[0] * q[2]);
        u[1][0] = 2.0 * (q[2] * q[1] + q[0] * q[3]);
        u[1][1] = q[0] * q[0] - q[1] * q[1] + q[2] * q[2] - q[3] * q[3];
        u[1][2] = 2.0 * (q[2] * q[3] - q[0] * q[1]);
        u[2][0] = 2.0 * (q[3] * q[1] - q[0] * q[2]);
        u[2][1] = 2.0 * (q[3] * q[2] + q[0] * q[1]);
        u[2][2] = q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3];
    }

    private void qtrfit() {
        double xxyx = 0.0;
        double xxyy = 0.0;
        double xxyz = 0.0;
        double xyyx = 0.0;
        double xyyy = 0.0;
        double xyyz = 0.0;
        double xzyx = 0.0;
        double xzyy = 0.0;
        double xzyz = 0.0;
        double[] x = this.crdRotate[this.pairs.get((int)1).fragment];
        double[] y = this.crdFixed[this.pairs.get((int)1).fixed];
        double w = 1.0;
        xxyx += x[0] * y[0] * w;
        xxyy += x[0] * y[1] * w;
        xxyz += x[0] * y[2] * w;
        xyyx += x[1] * y[0] * w;
        xyyy += x[1] * y[1] * w;
        xyyz += x[1] * y[2] * w;
        xzyx += x[2] * y[0] * w;
        xzyy += x[2] * y[1] * w;
        xzyz += x[2] * y[2] * w;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.cQ[i][j] = 0.0;
            }
        }
        this.cQ[0][0] = xxyx + xyyy + xzyz;
        this.cQ[0][1] = xzyy - xyyz;
        this.cQ[1][1] = xxyx - xyyy - xzyz;
        this.cQ[0][2] = xxyz - xzyx;
        this.cQ[1][2] = xxyy + xyyx;
        this.cQ[2][2] = xyyy - xzyz - xxyx;
        this.cQ[0][3] = xyyx - xxyy;
        this.cQ[1][3] = xzyx + xxyz;
        this.cQ[2][3] = xyyz + xzyy;
        this.cQ[3][3] = xzyz - xxyx - xyyy;
        DirectedMerge.jacobi(this.cQ, this.dQ, this.vQ, this.max_sweeps);
        int pos = 3;
        this.q[0] = this.vQ[0][pos];
        this.q[1] = this.vQ[1][pos];
        this.q[2] = this.vQ[2][pos];
        this.q[3] = this.vQ[3][pos];
        DirectedMerge.q2mat(this.q, this.u);
    }

    public static double align(MoleculeGraph fixed, MoleculeGraph fragment) {
        DirectedMerge d = new DirectedMerge(fixed, fragment);
        d.createPairsFromUserMappedAtoms();
        d.run();
        fragment = d.getRotatedFragment();
        if (d.getOriginalDistanceBetweenThirdPair() != -1.0) {
            return d.getOriginalDistanceBetweenThirdPair();
        }
        return d.getOriginalDistanceBetweenSecondPair();
    }

    public static double align(MoleculeGraph fixed, MoleculeGraph fragment, Vector<MolAtom[]> v) {
        DirectedMerge d = new DirectedMerge(fixed, fragment);
        d.createPairs(v);
        d.run();
        fragment = d.getRotatedFragment();
        if (d.getOriginalDistanceBetweenThirdPair() != -1.0) {
            return d.getOriginalDistanceBetweenThirdPair();
        }
        return d.getOriginalDistanceBetweenSecondPair();
    }

    private class Function
    implements GradientOptimization.FunctionToMinimize {
        Quaternion q = new Quaternion();
        double[] variables = new double[1];
        double[] gradient = new double[1];
        Vector<Constraint> constr = new Vector();
        double[] axis;
        double[] axisXrot = new double[3];
        double[] consrVect = new double[3];
        double[][] crdOrig;

        public Function() {
            this.axis = MolGeom.arrayCopy(DirectedMerge.this.crdFixed[((MyMap)((DirectedMerge)DirectedMerge.this).pairs.get((int)1)).fixed]);
            MolGeom.normalize(this.axis);
            if (DirectedMerge.this.pairs.size() == 3) {
                this.constr.add(new Quadratic(DirectedMerge.this.crdFixed[((MyMap)((DirectedMerge)DirectedMerge.this).pairs.get((int)2)).fixed], DirectedMerge.this.crdRotate[((MyMap)((DirectedMerge)DirectedMerge.this).pairs.get((int)2)).fragment], WEIGHT_FOR_THIRD_ATOM));
            } else {
                for (int i = 0; i < DirectedMerge.this.crdFixed.length; ++i) {
                    if (!this.unselectedAtomFixed(i)) continue;
                    double vdwI = PeriodicSystem.getVanDerWaalsRadius(DirectedMerge.this.fixed.getAtom(i).getAtno());
                    for (int j = 0; j < DirectedMerge.this.crdRotate.length; ++j) {
                        if (!this.unselectedAtomRotate(j)) continue;
                        this.constr.add(new Span(DirectedMerge.this.crdFixed[i], DirectedMerge.this.crdRotate[j], WEIGHT_FOR_SPANNING));
                        double vdwJ = PeriodicSystem.getVanDerWaalsRadius(DirectedMerge.this.fragment.getAtom(j).getAtno());
                        double r0 = (vdwI + vdwJ) * VAN_DER_WAALS_RADIUS_SCALE;
                        this.constr.add(new Proximity(DirectedMerge.this.crdFixed[i], DirectedMerge.this.crdRotate[j], WEIGHT_FOR_PROX, r0));
                    }
                }
            }
            this.variables[0] = 0.0;
            this.crdOrig = MolGeom.arrayCopy(DirectedMerge.this.crdRotate);
            this.initialScan();
        }

        private void initialScan() {
            int steps = 100;
            double d = Math.PI * 2 / (double)steps;
            double fmin = 0.0;
            double valMin = 0.0;
            for (int i = 0; i < steps; ++i) {
                this.variables[0] = this.variables[0] + d;
                this.setVariables(this.variables);
                double f = this.getFunctionValue();
                if (i != 0 && !(fmin > f)) continue;
                fmin = f;
                valMin = this.variables[0];
            }
            this.variables[0] = valMin;
            this.setVariables(this.variables);
        }

        private boolean unselectedAtomFixed(int atom) {
            if (atom == ((MyMap)((DirectedMerge)DirectedMerge.this).pairs.get((int)0)).fixed) {
                return false;
            }
            if (atom == ((MyMap)((DirectedMerge)DirectedMerge.this).pairs.get((int)1)).fixed) {
                return false;
            }
            return DirectedMerge.this.pairs.size() != 3 || atom != ((MyMap)((DirectedMerge)DirectedMerge.this).pairs.get((int)2)).fixed;
        }

        private boolean unselectedAtomRotate(int atom) {
            if (atom == ((MyMap)((DirectedMerge)DirectedMerge.this).pairs.get((int)0)).fragment) {
                return false;
            }
            if (atom == ((MyMap)((DirectedMerge)DirectedMerge.this).pairs.get((int)1)).fragment) {
                return false;
            }
            return DirectedMerge.this.pairs.size() != 3 || atom != ((MyMap)((DirectedMerge)DirectedMerge.this).pairs.get((int)2)).fragment;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public double[] getVariables() {
            return this.variables;
        }

        @Override
        public double getFunctionValue() {
            double fv = 0.0;
            for (Constraint c : this.constr) {
                fv += c.function();
            }
            return fv;
        }

        @Override
        public double[] getFunctionGradient() {
            this.gradient[0] = 0.0;
            for (Constraint c : this.constr) {
                MolGeom.getVector3D(this.axis, c.atom2, this.axisXrot);
                MolGeom.minusVec(c.atom2, c.atom1, this.consrVect);
                this.gradient[0] = this.gradient[0] + MolGeom.dot3D(this.axisXrot, this.consrVect) * c.derivateDividedByDist();
            }
            return this.gradient;
        }

        @Override
        public boolean setVariables(double[] doubles) {
            MolGeom.arrayCopy(this.crdOrig, DirectedMerge.this.crdRotate);
            this.q.setAxisAndAngle(this.axis[0], this.axis[1], this.axis[2], doubles[0]);
            for (int i = 0; i < DirectedMerge.this.crdRotate.length; ++i) {
                ((DirectedMerge)DirectedMerge.this).crdRotate[i] = this.q.rotate(DirectedMerge.this.crdRotate[i]);
            }
            DirectedMerge.this.show();
            return true;
        }

        public double[] numeric() {
            double[] ret = new double[this.gradient.length];
            double var = this.getVariables()[0];
            double small = 1.0E-5;
            this.variables[0] = this.variables[0] - small;
            this.setVariables(this.variables);
            double e1 = this.getFunctionValue();
            this.variables[0] = var + small;
            this.setVariables(this.variables);
            double e2 = this.getFunctionValue();
            this.variables[0] = var;
            this.setVariables(this.variables);
            ret[0] = (e2 - e1) / (small * 2.0);
            return ret;
        }

        @Override
        public void print() {
        }

        @Override
        public void print(String string) {
        }
    }

    private static class Proximity
    extends Constraint {
        double vdw;

        Proximity(double[] atom1, double[] atom2, double weight, double vdw) {
            super(atom1, atom2, weight);
            this.vdw = vdw;
        }

        @Override
        public double function() {
            double x = Math.sqrt(MolGeom.getDistSq(this.atom1, this.atom2));
            if (x > this.vdw) {
                return 0.0;
            }
            double dx = this.vdw - x;
            return dx * dx * dx * this.weight;
        }

        @Override
        public double derivateDividedByDist() {
            double x = Math.sqrt(MolGeom.getDistSq(this.atom1, this.atom2));
            if (x > this.vdw) {
                return 0.0;
            }
            double dx = this.vdw - x;
            return -3.0 * dx * dx * this.weight / x;
        }
    }

    private static class Span
    extends Constraint {
        Span(double[] atom1, double[] atom2, double weight) {
            super(atom1, atom2, weight);
        }

        @Override
        public double function() {
            return -Math.sqrt(MolGeom.getDistSq(this.atom1, this.atom2)) * this.weight;
        }

        @Override
        public double derivateDividedByDist() {
            double x = Math.sqrt(MolGeom.getDistSq(this.atom1, this.atom2));
            if (x < 1.0E-5) {
                System.err.println("distance approaches zero");
            }
            return -this.weight / x;
        }
    }

    private static class Quadratic
    extends Constraint {
        Quadratic(double[] atom1, double[] atom2, double weight) {
            super(atom1, atom2, weight);
        }

        @Override
        public double function() {
            return MolGeom.getDistSq(this.atom1, this.atom2) * this.weight;
        }

        @Override
        public double derivateDividedByDist() {
            return 2.0 * this.weight;
        }
    }

    private static abstract class Constraint {
        double weight;
        double[] atom1;
        double[] atom2;

        public Constraint(double[] atom1, double[] atom2, double weight) {
            this.atom1 = atom1;
            this.atom2 = atom2;
            this.weight = weight;
        }

        double getDistSQ() {
            return MolGeom.getDistSq(this.atom1, this.atom2);
        }

        public abstract double function();

        public abstract double derivateDividedByDist();
    }

    private class Visualizer {
        double[] crdAll;

        public Visualizer() {
            Molecule m = new Molecule();
            DirectedMerge.this.fixed.clonecopy(m);
            m.fuse(DirectedMerge.this.fragment);
            this.crdAll = new double[m.getAtomCount() * 3];
        }

        public void show() {
            int i;
            int c = 0;
            for (i = 0; i < DirectedMerge.this.crdFixed.length; ++i) {
                this.crdAll[c++] = DirectedMerge.this.crdFixed[i][0];
                this.crdAll[c++] = DirectedMerge.this.crdFixed[i][1];
                this.crdAll[c++] = DirectedMerge.this.crdFixed[i][2];
            }
            for (i = 0; i < DirectedMerge.this.crdRotate.length; ++i) {
                this.crdAll[c++] = DirectedMerge.this.crdRotate[i][0];
                this.crdAll[c++] = DirectedMerge.this.crdRotate[i][1];
                this.crdAll[c++] = DirectedMerge.this.crdRotate[i][2];
            }
        }
    }

    private static class MyMap {
        int mapID;
        int fixed;
        int fragment;

        public MyMap(int mapID, int fixed, int fragment) {
            this.mapID = mapID;
            this.fixed = fixed;
            this.fragment = fragment;
        }
    }
}

