/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.edit;

import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.graphics.MPolyline;
import java.awt.Color;

public class Mirror {
    private static final boolean wantArrows = false;
    public static double ZERO_LIMIT = 1.0E-4;

    private static double[] molAtom2crd(MolAtom ma) {
        double[] x = new double[]{ma.getX(), ma.getY(), ma.getZ()};
        return x;
    }

    private static void crd2molAtom(double[] crd, MolAtom a) {
        a.setXYZ(crd[0], crd[1], crd[2]);
    }

    private static void mirror(MoleculeGraph fragment, double[] c) {
        MolGeom.mul(c, 2.0);
        for (int i = 0; i < fragment.getAtomCount(); ++i) {
            MolAtom ai = fragment.getAtom(i);
            double[] ci = Mirror.molAtom2crd(ai);
            MolGeom.minusVec(c, ci, ci);
            Mirror.crd2molAtom(ci, ai);
        }
    }

    public static void mirror(MoleculeGraph fragment, MolAtom center) {
        double[] c = Mirror.molAtom2crd(center);
        Mirror.mirror(fragment, c);
    }

    public static void mirror(MoleculeGraph fragment) {
        if (fragment.getAtomCount() == 0) {
            return;
        }
        double[] c = new double[3];
        for (int i = 0; i < fragment.getAtomCount(); ++i) {
            MolAtom ai = fragment.getAtom(i);
            double[] ci = Mirror.molAtom2crd(ai);
            MolGeom.plusVec(c, ci, c);
        }
        MolGeom.mul(c, 1.0 / (double)fragment.getAtomCount());
        Mirror.mirror(fragment, c);
    }

    public static void mirror(MoleculeGraph fragment, MolAtom[] plane) {
        Object md = null;
        double[][] v = new double[][]{Mirror.molAtom2crd(plane[0]), Mirror.molAtom2crd(plane[1]), Mirror.molAtom2crd(plane[2])};
        double[] a1 = new double[3];
        double[] a2 = new double[3];
        double[] norm1 = new double[3];
        double[] norm2 = new double[3];
        MolGeom.minusVec(v[1], v[0], a1);
        MolGeom.minusVec(v[2], v[0], a2);
        MolGeom.getVector3D(a1, a2, norm1);
        MolGeom.normalize(norm1);
        MolGeom.getVector3D(a2, a1, norm2);
        MolGeom.normalize(norm2);
        int stop = fragment.getAtomCount();
        for (int i = 0; i < stop; ++i) {
            double[] atomic = Mirror.molAtom2crd(fragment.getAtom(i));
            MolGeom.minusVec(atomic, v[0], atomic);
            double d1 = MolGeom.getDistSq(norm1, atomic);
            double d2 = MolGeom.getDistSq(norm2, atomic);
            double[] closer = norm1;
            double[] other = norm2;
            if (d1 > d2) {
                closer = norm2;
                other = norm1;
            }
            double perpDot = MolGeom.dot3D(closer, atomic);
            double[] perp = MolGeom.arrayCopy(other);
            MolGeom.mul(perp, perpDot);
            if (Math.abs(perpDot) < ZERO_LIMIT) continue;
            double[] inplaneTmp = new double[3];
            MolGeom.getVector3D(closer, atomic, inplaneTmp);
            double[] inplane = new double[3];
            MolGeom.getVector3D(inplaneTmp, closer, inplane);
            MolGeom.normalize(inplane);
            double parallDot = MolGeom.dot3D(inplane, atomic);
            MolGeom.mul(inplane, parallDot);
            double[] res = new double[3];
            MolGeom.plusVec(inplane, perp, res);
            MolGeom.plusVec(v[0], res, res);
            fragment.getAtom(i).setXYZ(res[0], res[1], res[2]);
        }
    }

    private static MPolyline arrow(double[] crd1, double[] crd2, Color color) {
        MPoint mp1 = new MPoint(crd1[0], crd1[1], crd1[2]);
        MPoint mp2 = new MPoint(crd2[0], crd2[1], crd2[2]);
        MPolyline arrow = new MPolyline(mp1, mp2, color, color);
        arrow.setArrow(true);
        arrow.setArrowLength(MPolyline.HEAD, 0.3);
        arrow.setArrowWidth(MPolyline.HEAD, 0.2);
        return arrow;
    }
}

