/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.geom;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.geom.Tetrahedron;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.Vector;

public class Equivalences {
    public static boolean isDistancesOK(double[] a1, double[] a2, double[] b1, double[] b2, boolean useShortClip, StringBuffer s) {
        double dev;
        double d0 = a1[0] - a2[0];
        double d1 = a1[1] - a2[1];
        double d2 = a1[2] - a2[2];
        double da = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        double e0 = b1[0] - b2[0];
        double e1 = b1[1] - b2[1];
        double e2 = b1[2] - b2[2];
        double db = Math.sqrt(e0 * e0 + e1 * e1 + e2 * e2);
        if ((!useShortClip || da < 4.0 || db < 4.0) && (dev = 1000.0 * Math.abs(da - db) / Math.max(da, db)) > 20.0) {
            if (s != null) {
                s.append("da:" + debugPrintout.formatNumber(da) + " db:" + debugPrintout.formatNumber(db) + " dev: " + debugPrintout.formatNumber(dev));
            }
            return false;
        }
        return true;
    }

    static boolean same(double[][] c1, double[][] c2) {
        for (int i = 0; i < c1.length; ++i) {
            for (int j = i + 1; j < c1.length; ++j) {
                if (Equivalences.isDistancesOK(c1[i], c1[j], c2[i], c2[j], false, null)) continue;
                return false;
            }
        }
        return true;
    }

    public static int[] findDuplicates_0(double[][][] set1, Vector set1ext, double[][][] set2, debugPrintout debug) {
        int i;
        if (debug != null) {
            debug.printB("Fill tetrahedrons");
        }
        if (set1ext != null && set1ext.size() > 0) {
            double[][][] newset1 = new double[(set1 != null ? ((double[][][])set1).length : 0) + set1ext.size()][][];
            int j = 0;
            if (set1 != null) {
                for (i = 0; i < ((double[][][])set1).length; ++i) {
                    newset1[j++] = set1[i];
                }
            }
            for (i = 0; i < set1ext.size(); ++i) {
                newset1[j++] = (double[][])set1ext.get(i);
            }
            set1 = newset1;
        }
        Tetrahedron[] tet = new Tetrahedron[set2.length];
        BitSet ok = new BitSet(set2.length);
        for (i = 0; i < set2.length; ++i) {
            tet[i] = new Tetrahedron(set2[i]);
            ok.set(i);
        }
        if (debug != null) {
            debug.printB("Check");
        }
        block3: for (i = 0; i < set2.length; ++i) {
            int j;
            boolean mightChiral = tet[i].getType() == 4;
            double genp2 = tet[i].getGenP();
            if (debug != null) {
                debug.println("i=" + i);
            }
            if (set1 != null) {
                for (j = 0; j < ((double[][][])set1).length; ++j) {
                    if (mightChiral && tet[i].getGenP(set1[j]) * genp2 < 0.0 || !Equivalences.same(set2[i], set1[j])) continue;
                    ok.clear(i);
                    if (debug == null) break;
                    debug.println("Same " + i + " " + j);
                    break;
                }
            }
            if (!ok.get(i)) continue;
            for (j = 0; j < i; ++j) {
                if (mightChiral && tet[i].getGenP(set2[j]) * genp2 < 0.0 || !Equivalences.same(set2[i], set2[j])) continue;
                ok.clear(i);
                if (debug == null) continue block3;
                debug.println("Same in set2 " + i + " " + j);
                continue block3;
            }
        }
        int oks = 0;
        for (int i2 = 0; i2 < set2.length; ++i2) {
            if (!ok.get(i2)) continue;
            ++oks;
        }
        if (oks == 0) {
            return null;
        }
        int[] ret = new int[oks];
        oks = 0;
        for (int i3 = 0; i3 < set2.length; ++i3) {
            if (!ok.get(i3)) continue;
            ret[oks++] = i3;
        }
        return ret;
    }

    public static int[] findDuplicates(double[][][] set1, Vector set1ext, double[][][] set2, CleanSettings settings) {
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("findDuplicates()");
        }
        if (settings.OPT_stopper_equivalences != null) {
            settings.OPT_stopper_equivalences.start();
        }
        int[] ret = Equivalences.findDuplicates_0(set1, set1ext, set2, debug);
        if (settings.OPT_stopper_equivalences != null) {
            settings.OPT_stopper_equivalences.stop();
        }
        if (debug != null) {
            debug.decLevel();
        }
        return ret;
    }

    public static int[] getMorganLabels(myMolecule m) {
        Molecule cm = m.getOriginalMolCopy();
        int[] ret = new int[cm.getAtomCount()];
        cm.getGrinv(ret);
        return ret;
    }

    public static int[] getMorganLabels(myMolecule m, int[] selecteds) {
        return Equivalences.getMorganLabels(m, new int[][]{selecteds});
    }

    public static int[] getMorganLabels(myMolecule m, int[][] selecteds) {
        int i;
        Molecule cm = m.getOriginalMolCopy().cloneMolecule();
        BitSet anums = new BitSet();
        anums.set(0);
        anums.set(1);
        int[] atnos = new int[cm.getAtomCount()];
        for (i = 0; i < cm.getAtomCount(); ++i) {
            atnos[i] = cm.getAtom(i).getAtno();
            anums.set(atnos[i]);
        }
        for (i = 0; i < cm.getAtomCount(); ++i) {
            MolAtom ai = cm.getAtom(i);
            if (ai.getAtno() != 1 || ai.getBondCount() != 1) continue;
            ai.getBond(0).setType(1);
        }
        int hnew = U.firstClearBit(anums);
        U.replaceAll(atnos, 1, hnew);
        anums.set(hnew);
        BitSet seldone = new BitSet();
        for (int gr = 0; gr < selecteds.length; ++gr) {
            seldone.clear();
            for (int i2 = 0; i2 < selecteds[gr].length; ++i2) {
                if (seldone.get(i2)) continue;
                int from = atnos[selecteds[gr][i2]];
                int to = U.firstClearBit(anums);
                anums.set(to);
                for (int j = i2; j < selecteds[gr].length; ++j) {
                    if (atnos[selecteds[gr][j]] != from) continue;
                    atnos[selecteds[gr][j]] = to;
                    seldone.set(j);
                }
            }
        }
        for (int i3 = 0; i3 < cm.getAtomCount(); ++i3) {
            cm.getAtom(i3).setAtno(atnos[i3]);
        }
        int[] ret = new int[cm.getAtomCount()];
        cm.getGrinv(ret);
        return ret;
    }
}

