/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.geom;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.geom.Equivalences;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.IntSet;
import chemaxon.marvin.modelling.util.NodeGroups;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.Vector;

public class MultiAtomMapping {
    IntSet hpatoms = null;
    Vector hpperm = null;
    Vector indepgroups = null;
    int[] fuseAtoms;
    int[] anchors;
    int[] anchorDirectors;
    int[] hparr = null;

    public BitSet findAutoisomorphs(myMolecule frag, double[][] c) {
        int i;
        BitSet b = new BitSet(this.getHPPermCount());
        Substructure3DSearch ss = new Substructure3DSearch();
        ss.setQuery(frag.getOriginalMolCopy());
        ss.setTarget(frag.getOriginalMolCopy());
        int[] fm = new int[c.length];
        for (i = 0; i < fm.length; ++i) {
            fm[i] = -1;
        }
        for (i = 0; i < this.hpatoms.getWeight(); ++i) {
            int h;
            fm[h] = h = this.hpatoms.get(i);
        }
        ss.setFrozenMatch(fm);
        ss.setIgnoreGeometryMatching(false, 0.1);
        double[][] qc = new double[c.length][3];
        double[][] tc = new double[c.length][3];
        block2: for (int i2 = 1; i2 < this.getHPPermCount(); ++i2) {
            U.copyTo(c, qc, this.getHPPerm(i2));
            ss.setQueryCoordinates(qc);
            for (int j = 0; j < i2; ++j) {
                if (b.get(j)) continue;
                U.copyTo(c, tc, this.getHPPerm(j));
                ss.setTargetCoordinates(tc);
                if (!ss.findFirst()) continue;
                b.set(i2);
                continue block2;
            }
        }
        return b;
    }

    public MultiAtomMapping(myMolecule frag, int[] fuseAtoms, int[] anchors, int[] anchorDirectors) {
        this.fuseAtoms = fuseAtoms;
        this.anchors = anchors;
        this.anchorDirectors = anchorDirectors;
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("new MultiAtomMapping()");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("FuseAtoms: " + U.sel(fuseAtoms));
            CleanArgs.verbose("Anchors: " + U.sel(anchors));
            CleanArgs.verbose("AnchorDirectors: " + U.sel(anchorDirectors));
        }
        this.hpatoms = new IntSet(frag.a);
        this.hpatoms.add(fuseAtoms);
        if (debug != null) {
            frag.placeApplet("final setAtoms", U.sel(this.hpatoms.get()));
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("setAtoms: " + U.sel(this.hpatoms.get()));
        }
        Substructure3DSearch ss = new Substructure3DSearch();
        Molecule m = frag.getOriginalMolCopy();
        ss.setMolecules(m, m);
        ss.setIgnoreExactMatching(false);
        ss.setIgnoreGeometryConstraints(true);
        ss.setHighPriorityQueryAtoms(this.hpatoms.get());
        this.hpperm = new Vector();
        if (ss.findFirst()) {
            do {
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Permutation: " + U.sel(ss.getResult()));
                }
                this.hpperm.add(ss.getResult());
            } while (ss.findNext());
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Identify marked eqgroups");
        }
        int[][] mark = new int[this.hpatoms.getWeight()][1];
        for (int i = 0; i < mark.length; ++i) {
            mark[i][0] = this.hpatoms.get(i);
        }
        NodeGroups eq0 = new NodeGroups(Equivalences.getMorganLabels(frag, mark));
        if (debug != null) {
            eq0.placeApplet(frag, "Eq groups");
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Identify independent anchor groups", U.toString(mark));
        }
        this.indepgroups = new Vector();
        IntSet aset = new IntSet(anchors);
        for (int i = 0; i < eq0.getGroupCount(); ++i) {
            int[] g = eq0.getGroup(i);
            if (aset.contains(g)) {
                if (this.hpatoms.containsAny(g)) continue;
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Group " + i + " found: " + U.sel(g));
                }
                if (debug != null) {
                    frag.placeApplet("Group " + i, U.sel(g));
                }
                this.indepgroups.add(g);
                if (!CleanArgs.doVerbose()) continue;
                CleanArgs.verbose("Added.");
                continue;
            }
            if (!aset.containsAny(g)) continue;
            int[] idg = U.and(g, aset.get());
            this.indepgroups.add(idg);
            if (!CleanArgs.doVerbose()) continue;
            CleanArgs.verbose("Parial anchor group match added: " + U.sel(idg));
        }
        if (debug != null) {
            debug.decLevel();
        }
    }

    public int[] getAnchorDirectors(int[] g) {
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("getAnchorDirectors()", "g: " + U.sel(g) + "<BR>" + "anchorDirectos: " + U.sel(this.anchorDirectors));
        }
        if (g.length == 0) {
            return new int[0];
        }
        int[] ret = U.and(g, this.anchorDirectors);
        return ret;
    }

    public int[] getOverlappingAnchorGroup(int[] g) {
        int i;
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("getOverlappingAnchorGroup( " + U.sel(g) + ")");
            for (int i2 = 0; i2 < this.getIndepgroupCount(); ++i2) {
                CleanArgs.verbose("IndepGroup " + i2 + ": " + U.sel(this.getIndepGroup(i2)));
            }
            CleanArgs.verbose("Anchors: " + U.sel(this.anchors));
        }
        int[] ret = null;
        int groupIndex = -1;
        for (i = 0; i < this.getIndepgroupCount(); ++i) {
            int[] gi = this.getIndepGroup(i);
            if (!U.hasCommon(g, gi)) continue;
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("IndepGroup hit. i=" + i + " gi=" + U.sel(gi));
            }
            if (ret == null) {
                ret = gi;
                groupIndex = i;
                continue;
            }
            throw new IndexOutOfBoundsException("Multiple independent group overlap error");
        }
        for (i = 0; i < this.anchors.length; ++i) {
            if (!U.contains(g, this.anchors[i])) continue;
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Single anchor overlap hit. a[" + i + "]=" + this.anchors[i]);
            }
            if (groupIndex == -1) {
                if (ret == null) {
                    ret = new int[]{this.anchors[i]};
                    continue;
                }
                throw new IndexOutOfBoundsException("Multiple single anchor overlap error");
            }
            if (U.contains(this.getIndepGroup(groupIndex), this.anchors[i])) continue;
            throw new IndexOutOfBoundsException("Multiple single anchor/independent group overlap error");
        }
        if (ret == null) {
            ret = new int[]{};
        }
        return ret;
    }

    public int getIndepgroupCount() {
        return this.indepgroups.size();
    }

    public int[] getIndepGroup(int n) {
        return (int[])this.indepgroups.get(n);
    }

    public int getHPPermCount() {
        return this.hpperm.size();
    }

    public int[] getHPPerm(int i) {
        return (int[])this.hpperm.get(i);
    }

    public int getHPAtomCount() {
        return this.hpatoms.getWeight();
    }

    public int[] getHPAtoms() {
        if (this.hparr == null) {
            this.hparr = this.hpatoms.get();
        }
        return this.hparr;
    }
}

