/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.interfacing;

import chemaxon.marvin.modelling.interfacing.CalculationAbortedException;
import chemaxon.marvin.modelling.interfacing.CalculationFailedException;
import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.CalculationResult;
import chemaxon.marvin.modelling.interfacing.CxnMoleculeInput;
import chemaxon.marvin.modelling.interfacing.InvokeCalculation;
import chemaxon.marvin.modelling.interfacing.MultifragMoleculeAdapter;
import chemaxon.marvin.modelling.interfacing.RxnMoleculeAdapter;

public class CxnMoleculeAdapter
extends InvokeCalculation {
    private InvokeCalculation base = null;
    private MultifragMoleculeAdapter mfa = null;
    private RxnMoleculeAdapter rma = null;

    public CxnMoleculeAdapter(InvokeCalculation basecalc) {
        this.setVerbosePrinter(basecalc.getVerbosePrinter());
        if (this.vp != null) {
            this.vp.print("CxnMoleculeAdapter constructed");
        }
        this.base = basecalc;
        this.mfa = new MultifragMoleculeAdapter(basecalc);
    }

    @Override
    public CalculationResult invoke(CalculationInput input, boolean singlec) throws CalculationAbortedException, CalculationFailedException {
        CxnMoleculeInput mi = (CxnMoleculeInput)input.getInputDescriptor();
        if (RxnMoleculeAdapter.isRxnMolecule(mi)) {
            if (this.vp != null) {
                this.vp.print("Invoke on RxnMolecule");
            }
            if (this.rma == null) {
                this.rma = new RxnMoleculeAdapter(this.base);
            }
            return this.rma.invoke(input);
        }
        if (this.vp != null) {
            this.vp.print("Invoke on Multifrag");
        }
        return this.mfa.invoke(input, singlec);
    }
}

