/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.interfacing;

import chemaxon.core.util.BondTable;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.MultipleConformerResult;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.struc.ConformersDescriptor;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.struc.StereoCriteriaList;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import java.util.BitSet;

public class CxnMoleculeInput
implements CalculationInput {
    private Molecule mol = null;
    private SelectionMolecule selMol = null;
    int singleFragStatus = 0;
    private int[] fragIndex = null;
    private int[] atomToFrag = null;
    private CxnMoleculeInput[] infrags = null;
    public static String ENERGYPROPLABEL = "Energy";
    public static String ENERGYPROPABORTEDVALUE = "CLEAN3D_ABORTED";
    public static String ENERGYPROPFAILEDVALUE = "CLEAN3D_FAILED";
    private Fragment selMolFragH = null;
    private Fragment selMolFragNonH = null;

    @Override
    public int[] getAtomToFrag() {
        if (this.atomToFrag == null) {
            int i;
            this.findFrags();
            this.atomToFrag = new int[this.getAtomCount()];
            for (i = 0; i < this.atomToFrag.length; ++i) {
                this.atomToFrag[i] = -1;
            }
            for (i = 0; i < this.infrags.length; ++i) {
                int[] ai = this.infrags[i].getFragIndex();
                for (int j = 0; j < ai.length; ++j) {
                    if (this.atomToFrag[ai[j]] != -1) {
                        throw new UnsupportedOperationException();
                    }
                    this.atomToFrag[ai[j]] = i;
                }
            }
        }
        return this.atomToFrag;
    }

    public CxnMoleculeInput(Molecule m) {
        this.mol = m;
    }

    public CxnMoleculeInput(SelectionMolecule m) {
        this.selMol = m;
    }

    public CxnMoleculeInput(SelectionMolecule m, int[] fi) {
        this.selMol = m;
        this.fragIndex = fi;
    }

    @Override
    public int[] getFragIndex() {
        return this.fragIndex;
    }

    private boolean isSelMolPresent() {
        return this.selMol != null;
    }

    private boolean isMolPresent() {
        return this.mol != null;
    }

    public Molecule getMol() {
        return this.mol;
    }

    public SelectionMolecule getSelMol() {
        return this.selMol;
    }

    @Override
    public int getAtomCount() {
        if (this.isMolPresent()) {
            return this.getMol().getAtomCount();
        }
        if (this.isSelMolPresent()) {
            return this.getSelMol().getAtomCount();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public CalculationInput[] findFrags() {
        if (this.infrags == null) {
            int i;
            SelectionMolecule[] frags;
            MoleculeGraph orig = null;
            if (this.isMolPresent()) {
                orig = this.getMol();
                frags = this.getMol().findFrags();
                for (i = 0; i < frags.length; ++i) {
                    frags[i].setDim(this.getMol().getDim());
                }
            } else if (this.isSelMolPresent()) {
                orig = this.getSelMol();
                frags = (SelectionMolecule[])this.getSelMol().findFrags(SelectionMolecule.class);
                for (i = 0; i < frags.length; ++i) {
                    frags[i].setDim(this.getSelMol().getDim());
                }
            } else {
                throw new UnsupportedOperationException();
            }
            this.infrags = new CxnMoleculeInput[frags.length];
            for (i = 0; i < this.infrags.length; ++i) {
                int[] ai = new int[frags[i].getAtomCount()];
                for (int j = 0; j < ai.length; ++j) {
                    ai[j] = orig.indexOf(frags[i].getAtom(j));
                }
                this.infrags[i] = new CxnMoleculeInput(frags[i], ai);
            }
        }
        return this.infrags;
    }

    public MoleculeGraph getMoleculeGraph() {
        if (this.isMolPresent()) {
            return this.getMol();
        }
        if (this.isSelMolPresent()) {
            return this.getSelMol();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSingleFrag() {
        if (this.singleFragStatus == 0) {
            MoleculeGraph m = this.getMoleculeGraph();
            BitSet visited = new BitSet(m.getAtomCount());
            visited.set(0);
            int[] atomsToVisit = new int[m.getAtomCount()];
            atomsToVisit[0] = 0;
            int atomsToVisitSize = 1;
            int[][] ctab = m.getCtab();
            while (atomsToVisitSize > 0) {
                int ai = atomsToVisit[--atomsToVisitSize];
                for (int i = 0; i < ctab[ai].length; ++i) {
                    int a = ctab[ai][i];
                    if (visited.get(a)) continue;
                    visited.set(a);
                    atomsToVisit[atomsToVisitSize++] = a;
                }
            }
            this.singleFragStatus = visited.cardinality() == m.getAtomCount() ? 1 : 2;
        }
        return this.singleFragStatus == 1;
    }

    public void storeConformer(MultipleConformerResult res, boolean fillConfDesc) {
        ConformersDescriptor.writeCoords(this.mol, res.getCoordinates(0), true);
        this.mol.setDim(3);
        if (fillConfDesc) {
            ConformersDescriptor.createAndStoreConformersDescriptor(this.mol, res.getCoordinates(), res.getEnergy());
        }
    }

    public void storeEnergy(double e) {
        String ps = "" + Math.rint(e * 100.0) / 100.0;
        this.mol.setProperty(ENERGYPROPLABEL, ps);
    }

    public void storeEnergyAborted() {
        this.mol.setProperty(ENERGYPROPLABEL, ENERGYPROPABORTEDVALUE);
    }

    public void storeEnergyFailed() {
        this.mol.setProperty(ENERGYPROPLABEL, ENERGYPROPFAILEDVALUE);
    }

    public void removeEnergyProperty() {
        this.mol.setProperty(ENERGYPROPLABEL, null);
    }

    public boolean isMolecule3D() {
        if (this.getMol().getDim() != 3) {
            return false;
        }
        Molecule m = this.getMol();
        MoleculeGraph[] mols = m.findFrags(SelectionMolecule.class);
        for (int fragNo = 0; fragNo < mols.length; ++fragNo) {
            int i;
            SelectionMolecule frag = (SelectionMolecule)mols[fragNo];
            BondTable btab = frag.getBondTable();
            double[][] ca = new double[frag.getAtomCount()][3];
            for (i = 0; i < ca.length; ++i) {
                MolAtom a = frag.getAtom(i);
                ca[i][0] = a.getX();
                ca[i][1] = a.getY();
                ca[i][2] = a.getZ();
            }
            if (!U.isDoubleOK(ca)) {
                return false;
            }
            for (i = 1; i < frag.getAtomCount(); ++i) {
                for (int j = 0; j < i; ++j) {
                    double d = V.vectLen(ca[i], ca[j]);
                    if (!(btab.getBondIndex(i, j) == -1 ? d < 1.0 : d < 0.6 || d > 5.0)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Fragment getSelMolFrag(boolean hydrogenize, CleanSettings settings) {
        if ((hydrogenize ? this.selMolFragH : this.selMolFragNonH) == null) {
            debugPrintout debug = CleanArgs.getDebug();
            Molecule tmp = new Molecule();
            this.getSelMol().clonecopy(tmp);
            if (this.getAtomCount() != tmp.getAtomCount()) {
                throw new UnsupportedOperationException();
            }
            if (hydrogenize && !tmp.hydrogenize(true)) {
                throw new UnsupportedOperationException("Hydrogenize failed");
            }
            SelectionMolecule selmol = tmp.findFrags()[0];
            if (selmol.getAtomCount() != tmp.getAtomCount()) {
                throw new UnsupportedOperationException();
            }
            myMolecule mymol = new myMolecule(selmol, debug, settings);
            if (debug != null) {
                mymol.placeApplet("Molecule");
                debug.incLevel("MyMole details");
                mymol.printout(debug);
                debug.decLevel();
            }
            StereoCriteriaList stereo = new StereoCriteriaList(selmol, settings, mymol.ctab, mymol.bat, mymol.bonds);
            if (debug != null) {
                stereo.printout(debug, mymol);
            }
            Fragment f = new Fragment(mymol, settings);
            f.setStereo(stereo);
            if (hydrogenize) {
                this.selMolFragH = f;
            } else {
                this.selMolFragNonH = f;
            }
        }
        return hydrogenize ? this.selMolFragH : this.selMolFragNonH;
    }

    public double[][] getSingleFragCoordinates() {
        double[][] ret = new double[this.getAtomCount()][3];
        if (this.isSelMolPresent()) {
            SelectionMolecule sm = this.getSelMol();
            for (int i = 0; i < ret.length; ++i) {
                ret[i][0] = sm.getAtom(i).getX();
                ret[i][1] = sm.getAtom(i).getY();
                ret[i][2] = sm.getAtom(i).getZ();
            }
        } else {
            Molecule sm = this.getMol();
            for (int i = 0; i < ret.length; ++i) {
                ret[i][0] = sm.getAtom(i).getX();
                ret[i][1] = sm.getAtom(i).getY();
                ret[i][2] = sm.getAtom(i).getZ();
            }
        }
        return ret;
    }

    @Override
    public double[][] getCoordinates(int conf) {
        if (conf != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.getSingleFragCoordinates();
    }

    @Override
    public double[][][] getCoordinates() {
        return new double[][][]{this.getSingleFragCoordinates()};
    }

    @Override
    public double getEnergy(int conf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] getEnergy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEnergyAvailable() {
        return false;
    }

    @Override
    public boolean isCoordinatesAvailable() {
        return true;
    }

    @Override
    public CalculationInput getInputDescriptor() {
        return this;
    }
}

