/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.interfacing;

import chemaxon.marvin.modelling.interfacing.CalculationAbortedException;
import chemaxon.marvin.modelling.interfacing.CalculationFailedException;
import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.CalculationResult;
import chemaxon.marvin.modelling.interfacing.InvokeCalculation;
import chemaxon.marvin.modelling.interfacing.MultipleConformerResult;
import chemaxon.marvin.modelling.interfacing.MultipleConformersResultImpl;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.util.U;

public class MultifragMoleculeAdapter
extends InvokeCalculation {
    InvokeCalculation base;

    public MultifragMoleculeAdapter(InvokeCalculation basecalc) {
        this.base = basecalc;
    }

    @Override
    public CalculationResult invoke(CalculationInput input, boolean singlec) throws CalculationAbortedException, CalculationFailedException {
        MultipleConformersResultImpl ret;
        CalculationInput[] frags = input.findFrags();
        if (frags.length == 1) {
            return this.base.invoke(frags[0], singlec);
        }
        int keepConfFrag = 0;
        if (singlec) {
            keepConfFrag = -1;
        } else {
            for (int i = 0; i < frags.length; ++i) {
                if (frags[i].getAtomCount() <= frags[keepConfFrag].getAtomCount()) continue;
                keepConfFrag = i;
            }
        }
        boolean allEnergiesAvailable = true;
        boolean allCoordinatesAvailable = true;
        MultipleConformerResult[] res = new MultipleConformerResult[frags.length];
        for (int i = 0; i < frags.length; ++i) {
            boolean invokesingle = singlec || i != keepConfFrag;
            res[i] = (MultipleConformerResult)this.base.invoke(frags[i], invokesingle);
            if (!res[i].isEnergyAvailable()) {
                allEnergiesAvailable = false;
            }
            if (!res[i].isCoordinatesAvailable()) {
                allCoordinatesAvailable = false;
            }
            if (!invokesingle || res[i].size() == 1) continue;
            throw new UnsupportedOperationException();
        }
        if (allCoordinatesAvailable) {
            double sep = 0.0;
            for (int i = 0; i < frags.length; ++i) {
                for (int j = 0; j < res[i].size(); ++j) {
                    V.moveMCToOrigo(res[i].getCoordinates(j));
                }
                double m = U.maxAbs(res[i].getCoordinates());
                if (!(m > sep)) continue;
                sep = m;
            }
            double[][] cras = V.genCubeRaster(2.0 * sep + 1.5, frags.length);
            for (int i = 0; i < frags.length; ++i) {
                for (int j = 0; j < res[i].size(); ++j) {
                    V.plusWriteBackToAllA(res[i].getCoordinates(j), cras[i]);
                }
            }
        }
        int siz = keepConfFrag >= 0 ? 1 : res[keepConfFrag].size();
        double optl = MultipleConformerResult.collectOptLimits(res);
        double[][][] coord = null;
        if (allCoordinatesAvailable) {
            coord = new double[siz][input.getAtomCount()][];
            for (int i = 0; i < frags.length; ++i) {
                for (int j = 0; j < siz; ++j) {
                    int sc = i == keepConfFrag ? j : 0;
                    int[] ai = frags[i].getFragIndex();
                    double[][] resc = res[i].getCoordinates(sc);
                    for (int k = 0; k < ai.length; ++k) {
                        coord[j][ai[k]] = resc[k];
                    }
                }
            }
        }
        double[] en = null;
        if (allEnergiesAvailable) {
            en = new double[siz];
            for (int i = 0; i < frags.length; ++i) {
                int j = 0;
                while (j < siz) {
                    int sc = i == keepConfFrag ? j : 0;
                    int n = j++;
                    en[n] = en[n] + res[i].getEnergy(sc);
                }
            }
        }
        if (allCoordinatesAvailable && allEnergiesAvailable) {
            ret = new MultipleConformersResultImpl(input, coord, en);
            ret.overrideOptLimit(optl);
        } else if (allCoordinatesAvailable) {
            ret = new MultipleConformersResultImpl(input, coord);
            ret.overrideOptLimit(optl);
        } else if (allEnergiesAvailable) {
            ret = new MultipleConformersResultImpl(input, en);
        } else {
            throw new UnsupportedOperationException();
        }
        return ret;
    }
}

