/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.interfacing;

import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.CalculationResult;

public abstract class MultipleConformerResult
implements CalculationResult,
CalculationInput {
    public abstract int size();

    @Override
    public abstract double[][] getCoordinates(int var1);

    @Override
    public abstract double[][][] getCoordinates();

    @Override
    public abstract double getEnergy(int var1);

    @Override
    public abstract double[] getEnergy();

    @Override
    public abstract boolean isEnergyAvailable();

    @Override
    public abstract boolean isCoordinatesAvailable();

    public abstract void overrideEnergy(int var1, double var2);

    public abstract void overrideOptLimit(double var1);

    public abstract double getOptLimit();

    public static double collectOptLimits(MultipleConformerResult[] res) {
        double ret = res[0].getOptLimit();
        for (int i = 0; i < res.length; ++i) {
            double li = res[i].getOptLimit();
            if (li < 0.0) {
                return -1.0;
            }
            if (!(li > ret)) continue;
            ret = li;
        }
        return ret;
    }

    public static boolean collectAllEnergyAvailable(MultipleConformerResult[] res) {
        for (int i = 0; i < res.length; ++i) {
            if (res[i].isEnergyAvailable()) continue;
            return false;
        }
        return true;
    }

    public static boolean collectAllCoordAvailable(MultipleConformerResult[] res) {
        for (int i = 0; i < res.length; ++i) {
            if (res[i].isCoordinatesAvailable()) continue;
            return false;
        }
        return true;
    }
}

