/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.interfacing;

import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.CxnMoleculeInput;
import chemaxon.marvin.modelling.interfacing.MultipleConformerResult;

public class MultipleConformersResultImpl
extends MultipleConformerResult {
    private double[][][] coord = null;
    private double[] en = null;
    private int siz = -1;
    private double optl = -1.0;
    private CalculationInput in;
    private CalculationInput[] frags = null;
    private int[] atomToFrag = null;
    private boolean singleFrag = false;
    private int[] fragIndex = null;

    @Override
    public int size() {
        return this.siz;
    }

    @Override
    public double[][][] getCoordinates() {
        return this.coord;
    }

    @Override
    public double[] getEnergy() {
        return this.en;
    }

    @Override
    public double[][] getCoordinates(int conf) {
        return this.coord[conf];
    }

    @Override
    public double getEnergy(int conf) {
        return this.en[conf];
    }

    @Override
    public boolean isEnergyAvailable() {
        return this.en != null;
    }

    @Override
    public boolean isCoordinatesAvailable() {
        return this.coord != null;
    }

    @Override
    public double getOptLimit() {
        return this.optl;
    }

    @Override
    public int getAtomCount() {
        if (!this.isCoordinatesAvailable()) {
            return 0;
        }
        return this.getCoordinates(0).length;
    }

    @Override
    public void overrideEnergy(int conf, double e) {
        if (this.en == null && this.coord == null) {
            this.siz = 1;
            this.en = new double[1];
        } else if (this.en == null) {
            this.en = new double[this.siz];
        }
        this.en[conf] = e;
    }

    @Override
    public void overrideOptLimit(double l) {
        this.optl = l;
    }

    @Override
    public CalculationInput getInputDescriptor() {
        return this.in;
    }

    public void setFrags(MultipleConformerResult[] frags, int[] atomToFrag) {
        this.frags = frags;
        this.atomToFrag = atomToFrag;
    }

    @Override
    public CalculationInput[] findFrags() {
        if (this.frags == null) {
            return new CalculationInput[]{this};
        }
        return this.frags;
    }

    @Override
    public int[] getAtomToFrag() {
        return this.atomToFrag;
    }

    @Override
    public int[] getFragIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSingleFrag() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MultipleConformersResultImpl(CalculationInput in, double e) {
        this.siz = 1;
        this.en = new double[]{e};
        this.in = in;
    }

    public MultipleConformersResultImpl(CalculationInput in, double[][] c) {
        CxnMoleculeInput mi = (CxnMoleculeInput)in;
        if (mi.getAtomCount() != c.length) {
            throw new UnsupportedOperationException();
        }
        this.siz = 1;
        this.in = in;
        this.coord = new double[][][]{c};
    }

    public MultipleConformersResultImpl(CalculationInput in, double[][][] c) {
        CxnMoleculeInput mi = (CxnMoleculeInput)in;
        for (int i = 0; i < c.length; ++i) {
            if (mi.getAtomCount() == c[i].length) continue;
            throw new UnsupportedOperationException();
        }
        this.siz = c.length;
        this.in = in;
        this.coord = c;
    }

    public MultipleConformersResultImpl(CalculationInput in, double[][] c, double e) {
        CxnMoleculeInput mi = (CxnMoleculeInput)in;
        if (mi.getAtomCount() != c.length) {
            throw new UnsupportedOperationException();
        }
        this.siz = 1;
        this.in = in;
        this.coord = new double[][][]{c};
        this.en = new double[]{e};
    }

    public MultipleConformersResultImpl(CalculationInput in, double[][][] c, double[] e, int storedAtomCount, int storedConfCount) {
        int i;
        CxnMoleculeInput mi = (CxnMoleculeInput)in;
        if (mi.getAtomCount() != storedAtomCount) {
            throw new UnsupportedOperationException();
        }
        for (i = 0; i < c.length; ++i) {
            if (c[i].length >= storedAtomCount) continue;
            throw new UnsupportedOperationException();
        }
        if (c.length != e.length) {
            throw new UnsupportedOperationException();
        }
        this.siz = storedConfCount;
        this.in = in;
        this.coord = new double[storedConfCount][storedAtomCount][];
        this.en = new double[storedConfCount];
        for (i = 0; i < storedConfCount; ++i) {
            for (int j = 0; j < storedAtomCount; ++j) {
                this.coord[i][j] = c[i][j];
            }
            this.en[i] = e[i];
        }
    }

    public MultipleConformersResultImpl(CalculationInput in, double[][][] c, double[] e, int storedConfCount) {
        int i;
        CxnMoleculeInput mi = (CxnMoleculeInput)in;
        for (i = 0; i < c.length; ++i) {
            if (mi.getAtomCount() == c[i].length) continue;
            throw new UnsupportedOperationException();
        }
        if (c.length != e.length) {
            throw new UnsupportedOperationException();
        }
        this.siz = storedConfCount;
        this.in = in;
        this.coord = new double[storedConfCount][][];
        this.en = new double[storedConfCount];
        for (i = 0; i < storedConfCount; ++i) {
            this.coord[i] = c[i];
            this.en[i] = e[i];
        }
    }

    public MultipleConformersResultImpl(CalculationInput in, double[][][] c, double[] e) {
        CxnMoleculeInput mi = (CxnMoleculeInput)in;
        for (int i = 0; i < c.length; ++i) {
            if (mi.getAtomCount() == c[i].length) continue;
            throw new UnsupportedOperationException();
        }
        if (c.length != e.length) {
            throw new UnsupportedOperationException();
        }
        this.siz = c.length;
        this.in = in;
        this.coord = c;
        this.en = e;
    }

    public MultipleConformersResultImpl(CalculationInput in, double[] e) {
        this.siz = e.length;
        this.in = in;
        this.en = e;
    }
}

