/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.util.DoubleIntQuickSort;
import java.util.BitSet;

public class DIISInterpolation {
    private double zeroLimit = 1.0E-12;
    private int nComponentsMaxLimit = 0;
    private int nComponentsMinLimit = 0;
    private int nDimensionMaxLimit = 0;
    private double radiusLimit = 0.0;
    private double relativeRadiusLimit = 0.0;
    private int vectMaxLength = 0;
    private DIIS fullDIIS = null;
    private boolean useRadius = false;
    private BitSet except = null;

    public DIISInterpolation() {
    }

    public DIISInterpolation(double[][] subspaceVectors) {
        this.setSubspaceVectors(subspaceVectors);
    }

    private double[] getCenter(double[][] subspaceVectors, double[] center) {
        if (center == null) {
            center = new double[this.vectMaxLength];
        }
        int nVector = subspaceVectors.length;
        for (int i = 0; i < nVector; ++i) {
            center = JLinAlg.VectAdd(subspaceVectors[i], center, center);
        }
        center = JLinAlg.VectScale(center, 1.0 / (double)nVector, center);
        return center;
    }

    public double[] getCoefficients(double[] v) {
        return this.getCoefficients(v, null);
    }

    public double[] getCoefficients(double[] v, double[] c) {
        if (this.fullDIIS == null) {
            return null;
        }
        if (this.fullDIIS.differences == null) {
            this.fullDIIS.createSubspace(this.getCenter(this.fullDIIS.subspaceVectors, null));
        }
        return this.fullDIIS.getCoefficients(v, c);
    }

    public double getNComponentsMaxLimit() {
        return this.nComponentsMaxLimit;
    }

    public double getNComponentsMinLimit() {
        return this.nComponentsMinLimit;
    }

    public int getNDimensionMaxLimit() {
        return this.nDimensionMaxLimit;
    }

    public double getRadiusLimit() {
        return this.radiusLimit;
    }

    public double getRelativeRadiusLimit() {
        return this.relativeRadiusLimit;
    }

    public double[][] getSubspaceVectors() {
        if (this.fullDIIS == null) {
            return null;
        }
        return this.fullDIIS.subspaceVectors;
    }

    public double getZeroLimit() {
        return this.zeroLimit;
    }

    public boolean isUseRadius() {
        return this.useRadius;
    }

    public void setNComponentsMaxLimit(int componentsMaxLimit) {
        this.useRadius = true;
        this.nComponentsMaxLimit = componentsMaxLimit;
    }

    public void setNComponentsMinLimit(int componentsMinLimit) {
        this.useRadius = true;
        this.nComponentsMinLimit = componentsMinLimit;
    }

    public void setNDimensionMaxLimit(int dimensionMaxLimit) {
        this.nDimensionMaxLimit = dimensionMaxLimit;
    }

    public void setRadiusLimit(double radiusLimit) {
        this.useRadius = true;
        this.radiusLimit = radiusLimit;
    }

    public void setRelativeRadiusLimit(double relativeRadiusLimit) {
        this.useRadius = true;
        this.relativeRadiusLimit = relativeRadiusLimit;
    }

    public void setSubspaceVectors(double[][] subspaceVectors) {
        this.fullDIIS = new DIIS();
        this.vectMaxLength = 0;
        for (int i = 0; i < subspaceVectors.length; ++i) {
            if (subspaceVectors[i].length <= this.vectMaxLength) continue;
            this.vectMaxLength = subspaceVectors[i].length;
        }
        DIIS.access$902(this.fullDIIS, subspaceVectors);
    }

    public void setZeroLimit(double zeroLimit) {
        this.zeroLimit = zeroLimit;
    }

    public BitSet getExcept() {
        return this.except;
    }

    public void setExcept(BitSet except) {
        this.except = except;
    }

    private class DIIS {
        private double[][] subspaceVectors = null;
        private double[][] differences = null;
        private int centerIdx = -1;
        private int[] diffIndeces = null;
        private BitSet centerSet = null;
        private boolean checkLimits = false;

        private DIIS() {
        }

        private void createSubspace(double[] center) {
            int nVector = this.subspaceVectors.length;
            double minLen = Double.MAX_VALUE;
            for (int i = 0; i < nVector; ++i) {
                double d;
                if (DIISInterpolation.this.except != null && DIISInterpolation.this.except.get(i) || !((d = JLinAlg.VLength(JLinAlg.vectSubtract(center, this.subspaceVectors[i]))) < minLen)) continue;
                minLen = d;
                this.centerIdx = i;
            }
            boolean check = this.checkLimits && DIISInterpolation.this.useRadius;
            this.differences = new double[nVector - 1][];
            this.diffIndeces = new int[this.differences.length];
            this.centerSet = new BitSet(this.subspaceVectors.length);
            int j = 0;
            for (int i = 0; i < nVector; ++i) {
                if (i != this.centerIdx) {
                    this.differences[j] = JLinAlg.vectSubtract(this.subspaceVectors[i], center);
                    if (DIISInterpolation.this.except != null && DIISInterpolation.this.except.get(i)) continue;
                    this.diffIndeces[j] = i;
                    ++j;
                    continue;
                }
                this.centerSet.set(i);
            }
            int nC = j;
            if (check) {
                if (DIISInterpolation.this.nComponentsMaxLimit > 0) {
                    nC = Math.min(nC, DIISInterpolation.this.nComponentsMaxLimit - 1);
                }
                double[] diff = new double[j];
                for (int i = 0; i < diff.length; ++i) {
                    diff[i] = JLinAlg.VLength(this.differences[i]);
                }
                DoubleIntQuickSort diqs = new DoubleIntQuickSort(1, diff, this.diffIndeces);
                diqs.qsort();
                double radius = Math.max(DIISInterpolation.this.radiusLimit, diff[0] * DIISInterpolation.this.relativeRadiusLimit);
                int nRadiusOK = 0;
                for (int i = 0; i < nC; ++i) {
                    if (radius != 0.0 && !(diff[i] <= radius)) continue;
                    ++nRadiusOK;
                }
                nC = Math.min(nC, Math.max(nRadiusOK, DIISInterpolation.this.nComponentsMinLimit - 1));
            }
            j = 0;
            for (int i = 0; i < nC; ++i) {
                this.differences[j] = JLinAlg.vectSubtract(this.subspaceVectors[this.diffIndeces[i]], this.subspaceVectors[this.centerIdx]);
                if (JLinAlg.VDot(this.differences[j], this.differences[j]) <= DIISInterpolation.this.zeroLimit) {
                    this.centerSet.set(i);
                    continue;
                }
                if (DIISInterpolation.this.except != null && DIISInterpolation.this.except.get(i)) continue;
                this.diffIndeces[j] = this.diffIndeces[i];
                ++j;
            }
            nC = j;
            if (this.differences.length > nC) {
                double[][] tmpDiff = this.differences;
                int[] tmpDiffIdx = this.diffIndeces;
                this.differences = new double[nC][];
                this.diffIndeces = new int[nC];
                for (int i = 0; i < nC; ++i) {
                    this.differences[i] = tmpDiff[i];
                    this.diffIndeces[i] = tmpDiffIdx[i];
                }
            }
        }

        private double[] getCoefficients(double[] v, double[] c) {
            if (c == null) {
                c = new double[this.subspaceVectors.length];
            }
            double[] projectedV = JLinAlg.VLinComb(JLinAlg.mtVMultiply(new JLinAlg.Matrix(this.differences).getInverse(DIISInterpolation.this.zeroLimit), JLinAlg.vectSubtract(v, this.subspaceVectors[this.centerIdx])), this.differences, null);
            projectedV = JLinAlg.VectAdd(projectedV, this.subspaceVectors[this.centerIdx], projectedV);
            boolean check = DIISInterpolation.this.useRadius;
            if (check) {
                DIIS partialDIIS = new DIIS();
                partialDIIS.subspaceVectors = this.subspaceVectors;
                partialDIIS.checkLimits = true;
                partialDIIS.createSubspace(projectedV);
                c = partialDIIS.getSimpleCoefficients(v, c);
            } else {
                c = this.getSimpleCoefficients(v, c);
            }
            return c;
        }

        private double[] getSimpleCoefficients(double[] v, double[] c) {
            if (c == null) {
                c = new double[this.subspaceVectors.length];
            } else {
                JLinAlg.VectClear(c);
            }
            c[this.centerIdx] = 1.0;
            double[] dV = JLinAlg.vectSubtract(v, this.subspaceVectors[this.centerIdx]);
            System.err.println("Shortest metrid from center is " + JLinAlg.VDot(dV, dV) + " (" + DIISInterpolation.this.zeroLimit + ")");
            double eigenValueLimit = JLinAlg.VDot(dV, dV);
            if (JLinAlg.VDot(dV, dV) > DIISInterpolation.this.zeroLimit) {
                BitSet mType = new BitSet();
                mType.set(2);
                mType.set(1);
                JLinAlg.Matrix overlap = new JLinAlg.Matrix(this.differences.length, this.differences.length, mType);
                for (int i = 0; i < this.differences.length; ++i) {
                    for (int j = i; j < this.differences.length; ++j) {
                        overlap.setElement(i, j, JLinAlg.VDot(this.differences[i], this.differences[j]));
                    }
                }
                overlap.reDiagonalize(DIISInterpolation.this.zeroLimit);
                JLinAlg.SetRank(overlap, eigenValueLimit);
                double[] c0 = null;
                while (DIISInterpolation.this.nDimensionMaxLimit > 0 && overlap.nRank > DIISInterpolation.this.nDimensionMaxLimit) {
                    JLinAlg.SetRank(overlap, overlap.aEVa.getElement(0, 0), false);
                }
                double[] spVec = new double[this.differences.length];
                for (int i = 0; i < spVec.length; ++i) {
                    spVec[i] = JLinAlg.VDot(dV, this.differences[i]);
                }
                JLinAlg.Matrix oInverse = overlap.getInverse();
                c0 = JLinAlg.mVMultiply(oInverse, spVec);
                for (int i = 0; i < c0.length; ++i) {
                    c[this.diffIndeces[i]] = c0[i];
                    int n = this.centerIdx;
                    c[n] = c[n] - c0[i];
                }
            }
            int nCenter = this.centerSet.cardinality();
            System.err.println("Degree of 0D redundancy: " + nCenter);
            if (nCenter > 1) {
                double cc = c[this.centerIdx] / (double)nCenter;
                for (int i = 0; i < this.subspaceVectors.length; ++i) {
                    if (!this.centerSet.get(i)) continue;
                    c[i] = cc;
                }
            }
            return c;
        }

        static /* synthetic */ double[][] access$902(DIIS x0, double[][] x1) {
            x0.subspaceVectors = x1;
            return x1;
        }
    }
}

