/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.newmd.boundary.Monitor;
import chemaxon.marvin.modelling.newmd.boundary.MonitorI;
import chemaxon.marvin.modelling.util.U;
import java.util.BitSet;

public class EquationSequenceSolver {
    private JLinAlg.Matrix coeffMat = null;
    private JLinAlg.Matrix inverse = null;
    private boolean estimatedInitialInverse = true;
    private double convergenceLimit = 0.0;
    private double convergence = 1.0E-8;
    private int verboseLevel = 0;
    private int coeffRank = 0;
    private MonitorI numericMonitor = null;
    private Monitor analyticMonitor = null;

    public double[] solve(double[] y) {
        return this.solve(y, (double[])null);
    }

    public double[] solve(double[] y, double[] x) {
        if (!U.isDoubleOK(y)) {
            ErrPrint.errPrint("NaN got in solve: ", y);
        }
        int vLevel = this.verboseLevel;
        this.convergenceLimit = JLinAlg.VLength(y) * 1.0E-6;
        if (this.coeffMat == null) {
            throw new UnsupportedOperationException("Coefficient matrix has not been set in EquationSequenceSolver.solve().");
        }
        if (this.inverse != null && this.inverse.nRows != this.coeffMat.nRows) {
            this.inverse = null;
        }
        if (x == null) {
            x = new double[this.coeffMat.nCols];
        }
        double[] xTmp = new double[y.length];
        double[] x0Tmp = new double[y.length];
        double[] deltaY = new double[y.length];
        double[] deltaY0 = new double[y.length];
        double[] deltaXTmp = new double[y.length];
        double[] deltaYTmp = new double[y.length];
        double[] deltaXRef = new double[y.length];
        double[] deltaYRef = new double[y.length];
        boolean newInverse = false;
        if (this.inverse == null) {
            newInverse = true;
            if (this.analyticMonitor != null) {
                this.analyticMonitor.start();
            }
            BitSet mType = new BitSet();
            mType.set(2);
            mType.set(1);
            this.inverse = new JLinAlg.Matrix(this.coeffMat.nRows, this.coeffMat.nRows, mType);
            System.err.println("Set up new inverse of size: " + this.coeffMat.nRows);
            if (this.estimatedInitialInverse) {
                for (int i = 0; i < this.inverse.nRows; ++i) {
                    double d = this.coeffMat.rowDot(i, i);
                    d = Math.abs(d) > this.inverse.zeroLimit ? 1.0 / d : 0.0;
                    this.inverse.setElement(i, i, d);
                }
            } else {
                JLinAlg.Matrix mMt = new JLinAlg.Matrix(this.coeffMat.nRows, this.coeffMat.nRows, mType);
                JLinAlg.mMtMultiply(this.coeffMat, this.coeffMat, mMt);
                mMt.zeroLimit = 1.0E-12;
                JLinAlg.Matrix mMtInverse = mMt.getInverse();
                this.setCoeffRank(mMt.nRank);
                for (int i = 0; i < this.inverse.nRows; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        this.inverse.setElement(i, j, mMtInverse.getElement(i, j));
                    }
                }
                xTmp = JLinAlg.mVMultiply(this.inverse, y, xTmp);
                this.inverse.zeroLimit = 1.0E-20;
                if (this.analyticMonitor != null) {
                    this.analyticMonitor.stop();
                }
                x0Tmp = JLinAlg.mVMultiply(mMt, xTmp, x0Tmp);
                deltaXTmp = JLinAlg.mtVMultiply(this.coeffMat, JLinAlg.vectSubtract(y, x0Tmp), x);
                double[] ret = JLinAlg.mtVMultiply(this.coeffMat, xTmp, x);
                return ret;
            }
        }
        deltaY = JLinAlg.VectCopy(y, deltaY);
        if (this.numericMonitor != null) {
            this.numericMonitor.start();
        }
        int iCycle = 0;
        do {
            double sigma;
            vLevel = this.verboseLevel;
            deltaXTmp = JLinAlg.mVMultiply(this.inverse, deltaY, deltaXTmp);
            deltaYTmp = JLinAlg.mVMultiply(this.coeffMat, JLinAlg.mtVMultiply(this.coeffMat, deltaXTmp), deltaYTmp);
            double sigma0 = sigma = JLinAlg.VDot(deltaY, deltaYTmp) / JLinAlg.VDot(deltaYTmp, deltaYTmp);
            if (Math.abs(sigma) < 0.001) {
                ++vLevel;
                JLinAlg.VectScaleAndAdd(xTmp, sigma, deltaXTmp, x0Tmp);
                deltaY0 = JLinAlg.vectSubtract(y, JLinAlg.mVMultiply(this.coeffMat, JLinAlg.mtVMultiply(this.coeffMat, x0Tmp), deltaYTmp), deltaY0);
                JLinAlg.VectCopy(deltaY, deltaXRef);
                deltaYRef = JLinAlg.mVMultiply(this.coeffMat, JLinAlg.mtVMultiply(this.coeffMat, deltaXRef), deltaYRef);
                sigma = JLinAlg.VDot(deltaY, deltaYRef) / JLinAlg.VDot(deltaYRef, deltaYRef);
                JLinAlg.VectCopy(deltaXRef, deltaXTmp);
            }
            JLinAlg.VectScaleAndAdd(xTmp, sigma, deltaXTmp, xTmp);
            this.inverse = EquationSequenceSolver.updateSR1(deltaYTmp, deltaXTmp, this.inverse);
            deltaY = JLinAlg.vectSubtract(y, JLinAlg.mVMultiply(this.coeffMat, JLinAlg.mtVMultiply(this.coeffMat, xTmp), deltaYTmp), deltaY);
            ++iCycle;
            if (this.verboseLevel > 0) {
                System.err.println("Solver:\t" + iCycle + "\t" + JLinAlg.VLength(deltaY) + " >\t" + this.convergenceLimit + "\t" + sigma0 + "\t" + sigma);
            }
            if (iCycle > y.length * 10) {
                System.err.println("Solver is about to give up. We use analytic inverse for now.");
                if (this.numericMonitor != null) {
                    this.numericMonitor.stop(iCycle);
                }
                if (this.analyticMonitor != null) {
                    this.analyticMonitor.start();
                }
                BitSet mType = new BitSet();
                mType.set(2);
                mType.set(1);
                this.inverse = new JLinAlg.Matrix(this.coeffMat.nRows, this.coeffMat.nRows, mType);
                JLinAlg.Matrix mMt = new JLinAlg.Matrix(this.coeffMat.nRows, this.coeffMat.nRows, mType);
                System.err.println("Set up new inverse of size: " + this.coeffMat.nRows);
                JLinAlg.mMtMultiply(this.coeffMat, this.coeffMat, mMt);
                mMt.zeroLimit = 1.0E-12;
                JLinAlg.Matrix mMtInverse = mMt.getInverse();
                this.setCoeffRank(mMt.nRank);
                for (int i = 0; i < this.inverse.nRows; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        this.inverse.setElement(i, j, mMtInverse.getElement(i, j));
                    }
                }
                xTmp = JLinAlg.mVMultiply(this.inverse, y, xTmp);
                this.inverse.zeroLimit = 1.0E-20;
                if (this.analyticMonitor != null) {
                    this.analyticMonitor.stop();
                }
                System.err.println("Analytic inverse is ready to use. ");
                x0Tmp = JLinAlg.mVMultiply(mMt, xTmp, x0Tmp);
                deltaXTmp = JLinAlg.mtVMultiply(this.coeffMat, JLinAlg.vectSubtract(y, x0Tmp), x);
                double[] ret = JLinAlg.mtVMultiply(this.coeffMat, xTmp, x);
                return ret;
            }
            if (iCycle % 1000 != 0) continue;
            System.err.println("Solver:\t" + iCycle + "\t" + JLinAlg.VLength(deltaY) + "\t" + this.convergenceLimit);
        } while (JLinAlg.VLength(deltaY) > this.convergenceLimit);
        if (this.numericMonitor != null) {
            this.numericMonitor.stop(iCycle);
        }
        if (iCycle > 100) {
            System.err.println();
            System.err.println("Solver:\t" + iCycle + "\t" + JLinAlg.VLength(deltaY) + "\t" + this.convergenceLimit);
        }
        x0Tmp = JLinAlg.mtVMultiply(this.coeffMat, xTmp, x);
        deltaXTmp = JLinAlg.mtVMultiply(this.coeffMat, JLinAlg.vectSubtract(y, JLinAlg.mVMultiply(this.coeffMat, x0Tmp), x));
        double[] ret = JLinAlg.mtVMultiply(this.coeffMat, xTmp, x);
        return ret;
    }

    public static JLinAlg.Matrix updateSR1(double[] x, double[] y, JLinAlg.Matrix a) {
        double d;
        double[] e = JLinAlg.vectSubtract(y, JLinAlg.mVMultiply(a, x));
        if (e.length > a.nRows) {
            System.err.println("Size mismatch in SR1.");
        }
        if (Math.abs(d = JLinAlg.VDot(e, x)) < a.zeroLimit) {
            return a;
        }
        for (int i = 0; i < e.length; ++i) {
            for (int j = 0; j <= i; ++j) {
                if (i >= a.nRows || j >= a.nCols) continue;
                double aij = a.getElement(i, j);
                a.setElement(i, j, aij + e[i] * e[j] / d);
            }
        }
        return a;
    }

    public double[] solve(JLinAlg.Matrix a, double[] y) {
        this.setCoeffMat(a);
        return this.solve(y);
    }

    public double[] solve(JLinAlg.Matrix a, double[] x, double[] y) {
        this.setCoeffMat(a);
        return this.solve(y, x);
    }

    public JLinAlg.Matrix getCoeffMat() {
        return this.coeffMat;
    }

    public void setCoeffMat(JLinAlg.Matrix coeffMat) {
        this.coeffMat = coeffMat;
    }

    public JLinAlg.Matrix getInverse() {
        return this.inverse;
    }

    public void setInverse(JLinAlg.Matrix inverse) {
        this.inverse = inverse;
    }

    public boolean isEstimatedInitialInverse() {
        return this.estimatedInitialInverse;
    }

    public void setEstimatedInitialInverse(boolean estimatedInitialInverse) {
        this.estimatedInitialInverse = estimatedInitialInverse;
    }

    public void setConvergence(double convergence) {
        this.convergence = convergence;
    }

    public double getConvergence() {
        return this.convergence;
    }

    public int getCoeffRank() {
        return this.coeffRank;
    }

    private void setCoeffRank(int coeffRank) {
        this.coeffRank = coeffRank;
    }

    public MonitorI getNumericMonitor() {
        return this.numericMonitor;
    }

    public void setNumericMonitor(MonitorI numericMonitor) {
        this.numericMonitor = numericMonitor;
    }

    public Monitor getAnalyticMonitor() {
        return this.analyticMonitor;
    }

    public void setAnalyticMonitor(Monitor analyticMonitor) {
        this.analyticMonitor = analyticMonitor;
    }
}

