/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.calculations.clean.Opt3D;
import chemaxon.formats.MolExporter;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import java.io.FileOutputStream;

public class FunctionAdapter
implements GradientOptimization.FunctionToMinimize {
    private static FileOutputStream molOut = null;
    private static MolExporter mExporter = null;
    myMolecule myMol = null;
    Molecule mol = null;
    Opt3D.Dreiding dr = null;
    boolean energyValid = false;
    boolean gradientValid = false;
    double scale = 0.0015936001019904065;
    double[] v = null;
    double[] g = null;
    double e = 0.0;
    int varsize;
    SimpleCanceller canceller = null;

    @Override
    public boolean isCancelled() {
        if (this.dr.getCorrupted()) {
            return true;
        }
        if (this.canceller == null) {
            return false;
        }
        return this.canceller.isCancelled();
    }

    public void setCanceller(SimpleCanceller c) {
        this.canceller = c;
    }

    public Molecule updateMolecule() {
        if (this.mol == null) {
            this.mol = this.myMol.getOriginalMolCopy();
        }
        this.mol.setDim(3);
        for (int i = 0; i < this.myMol.a; ++i) {
            MolAtom a = this.mol.getAtom(i);
            a.setXYZ(this.myMol.coord[i][0], this.myMol.coord[i][1], this.myMol.coord[i][2]);
        }
        return this.mol;
    }

    public myMolecule getMyMol() {
        return this.myMol;
    }

    public void invalidate() {
        this.energyValid = false;
        this.gradientValid = false;
    }

    public FunctionAdapter(myMolecule m) {
        this.myMol = m;
        this.varsize = this.myMol.a * 3;
        this.dr = new Opt3D.Dreiding(this.myMol, null);
        this.g = new double[this.varsize];
        this.v = new double[this.varsize];
    }

    public FunctionAdapter(Molecule m) {
        this.mol = m;
        SelectionMolecule sm = new SelectionMolecule();
        m.clonecopy(sm);
        this.myMol = new myMolecule(sm, null, null);
        this.varsize = this.myMol.a * 3;
        this.dr = new Opt3D.Dreiding(this.myMol, null);
        this.g = new double[this.varsize];
        this.v = new double[this.varsize];
    }

    @Override
    public double[] getVariables() {
        int j = 0;
        for (int i = 0; i < this.myMol.a; ++i) {
            for (int k = 0; k < 3; ++k) {
                this.v[j++] = this.myMol.coord[i][k];
            }
        }
        return this.v;
    }

    @Override
    public double getFunctionValue() {
        if (!this.energyValid) {
            this.e = this.dr.getEnergy(true);
            this.energyValid = true;
        }
        return this.e * this.scale;
    }

    @Override
    public double[] getFunctionGradient() {
        if (!this.gradientValid) {
            this.getFunctionValue();
            for (int il = 0; il < this.myMol.a; ++il) {
                for (int jl = 0; jl < 3; ++jl) {
                    int k = il * 3 + jl;
                    double[][] drd = this.dr.getDeriv();
                    this.g[k] = drd[il][jl] * this.scale;
                }
            }
            this.gradientValid = true;
        }
        return this.g;
    }

    public void clearDreidingCorrupted() {
        this.dr.clearCorrupted();
    }

    @Override
    public boolean setVariables(double[] var) {
        if (var.length != this.varsize) {
            throw new IndexOutOfBoundsException("Variable size mismatch");
        }
        this.energyValid = false;
        this.gradientValid = false;
        int j = 0;
        for (int i = 0; i < this.myMol.a; ++i) {
            for (int k = 0; k < 3; ++k) {
                this.myMol.coord[i][k] = var[j++];
            }
        }
        return true;
    }

    @Override
    public void print() {
        this.print(null);
    }

    @Override
    public void print(String msg) {
        String fileName = "optimizationDebug.sdf";
        System.err.println("Appending molecule to \"" + fileName + "\".");
        try {
            if (molOut == null) {
                molOut = new FileOutputStream(fileName, true);
                mExporter = new MolExporter(molOut, "sdf");
            }
            Molecule mol = myMolecule.constructMolecule(this.myMol);
            mol.setProperty("CLEAN3D.TIMESTAMP", CleanArgs.getFormattedElapsedTime());
            if (msg != null) {
                mol.setProperty("CLEAN3D.OPTMSG", msg);
            }
            mExporter.write(mol);
            molOut.close();
            molOut = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

