/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.TextUtils;
import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.internals.ChangeCorrector;
import chemaxon.marvin.modelling.util.U;
import java.util.BitSet;

public class GradientOptimization {
    private final double gold = 1.0 + Math.sqrt(5.0) / 2.0;
    private int verboseLevel = 0;
    private VerbosePrinter verbose = null;
    private double steepestDescentScaleFactor = 1.0;
    private boolean steepestDescent = true;
    private boolean conjugateGradient = true;
    private boolean fullAutomaticAlgorithm = false;
    private boolean quasyNewtonBFGS = false;
    private boolean rationalFunctionOptimization = false;
    private boolean linearSearch = true;
    private boolean multiDimensionalSearch = false;
    private boolean forcedMinimization = true;
    private FunctionToMinimize function = null;
    private double searchGradientCosLimit = 0.1;
    private double finishGradientRMSLimit = 1.0E-4;
    private double stopAtGradientMax = 1.0E-8;
    private double gradientRMSLimit = 1.0E-8;
    private double maxLimitFactor = 4.0;
    private double maxStepComponent = 0.0;
    private double stepLimitFactor = 3.0;
    private double stepRMSLimit = 0.1;
    private double smallOverlapLimit = 1.0E-7;
    private double noEnergyDifference = 1.0E-10;
    private double eigenValueLimit = 1.0E-4;
    private int storageSizeLimit = 8;
    private int numberOfSteps = 0;
    private int numberOfInnerSteps = 0;
    private int numberOfOuterSteps = 0;
    private int maxNumberOfOuterSteps = 5000;
    private int maxNumberOfInnerSteps = 100;
    private int maxNumberOfSearchFails = 5;
    private int numberOfSearchFails = 0;
    private boolean continueOptimization = false;
    private double[] gradient = null;
    private double[] variables = null;
    private double fValue = Double.POSITIVE_INFINITY;
    private double[] tmpGradient = null;
    private double[] tmpVariables = null;
    private double tmpValue = Double.POSITIVE_INFINITY;
    private double[] step = null;
    private HistoryStorage combinedHistory = null;
    private HistoryStorage outerHistory = null;
    private double[][] projectedSteps = null;
    private double[][] projectedGradientChanges = null;
    private double[] projectedGradient = null;
    private Storage bestSearchPoint = null;
    private boolean searchActive = false;
    private boolean searchFailed = false;
    private boolean searchConverged = false;
    private boolean negativeEigenvalue = false;
    private boolean doGDIIS = false;
    private boolean optimizationConverged = false;
    private boolean useStepCriteria = true;
    private ChangeCorrector cc = new Corr();

    public GradientOptimization() {
        this.verbose = new VerbosePrinterImplementation();
    }

    public GradientOptimization(FunctionToMinimize function) {
        this.verbose = new VerbosePrinterImplementation();
        this.function = function;
    }

    public boolean continueRun() throws GradientOptimizationException {
        int origMaxNumberOfOuterSteps = this.maxNumberOfOuterSteps;
        if (this.numberOfOuterSteps > 0) {
            this.maxNumberOfOuterSteps = Math.max(this.maxNumberOfOuterSteps, 1);
            while (this.maxNumberOfOuterSteps <= this.numberOfOuterSteps) {
                this.maxNumberOfOuterSteps += Math.max(origMaxNumberOfOuterSteps, 1);
            }
            if (this.verboseLevel > 0) {
                this.verbose.println("Continue optimization, change limit for number of outer steps to: " + this.maxNumberOfOuterSteps);
            }
            this.continueOptimization = true;
        }
        boolean ok = this.run();
        this.maxNumberOfOuterSteps = origMaxNumberOfOuterSteps;
        this.continueOptimization = false;
        return ok;
    }

    public boolean run() throws GradientOptimizationException {
        if (this.verboseLevel > 3) {
            this.verbose.println("GradientOptimization.run()");
        }
        if (!this.continueOptimization) {
            if (this.verboseLevel > 3) {
                this.verbose.println("!continueOptimization");
            }
            if (this.outerHistory != null) {
                this.outerHistory.setStorageSize(0);
            }
            if (this.combinedHistory != null) {
                this.combinedHistory.setStorageSize(0);
            }
            this.bestSearchPoint = null;
            this.searchActive = false;
            this.searchConverged = false;
            this.searchFailed = false;
            this.numberOfInnerSteps = 0;
            this.numberOfSteps = 0;
            this.numberOfOuterSteps = 0;
            this.numberOfSearchFails = 0;
            this.negativeEigenvalue = false;
            this.doGDIIS = false;
            this.optimizationConverged = false;
            if (this.verboseLevel > 0) {
                this.function.print("Method run()");
            }
        }
        if (this.function == null) {
            throw new GradientOptimizationException("Function interface has not bee initialized");
        }
        boolean convergenceOK = false;
        boolean loop = true;
        do {
            if (this.verboseLevel > 3) {
                this.verbose.println("do { ...");
            }
            if (this.function.isCancelled()) {
                if (this.verboseLevel > 3) {
                    this.verbose.println("function.isCancelled() ... ");
                }
                return false;
            }
            if (this.verboseLevel > 3) {
                this.verbose.println("call getVariables()");
            }
            this.variables = this.function.getVariables();
            if (this.verboseLevel > 3) {
                this.verbose.println("variables: " + U.sel(this.variables));
                this.verbose.println("call getFunctionGradient()");
            }
            this.gradient = this.function.getFunctionGradient();
            if (this.verboseLevel > 3) {
                this.verbose.println("variables: " + U.sel(this.variables));
                this.verbose.println("gradient: " + U.sel(this.gradient));
                this.verbose.println("call getFunctionValue()");
            }
            this.fValue = this.function.getFunctionValue();
            if (this.verboseLevel > 3) {
                this.verbose.println("variables: " + U.sel(this.variables));
                this.verbose.println("gradient:  " + U.sel(this.gradient));
                this.verbose.println("fValue:    " + this.fValue);
            }
            if (Double.isNaN(this.fValue)) {
                if (this.verboseLevel > 0) {
                    this.verbose.println("fValue is NaN");
                    this.function.print("fValue is NaN");
                }
                return false;
            }
            if (this.verboseLevel > 3) {
                System.err.println("Gradient RMS is: " + JLinAlg.VectRMS(this.gradient));
                this.function.print("Gradient RMS is: " + JLinAlg.VectRMS(this.gradient));
            }
            this.step = this.doStep(this.variables, this.gradient, this.fValue, this.step);
            if (this.verboseLevel > 3) {
                ErrPrint.errPrint("Step:", this.step);
            }
            if (!(convergenceOK = this.isOptimizationConverged())) {
                this.function.setVariables(JLinAlg.VectAdd(this.variables, this.step, this.variables));
            }
            if (this.numberOfInnerSteps == 0 && this.function.isCancelled()) {
                if (this.verboseLevel > 0) {
                    this.function.print("isOptimizationConverged(): " + this.isOptimizationConverged());
                }
                return this.isOptimizationConverged();
            }
            boolean bl = loop = !(this.numberOfOuterSteps >= this.maxNumberOfOuterSteps && this.numberOfInnerSteps <= 0 || convergenceOK || JLinAlg.VectRMS(this.step) == 0.0 && !this.gradientConverged(this.gradient));
            if (this.numberOfOuterSteps <= 2) continue;
            boolean bl2 = loop = loop && this.outerHistory.storageSize > 1;
        } while (loop);
        if (this.verboseLevel == 1) {
            this.printSummaryLine();
        }
        if (this.verboseLevel > 0) {
            this.verbose.println("Converged: " + convergenceOK);
            this.function.print("Converged: " + convergenceOK);
        }
        return convergenceOK;
    }

    public double[] doStep(double[] variables, double[] gradient, double functionValue) {
        return this.doStep(variables, gradient, functionValue, null);
    }

    public double[] doStep(double[] variables, double[] gradient, double functionValue, double[] step) {
        if (step == null) {
            if (this.step == null) {
                this.step = new double[variables.length];
            }
            step = this.step;
        }
        if (this.step != step) {
            this.step = step;
        }
        JLinAlg.VectClear(step);
        if (this.combinedHistory == null) {
            int len = variables.length;
            this.combinedHistory = new HistoryStorage(this.storageSizeLimit, len);
            this.outerHistory = new HistoryStorage(2, len);
        }
        if (!this.store(this.combinedHistory, variables, gradient, functionValue)) {
            return step;
        }
        if (JLinAlg.VectMaxComponent(gradient, true) <= this.stopAtGradientMax && this.numberOfInnerSteps == 0) {
            this.optimizationConverged = true;
            this.searchActive = false;
            this.resetStorage();
            JLinAlg.VectClear(step);
            if (this.verboseLevel > 3) {
                this.function.print();
            }
            if (this.verboseLevel > 1) {
                System.err.println("Convergence because gradient reached hard gradient limit: " + this.stopAtGradientMax);
            }
            if (this.verboseLevel > 1) {
                this.printSummaryLine();
            }
            return step;
        }
        this.negativeEigenvalue = false;
        if (this.combinedHistory.storageSize < 2 && this.searchActive) {
            if (this.verboseLevel > 3) {
                this.verbose.println("Subspace collapsed...");
                this.numericSecondDerivatives();
                if (this.function != null) {
                    this.function.print();
                }
            }
            this.searchActive = false;
        }
        this.gradient = gradient;
        this.variables = variables;
        this.fValue = functionValue;
        this.searchFailed = false;
        this.searchConverged = false;
        if (this.searchActive) {
            if (this.searchActive && this.verboseLevel > 3) {
                this.printSummaryLine();
            }
            this.multiDimensionalSearch(this.combinedHistory);
            if (this.searchActive && this.verboseLevel > 3) {
                this.printSummaryLine();
            }
            ++this.numberOfInnerSteps;
            boolean bl = this.searchFailed = this.searchFailed || this.searchActive && this.numberOfInnerSteps >= this.maxNumberOfInnerSteps || !this.searchConverged && JLinAlg.VectRMS(step) == 0.0;
            if (this.searchFailed) {
                ++this.numberOfSearchFails;
                if (this.numberOfSearchFails > this.maxNumberOfSearchFails) {
                    JLinAlg.VectClear(step);
                    return step;
                }
                if (this.verboseLevel > 3) {
                    this.verbose.println("Search failed, use best point.");
                }
                this.searchActive = false;
                this.tmpVariables = this.bestSearchPoint.variables;
                this.tmpGradient = this.bestSearchPoint.gradient;
                JLinAlg.VectClear(step);
                this.tmpValue = this.bestSearchPoint.fValue;
                if (!this.finish()) {
                    if (this.verboseLevel > 3) {
                        this.verbose.println("Search failed, not in final stage, reset storage.");
                    }
                    this.resetStorage();
                    this.store(this.combinedHistory, this.tmpVariables, this.tmpGradient, this.tmpValue);
                }
            } else if (this.searchConverged) {
                this.numberOfSearchFails = 0;
            }
        }
        if (!this.searchActive) {
            boolean storeOK = false;
            storeOK = this.searchFailed ? this.store(this.outerHistory, this.tmpVariables, this.tmpGradient, functionValue) : this.store(this.outerHistory, variables, gradient, functionValue);
            if (!storeOK) {
                return step;
            }
            if (!this.rationalFunctionOptimization && !this.quasyNewtonBFGS) {
                if (this.conjugateGradient) {
                    this.conjugateGradientStep(this.outerHistory, step);
                } else {
                    this.steepestDescentStep(this.outerHistory.gStorage[0], step);
                    this.controlStepSize(step);
                }
            }
        }
        JLinAlg.VectAdd(this.cc.correct(JLinAlg.vectSubtract(this.combinedHistory.xStorage[0], variables)), step, step);
        ++this.numberOfSteps;
        this.setStepControl();
        if (this.verboseLevel > 2 && this.numberOfSteps > 0 && !this.searchFailed && !this.searchConverged) {
            this.printSummaryLine();
        }
        if (!this.searchActive) {
            ++this.numberOfOuterSteps;
            if (this.outerHistory.storageSize > 1) {
                boolean bl = this.optimizationConverged = this.converged(gradient, this.cc.correct(JLinAlg.vectSubtract(this.outerHistory.xStorage[0], this.outerHistory.xStorage[1]))) && !this.searchFailed && !this.negativeEigenvalue;
                if (this.verboseLevel > 3) {
                    this.verbose.println("Convergence: " + this.converged(gradient, this.cc.correct(JLinAlg.vectSubtract(this.outerHistory.xStorage[0], this.outerHistory.xStorage[1]))) + " " + this.searchFailed);
                }
            }
            if (this.verboseLevel > 1) {
                this.printSummaryLine();
            }
            this.numberOfInnerSteps = 0;
            boolean bl = this.searchActive = !this.optimizationConverged;
        }
        if (this.step != step) {
            JLinAlg.VectCopy(step, this.step);
        }
        return step;
    }

    private void multiDimensionalSearch(HistoryStorage hS) {
        boolean badCurviture;
        double lambda;
        double lowestEigenValue;
        this.doGDIIS = false;
        double lambdaLimit = 0.0;
        if (this.bestSearchPoint == null) {
            this.bestSearchPoint = this.getStorageItem(hS, 0);
        }
        if (this.numberOfSteps == 0) {
            this.bestSearchPoint = this.getStorageItem(hS, 1);
        }
        if (!this.forcedMinimization || hS.valStorage[0] < this.bestSearchPoint.fValue + this.noEnergyDifference) {
            Storage s = this.getStorageItem(hS, 0);
            s.fValue = Math.min(this.bestSearchPoint.fValue, s.fValue);
            this.bestSearchPoint = s;
        } else if (this.numberOfInnerSteps > 13 && this.stepRMSLimit < 1.0E-6 * JLinAlg.VectRMS(this.bestSearchPoint.gradient)) {
            this.searchConverged = false;
            this.searchFailed = true;
            if (this.verboseLevel > 3) {
                this.verbose.println(" Too small step limit, search failed.");
            }
            return;
        }
        int nStoredSteps = hS.storageSize - 1;
        this.projectedSteps = new double[nStoredSteps][];
        this.projectedGradientChanges = new double[nStoredSteps][];
        for (int i = 0; i < nStoredSteps; ++i) {
            this.projectedSteps[i] = hS.subspaceBasis.getComponents(this.cc.correct(JLinAlg.vectSubtract(hS.xStorage[i + 1], hS.xStorage[0])), this.projectedSteps[i]);
            this.projectedGradientChanges[i] = hS.subspaceBasis.getComponents(this.cc.correct(JLinAlg.vectSubtract(hS.gStorage[i + 1], hS.gStorage[0])), this.projectedGradientChanges[i]);
        }
        double sScale = 1.0 / Math.sqrt(JLinAlg.VLength(this.projectedSteps[0]));
        for (int i = 0; i < nStoredSteps; ++i) {
            JLinAlg.VectScale(this.projectedSteps[i], sScale, this.projectedSteps[i]);
            JLinAlg.VectScale(this.projectedGradientChanges[i], sScale, this.projectedGradientChanges[i]);
        }
        this.projectedGradient = hS.subspaceBasis.getComponents(hS.gStorage[0], null);
        double pLen = Math.sqrt(JLinAlg.VDot(this.projectedGradient, this.projectedGradient));
        double gLen = Math.sqrt(JLinAlg.VDot(hS.gStorage[0], hS.gStorage[0]));
        double gCos = pLen / gLen;
        if (this.verboseLevel > 3) {
            this.verbose.println("multidimensionalSearch gradient cosine:" + gCos);
            this.verbose.println("Curviture check: " + hS.valStorage[0] + " best: " + this.bestSearchPoint.fValue);
        }
        if (this.fValue == this.bestSearchPoint.fValue || !this.forcedMinimization) {
            this.searchConverged = true;
        }
        JLinAlg.Matrix dGtdX = new JLinAlg.Matrix(nStoredSteps, nStoredSteps);
        for (int i = 0; i < nStoredSteps; ++i) {
            for (int j = 0; j < nStoredSteps; ++j) {
                dGtdX.setElement(i, j, JLinAlg.VDot(this.projectedGradientChanges[i], this.projectedSteps[j]));
            }
        }
        JLinAlg.Matrix dXt = new JLinAlg.Matrix(this.projectedSteps);
        JLinAlg.Matrix dXti = dXt.getInverse();
        JLinAlg.Matrix dGtdXdXi = JLinAlg.mMtMultiply(dGtdX, dXti);
        JLinAlg.Matrix subSpaceHessian = JLinAlg.mMMultiply(dXti, dGtdXdXi);
        subSpaceHessian.diagonalize(0.0, Double.MIN_VALUE);
        if (this.verboseLevel > 3) {
            this.verbose.println("Check Hessian symmetry:");
        }
        for (int i = 0; i < subSpaceHessian.nRank; ++i) {
            double o = JLinAlg.VDot(subSpaceHessian.aLEV, i, subSpaceHessian.aREV, i);
            if (this.verboseLevel > 3) {
                this.verbose.print(" " + o);
            }
            if (!(o < 0.98)) continue;
            if (hS.storageSize > 2) {
                if (this.verboseLevel > 3) {
                    this.verbose.println(" Too large assymetric deviation, reduce storage.");
                }
                hS.setStorageSize(hS.storageSize - 1);
                this.multiDimensionalSearch(hS);
                return;
            }
            this.searchConverged = false;
            this.searchFailed = true;
            if (this.verboseLevel > 3) {
                this.verbose.println(" Too large assymetric deviation, search failed.");
            }
            return;
        }
        if (this.verboseLevel > 3) {
            this.verbose.println();
        }
        if (this.verboseLevel > 3) {
            ErrPrint.errPrint("EigenValues:", subSpaceHessian.aEVa.aVec);
        }
        if ((lowestEigenValue = subSpaceHessian.aEVa.getElement(0, 0)) <= 0.0) {
            if (this.verboseLevel > 3) {
                this.verbose.println(" Negative eigenvalue...");
            }
            if (hS.storageSize > 2) {
                if (this.verboseLevel > 3) {
                    this.verbose.println(" Too low eigenvalue, reduce storage.");
                }
                hS.setStorageSize(hS.storageSize - 1);
                this.multiDimensionalSearch(hS);
                return;
            }
            lambdaLimit = Math.max(-lowestEigenValue + this.eigenValueLimit, lambdaLimit);
        }
        this.negativeEigenvalue = lowestEigenValue < 0.0;
        boolean bl = this.searchConverged = this.searchConverged && (!this.negativeEigenvalue || gCos <= this.searchGradientCosLimit);
        if (this.doGDIIS) {
            double[][] dG = new double[hS.storageSize - 1][];
            double[] spVec = new double[dG.length];
            for (int i = 1; i < hS.storageSize; ++i) {
                dG[i - 1] = this.cc.correct(JLinAlg.vectSubtract(hS.gStorage[i], hS.gStorage[0]));
                spVec[i - 1] = JLinAlg.VDot(dG[i - 1], hS.gStorage[0]);
            }
            BitSet mType = new BitSet();
            mType.set(2);
            mType.set(1);
            JLinAlg.Matrix o = new JLinAlg.Matrix(spVec.length, spVec.length, mType);
            for (int i = 0; i < spVec.length; ++i) {
                for (int j = i; j < spVec.length; ++j) {
                    o.setElement(i, j, JLinAlg.VDot(dG[i], dG[j]));
                }
            }
            double[] c0 = JLinAlg.mVMultiply(o.getInverse(), spVec);
            double[] c = new double[hS.storageSize];
            c[0] = 1.0;
            for (int i = 1; i < c.length; ++i) {
                c[i] = -c0[i - 1];
                c[0] = c[0] + c0[i - 1];
            }
            if (this.verboseLevel > 3) {
                ErrPrint.errPrint("GDIIS coefficients:", c);
            }
            this.tmpGradient = JLinAlg.VLinComb(c, hS.gStorage, null);
            this.tmpVariables = JLinAlg.VLinComb(c, hS.xStorage, null);
            this.tmpValue = hS.valStorage[0];
            this.step = JLinAlg.VectAdd(this.cc.correct(JLinAlg.vectSubtract(this.tmpVariables, hS.xStorage[0])), this.step);
            this.controlStepSize(this.step);
            this.searchActive = !this.searchConverged && !this.searchFailed;
            return;
        }
        double[] originalEigenValues = JLinAlg.VectCopy(subSpaceHessian.aEVa.aVec);
        boolean lambdaConverged = false;
        double oldLambda = lambda = Math.max(gLen * gLen, lambdaLimit);
        double[] projectedStep = null;
        int cycRFO = 0;
        double[] tmpStep = new double[this.step.length];
        boolean bl2 = badCurviture = originalEigenValues[0] <= 0.0;
        while (!lambdaConverged && cycRFO < 100) {
            int i;
            ++cycRFO;
            for (i = 0; i < originalEigenValues.length; ++i) {
                subSpaceHessian.aEVa.aVec[i] = originalEigenValues[i] + lambda;
                subSpaceHessian.aEVa.aVec[i] = Math.max(subSpaceHessian.aEVa.aVec[i], this.eigenValueLimit);
            }
            if (this.verboseLevel > 3) {
                ErrPrint.errPrint("EigenValues:", subSpaceHessian.aEVa.aVec);
                for (i = 0; i < subSpaceHessian.nRank; ++i) {
                    this.verbose.print(" " + debugPrintout.formatNumber(5, 2, JLinAlg.VDot(subSpaceHessian.aLEV, i, subSpaceHessian.aREV, i)));
                }
                this.verbose.println();
            }
            projectedStep = JLinAlg.mVMultiply(subSpaceHessian.getInverse(), this.projectedGradient);
            oldLambda = lambda;
            lambda = JLinAlg.VDot(projectedStep, this.projectedGradient) + lambdaLimit;
            if (badCurviture || cycRFO > 13) {
                lambda = (lambda + oldLambda) / 2.0;
            }
            if (lambda < lambdaLimit) {
                lambdaLimit += 2.0 * Math.abs(lambda);
                lambda = lambdaLimit;
            }
            boolean bl3 = lambdaConverged = Math.abs(lambda - oldLambda) / oldLambda < 0.1;
            if (this.verboseLevel > 3) {
                this.verbose.println("Lambda: " + cycRFO + " " + oldLambda + " " + lambda + " " + lambdaLimit + " " + lambdaConverged);
            }
            tmpStep = JLinAlg.VLinComb(projectedStep, hS.subspaceBasis.getBasis(), tmpStep);
        }
        this.step = JLinAlg.VectScaleAndAdd(this.step, -1.0, tmpStep, this.step);
        if (this.searchConverged) {
            double[] stepDiffCoefficients = hS.subspaceBasis.getComponentsOnOriginalVectors(projectedStep, null);
            double[] gDIISCoefficients = new double[hS.storageSize];
            gDIISCoefficients[0] = 1.0;
            if (this.verboseLevel > 3) {
                ErrPrint.errPrint("Step coefficients on subspace-spanning original vectors:", stepDiffCoefficients);
            }
            for (int i = 1; i < gDIISCoefficients.length; ++i) {
                gDIISCoefficients[0] = gDIISCoefficients[0] + stepDiffCoefficients[i - 1];
                gDIISCoefficients[i] = -stepDiffCoefficients[i - 1];
            }
            if (this.verboseLevel > 3) {
                ErrPrint.errPrint("MDS (GDIIS-like) coefficients:", gDIISCoefficients);
            }
            this.tmpGradient = JLinAlg.VLinComb(gDIISCoefficients, hS.gStorage, null);
            this.tmpVariables = JLinAlg.VLinComb(gDIISCoefficients, hS.xStorage, null);
            this.tmpValue = hS.valStorage[0];
            if (subSpaceHessian.aEVa.aVec.length != subSpaceHessian.nRank) {
                throw new RuntimeException("Rank mismatch");
            }
        }
        this.controlStepSize(this.step);
        this.searchActive = !this.searchConverged && !this.searchFailed;
    }

    private void steepestDescentStep(double[] gradient, double[] step) {
        if (this.verboseLevel > 3) {
            this.verbose.println("Do SD step...");
        }
        JLinAlg.VectScaleAndAdd(step, -this.steepestDescentScaleFactor, gradient, step);
    }

    private void conjugateGradientStep(HistoryStorage hS, double[] step) {
        this.steepestDescentStep(hS.gStorage[0], step);
        if (hS.storageSize > 1 && !this.doGDIIS) {
            double gamma = JLinAlg.VDot(this.cc.correct(JLinAlg.vectSubtract(hS.gStorage[0], hS.gStorage[1])), hS.gStorage[0]) / JLinAlg.VDot(hS.gStorage[1], hS.gStorage[1]);
            gamma = Math.min(2.0, gamma);
            JLinAlg.VectScaleAndAdd(step, gamma, this.cc.correct(JLinAlg.vectSubtract(hS.xStorage[0], hS.xStorage[1])), step);
            if (this.verboseLevel > 3) {
                this.verbose.println("CG gamma is: " + gamma);
            }
        } else if (this.verboseLevel > 3) {
            this.verbose.println("Do SD step in CG...");
        }
        this.controlStepSize(step);
    }

    private boolean controlStepSize(double[] step) {
        double scRMS = 1.0;
        double sizeRMS = JLinAlg.VectRMS(step);
        if (sizeRMS > this.stepRMSLimit) {
            scRMS = this.stepRMSLimit / sizeRMS;
        }
        double stepMax = JLinAlg.VectMaxComponent(step.length, step, 0, true);
        double scMax = 1.0;
        if (stepMax > this.stepRMSLimit * this.maxLimitFactor) {
            scMax = this.stepRMSLimit * this.maxLimitFactor / stepMax;
        }
        double sc = Math.min(scRMS, scMax);
        if (this.searchActive) {
            sc *= 0.99;
        }
        if (sc < 1.0) {
            if (this.verboseLevel > 3) {
                this.verbose.println("Scaling step by: " + sc);
            }
            JLinAlg.VectScale(step.length, step, 0, sc, step, 0);
            return true;
        }
        return false;
    }

    private double increasedLimit(double[] step) {
        double sRMS = Math.sqrt(JLinAlg.VDot(step, step) / (double)step.length) * this.gold;
        double sMax = JLinAlg.VectMaxComponent(step.length, step, 0, true) * this.gold;
        double sMaxLimit = this.stepRMSLimit * this.maxLimitFactor;
        double scMax = Math.max(sRMS / this.stepRMSLimit, sMax / sMaxLimit);
        sMaxLimit = Math.max(1.0, scMax) * this.stepRMSLimit;
        if (this.getMaxStepComponent() > 0.0 && this.getMaxLimitFactor() > 0.0) {
            sMaxLimit = Math.min(sMaxLimit, this.getMaxStepComponent() / this.getMaxLimitFactor());
        }
        return sMaxLimit;
    }

    private double decreasedLimit(double[] step) {
        double sRMS = Math.sqrt(JLinAlg.VDot(step, step) / (double)step.length) / this.gold;
        double sMax = JLinAlg.VectMaxComponent(step.length, step, 0, true) / this.gold;
        double sMaxLimit = this.stepRMSLimit * this.maxLimitFactor;
        double scMin = Math.min(sRMS / this.stepRMSLimit, sMax / sMaxLimit);
        return Math.min(1.0, scMin) * this.stepRMSLimit;
    }

    private void setStepControl() {
        if (this.verboseLevel > 3) {
            this.verbose.println("setStepControl called.");
        }
        boolean valFail = Double.isNaN(this.fValue);
        if (this.searchActive && this.numberOfInnerSteps > 0) {
            double[] step = this.cc.correct(JLinAlg.vectSubtract(this.combinedHistory.xStorage[0], this.combinedHistory.xStorage[1]));
            if (!valFail && this.fValue <= this.combinedHistory.valStorage[0]) {
                this.stepRMSLimit = this.increasedLimit(step);
                if (this.verboseLevel > 3) {
                    this.verbose.println("Increase step limit to: " + this.stepRMSLimit);
                }
            } else if (valFail || this.fValue > this.combinedHistory.valStorage[0] + this.noEnergyDifference) {
                this.stepRMSLimit = this.decreasedLimit(step);
                if (this.verboseLevel > 3) {
                    this.verbose.println("Decrease step limit to: " + this.stepRMSLimit);
                }
            }
        } else if (!this.searchActive && this.outerHistory.storageSize > 1) {
            double[] step = this.cc.correct(JLinAlg.vectSubtract(this.outerHistory.xStorage[0], this.outerHistory.xStorage[1]));
            if (!valFail && this.outerHistory.valStorage[0] < this.outerHistory.valStorage[1]) {
                this.stepRMSLimit = this.increasedLimit(step);
                if (this.verboseLevel > 3) {
                    this.verbose.println("Increase step limit to: " + this.stepRMSLimit);
                }
            } else if (valFail || this.outerHistory.valStorage[0] > this.outerHistory.valStorage[1]) {
                this.stepRMSLimit = this.decreasedLimit(step);
                if (this.verboseLevel > 3) {
                    this.verbose.println("Decrease step limit to: " + this.stepRMSLimit);
                }
            }
        }
    }

    public boolean converged(double[] gradient, double[] step) {
        double gRMS = JLinAlg.VectRMS(gradient);
        double gMax = JLinAlg.VectMaxComponent(gradient, true);
        double sRMS = JLinAlg.VectRMS(step);
        double sMax = JLinAlg.VectMaxComponent(step, true);
        double gradientMaxLimit = this.gradientRMSLimit * this.maxLimitFactor;
        double stepRMSLimit = this.gradientRMSLimit * this.stepLimitFactor;
        double stepMaxLimit = stepRMSLimit * this.maxLimitFactor;
        boolean gRMSConverged = gRMS <= this.gradientRMSLimit;
        boolean gMaxConverged = gMax <= gradientMaxLimit;
        boolean sRMSConverged = sRMS <= stepRMSLimit;
        boolean sMaxConverged = sMax <= stepMaxLimit;
        return gRMSConverged && gMaxConverged && (!this.isUseStepCriteria() || sRMSConverged && sMaxConverged);
    }

    public boolean gradientConverged(double[] gradient) {
        double gRMS = JLinAlg.VectRMS(gradient);
        double gMax = JLinAlg.VectMaxComponent(gradient, true);
        double gradientMaxLimit = this.gradientRMSLimit * this.maxLimitFactor;
        boolean gRMSConverged = gRMS <= this.gradientRMSLimit;
        boolean gMaxConverged = gMax <= gradientMaxLimit;
        return gRMSConverged && gMaxConverged;
    }

    public boolean finish() {
        double gRMS = JLinAlg.VectRMS(this.gradient);
        return gRMS < this.finishGradientRMSLimit && this.combinedHistory.storageSize > 1 && this.fValue < this.combinedHistory.valStorage[0] + this.noEnergyDifference;
    }

    public void printSummaryLine() {
        if (this.step == null) {
            return;
        }
        double gRMS = JLinAlg.VectRMS(this.gradient);
        double gMax = JLinAlg.VectMaxComponent(this.gradient, true);
        double sRMS = 0.0;
        double sMax = 0.0;
        if (this.searchActive || this.outerHistory.storageSize < 2) {
            sRMS = JLinAlg.VectRMS(this.step);
            sMax = JLinAlg.VectMaxComponent(this.step, true);
        } else {
            double[] step = this.cc.correct(JLinAlg.vectSubtract(this.outerHistory.xStorage[0], this.outerHistory.xStorage[1]));
            sRMS = JLinAlg.VectRMS(step);
            sMax = JLinAlg.VectMaxComponent(step, true);
        }
        double gradientMaxLimit = this.gradientRMSLimit * this.maxLimitFactor;
        double stepRMSLimit = this.gradientRMSLimit * this.stepLimitFactor;
        double stepMaxLimit = stepRMSLimit * this.maxLimitFactor;
        boolean gRMSConverged = gRMS <= this.gradientRMSLimit;
        boolean gMaxConverged = gMax <= gradientMaxLimit;
        boolean sRMSConverged = sRMS <= stepRMSLimit;
        boolean sMaxConverged = sMax <= stepMaxLimit;
        String line = "";
        line = line + TextUtils.formatNumber(this.numberOfOuterSteps, 5);
        line = this.searchActive || this.searchConverged || this.numberOfSteps == 0 ? line + TextUtils.formatNumber(this.numberOfInnerSteps, 5) : line + TextUtils.formatNumber(-this.numberOfInnerSteps, 5);
        line = line + TextUtils.formatNumber(this.numberOfSteps, 5);
        line = line + TextUtils.formatNumber(this.combinedHistory.storageSize, 3);
        line = line + debugPrintout.formatNumber(12, 9, gRMS);
        line = line + debugPrintout.formatNumber(12, 9, gMax);
        line = line + debugPrintout.formatNumber(12, 9, sRMS);
        line = line + debugPrintout.formatNumber(12, 9, sMax);
        line = line + debugPrintout.formatNumber(14, 9, this.fValue) + " ";
        if (!this.searchActive) {
            line = line + this.booleanChr(gRMSConverged);
            line = line + this.booleanChr(gMaxConverged);
            line = line + this.booleanChr(sRMSConverged);
            line = line + this.booleanChr(sMaxConverged);
            line = line + this.booleanChr(this.isOptimizationConverged());
        }
        if (this.negativeEigenvalue) {
            line = line + "!";
        }
        this.verbose.println(line);
    }

    private String booleanChr(boolean flag) {
        if (flag) {
            return "+";
        }
        return "-";
    }

    private boolean store(HistoryStorage hS, double[] variables, double[] gradient, double functionValue) {
        hS.subspaceBasis = null;
        JLinAlg.OrthogonalBasis b = null;
        if (hS.storageSize > 0) {
            b = new JLinAlg.OrthogonalBasis(hS.storageSize, this.smallOverlapLimit);
        }
        try {
            this.addToStorage(hS, 0, new Storage(variables, gradient, functionValue));
        }
        catch (GradientOptimizationException ex) {
            ex.printStackTrace();
        }
        if (this.forcedMinimization) {
            this.reOrderStorage(hS);
        }
        for (int i = 1; i < hS.storageSize; ++i) {
            if (b.addVector(this.cc.correct(JLinAlg.vectSubtract(hS.xStorage[i], hS.xStorage[0])))) continue;
            this.removeFromStorage(hS, i);
            --i;
        }
        hS.subspaceBasis = b;
        if (this.verboseLevel > 3) {
            System.err.println("Storage called, size is:" + hS.storageSize);
        }
        return true;
    }

    private void reOrderStorage(HistoryStorage hS) {
        if (hS.storageSize < 2) {
            return;
        }
        int iBest = JLinAlg.VectMinIndex(hS.storageSize, hS.valStorage, 0, false);
        if (iBest > 0 && hS.valStorage[0] > hS.valStorage[iBest] + this.noEnergyDifference) {
            int iFrom = iBest;
            int iTo = 0;
            double[] sX = hS.xStorage[iFrom];
            double[] sG = hS.gStorage[iFrom];
            double sV = hS.valStorage[iFrom];
            for (int i = iFrom; i > iTo; --i) {
                hS.xStorage[i] = hS.xStorage[i - 1];
                hS.gStorage[i] = hS.gStorage[i - 1];
                hS.valStorage[i] = hS.valStorage[i - 1];
            }
            hS.xStorage[iTo] = sX;
            hS.gStorage[iTo] = sG;
            hS.valStorage[iTo] = sV;
        }
    }

    private void resetStorage() {
        this.combinedHistory.setStorageSize(0);
        this.outerHistory.setStorageSize(0);
    }

    private void setStorage(HistoryStorage hS, int i, Storage s) throws GradientOptimizationException {
        if (i > hS.storageSizeLimit - 1) {
            throw new GradientOptimizationException("Storage overflow error in setStorage");
        }
        if (i > hS.storageSize) {
            throw new GradientOptimizationException("Storage continuity error in setStorage");
        }
        for (int j = 0; j < s.variables.length; ++j) {
            hS.xStorage[i][j] = s.variables[j];
            hS.gStorage[i][j] = s.gradient[j];
        }
        hS.valStorage[i] = s.fValue;
        if (i == hS.storageSize) {
            hS.storageSize++;
        }
    }

    private void addToStorage(HistoryStorage hS, int i, Storage s) throws GradientOptimizationException {
        if (i > hS.storageSizeLimit - 1) {
            throw new GradientOptimizationException("Storage overflow error in setStorage");
        }
        if (i > hS.storageSize) {
            throw new GradientOptimizationException("Storage continuity error in setStorage");
        }
        if (hS.storageSize == hS.storageSizeLimit) {
            this.removeFromStorage(hS, hS.storageSize - 1);
        }
        double[] xSave = null;
        double[] gSave = null;
        if (hS.storageSize > 0) {
            xSave = hS.xStorage[hS.storageSize];
            gSave = hS.gStorage[hS.storageSize];
        }
        for (int j = hS.storageSize; j >= i + 1; --j) {
            hS.xStorage[j] = hS.xStorage[j - 1];
            hS.gStorage[j] = hS.gStorage[j - 1];
            hS.valStorage[j] = hS.valStorage[j - 1];
        }
        if (hS.storageSize > 0) {
            hS.xStorage[i] = xSave;
            hS.gStorage[i] = gSave;
        }
        hS.storageSize++;
        this.setStorage(hS, i, s);
    }

    private Storage getStorageItem(HistoryStorage hS, int i) {
        return new Storage(hS.xStorage[i], hS.gStorage[i], hS.valStorage[i]);
    }

    private void removeFromStorage(HistoryStorage hS, int i) {
        double[] xSave = hS.xStorage[i];
        double[] gSave = hS.gStorage[i];
        for (int j = i; j < hS.storageSize - 1; ++j) {
            hS.xStorage[j] = hS.xStorage[j + 1];
            hS.gStorage[j] = hS.gStorage[j + 1];
            hS.valStorage[j] = hS.valStorage[j + 1];
        }
        hS.xStorage[((HistoryStorage)hS).storageSize - 1] = xSave;
        hS.gStorage[((HistoryStorage)hS).storageSize - 1] = gSave;
        hS.storageSize--;
    }

    public double[][] numericSecondDerivatives() {
        if (this.function == null) {
            return null;
        }
        double[][] h = new double[this.function.getVariables().length][this.function.getVariables().length];
        double dX = 1.0E-6;
        double[] g0 = new double[this.function.getVariables().length];
        double[] dG = new double[this.function.getVariables().length];
        double[] x = JLinAlg.VectCopy(this.function.getVariables());
        int i = 0;
        while (i < h.length) {
            int n = i;
            x[n] = x[n] + dX;
            this.function.setVariables(x);
            JLinAlg.vectSubtract(this.function.getFunctionGradient(), g0, dG);
            int n2 = i;
            x[n2] = x[n2] - 2.0 * dX;
            this.function.setVariables(x);
            dG = JLinAlg.vectSubtract(dG, this.function.getFunctionGradient(), dG);
            dG = JLinAlg.VectScale(dG, 0.5, dG);
            for (int j = 0; j < x.length; ++j) {
                h[i][j] = dG[j] / dX;
            }
            int n3 = i++;
            x[n3] = x[n3] + dX;
        }
        if (this.verboseLevel > 3) {
            JLinAlg.Matrix hM = new JLinAlg.Matrix(h);
            hM.Print("Numeric Hessian: ");
        }
        return h;
    }

    public double getGradientRMSLimit() {
        return this.gradientRMSLimit;
    }

    public void setGradientRMSLimit(double gradientRMSLimit) {
        this.gradientRMSLimit = gradientRMSLimit;
    }

    public double getMaxLimitFactor() {
        return this.maxLimitFactor;
    }

    public void setMaxLimitFactor(double maxLimitFactor) {
        this.maxLimitFactor = maxLimitFactor;
    }

    public double getStepLimitFactor() {
        return this.stepLimitFactor;
    }

    public void setStepLimitFactor(double stepLimitFactor) {
        this.stepLimitFactor = stepLimitFactor;
    }

    public int getStorageSizeLimit() {
        return this.storageSizeLimit;
    }

    public void setStorageSizeLimit(int storageSizeLimit) {
        this.storageSizeLimit = storageSizeLimit = Math.max(storageSizeLimit, 2);
    }

    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    public int getNumberOfOuterSteps() {
        return this.numberOfOuterSteps;
    }

    public boolean isForcedMinimization() {
        return this.forcedMinimization;
    }

    public boolean isConjugateGradient() {
        return this.conjugateGradient;
    }

    public boolean isFullAutomaticAlgorithm() {
        return this.fullAutomaticAlgorithm;
    }

    public boolean isLinearSearch() {
        return this.linearSearch;
    }

    public boolean isMultiDimensionalSearch() {
        return this.multiDimensionalSearch;
    }

    public boolean isQuasyNewtonBFGS() {
        return this.quasyNewtonBFGS;
    }

    public boolean isRationalFunctionOptimization() {
        return this.rationalFunctionOptimization;
    }

    public boolean isSteepestDescent() {
        return this.steepestDescent;
    }

    public void setConjugateGradient(boolean conjugateGradient) {
        this.conjugateGradient = conjugateGradient;
    }

    public void setFullAutomaticAlgorithm(boolean fullAutomaticAlgorithm) {
        this.fullAutomaticAlgorithm = fullAutomaticAlgorithm;
    }

    public void setLinearSearch(boolean linearSearch) {
        this.linearSearch = linearSearch;
    }

    public void setMultiDimensionalSearch(boolean multiDimensionalSearch) {
        this.multiDimensionalSearch = multiDimensionalSearch;
    }

    public void setForcedMinimization(boolean forcedMinimization) {
        this.forcedMinimization = forcedMinimization;
    }

    private int getStorageSize(HistoryStorage hS) {
        return hS.storageSize;
    }

    public int getStorageSize() {
        return this.getStorageSize(this.combinedHistory);
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerboseLevel(int verboseLevel) {
        this.verboseLevel = verboseLevel;
    }

    public void setVerbosePrinter(VerbosePrinter v) {
        this.verbose = v;
    }

    public boolean isVerbosePrinterNotNull() {
        return this.verbose != null;
    }

    public boolean isOptimizationConverged() {
        return this.optimizationConverged;
    }

    public int getMaxNumberOfInnerSteps() {
        return this.maxNumberOfInnerSteps;
    }

    public int getMaxNumberOfOuterSteps() {
        return this.maxNumberOfOuterSteps;
    }

    public double getEigenValueLimit() {
        return this.eigenValueLimit;
    }

    public double getFinishGradientRMSLimit() {
        return this.finishGradientRMSLimit;
    }

    public int getNumberOfInnerSteps() {
        return this.numberOfInnerSteps;
    }

    public double getSearchGradientCosLimit() {
        return this.searchGradientCosLimit;
    }

    private boolean isSearchActive() {
        return this.searchActive;
    }

    public boolean isSearchConverged() {
        return this.searchConverged;
    }

    public boolean isSearchFailed() {
        return this.searchFailed;
    }

    public void setEigenValueLimit(double eigenValueLimit) {
        this.eigenValueLimit = eigenValueLimit;
    }

    public void setFinishGradientRMSLimit(double finishGradientRMSLimit) {
        this.finishGradientRMSLimit = finishGradientRMSLimit;
    }

    public void setMaxNumberOfInnerSteps(int maxNumberOfInnerSteps) {
        this.maxNumberOfInnerSteps = maxNumberOfInnerSteps;
    }

    public void setMaxNumberOfOuterSteps(int maxNumberOfOuterSteps) {
        this.maxNumberOfOuterSteps = maxNumberOfOuterSteps;
    }

    public void setSearchGradientCosLimit(double searchGradientCosLimit) {
        this.searchGradientCosLimit = searchGradientCosLimit;
    }

    public void setSmallOverlapLimit(double smallOverlapLimit) {
        this.smallOverlapLimit = smallOverlapLimit;
    }

    public double getNoEnergyDifference() {
        return this.noEnergyDifference;
    }

    public double getStopAtGradientMax() {
        return this.stopAtGradientMax;
    }

    public void setStopAtGradientMax(double stopAtGradientMax) {
        this.stopAtGradientMax = stopAtGradientMax;
    }

    public void setNoEnergyDifference(double noEnergyDifference) {
        this.noEnergyDifference = noEnergyDifference;
    }

    public FunctionToMinimize getFunction() {
        return this.function;
    }

    public double getMaxStepComponent() {
        return this.maxStepComponent;
    }

    public void setMaxStepComponent(double maxStepComponent) {
        this.maxStepComponent = Math.max(0.0, maxStepComponent);
    }

    public boolean isUseStepCriteria() {
        return this.useStepCriteria;
    }

    public void setUseStepCriteria(boolean useStepCriteria) {
        this.useStepCriteria = useStepCriteria;
    }

    public void setChangeCorrector(ChangeCorrector cc) {
        this.cc = cc;
    }

    private static class Corr
    implements ChangeCorrector {
        private Corr() {
        }

        @Override
        public double[] correct(double[] internalChange) {
            return internalChange;
        }
    }

    public static class HessianUpdater {
        public static final int SR1_UPDATE = 1;
        public static final int BFGS_UPDATE = 2;
        public static final int UNCONDITIONAL_BFGS_UPDATE = 4;
        private int updateMethod = 0;

        public HessianUpdater(int updateMethod) {
            this.updateMethod = updateMethod;
        }

        public JLinAlg.Matrix update(JLinAlg.Matrix initialHessian, double[] x, double[] y, JLinAlg.Matrix updatedHessian) {
            return null;
        }
    }

    public static interface FunctionToMinimize {
        public boolean isCancelled();

        public double[] getVariables();

        public double getFunctionValue();

        public double[] getFunctionGradient();

        public boolean setVariables(double[] var1);

        public void print();

        public void print(String var1);
    }

    public static interface VerbosePrinter {
        public void print(String var1);

        public void print(int var1);

        public void print(double var1);

        public void print(boolean var1);

        public void println();

        public void println(String var1);

        public void println(int var1);

        public void println(double var1);

        public void println(boolean var1);
    }

    public static class VerbosePrinterImplementation
    implements VerbosePrinter {
        @Override
        public void print(String s) {
            System.err.print(s);
        }

        @Override
        public void print(int i) {
            System.err.print(i);
        }

        @Override
        public void print(double d) {
            System.err.print(d);
        }

        @Override
        public void print(boolean b) {
            System.err.print(b);
        }

        @Override
        public void println() {
            System.err.println();
        }

        @Override
        public void println(String s) {
            System.err.println(s);
        }

        @Override
        public void println(int i) {
            System.err.println(i);
        }

        @Override
        public void println(double d) {
            System.err.println(d);
        }

        @Override
        public void println(boolean b) {
            System.err.println(b);
        }
    }

    public static class VerbosePrinterAdapter
    implements VerbosePrinter {
        private chemaxon.marvin.modelling.debug.VerbosePrinter mvp = null;

        public VerbosePrinterAdapter(chemaxon.marvin.modelling.debug.VerbosePrinter baseprinter) {
            this.mvp = baseprinter;
        }

        @Override
        public void print(String s) {
            if (this.mvp == null) {
                return;
            }
            this.mvp.print(s);
        }

        @Override
        public void print(int i) {
            if (this.mvp == null) {
                return;
            }
            this.mvp.print("" + i);
        }

        @Override
        public void print(double d) {
            if (this.mvp == null) {
                return;
            }
            this.mvp.print("" + d);
        }

        @Override
        public void print(boolean b) {
            if (this.mvp == null) {
                return;
            }
            this.mvp.print("" + b);
        }

        @Override
        public void println() {
            if (this.mvp == null) {
                return;
            }
            this.mvp.print("");
        }

        @Override
        public void println(String s) {
            if (this.mvp == null) {
                return;
            }
            this.mvp.print(s);
        }

        @Override
        public void println(int i) {
            if (this.mvp == null) {
                return;
            }
            this.mvp.print("" + i);
        }

        @Override
        public void println(double d) {
            if (this.mvp == null) {
                return;
            }
            this.mvp.print("" + d);
        }

        @Override
        public void println(boolean b) {
            if (this.mvp == null) {
                return;
            }
            this.mvp.print("" + b);
        }
    }

    private class HistoryStorage {
        private int storageSize = 0;
        private int storageSizeLimit = 0;
        double[][] xStorage = null;
        double[][] gStorage = null;
        double[] valStorage = null;
        private JLinAlg.OrthogonalBasis subspaceBasis = null;

        public HistoryStorage(int storageLimit, int vectorLength) {
            this.xStorage = new double[storageLimit][vectorLength];
            this.gStorage = new double[storageLimit][vectorLength];
            this.valStorage = new double[storageLimit];
            this.subspaceBasis = new JLinAlg.OrthogonalBasis(storageLimit - 1);
            this.storageSizeLimit = storageLimit;
            this.storageSize = 0;
        }

        public void setStorageSize(int storageSize) {
            if (storageSize < this.storageSize) {
                this.storageSize = storageSize;
                this.rebuildBasis();
            }
        }

        public int getStorageSize() {
            return this.storageSize;
        }

        public void rebuildBasis() {
            JLinAlg.OrthogonalBasis b = null;
            if (this.storageSize > 0) {
                b = new JLinAlg.OrthogonalBasis(this.storageSize, GradientOptimization.this.smallOverlapLimit);
                for (int i = 1; i < this.storageSize; ++i) {
                    if (b.addVector(GradientOptimization.this.cc.correct(JLinAlg.vectSubtract(this.xStorage[i], this.xStorage[0])))) continue;
                    GradientOptimization.this.removeFromStorage(this, i);
                    --i;
                }
            }
            this.subspaceBasis = b;
        }
    }

    private class Storage {
        double[] variables = null;
        double[] gradient = null;
        double fValue = Double.POSITIVE_INFINITY;

        Storage(double[] variables, double[] gradient, double fValue) {
            this.variables = variables;
            this.gradient = gradient;
            this.fValue = fValue;
        }
    }

    public class GradientOptimizationException
    extends Exception {
        private static final long serialVersionUID = -8973876294111029202L;

        public GradientOptimizationException() {
        }

        public GradientOptimizationException(String message) {
            super(message);
        }
    }
}

