/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.debug.debugPrintout;
import java.io.Serializable;

public class Graph {
    Object[] nodes = null;
    int[] e1 = null;
    int[] e2 = null;
    int n = 0;
    int e = 0;
    int[][] ctab = null;
    public static final int CHAIN_NODE = 1;
    public static final int RING_NODE = 2;
    public static final int IRBB_NODE = 3;
    public static final int RINGSETLIGAND_NODE = 4;

    public Graph() {
    }

    public static int[] createSetVectors(int[] nodeclass, int[] e1, int[] e2) {
        int[] n = new int[nodeclass.length];
        for (int i = 0; i < n.length; ++i) {
            n[i] = i;
        }
        boolean go = true;
        while (go) {
            go = false;
            for (int i = 0; i < e1.length; ++i) {
                if (nodeclass[e1[i]] != nodeclass[e2[i]] || n[e1[i]] == n[e2[i]]) continue;
                if (n[e1[i]] > n[e2[i]]) {
                    n[e1[i]] = n[e2[i]];
                } else {
                    n[e2[i]] = n[e1[i]];
                }
                go = true;
            }
        }
        return n;
    }

    public static int[] classifyNodes(int[][] SSSR2, int[][] ctab) {
        int i;
        int i2;
        int[] ret = new int[ctab.length];
        if (SSSR2 != null) {
            for (i2 = 0; i2 < SSSR2.length; ++i2) {
                for (int j = 0; j < SSSR2[i2].length; ++j) {
                    ret[SSSR2[i2][j]] = 2;
                }
            }
        }
        for (i2 = 0; i2 < ctab.length; ++i2) {
            if (ret[i2] != 0 || ctab[i2].length != 1) continue;
            ret[i2] = 4;
        }
        boolean go = true;
        while (go) {
            go = false;
            for (i = 0; i < ctab.length; ++i) {
                int ncn = 0;
                if (ret[i] != 0) continue;
                for (int j = 0; j < ctab[i].length; ++j) {
                    if (ret[ctab[i][j]] == 1) continue;
                    ++ncn;
                }
                if (ncn > true) continue;
                go = true;
                ret[i] = 1;
            }
        }
        for (i = 0; i < ret.length; ++i) {
            if (ret[i] != 0) continue;
            ret[i] = 3;
        }
        return ret;
    }

    public Graph(int inc, int iec) {
        this.nodes = new Object[inc];
        this.e1 = new int[iec];
        this.e2 = new int[iec];
    }

    public Graph(int[][] ctab) {
        int i;
        this.nodes = new Object[ctab.length];
        this.ctab = ctab;
        for (int i2 = 0; i2 < ctab.length; ++i2) {
            this.nodes[i2] = null;
        }
        this.n = ctab.length;
        int iec = 0;
        for (i = 0; i < ctab.length; ++i) {
            iec += ctab[i].length;
        }
        this.e = iec / 2;
        this.e1 = new int[iec];
        this.e2 = new int[iec];
        iec = 0;
        for (i = 0; i < ctab.length; ++i) {
            for (int j = 0; j < ctab[i].length; ++j) {
                if (i >= ctab[i][j]) continue;
                this.e1[iec] = i;
                this.e2[iec] = ctab[i][j];
                ++iec;
            }
        }
    }

    void ensureNode(int n) {
        if (this.nodes == null) {
            this.nodes = new Object[2 * n + 10];
        } else if (this.nodes.length <= n) {
            Object[] tmp = new Object[2 * n + 10];
            for (int i = 0; i < this.nodes.length; ++i) {
                tmp[i] = this.nodes[i];
            }
            this.nodes = tmp;
        }
    }

    void ensureEdge(int n) {
        if (this.e1 == null) {
            this.e1 = new int[2 * n + 10];
            this.e2 = new int[2 * n + 10];
        } else if (this.e1.length <= n) {
            int[] tmp1 = new int[2 * n + 10];
            int[] tmp2 = new int[2 * n + 10];
            for (int i = 0; i < this.e1.length; ++i) {
                tmp1[i] = this.e1[i];
                tmp2[i] = this.e2[i];
            }
            this.e1 = tmp1;
            this.e2 = tmp2;
        }
    }

    public int addNode(Object nn) {
        this.ensureNode(this.n);
        this.nodes[this.n] = nn;
        ++this.n;
        return this.n - 1;
    }

    public int addEdge(int n1, int n2) {
        this.ensureEdge(this.e);
        this.e1[this.e] = n1;
        this.e2[this.e] = n2;
        ++this.e;
        return this.e - 1;
    }

    public int retrieveNode(Object n) {
        for (int i = 0; i < this.n; ++i) {
            if ((n != null || this.nodes[i] != null) && !n.equals(this.nodes[i])) continue;
            return i;
        }
        return -1;
    }

    public int findAcyclicCenterIndex() {
        int i;
        int lastmarked = -1;
        boolean[] marked = new boolean[this.n];
        boolean[] markedNew = new boolean[this.n];
        int[] neighs = new int[this.n];
        for (i = 0; i < this.e; ++i) {
            int n = this.e1[i];
            neighs[n] = neighs[n] + 1;
            int n2 = this.e2[i];
            neighs[n2] = neighs[n2] + 1;
        }
        for (i = 0; i < this.n; ++i) {
            if (neighs[i] == 1) {
                marked[i] = true;
                lastmarked = i;
                continue;
            }
            marked[i] = false;
        }
        boolean go = true;
        while (go) {
            go = false;
            for (int i2 = 0; i2 < this.n; ++i2) {
                markedNew[i2] = marked[i2];
                if (marked[i2]) continue;
                for (int j = 0; j < this.e; ++j) {
                    if ((this.e1[j] != i2 || !marked[this.e2[j]]) && (this.e2[j] != i2 || !marked[this.e1[j]])) continue;
                    go = true;
                    markedNew[i2] = true;
                    lastmarked = i2;
                }
            }
            boolean[] tmp = marked;
            marked = markedNew;
            markedNew = marked;
        }
        return lastmarked;
    }

    int[] findCenterInCyclic() {
        int i;
        if (this.n == 1) {
            return new int[]{0};
        }
        int[][] sr = new int[this.n][this.n];
        for (i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                sr[i][j] = -1;
            }
        }
        for (i = 0; i < this.n; ++i) {
            sr[i][i] = 0;
        }
        boolean go = true;
        while (go) {
            go = false;
            for (int i2 = 0; i2 < this.e; ++i2) {
                int n1 = this.e1[i2];
                int n2 = this.e2[i2];
                for (int j = 0; j < this.n; ++j) {
                    if (sr[j][n1] != -1 && (sr[j][n1] + 1 < sr[j][n2] || sr[j][n2] == -1)) {
                        sr[j][n2] = sr[j][n1] + 1;
                        go = true;
                    }
                    if (sr[j][n2] == -1 || sr[j][n2] + 1 >= sr[j][n1] && sr[j][n1] != -1) continue;
                    sr[j][n1] = sr[j][n2] + 1;
                    go = true;
                }
            }
        }
        int[] lr = new int[this.n];
        for (int i3 = 0; i3 < this.n; ++i3) {
            for (int j = 0; j < this.n; ++j) {
                if (lr[i3] >= sr[i3][j]) continue;
                lr[i3] = sr[i3][j];
            }
        }
        int slr = lr[0];
        int slrc = 1;
        for (int i4 = 1; i4 < this.n; ++i4) {
            if (slr == lr[i4]) {
                ++slrc;
                continue;
            }
            if (slr <= lr[i4]) continue;
            slr = lr[i4];
            slrc = 1;
        }
        int[] ret = new int[slrc];
        slrc = 0;
        for (int i5 = 0; i5 < this.n; ++i5) {
            if (slr != lr[i5]) continue;
            ret[slrc] = i5;
            ++slrc;
        }
        return ret;
    }

    public int[] findLayeredSequence() {
        int[] ret = new int[this.n];
        boolean[] marked = new boolean[this.n];
        int cni = this.findAcyclicCenterIndex();
        int p = 1;
        marked[cni] = true;
        ret[0] = cni;
        boolean[] nextLayer = new boolean[this.n];
        boolean go = true;
        while (go) {
            int i;
            go = false;
            for (i = 0; i < this.n; ++i) {
                nextLayer[i] = false;
            }
            for (i = 0; i < this.e; ++i) {
                if (!(marked[this.e1[i]] ^ marked[this.e2[i]])) continue;
                go = true;
                nextLayer[this.e1[i]] = !marked[this.e1[i]];
                nextLayer[this.e2[i]] = !marked[this.e2[i]];
            }
            for (i = 0; i < this.n; ++i) {
                if (!nextLayer[i]) continue;
                ret[p++] = i;
                marked[i] = true;
            }
        }
        return ret;
    }

    public void printout(debugPrintout d) {
        int i;
        d.printB("Nodes: " + this.n);
        d.printB("Edges: " + this.e);
        d.Tstart();
        d.Trow();
        d.TprintBC(2, "Nodes");
        d.Trow();
        d.TprintBC("#");
        d.TprintBC("desc");
        for (i = 0; i < this.n; ++i) {
            d.Trow();
            d.TprintBC("" + i);
            d.Tprint(this.nodes[i].toString());
        }
        d.Tstop();
        d.Tstart();
        d.Trow();
        d.TprintBC(4, "Edges");
        d.Trow();
        d.TprintBC("#");
        d.TprintBC("n1-n2");
        d.TprintBC("desc1");
        d.TprintBC("desc2");
        for (i = 0; i < this.e; ++i) {
            d.Trow();
            d.TprintBC("" + i);
            d.Tprint(this.e1[i] + " - " + this.e2[i]);
            d.Tprint(this.nodes[this.e1[i]].toString());
            d.Tprint(this.nodes[this.e2[i]].toString());
        }
        d.Tstop();
    }

    public static class NTuple
    implements Serializable {
        public int[] c = new int[2];

        public String toString() {
            String ret = "";
            for (int i = 0; i < this.c.length; ++i) {
                ret = ret + "[" + this.c[i] + "]";
            }
            return ret;
        }

        public boolean equals(Object n) {
            if (n == null || !NTuple.class.isInstance(n)) {
                return false;
            }
            NTuple nn = (NTuple)n;
            if (this.c != null && nn.c != null && this.c.length == nn.c.length) {
                for (int i = 0; i < this.c.length; ++i) {
                    if (this.c[i] == nn.c[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public NTuple(int v1, int v2) {
            this.c[0] = v1;
            this.c[1] = v2;
        }

        public int getV(int i) {
            return this.c[i];
        }
    }

    public static interface Node {
        public boolean isEqual(Node var1);
    }
}

