/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.linalg.Matrix;

public class JacobiTransformation {
    public double[][] a;
    public double[] d;
    public double[][] v;
    public int n;
    public int nrot;
    static final double JACOBI_EPS = 1.0E-5;

    public JacobiTransformation(Matrix m) {
        int ip;
        int j;
        int i;
        if (m.cols != m.rows) {
            System.err.println("ERROR - Jacobi! Non square matrix m given.");
            return;
        }
        this.n = m.cols;
        this.a = new double[this.n][this.n];
        for (i = 0; i < this.n; ++i) {
            for (j = 0; j < this.n; ++j) {
                this.a[i][j] = m.a[i][j];
            }
        }
        double[] b = new double[this.n];
        double[] z = new double[this.n];
        this.v = new double[this.n][this.n];
        for (ip = 0; ip < this.n; ++ip) {
            this.v[ip][ip] = 1.0;
        }
        this.d = new double[this.n];
        for (ip = 0; ip < this.n; ++ip) {
            b[ip] = this.a[ip][ip];
            this.d[ip] = this.a[ip][ip];
        }
        for (i = 1; i <= 50; ++i) {
            int iq;
            double sm = 0.0;
            for (ip = 0; ip < this.n - 1; ++ip) {
                for (iq = ip + 1; iq < this.n; ++iq) {
                    sm += Math.abs(this.a[ip][iq]);
                }
            }
            if (Math.abs(sm) < 1.0E-5) {
                return;
            }
            double tresh = i < 4 ? 0.2 * sm / (double)(this.n * this.n) : 0.0;
            for (ip = 0; ip < this.n - 1; ++ip) {
                for (iq = ip + 1; iq < this.n; ++iq) {
                    double t;
                    double g = 100.0 * Math.abs(this.a[ip][iq]);
                    if (i > 4 && Math.abs(this.d[ip]) + g == Math.abs(this.d[ip]) && Math.abs(this.d[iq]) + g == Math.abs(this.d[iq])) {
                        this.a[ip][iq] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(this.a[ip][iq]) > tresh)) continue;
                    double h = this.d[iq] - this.d[ip];
                    if (Math.abs(h) + g == Math.abs(h)) {
                        t = this.a[ip][iq] / h;
                    } else {
                        double theta = 0.5 * h / this.a[ip][iq];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    h = t * this.a[ip][iq];
                    int n = ip;
                    z[n] = z[n] - h;
                    int n2 = iq;
                    z[n2] = z[n2] + h;
                    int n3 = ip;
                    this.d[n3] = this.d[n3] - h;
                    int n4 = iq;
                    this.d[n4] = this.d[n4] + h;
                    this.a[ip][iq] = 0.0;
                    for (j = 0; j < ip; ++j) {
                        this.rotate(this.a, j, ip, j, iq, tau, s);
                    }
                    for (j = ip + 1; j < iq; ++j) {
                        this.rotate(this.a, ip, j, j, iq, tau, s);
                    }
                    for (j = iq + 1; j < this.n; ++j) {
                        this.rotate(this.a, ip, j, iq, j, tau, s);
                    }
                    for (j = 0; j < this.n; ++j) {
                        this.rotate(this.v, j, ip, j, iq, tau, s);
                    }
                    ++this.nrot;
                }
            }
            for (ip = 0; ip < this.n; ++ip) {
                int n = ip;
                b[n] = b[n] + z[ip];
                this.d[ip] = b[ip];
                z[ip] = 0.0;
            }
        }
        System.err.println("ERROR - Jacobi! Too many iterations");
    }

    void rotate(double[][] a, int i, int j, int k, int l, double tau, double s) {
        double g = a[i][j];
        double h = a[k][l];
        a[i][j] = g - s * (h + g * tau);
        a[k][l] = h + s * (g - h * tau);
    }
}

