/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg.internals;

import chemaxon.common.util.DoubleVector;
import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.internals.CombinedInternalCoordinate;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import java.util.Vector;

public class Internals {
    public static final int INTERNALTYPE_CARTESIAN = 0;
    public static final int INTERNALTYPE_CARTESIAN_X = 17;
    public static final int INTERNALTYPE_CARTESIAN_Y = 18;
    public static final int INTERNALTYPE_CARTESIAN_Z = 19;
    public static final int INTERNALTYPE_BONDLENGTH = 1;
    public static final int INTERNALTYPE_BONDANGLE = 2;
    public static final int INTERNALTYPE_DIHEDRAL = 3;
    public static final int INTERNALTYPE_OUTOFPLANE = 4;
    public static final int INTERNALTYPE_IMPROPERDIHEDRAL = 5;
    public static final int INTERNALTYPE_COSANGLE = 6;
    public static final int INTERNALTYPE_COMBINED = 8;
    public static final int INTERNALTYPE_LINEARBEND_I = 9;
    public static final int INTERNALTYPE_LINEARBEND_II = 10;
    public static final String[] internalCoordinateTypes = new String[]{"Cartesian\t", "Bond Length", "Bond Angle\t", "Dihedral\t", "OutOfPlane\t", "Improper\t", "CosAngle\t", "", "Combination", "LinearBend1", "LinearBend2"};

    public static double[] b(int a1, int a2, double[] coords, double[] v) {
        return JLinAlg.vectSubtract(3, coords, a2 * 3, coords, a1 * 3, v, 0);
    }

    public static double[] bu(int a1, int a2, double[] coords, double[] v) {
        double vLen = JLinAlg.VLength(v = Internals.b(a1, a2, coords, v));
        if (vLen > 0.0) {
            v = JLinAlg.VectScale(v, 1.0 / vLen, v);
        }
        return v;
    }

    public static double[] o(double[] v1, double[] v2, double[] v3) {
        v3[0] = v1[1] * v2[2] - v1[2] * v2[1];
        v3[1] = v1[2] * v2[0] - v1[0] * v2[2];
        v3[2] = v1[0] * v2[1] - v1[1] * v2[0];
        return v3;
    }

    public static double[] ou(double[] v1, double[] v2, double[] v3) {
        double v3Len = JLinAlg.VLength(v3 = Internals.o(v1, v2, v3));
        if (v3Len > 0.0) {
            v3 = JLinAlg.VectScale(v3, 1.0 / v3Len, v3);
        }
        return v3;
    }

    public static class GeneralCombinedInternal
    extends InternalCoordinate
    implements CombinedInternalCoordinate {
        private InternalCoordinate[] ic = null;
        private double[] c = null;
        private int[][] reverseIndeces = null;
        private Vector internalVec = null;
        private IntVector indexVec = null;
        private DoubleVector coeffVec = null;
        private boolean finalized = false;

        public GeneralCombinedInternal(double[] cartesianCoordinates) {
            super(cartesianCoordinates, null);
            this.setType(8);
            if (this.ic != null) {
                System.err.println("Internal error in Combined");
            }
            this.init();
        }

        public GeneralCombinedInternal(double[] cartesianCoordinates, int[] indeces) {
            super(cartesianCoordinates, indeces);
            this.setType(8);
            this.init();
        }

        public GeneralCombinedInternal(double[] cartesianCoordinates, InternalCoordinate[] ic, double[] coefficients) {
            super(cartesianCoordinates, null);
            this.ic = ic;
            this.c = coefficients;
            this.setType(8);
            this.init();
        }

        public GeneralCombinedInternal(double[] cartesianCoordinates, InternalCoordinate[] ic, double[] coefficients, int[] indeces) {
            super(cartesianCoordinates, indeces);
            this.ic = ic;
            this.c = coefficients;
            this.setType(8);
            this.init();
        }

        @Override
        public String toString() {
            String out = "Combination:";
            InternalCoordinate[] q = this.getComponentInternals();
            double[] c = this.getComponentCoefficients();
            if (c.length != q.length) {
                throw new UnsupportedOperationException("Length mismatch in toString");
            }
            for (int i = 0; i < q.length; ++i) {
                out = out + "\n" + c[i] + " " + q[i].toString();
            }
            return out;
        }

        public void add(InternalCoordinate internalCoordinate, double coefficient) {
            if (this.finalized) {
                throw new UnsupportedOperationException("This combined internal has already been finalized...");
            }
            this.internalVec.add(internalCoordinate);
            this.coeffVec.addElement(coefficient);
        }

        private void init() {
            int[] indeces;
            if (this.ic != null) {
                this.finalized = true;
            } else {
                this.internalVec = new Vector();
            }
            if (this.c == null) {
                this.coeffVec = new DoubleVector();
            }
            this.indexVec = (indeces = this.getAtomIndeces()) != null ? new IntVector(indeces) : new IntVector();
            if (this.ic != null) {
                this.setupIndeces();
            }
        }

        public void finalize() {
            if (!this.finalized) {
                this.setupIndeces();
            }
            this.finalized = true;
        }

        private void setupIndeces() {
            int i;
            if (this.ic == null) {
                this.ic = new InternalCoordinate[this.internalVec.size()];
                this.internalVec.toArray(this.ic);
            } else {
                for (i = 0; i < this.ic.length; ++i) {
                }
            }
            this.reverseIndeces = new int[this.ic.length][];
            for (i = 0; i < this.ic.length; ++i) {
                int[] indx = this.ic[i].getAtomIndeces();
                this.reverseIndeces[i] = new int[indx.length];
                for (int j = 0; j < indx.length; ++j) {
                    int pos = this.indexVec.indexOf(indx[j]);
                    if (pos == -1) {
                        pos = this.indexVec.size();
                        this.indexVec.addElement(indx[j]);
                    }
                    this.reverseIndeces[i][j] = pos;
                }
            }
            int[] indx = this.indexVec.toArray();
            IndxSort is = new IndxSort(indx, this.reverseIndeces);
            this.reverseIndeces = is.getReverseIndeces();
            indx = is.getIndx();
            this.setIndeces(indx);
            this.finalized = true;
            if (this.c == null && this.coeffVec != null) {
                this.c = this.coeffVec.toArray();
            }
            this.bMatLine = new InternalCoordinate.BMatrixLine(this.getAtomIndeces(), new double[this.getAtomIndeces().length * 3]);
        }

        @Override
        public void setType(int type) {
            super.setType(type);
        }

        @Override
        public void setCartesianCoordinates(double[] cartesianCoordinates) {
            InternalCoordinate[] ci = this.getComponentInternals();
            for (int i = 0; i < ci.length; ++i) {
                ci[i].setCartesianCoordinates(cartesianCoordinates);
            }
        }

        @Override
        public double[] fillBMatrixLine(double[] matrixLine) {
            this.finalize();
            JLinAlg.VectClear(matrixLine);
            for (int i = 0; i < this.getComponentInternals().length; ++i) {
                InternalCoordinate ic = this.getComponentInternals()[i];
                double[] compBMLine = ic.getBMatrixLine().getLineArray();
                int[] idx = ic.getAtomIndeces();
                for (int j = 0; j < idx.length; ++j) {
                    int iidx = this.reverseIndeces[i][j];
                    int n = iidx * 3;
                    matrixLine[n] = matrixLine[n] + this.c[i] * compBMLine[j * 3];
                    int n2 = iidx * 3 + 1;
                    matrixLine[n2] = matrixLine[n2] + this.c[i] * compBMLine[j * 3 + 1];
                    int n3 = iidx * 3 + 2;
                    matrixLine[n3] = matrixLine[n3] + this.c[i] * compBMLine[j * 3 + 2];
                }
            }
            return matrixLine;
        }

        @Override
        public InternalCoordinate.BMatrixLine getBMatrixLine() {
            this.finalize();
            this.fillBMatrixLine(this.bMatLine.lineElements);
            return this.bMatLine;
        }

        @Override
        public double getValue() {
            this.finalize();
            double val = 0.0;
            for (int i = 0; i < this.getComponentInternals().length; ++i) {
                val += this.c[i] * this.getComponentInternals()[i].getValue();
            }
            return val;
        }

        @Override
        public double[] getComponentCoefficients() {
            this.finalize();
            return this.c;
        }

        @Override
        public InternalCoordinate[] getComponentInternals() {
            this.finalize();
            return this.ic;
        }

        @Override
        public void setComponentCoefficients(double[] componentCoefficients) {
            if (this.finalized) {
                throw new UnsupportedOperationException("This combined internal has already been finalized...");
            }
            this.c = componentCoefficients;
            this.finalize();
        }

        @Override
        public void normalizeCoefficients() {
            JLinAlg.VectNormalize(this.c.length, this.c, 0, this.c, 0);
        }

        @Override
        public void setComponentInternals(InternalCoordinate[] componentInternals) {
            if (this.finalized) {
                throw new UnsupportedOperationException("This combined internal has already been finalized...");
            }
            this.ic = componentInternals;
        }

        private class IndxSort
        implements JLinAlg.Sortable {
            int[] sortedIndxforIndx = null;
            int[] indx = null;
            int[][] reverseIndeces = null;

            public int[][] getReverseIndeces() {
                return this.reverseIndeces;
            }

            public int[] getIndx() {
                return this.indx;
            }

            IndxSort(int[] indx, int[][] reverseIndeces) {
                int i;
                this.sortedIndxforIndx = new int[indx.length];
                this.indx = indx;
                this.reverseIndeces = reverseIndeces;
                for (int i2 = 0; i2 < this.sortedIndxforIndx.length; ++i2) {
                    this.sortedIndxforIndx[i2] = i2;
                }
                int[] ri = new int[this.sortedIndxforIndx.length];
                JLinAlg.quickSort(0, indx.length - 1, this);
                for (i = 0; i < this.sortedIndxforIndx.length; ++i) {
                    ri[this.sortedIndxforIndx[i]] = i;
                }
                for (i = 0; i < reverseIndeces.length; ++i) {
                    for (int j = 0; j < reverseIndeces[i].length; ++j) {
                        reverseIndeces[i][j] = ri[reverseIndeces[i][j]];
                    }
                }
            }

            @Override
            public boolean isGreater(int i, int j) {
                return this.indx[i] > this.indx[j];
            }

            @Override
            public void swap(int i, int j) {
                int ti = this.indx[i];
                this.indx[i] = this.indx[j];
                this.indx[j] = ti;
                ti = this.sortedIndxforIndx[i];
                this.sortedIndxforIndx[i] = this.sortedIndxforIndx[j];
                this.sortedIndxforIndx[j] = ti;
            }
        }
    }

    public static class InternalLinearBendII
    extends InternalCoordinate
    implements CombinedInternalCoordinate {
        private InternalCoordinate[] ic = null;
        private double[] c = null;

        public InternalLinearBendII(double[] cartesianCoordinates, int[] indeces) {
            super(cartesianCoordinates, indeces);
            this.setType(10);
            this.bMatLine = new InternalCoordinate.BMatrixLine(indeces, new double[indeces.length * 3]);
            this.ic = new InternalBondAngle[2];
            int[] ind1 = new int[]{indeces[0], indeces[1], indeces[3]};
            ind1[3] = indeces[2];
            this.ic[0] = new InternalDihedralAngle(cartesianCoordinates, ind1);
            int[] ind2 = new int[]{indeces[2], indeces[1], indeces[3]};
            ind2[3] = indeces[0];
            this.ic[1] = new InternalDihedralAngle(cartesianCoordinates, ind2);
            this.c = new double[2];
            this.c[0] = 0.5;
            this.c[1] = -0.5;
        }

        @Override
        public void setType(int type) {
            super.setType(type);
        }

        @Override
        public double[] fillBMatrixLine(double[] matrixLine) {
            InternalCoordinate.BMatrixLine b1 = this.getComponentInternals()[0].getBMatrixLine();
            InternalCoordinate.BMatrixLine b2 = this.getComponentInternals()[1].getBMatrixLine();
            double[] c = this.getComponentCoefficients();
            matrixLine[0] = c[0] * b1.lineElements[0] + c[1] * b2.lineElements[9];
            matrixLine[1] = c[0] * b1.lineElements[1] + c[1] * b2.lineElements[10];
            matrixLine[2] = c[0] * b1.lineElements[2] + c[1] * b2.lineElements[11];
            matrixLine[3] = c[0] * b1.lineElements[3] + c[1] * b2.lineElements[3];
            matrixLine[4] = c[0] * b1.lineElements[4] + c[1] * b2.lineElements[4];
            matrixLine[5] = c[0] * b1.lineElements[5] + c[1] * b2.lineElements[5];
            matrixLine[6] = c[0] * b1.lineElements[9] + c[1] * b2.lineElements[0];
            matrixLine[7] = c[0] * b1.lineElements[10] + c[1] * b2.lineElements[1];
            matrixLine[8] = c[0] * b1.lineElements[11] + c[1] * b2.lineElements[2];
            matrixLine[9] = c[0] * b1.lineElements[6] + c[1] * b2.lineElements[6];
            matrixLine[10] = c[0] * b1.lineElements[7] + c[1] * b2.lineElements[7];
            matrixLine[11] = c[0] * b1.lineElements[8] + c[1] * b2.lineElements[8];
            return matrixLine;
        }

        @Override
        public InternalCoordinate.BMatrixLine getBMatrixLine() {
            this.fillBMatrixLine(this.bMatLine.lineElements);
            return this.bMatLine;
        }

        @Override
        public double getValue() {
            double[] c = this.getComponentCoefficients();
            return c[0] * this.getComponentInternals()[0].getValue() + c[1] * this.getComponentInternals()[1].getValue();
        }

        @Override
        public double[] getComponentCoefficients() {
            return this.c;
        }

        @Override
        public InternalCoordinate[] getComponentInternals() {
            return this.ic;
        }

        @Override
        public void setComponentCoefficients(double[] componentCoefficients) {
            this.c = componentCoefficients;
        }

        @Override
        public void normalizeCoefficients() {
            JLinAlg.VectNormalize(this.c.length, this.c, 0, this.c, 0);
        }

        @Override
        public void setComponentInternals(InternalCoordinate[] componentInternals) {
            this.ic = componentInternals;
        }
    }

    public static class InternalLinearBendI
    extends InternalCoordinate
    implements CombinedInternalCoordinate {
        private InternalCoordinate[] ic = null;
        private double[] c = null;

        public InternalLinearBendI(double[] cartesianCoordinates, int[] indeces) {
            super(cartesianCoordinates, indeces);
            this.setType(9);
            this.bMatLine = new InternalCoordinate.BMatrixLine(indeces, new double[indeces.length * 3]);
            InternalCoordinate[] ic = new InternalBondAngle[2];
            int[] ind1 = new int[]{indeces[0], indeces[1], indeces[3]};
            int[] ind2 = new int[]{indeces[2], indeces[1], indeces[3]};
            double[] c = new double[]{1.0, 1.0};
            this.setComponentInternals(ic);
            this.setComponentCoefficients(c);
        }

        @Override
        public void setType(int type) {
            super.setType(type);
        }

        @Override
        public double[] fillBMatrixLine(double[] matrixLine) {
            InternalCoordinate.BMatrixLine b1 = this.getComponentInternals()[0].getBMatrixLine();
            InternalCoordinate.BMatrixLine b2 = this.getComponentInternals()[1].getBMatrixLine();
            double[] c = this.getComponentCoefficients();
            matrixLine[0] = c[0] * b1.lineElements[0] + c[1] * b2.lineElements[3];
            matrixLine[1] = c[0] * b1.lineElements[1] + c[1] * b2.lineElements[4];
            matrixLine[2] = c[0] * b1.lineElements[2] + c[1] * b2.lineElements[5];
            matrixLine[3] = c[0] * b1.lineElements[3] + c[1] * b2.lineElements[6];
            matrixLine[4] = c[0] * b1.lineElements[4] + c[1] * b2.lineElements[7];
            matrixLine[5] = c[0] * b1.lineElements[5] + c[1] * b2.lineElements[8];
            matrixLine[6] = b2.lineElements[0];
            matrixLine[7] = b2.lineElements[1];
            matrixLine[8] = b2.lineElements[2];
            matrixLine[9] = c[0] * b1.lineElements[6] + c[1] * b2.lineElements[9];
            matrixLine[10] = c[0] * b1.lineElements[7] + c[1] * b2.lineElements[10];
            matrixLine[11] = c[0] * b1.lineElements[8] + c[1] * b2.lineElements[11];
            return matrixLine;
        }

        @Override
        public InternalCoordinate.BMatrixLine getBMatrixLine() {
            this.fillBMatrixLine(this.bMatLine.lineElements);
            return this.bMatLine;
        }

        @Override
        public double getValue() {
            double[] c = this.getComponentCoefficients();
            return c[0] * this.getComponentInternals()[0].getValue() + c[1] * this.getComponentInternals()[1].getValue();
        }

        @Override
        public double[] getComponentCoefficients() {
            return this.c;
        }

        @Override
        public InternalCoordinate[] getComponentInternals() {
            return this.ic;
        }

        @Override
        public void setComponentCoefficients(double[] componentCoefficients) {
            this.c = componentCoefficients;
        }

        @Override
        public void normalizeCoefficients() {
            JLinAlg.VectNormalize(this.c.length, this.c, 0, this.c, 0);
        }

        @Override
        public void setComponentInternals(InternalCoordinate[] componentInternals) {
            this.ic = componentInternals;
        }
    }

    public static class InternalImproperDihedral
    extends InternalCoordinate
    implements CombinedInternalCoordinate {
        private InternalCoordinate[] ic = null;
        private double[] c = null;

        public InternalImproperDihedral(double[] cartesianCoordinates, int[] indeces) {
            super(cartesianCoordinates, indeces);
            this.setType(5);
            this.bMatLine = new InternalCoordinate.BMatrixLine(indeces, new double[indeces.length * 3]);
            int[] ind1 = new int[4];
            InternalCoordinate[] dihedrals = new InternalCoordinate[2];
            double[] coefficients = new double[]{-0.5, 0.5};
            ind1[0] = indeces[0];
            ind1[1] = indeces[2];
            ind1[2] = indeces[1];
            ind1[3] = indeces[3];
            dihedrals[0] = new InternalDihedralAngle(cartesianCoordinates, ind1);
            int[] ind2 = new int[]{indeces[2], indeces[0], indeces[1], indeces[3]};
            dihedrals[1] = new InternalDihedralAngle(cartesianCoordinates, ind2);
            this.setComponentInternals(dihedrals);
            this.setComponentCoefficients(coefficients);
        }

        @Override
        public void setType(int type) {
            super.setType(type);
        }

        @Override
        public double[] fillBMatrixLine(double[] matrixLine) {
            InternalCoordinate.BMatrixLine b1 = this.getComponentInternals()[0].getBMatrixLine();
            InternalCoordinate.BMatrixLine b2 = this.getComponentInternals()[1].getBMatrixLine();
            double[] c = this.getComponentCoefficients();
            matrixLine[0] = c[0] * b1.lineElements[0] + c[1] * b2.lineElements[3];
            matrixLine[1] = c[0] * b1.lineElements[1] + c[1] * b2.lineElements[4];
            matrixLine[2] = c[0] * b1.lineElements[2] + c[1] * b2.lineElements[5];
            matrixLine[3] = c[0] * b1.lineElements[6] + c[1] * b2.lineElements[6];
            matrixLine[4] = c[0] * b1.lineElements[7] + c[1] * b2.lineElements[7];
            matrixLine[5] = c[0] * b1.lineElements[8] + c[1] * b2.lineElements[8];
            matrixLine[6] = c[0] * b1.lineElements[3] + c[1] * b2.lineElements[0];
            matrixLine[7] = c[0] * b1.lineElements[4] + c[1] * b2.lineElements[1];
            matrixLine[8] = c[0] * b1.lineElements[5] + c[1] * b2.lineElements[2];
            matrixLine[9] = c[0] * b1.lineElements[9] + c[1] * b2.lineElements[9];
            matrixLine[10] = c[0] * b1.lineElements[10] + c[1] * b2.lineElements[10];
            matrixLine[11] = c[0] * b1.lineElements[11] + c[1] * b2.lineElements[11];
            return matrixLine;
        }

        @Override
        public InternalCoordinate.BMatrixLine getBMatrixLine() {
            this.fillBMatrixLine(this.bMatLine.lineElements);
            return this.bMatLine;
        }

        @Override
        public double getValue() {
            double[] c = this.getComponentCoefficients();
            return Math.PI + c[0] * this.getComponentInternals()[0].getValue() + c[1] * this.getComponentInternals()[1].getValue();
        }

        @Override
        public double[] getComponentCoefficients() {
            return this.c;
        }

        @Override
        public InternalCoordinate[] getComponentInternals() {
            return this.ic;
        }

        @Override
        public void setComponentCoefficients(double[] componentCoefficients) {
            this.c = componentCoefficients;
        }

        @Override
        public void setComponentInternals(InternalCoordinate[] componentInternals) {
            this.ic = componentInternals;
        }

        @Override
        public void normalizeCoefficients() {
            JLinAlg.VectNormalize(this.c.length, this.c, 0, this.c, 0);
        }
    }

    public static class InternalOutOfPlaneAngle
    extends InternalCoordinate {
        public InternalOutOfPlaneAngle(double[] cartesianCoordinates, int[] indeces) {
            super(cartesianCoordinates, indeces);
            this.setType(4);
            this.bMatLine = new InternalCoordinate.BMatrixLine(indeces, new double[indeces.length * 3]);
        }

        @Override
        public double[] fillBMatrixLine(double[] matrixLine) {
            double[] coords = this.getCartesianCoordinates();
            int a1 = this.getAtomIndeces()[0];
            int a2 = this.getAtomIndeces()[1];
            int a3 = this.getAtomIndeces()[2];
            int a4 = this.getAtomIndeces()[3];
            double[] b21 = Internals.b(a2, a1, coords, new double[3]);
            double lb21 = JLinAlg.VLength(b21);
            double[] bu21 = JLinAlg.VectScale(b21, 1.0 / lb21, new double[3]);
            double[] b23 = Internals.b(a2, a3, coords, new double[3]);
            double lb23 = JLinAlg.VLength(b23);
            double[] bu23 = JLinAlg.VectScale(b23, 1.0 / lb23, new double[3]);
            double[] wu1 = Internals.o(b21, b23, new double[3]);
            double lw1 = JLinAlg.VLength(wu1);
            JLinAlg.VectScale(wu1, 1.0 / lw1, wu1);
            double[] b24 = Internals.b(a2, a4, coords, new double[3]);
            double lb24 = JLinAlg.VLength(b24);
            double sin = JLinAlg.VDot(b24, wu1) / lb24;
            sin = Math.max(-1.0, Math.min(1.0, sin));
            if (sin == 1.0) {
                JLinAlg.VectClear(12, matrixLine, 0);
                return matrixLine;
            }
            JLinAlg.VectScaleAndAdd(3, wu1, 0, -sin / lb24, b24, 0, matrixLine, 9);
            double cos = Math.sqrt(1.0 - sin * sin);
            JLinAlg.VectScale(3, matrixLine, 9, 1.0 / (cos * lb24), matrixLine, 9);
            double sinPhi1 = lw1 / (lb21 * lb23);
            double cosPhi1 = JLinAlg.VDot(b21, b23) / (lb21 * lb23);
            double[] w34 = Internals.o(b23, b24, new double[3]);
            double sc1 = 1.0 / (lb21 * lb23 * lb24 * cos * sinPhi1);
            JLinAlg.VectScale(3, w34, 0, sc1, matrixLine, 0);
            double[] wx = JLinAlg.VectScaleAndAdd(bu21, -cosPhi1, bu23, new double[3]);
            double sc2 = -sin / (lb21 * cos * sinPhi1 * sinPhi1);
            JLinAlg.VectScaleAndAdd(3, matrixLine, 0, sc2, wx, 0, matrixLine, 0);
            double[] w14 = Internals.o(b24, b21, new double[3]);
            JLinAlg.VectScale(3, w14, 0, sc1, matrixLine, 6);
            wx = JLinAlg.VectScaleAndAdd(bu23, -cosPhi1, bu21, wx);
            sc2 = -sin / (lb23 * cos * sinPhi1 * sinPhi1);
            JLinAlg.VectScaleAndAdd(3, matrixLine, 6, sc2, wx, 0, matrixLine, 6);
            matrixLine[3] = -matrixLine[0] - matrixLine[6] - matrixLine[9];
            matrixLine[4] = -matrixLine[1] - matrixLine[7] - matrixLine[10];
            matrixLine[5] = -matrixLine[2] - matrixLine[8] - matrixLine[11];
            return matrixLine;
        }

        @Override
        public InternalCoordinate.BMatrixLine getBMatrixLine() {
            this.fillBMatrixLine(this.bMatLine.lineElements);
            if (this.bMatLine.atomIndeces.length * 3 != this.bMatLine.lineElements.length) {
                throw new UnsupportedOperationException("Array mismatch.");
            }
            return this.bMatLine;
        }

        @Override
        public double getValue() {
            double[] coords = this.getCartesianCoordinates();
            int a1 = this.getAtomIndeces()[0];
            int a2 = this.getAtomIndeces()[1];
            int a3 = this.getAtomIndeces()[2];
            int a4 = this.getAtomIndeces()[3];
            double[] b21 = Internals.b(a2, a1, coords, new double[3]);
            double[] b23 = Internals.b(a2, a3, coords, new double[3]);
            double[] wu1 = Internals.ou(b21, b23, new double[3]);
            double[] b24 = Internals.b(a2, a4, coords, new double[3]);
            double lb24 = JLinAlg.VLength(b24);
            double sin = JLinAlg.VDot(b24, wu1) / lb24;
            sin = Math.max(-1.0, Math.min(1.0, sin));
            return Math.asin(sin);
        }
    }

    public static class InternalDihedralAngle
    extends InternalCoordinate {
        public InternalDihedralAngle(double[] cartesianCoordinates, int[] indeces) {
            super(cartesianCoordinates, indeces);
            this.setType(3);
            this.bMatLine = new InternalCoordinate.BMatrixLine(indeces, new double[indeces.length * 3]);
        }

        @Override
        public double[] fillBMatrixLine(double[] matrixLine) {
            double[] coords = this.getCartesianCoordinates();
            int a1 = this.getAtomIndeces()[0];
            int a2 = this.getAtomIndeces()[1];
            int a3 = this.getAtomIndeces()[2];
            int a4 = this.getAtomIndeces()[3];
            double[] b12 = Internals.b(a1, a2, coords, new double[3]);
            double[] ub23 = Internals.b(a2, a3, coords, new double[3]);
            double lb23 = JLinAlg.VLength(ub23);
            ub23 = JLinAlg.VectScale(ub23, 1.0 / lb23, ub23);
            double[] b34 = Internals.b(a3, a4, coords, new double[3]);
            double[] w1 = Internals.o(b12, ub23, new double[3]);
            double l2w1 = JLinAlg.VDot(w1, w1);
            JLinAlg.VectScale(3, w1, 0, -1.0 / l2w1, matrixLine, 0);
            double[] w2 = Internals.o(ub23, b34, new double[3]);
            double l2w2 = JLinAlg.VDot(w2, w2);
            JLinAlg.VectScale(3, w2, 0, 1.0 / l2w2, matrixLine, 9);
            double sc1 = (lb23 + JLinAlg.VDot(b12, ub23)) / lb23;
            JLinAlg.VectScale(3, matrixLine, 0, -sc1, matrixLine, 3);
            double sc2 = JLinAlg.VDot(b34, ub23) / lb23;
            JLinAlg.VectScaleAndAdd(3, matrixLine, 3, sc2, matrixLine, 9, matrixLine, 3);
            matrixLine[6] = -matrixLine[0] - matrixLine[3] - matrixLine[9];
            matrixLine[7] = -matrixLine[1] - matrixLine[4] - matrixLine[10];
            matrixLine[8] = -matrixLine[2] - matrixLine[5] - matrixLine[11];
            return matrixLine;
        }

        @Override
        public InternalCoordinate.BMatrixLine getBMatrixLine() {
            this.fillBMatrixLine(this.bMatLine.lineElements);
            return this.bMatLine;
        }

        @Override
        public double getValue() {
            double[] coords = this.getCartesianCoordinates();
            int a1 = this.getAtomIndeces()[0];
            int a2 = this.getAtomIndeces()[1];
            int a3 = this.getAtomIndeces()[2];
            int a4 = this.getAtomIndeces()[3];
            double[] b12 = Internals.b(a1, a2, coords, new double[3]);
            double[] ub23 = Internals.bu(a2, a3, coords, new double[3]);
            double[] b34 = Internals.b(a3, a4, coords, new double[3]);
            double[] wu1 = Internals.ou(b12, ub23, new double[3]);
            double[] wu2 = Internals.ou(ub23, b34, new double[3]);
            double x = JLinAlg.VDot(wu1, wu2);
            double y = JLinAlg.VDot(Internals.o(wu1, wu2, new double[3]), ub23);
            x = Math.min(1.0, Math.max(-1.0, x));
            y = Math.min(1.0, Math.max(-1.0, y));
            return Math.atan2(y, x);
        }

        @Override
        public double checkValueChange(double valueChange) {
            double pi = Math.PI;
            while (valueChange > pi) {
                valueChange -= 2.0 * pi;
            }
            while (valueChange < -pi) {
                valueChange += 2.0 * pi;
            }
            return valueChange;
        }
    }

    public static class InternalCosAngle
    extends InternalCoordinate {
        public InternalCosAngle(double[] cartesianCoordinates, int[] indeces) {
            super(cartesianCoordinates, indeces);
            this.setType(6);
            this.bMatLine = new InternalCoordinate.BMatrixLine(indeces, new double[indeces.length * 3]);
        }

        @Override
        public double[] fillBMatrixLine(double[] matrixLine) {
            double[] coords = this.getCartesianCoordinates();
            int a1 = this.getAtomIndeces()[0];
            int a2 = this.getAtomIndeces()[1];
            int a3 = this.getAtomIndeces()[2];
            double x1 = coords[a1 * 3];
            double y1 = coords[a1 * 3 + 1];
            double z1 = coords[a1 * 3 + 2];
            double x2 = coords[a2 * 3];
            double y2 = coords[a2 * 3 + 1];
            double z2 = coords[a2 * 3 + 2];
            double x3 = coords[a3 * 3];
            double y3 = coords[a3 * 3 + 1];
            double z3 = coords[a3 * 3 + 2];
            double dx1 = (x3 - x2) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -1.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) * (2.0 * x1 - 2.0 * x2) / 2.0;
            double dy1 = (y3 - y2) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -1.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) * (2.0 * y1 - 2.0 * y2) / 2.0;
            double dz1 = (z3 - z2) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -1.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) * (2.0 * z1 - 2.0 * z2) / 2.0;
            double dx2 = (-x3 + 2.0 * x2 - x1) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -1.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) * (-2.0 * x1 + 2.0 * x2) / 2.0 - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -1.5) * (-2.0 * x3 + 2.0 * x2) / 2.0;
            double dy2 = (-y3 + 2.0 * y2 - y1) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -1.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) * (-2.0 * y1 + 2.0 * y2) / 2.0 - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -1.5) * (-2.0 * y3 + 2.0 * y2) / 2.0;
            double dz2 = (-z3 + 2.0 * z2 - z1) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -1.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) * (-2.0 * z1 + 2.0 * z2) / 2.0 - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -1.5) * (-2.0 * z3 + 2.0 * z2) / 2.0;
            double dx3 = (x1 - x2) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -1.5) * (2.0 * x3 - 2.0 * x2) / 2.0;
            double dy3 = (y1 - y2) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -1.5) * (2.0 * y3 - 2.0 * y2) / 2.0;
            double dz3 = (z1 - z2) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -0.5) - ((x1 - x2) * (x3 - x2) + (y1 - y2) * (y3 - y2) + (z1 - z2) * (z3 - z2)) * Math.pow(x1 * x1 - 2.0 * x1 * x2 + x2 * x2 + y1 * y1 - 2.0 * y1 * y2 + y2 * y2 + z1 * z1 - 2.0 * z1 * z2 + z2 * z2, -0.5) * Math.pow(x3 * x3 - 2.0 * x3 * x2 + x2 * x2 + y3 * y3 - 2.0 * y3 * y2 + y2 * y2 + z3 * z3 - 2.0 * z3 * z2 + z2 * z2, -1.5) * (2.0 * z3 - 2.0 * z2) / 2.0;
            matrixLine[0] = dx1;
            matrixLine[1] = dy1;
            matrixLine[2] = dz1;
            matrixLine[3] = dx2;
            matrixLine[4] = dy2;
            matrixLine[5] = dz2;
            matrixLine[6] = dx3;
            matrixLine[7] = dy3;
            matrixLine[8] = dz3;
            return matrixLine;
        }

        @Override
        public InternalCoordinate.BMatrixLine getBMatrixLine() {
            this.fillBMatrixLine(this.bMatLine.lineElements);
            return this.bMatLine;
        }

        @Override
        public double getValue() {
            double[] coords = this.getCartesianCoordinates();
            int a1 = this.getAtomIndeces()[0];
            int a2 = this.getAtomIndeces()[1];
            int a3 = this.getAtomIndeces()[2];
            double[] u1 = Internals.bu(a2, a1, coords, new double[3]);
            double[] u2 = Internals.bu(a2, a3, coords, new double[3]);
            double cos = JLinAlg.VDot(u1, u2);
            cos = Math.max(-1.0, Math.min(1.0, cos));
            return cos;
        }
    }

    public static class InternalBondAngle
    extends InternalCoordinate {
        public InternalBondAngle(double[] cartesianCoordinates, int[] indeces) {
            super(cartesianCoordinates, indeces);
            this.setType(2);
            this.bMatLine = new InternalCoordinate.BMatrixLine(indeces, new double[indeces.length * 3]);
        }

        @Override
        public double[] fillBMatrixLine(double[] matrixLine) {
            double[] coords = this.getCartesianCoordinates();
            int a1 = this.getAtomIndeces()[0];
            int a2 = this.getAtomIndeces()[1];
            int a3 = this.getAtomIndeces()[2];
            double[] v1 = Internals.b(a2, a1, coords, new double[3]);
            double[] v2 = Internals.b(a2, a3, coords, new double[3]);
            double[] w = Internals.ou(v1, v2, new double[3]);
            double v1v1 = JLinAlg.VDot(v1, v1);
            double v2v2 = JLinAlg.VDot(v2, v2);
            double[] der = Internals.o(v1, w, new double[3]);
            matrixLine[0] = der[0] / v1v1;
            matrixLine[1] = der[1] / v1v1;
            matrixLine[2] = der[2] / v1v1;
            der = Internals.o(w, v2, der);
            matrixLine[6] = der[0] / v2v2;
            matrixLine[7] = der[1] / v2v2;
            matrixLine[8] = der[2] / v2v2;
            matrixLine[3] = -matrixLine[0] - matrixLine[6];
            matrixLine[4] = -matrixLine[1] - matrixLine[7];
            matrixLine[5] = -matrixLine[2] - matrixLine[8];
            return matrixLine;
        }

        @Override
        public InternalCoordinate.BMatrixLine getBMatrixLine() {
            this.fillBMatrixLine(this.bMatLine.lineElements);
            return this.bMatLine;
        }

        @Override
        public double getValue() {
            double[] coords = this.getCartesianCoordinates();
            int a1 = this.getAtomIndeces()[0];
            int a2 = this.getAtomIndeces()[1];
            int a3 = this.getAtomIndeces()[2];
            double[] u1 = Internals.bu(a2, a1, coords, new double[3]);
            double[] u2 = Internals.bu(a2, a3, coords, new double[3]);
            double cos = JLinAlg.VDot(u1, u2);
            cos = Math.max(-1.0, Math.min(1.0, cos));
            return Math.acos(cos);
        }
    }

    public static class InternalBondLength
    extends InternalCoordinate {
        public InternalBondLength(double[] cartesianCoordinates, int[] indeces) {
            super(cartesianCoordinates, indeces);
            this.setType(1);
            this.bMatLine = new InternalCoordinate.BMatrixLine(indeces, new double[indeces.length * 3]);
        }

        @Override
        public double[] fillBMatrixLine(double[] matrixLine) {
            JLinAlg.VectClear(matrixLine);
            double[] dUnit = JLinAlg.VectUnit(3, JLinAlg.vectSubtract(3, this.getCartesianCoordinates(), this.getAtomIndeces()[0] * 3, this.getCartesianCoordinates(), this.getAtomIndeces()[1] * 3), 0, null);
            JLinAlg.VectAdd(3, dUnit, 0, matrixLine, 0, matrixLine, 0);
            JLinAlg.vectSubtract(3, matrixLine, 3, dUnit, 0, matrixLine, 3);
            return matrixLine;
        }

        @Override
        public InternalCoordinate.BMatrixLine getBMatrixLine() {
            this.fillBMatrixLine(this.bMatLine.lineElements);
            return this.bMatLine;
        }

        @Override
        public double getValue() {
            return JLinAlg.VLength(JLinAlg.vectSubtract(3, this.getCartesianCoordinates(), this.getAtomIndeces()[0] * 3, this.getCartesianCoordinates(), this.getAtomIndeces()[1] * 3));
        }
    }

    public static class InternalCartesian
    extends InternalCoordinate {
        protected InternalCartesian(double[] cartesianCoordinates, int[] indeces) {
            super(cartesianCoordinates, indeces);
            super.setType(0);
            this.bMatLine = new InternalCoordinate.BMatrixLine(indeces, new double[3]);
        }

        public InternalCartesian(double[] cartesianCoordinates, int index, int type) {
            super(cartesianCoordinates, null);
            int[] indeces = new int[]{index};
            this.setIndeces(indeces);
            this.setType(type);
            this.bMatLine = new InternalCoordinate.BMatrixLine(indeces, new double[3]);
        }

        @Override
        public void setType(int type) {
            if (type != 17 && type != 18 && type != 19) {
                throw new UnsupportedOperationException("Invalid coordinate type.");
            }
            super.setType(type);
        }

        @Override
        public double[] fillBMatrixLine(double[] matrixLine) {
            if (this.getType() == 0) {
                throw new UnsupportedOperationException("Invalid coordinate type");
            }
            int j = this.getType() - 17;
            for (int i = 0; i < matrixLine.length; ++i) {
                matrixLine[i] = 0.0;
                if (i != j) continue;
                matrixLine[j] = 1.0;
            }
            return matrixLine;
        }

        @Override
        public double getValue() {
            int j = this.getType() - 17;
            return this.getCartesianCoordinates()[this.getAtomIndeces()[0] * 3 + j];
        }

        @Override
        public InternalCoordinate.BMatrixLine getBMatrixLine() {
            this.fillBMatrixLine(this.bMatLine.lineElements);
            return this.bMatLine;
        }
    }
}

