/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.calculations.clean.Opt3D;
import chemaxon.calculations.clean.Optimization;
import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.ForceField;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import java.util.BitSet;

public class DreidingFF
extends ForceField {
    BitSet funcFlags = new BitSet(4);
    Optimization.FunctionOptimization funct = null;
    myMolecule molFrag = null;
    SelectionMolecule[] selMol;
    double[] var = null;
    double[] grad = null;
    static final double scale = 627.51;

    public DreidingFF(Molecule mol) throws MDException {
        if (mol == null || mol.isEmpty()) {
            throw new MDException("Molecule is empty.");
        }
        if (mol.getFragCount() > 1) {
            if ((Debug.debuglevel & 8) > 0) {
                Debug.debugstream.println("FATAL: Multiple fragments!!!");
            }
            throw new MDException("Can't handle multiple fragment molecule.");
        }
        try {
            this.selMol = mol.findFrags();
            this.molFrag = new myMolecule(this.selMol[0], null, null);
            this.molFrag.fillDreidingDescriptors();
            this.funct = new Opt3D.MMOptimization(this.molFrag, null);
            this.var = this.funct.getVariablesScratch();
            this.grad = this.funct.getGradientsScratch();
        }
        catch (Exception e) {
            throw new MDException("Dreiding initialization failed.");
        }
    }

    @Override
    protected double CalcEnergy(double[] coords) throws MDException {
        try {
            BitSet funcFlags = new BitSet(4);
            System.arraycopy(coords, 0, this.var, 0, coords.length);
            funcFlags.set(3);
            funcFlags.set(0);
            double energy = this.funct.GetFunction(funcFlags) * 627.51;
            if ((Debug.debuglevel & 4) > 0) {
                Debug.debugstream.println("Dreiding.Energy:" + energy);
            }
            this.lastEnergy = energy;
            return energy;
        }
        catch (Exception e) {
            throw new MDException("Error in Dreiding energy calculation.");
        }
    }

    @Override
    protected double[] CalcForce(double[] coords) throws MDException {
        try {
            BitSet funcFlags = new BitSet(4);
            System.arraycopy(coords, 0, this.var, 0, coords.length);
            funcFlags.set(3);
            funcFlags.set(0);
            funcFlags.set(1);
            this.lastEnergy = this.funct.GetFunction(funcFlags);
            int i = 0;
            while (i < this.grad.length) {
                int n = i++;
                this.grad[n] = this.grad[n] * 627.51;
            }
            if ((Debug.debuglevel & 4) > 0) {
                int j = 1;
                Debug.debugstream.println("Dreiding.Gradients:");
                for (int i2 = 0; i2 < this.grad.length; i2 += 3) {
                    Debug.debugstream.println(j + ". " + this.grad[i2] + "\t" + this.grad[i2 + 1] + "\t" + this.grad[i2 + 2]);
                    ++j;
                }
                Debug.debugstream.println();
            }
            return this.grad;
        }
        catch (Exception e) {
            throw new MDException("Error in Dreiding force calculation.");
        }
    }
}

