/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.linalg.EquationSequenceSolver;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.mm.BMatrix;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.BitSet;

public class InternalCoordinateProjection {
    private Molecule mol;
    private BMatrix bmat;
    private BitSet ringAtoms = new BitSet();
    private boolean useSolver = true;
    private EquationSequenceSolver eSS = null;
    int[][] connectionTab;

    InternalCoordinateProjection(Molecule mol) {
        this.mol = mol;
        this.bmat = new BMatrix(mol);
        int[][] sSSR = mol.getSSSR();
        for (int i = 0; i < sSSR.length; ++i) {
            for (int j = 0; j < sSSR[i].length; ++j) {
                this.ringAtoms.set(sSSR[i][j]);
            }
        }
        if (this.useSolver) {
            this.eSS = new EquationSequenceSolver();
        }
    }

    public JLinAlg.Matrix calculateBondLengthB(double[] coords) {
        int i;
        boolean doAngles = true;
        this.bmat.setCrd(coords);
        this.bmat.calcBondGeom();
        BMatrix.BMatrixBond[] bb = this.bmat.getBonds();
        JLinAlg.Matrix matrixB = null;
        BMatrix.BMatrixAngle[] ba = null;
        if (doAngles) {
            ba = this.bmat.getAngles();
        }
        ArrayList<double[]> bLines = new ArrayList<double[]>();
        for (i = 0; i < bb.length; ++i) {
            double[] bLine = new double[this.mol.getAtomCount() * 3];
            int idx1 = bb[i].getA1().getPos();
            int idx2 = bb[i].getA2().getPos();
            double[] r = bb[i].getBMatrixRow();
            bLine[idx1] = r[0];
            bLine[idx1 + 1] = r[1];
            bLine[idx1 + 2] = r[2];
            bLine[idx2] = r[3];
            bLine[idx2 + 1] = r[4];
            bLine[idx2 + 2] = r[5];
            bLines.add(bLine);
        }
        if (doAngles) {
            for (i = 0; i < ba.length; ++i) {
                int idx1 = ba[i].getA1().getPos();
                int idx2 = ba[i].getA2().getPos();
                int idx3 = ba[i].getA3().getPos();
                int iA1 = ba[i].getA1().getID();
                int iA2 = ba[i].getA2().getID();
                int iA3 = ba[i].getA3().getID();
                if (this.ringAtoms.get(iA2) && this.ringAtoms.get(iA1) == this.ringAtoms.get(iA3)) continue;
                double[] a = ba[i].getBMatrixRow();
                double[] bLine = new double[this.mol.getAtomCount() * 3];
                bLine[idx1] = a[0];
                bLine[idx1 + 1] = a[1];
                bLine[idx1 + 2] = a[2];
                bLine[idx2] = a[3];
                bLine[idx2 + 1] = a[4];
                bLine[idx2 + 2] = a[5];
                bLine[idx3] = a[6];
                bLine[idx3 + 1] = a[7];
                bLine[idx3 + 2] = a[8];
                bLines.add(bLine);
            }
        }
        matrixB = new JLinAlg.Matrix(bLines.size(), this.mol.getAtomCount() * 3);
        for (i = 0; i < bLines.size(); ++i) {
            matrixB.setRow(i, (double[])bLines.get(i), 0);
        }
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("B matrix:");
            for (int j = 0; j < matrixB.nRows; ++j) {
                Debug.debugstream.print(j + ". row ");
                for (int k = 0; k < matrixB.nCols; ++k) {
                    Debug.debugstream.print(matrixB.getElement(j, k) + ", ");
                }
                Debug.debugstream.println();
            }
        }
        return matrixB;
    }

    public double[] projectVelocities(JLinAlg.Matrix matrixB, double[] speeds) {
        if (this.useSolver) {
            if (this.eSS == null) {
                this.eSS = new EquationSequenceSolver();
            }
            return this.eSS.solve(matrixB, JLinAlg.mVMultiply(matrixB, speeds));
        }
        matrixB.reDiagonalize(0.001);
        JLinAlg.Matrix matrixBinv = matrixB.getInverse(0.001);
        JLinAlg.Matrix projectorP = JLinAlg.mMMultiply(matrixBinv, matrixB);
        double[] pSpeeds = JLinAlg.mVMultiply(projectorP, speeds);
        return pSpeeds;
    }
}

