/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.ForceField;
import chemaxon.marvin.modelling.md.Integrator;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.md.MDTools;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Iterator;

public class LeapFrog
extends MDTools
implements Integrator {
    double[] v_prev;
    double[] a;
    double[] grad;
    double potenergy = 0.0;
    double dt = 1.0;
    ForceField ff = null;

    public LeapFrog(Molecule mol, ForceField forcefield) throws MDException {
        super(mol);
        if (forcefield == null) {
            throw new MDException("Force field must be initialized before intergrator called.");
        }
        this.a = new double[this.atomcount * 3];
        this.grad = new double[this.atomcount * 3];
        this.v_prev = new double[this.atomcount * 3];
        this.ff = forcefield;
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.grad[i] = 0.0;
            this.v_prev[i] = 0.0;
            this.a[i] = 0.0;
        }
    }

    @Override
    public void setStepTime(double femtosectimestep) throws MDException {
        if (femtosectimestep <= 0.0) {
            throw new MDException("Time step should be positive.");
        }
        this.dt = femtosectimestep;
    }

    @Override
    public void setTemperature(double temperature) throws MDException {
        super.setTemperature(temperature);
        System.arraycopy(this.velocities, 0, this.v_prev, 0, this.velocities.length);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Temperature position update");
        }
    }

    @Override
    public double getPotentialEnergy() {
        return this.potenergy;
    }

    @Override
    public Iterator Update() {
        return new UpdateData();
    }

    class UpdateData
    implements Iterator {
        UpdateData() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        public Object next() {
            double matommass;
            MolAtom matom;
            int i;
            if ((Debug.debuglevel & 1) > 0) {
                Debug.debugstream.println("NEXT MD step...");
                Debug.debugstream.println("Next atomcount:" + LeapFrog.this.atomcount);
                Debug.debugstream.println("Next length:" + LeapFrog.this.coords.length);
                Debug.debugstream.println("Step time: " + LeapFrog.this.dt + " fs");
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i = 0; i < LeapFrog.this.atomcount; ++i) {
                    matom = LeapFrog.this.mdmol.getAtom(i);
                    matommass = matom.getMass();
                    Debug.debugstream.println(i + ".\t" + matommass + "\t" + LeapFrog.this.coords[i * 3] + "\t" + LeapFrog.this.coords[i * 3 + 1] + "\t" + LeapFrog.this.coords[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Next coordinates (x y z) Angstrom");
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i = 0; i < LeapFrog.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + LeapFrog.this.velocities[i * 3] + "\t" + LeapFrog.this.velocities[i * 3 + 1] + "\t" + LeapFrog.this.velocities[i * 3 + 2]);
                }
                Debug.debugstream.println();
            }
            try {
                LeapFrog.this.grad = LeapFrog.this.ff.Force(LeapFrog.this.coords);
                LeapFrog.this.potenergy = LeapFrog.this.ff.Energy(LeapFrog.this.coords);
            }
            catch (MDException e) {
                return e;
            }
            for (i = 0; i < LeapFrog.this.atomcount; ++i) {
                matom = LeapFrog.this.mdmol.getAtom(i);
                matommass = matom.getMass();
                for (int j = 0; j < 3; ++j) {
                    int idx = i * 3 + j;
                    LeapFrog.this.a[idx] = -4.1868E-4 * LeapFrog.this.grad[idx] / matommass;
                    double v = LeapFrog.this.v_prev[idx] + LeapFrog.this.a[idx] * LeapFrog.this.dt;
                    LeapFrog.this.velocities[idx] = (v + LeapFrog.this.v_prev[idx]) / 2.0;
                    LeapFrog.this.coords[idx] = LeapFrog.this.coords[idx] + v * LeapFrog.this.dt;
                    LeapFrog.this.v_prev[idx] = v;
                }
            }
            if ((Debug.debuglevel & 1) > 0) {
                Debug.debugstream.println("Accelerations (x y z) Angstrom/femtosecond^2");
                for (i = 0; i < LeapFrog.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + LeapFrog.this.a[i * 3] + "\t" + LeapFrog.this.a[i * 3 + 1] + "\t" + LeapFrog.this.a[i * 3 + 2]);
                }
                Debug.debugstream.println();
            }
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("After MD step...");
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i = 0; i < LeapFrog.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + LeapFrog.this.coords[i * 3] + "\t" + LeapFrog.this.coords[i * 3 + 1] + "\t" + LeapFrog.this.coords[i * 3 + 2]);
                }
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i = 0; i < LeapFrog.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + LeapFrog.this.velocities[i * 3] + "\t" + LeapFrog.this.velocities[i * 3 + 1] + "\t" + LeapFrog.this.velocities[i * 3 + 2]);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

