/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.JQuatFit;
import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.InternalCoordinateProjection;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.md.Thermostat;
import chemaxon.marvin.modelling.util.Stopper;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class MDTools {
    Molecule mdmol;
    int atomcount;
    final double[] coords;
    final double[] velocities;
    Thermostat tt = null;
    protected boolean internalProjection = false;
    protected boolean translationRotationProjection = false;
    protected boolean virtualResistance = false;
    protected double resistanceCoeff = 0.0;
    protected InternalCoordinateProjection icp = null;
    protected boolean activeTermostat = false;
    protected boolean useMassWeightedBMatrix = true;
    protected JLinAlg.Matrix matrixB = null;
    protected JLinAlg.Matrix massWeightedBMatrix = null;
    protected int[][] qfitpairs = null;
    protected double dt = 1.0;
    protected Stopper bMatStopper = null;
    protected Stopper mdStopper = null;
    protected Stopper projectionStopper = null;

    public MDTools(Molecule mol) throws MDException {
        int i;
        if (mol == null || mol.isEmpty()) {
            throw new MDException("Molecule is empty.");
        }
        if (mol.getFragCount() > 1) {
            throw new MDException("Can't handle multifragment molecules.");
        }
        this.mdmol = mol;
        this.atomcount = mol.getAtomCount();
        this.coords = new double[this.atomcount * 3];
        this.velocities = new double[this.atomcount * 3];
        for (i = 0; i < this.atomcount; ++i) {
            MolAtom matom = this.mdmol.getAtom(i);
            if (matom.getMass() == 0.0) {
                throw new MDException("Molecule is not valid. Atommass can't be zero!");
            }
            this.coords[3 * i] = matom.getX();
            this.coords[3 * i + 1] = matom.getY();
            this.coords[3 * i + 2] = matom.getZ();
        }
        for (i = 0; i < this.velocities.length; ++i) {
            this.velocities[i] = 0.0;
        }
        this.tt = new Thermostat(this.mdmol, this.velocities);
        this.mdStopper = new Stopper(false, "MD Stopper");
        this.bMatStopper = new Stopper(false, "BMat Stopper");
        this.projectionStopper = new Stopper(false, "Projection Stopper");
    }

    public void setCoordinates(double[] newcoords) throws MDException {
        if (newcoords == null) {
            throw new MDException("New coordinate array is null.");
        }
        if (this.coords.length != newcoords.length) {
            throw new MDException("New coordinate array dimension is incompatible with the current molecule.");
        }
        System.arraycopy(newcoords, 0, this.coords, 0, newcoords.length);
        for (int i = 0; i < this.atomcount; ++i) {
            MolAtom matom = this.mdmol.getAtom(i);
            matom.setXYZ(newcoords[i * 3], newcoords[i * 3 + 1], newcoords[i * 3 + 2]);
        }
    }

    public void storeCoordinates(Molecule m, double[] d) throws MDException {
        if (d == null) {
            throw new MDException("New coordinate array is null.");
        }
        if (m == null) {
            throw new MDException("Molecule parameter is null.");
        }
        if (m.getAtomCount() * 3 != d.length) {
            throw new MDException("New coordinate array dimension is incompatible with the parameter molecule.");
        }
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            m.getAtom(i).setXYZ(d[3 * i], d[3 * i + 1], d[3 * i + 2]);
        }
    }

    public void centerCoordinates() {
        if (this.coords != null && this.coords.length != 0) {
            int i;
            double avgx = 0.0;
            double avgy = 0.0;
            double avgz = 0.0;
            for (i = 0; i < this.atomcount; ++i) {
                avgx += this.coords[i * 3];
                avgy += this.coords[i * 3 + 1];
                avgz += this.coords[i * 3 + 2];
            }
            avgx /= (double)this.atomcount;
            avgy /= (double)this.atomcount;
            avgz /= (double)this.atomcount;
            for (i = 0; i < this.atomcount; ++i) {
                int n = i * 3;
                this.coords[n] = this.coords[n] - avgx;
                int n2 = i * 3 + 1;
                this.coords[n2] = this.coords[n2] - avgy;
                int n3 = i * 3 + 2;
                this.coords[n3] = this.coords[n3] - avgz;
            }
        }
    }

    public void setVelocities(double[] newvelocities) throws MDException {
        if (newvelocities == null) {
            throw new MDException("Velocity array is null.");
        }
        if (this.velocities.length != newvelocities.length) {
            throw new MDException("New velocity array dimension is incompatible.");
        }
        double[] tmpVelocities = newvelocities;
        if (this.internalProjection || this.translationRotationProjection) {
            tmpVelocities = this.getProjectedVelocities(newvelocities);
        }
        System.arraycopy(tmpVelocities, 0, this.velocities, 0, this.atomcount * 3);
        if (this.activeTermostat) {
            this.tt.scaleTemperature(this.velocities);
        }
    }

    public void setTemperature(double temp) throws MDException {
        this.tt.setTemperature(temp);
    }

    public double getTemperature() {
        return this.tt.getTemperature();
    }

    protected double[] getProjectedVelocities(double[] velocities) {
        int i;
        if (!this.internalProjection && !this.translationRotationProjection) {
            return velocities;
        }
        double[] newvelocities = null;
        if ((Debug.debuglevel & 2) > 0) {
            Debug.debugstream.println("Temperature at entering projection: " + this.tt.getTemperature(velocities));
        }
        if (this.qfitpairs == null) {
            this.qfitpairs = new int[2][this.atomcount];
            for (i = 0; i < this.atomcount; ++i) {
                this.qfitpairs[0][i] = i;
                this.qfitpairs[1][i] = i;
            }
        }
        if (this.internalProjection) {
            int j;
            int i2;
            double[] mVec;
            if (this.icp == null) {
                this.icp = new InternalCoordinateProjection(this.mdmol);
            }
            this.bMatStopper.start();
            this.matrixB = this.icp.calculateBondLengthB(this.coords);
            this.bMatStopper.stop();
            this.projectionStopper.start();
            if (this.useMassWeightedBMatrix) {
                if (this.massWeightedBMatrix == null) {
                    this.massWeightedBMatrix = new JLinAlg.Matrix(this.matrixB.nRows, this.matrixB.nCols);
                }
                mVec = new double[velocities.length];
                for (i2 = 0; i2 < this.mdmol.getAtomCount(); ++i2) {
                    for (j = 0; j < 3; ++j) {
                        mVec[i2 * 3 + j] = 1.0 / this.mdmol.getAtom(i2).getMass();
                    }
                }
                for (i2 = 0; i2 < this.matrixB.nRows; ++i2) {
                    int rShft = this.matrixB.rowIndex(i2);
                    for (int j2 = 0; j2 < mVec.length; ++j2) {
                        this.massWeightedBMatrix.aVec[rShft + j2] = this.matrixB.aVec[rShft + j2] * mVec[j2];
                    }
                }
                newvelocities = JLinAlg.VectCopy(velocities, newvelocities);
                for (i2 = 0; i2 < newvelocities.length; ++i2) {
                    int n = i2;
                    newvelocities[n] = newvelocities[n] / mVec[i2];
                }
                newvelocities = this.icp.projectVelocities(this.massWeightedBMatrix, newvelocities);
                for (i2 = 0; i2 < newvelocities.length; ++i2) {
                    int n = i2;
                    newvelocities[n] = newvelocities[n] * mVec[i2];
                }
            } else {
                mVec = new double[velocities.length];
                for (i2 = 0; i2 < this.mdmol.getAtomCount(); ++i2) {
                    for (j = 0; j < 3; ++j) {
                        mVec[i2 * 3 + j] = this.mdmol.getAtom(i2).getMass();
                    }
                }
                newvelocities = JLinAlg.VectCopy(velocities, newvelocities);
                for (i2 = 0; i2 < newvelocities.length; ++i2) {
                    int n = i2;
                    newvelocities[n] = newvelocities[n] * mVec[i2];
                }
                newvelocities = this.icp.projectVelocities(this.matrixB, newvelocities);
                for (i2 = 0; i2 < newvelocities.length; ++i2) {
                    int n = i2;
                    newvelocities[n] = newvelocities[n] / mVec[i2];
                }
            }
            this.projectionStopper.stop();
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("Temperature of internal projection: " + this.tt.getTemperature(newvelocities));
            }
            for (i = 0; i < this.atomcount * 3; ++i) {
                newvelocities[i] = velocities[i] - newvelocities[i];
            }
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("Temperature after removal projection: " + this.tt.getTemperature(newvelocities));
            }
            if (!this.translationRotationProjection) {
                return newvelocities;
            }
        }
        if (newvelocities == null) {
            newvelocities = JLinAlg.VectCopy(velocities);
        }
        double[][] refcoords = new double[this.atomcount][3];
        double[][] newcoords = new double[this.atomcount][3];
        double[][] fitcoords = new double[this.atomcount][3];
        for (int i3 = 0; i3 < this.atomcount; ++i3) {
            refcoords[i3][0] = this.coords[i3 * 3];
            refcoords[i3][1] = this.coords[i3 * 3 + 1];
            refcoords[i3][2] = this.coords[i3 * 3 + 2];
            newcoords[i3][0] = refcoords[i3][0] + newvelocities[i3 * 3] * this.dt;
            newcoords[i3][1] = refcoords[i3][1] + newvelocities[i3 * 3 + 1] * this.dt;
            newcoords[i3][2] = refcoords[i3][2] + newvelocities[i3 * 3 + 2] * this.dt;
            fitcoords[i3][0] = newcoords[i3][0];
            fitcoords[i3][1] = newcoords[i3][1];
            fitcoords[i3][2] = newcoords[i3][2];
        }
        JQuatFit qfr = new JQuatFit(refcoords);
        double[] mWeight = new double[this.mdmol.getAtomCount()];
        for (int i4 = 0; i4 < mWeight.length; ++i4) {
            mWeight[i4] = this.mdmol.getAtom(i4).getMass();
            int n = i4;
            mWeight[n] = mWeight[n] * mWeight[i4];
        }
        qfr.quatfit(fitcoords, mWeight, this.qfitpairs);
        double[][] transvelo = new double[this.atomcount][3];
        for (int i5 = 0; i5 < this.atomcount; ++i5) {
            transvelo[i5][0] = (newcoords[i5][0] - fitcoords[i5][0]) / this.dt;
            transvelo[i5][1] = (newcoords[i5][1] - fitcoords[i5][1]) / this.dt;
            transvelo[i5][2] = (newcoords[i5][2] - fitcoords[i5][2]) / this.dt;
            int n = i5 * 3;
            newvelocities[n] = newvelocities[n] - transvelo[i5][0];
            int n2 = i5 * 3 + 1;
            newvelocities[n2] = newvelocities[n2] - transvelo[i5][1];
            int n3 = i5 * 3 + 2;
            newvelocities[n3] = newvelocities[n3] - transvelo[i5][2];
        }
        if ((Debug.debuglevel & 2) > 0) {
            Debug.debugstream.println("Temperature after tr-rot removal: " + this.tt.getTemperature(newvelocities));
        }
        return newvelocities;
    }

    public double[] getCoordinates() {
        return this.coords;
    }

    public double[] getVelocities() {
        return this.velocities;
    }

    public double getKineticEnergy() {
        return this.tt.getKineticEnergy();
    }

    public void setActiveTermostat(boolean activeTermostat, double strength) {
        this.activeTermostat = activeTermostat;
        if (activeTermostat && strength > 0.0 && strength <= 1.0) {
            this.tt.setStrength(strength);
        }
    }

    public void setInternalProjection(boolean internalProjection) {
        this.internalProjection = internalProjection;
    }

    public void setTranslationRotationProjection(boolean translationRotationProjection) {
        this.translationRotationProjection = translationRotationProjection;
    }

    public void setVirtualResistance(boolean virtualResistance, double resistanceCoeff) {
        this.virtualResistance = virtualResistance;
        this.resistanceCoeff = resistanceCoeff;
    }

    public long getProjectionTime() {
        return this.projectionStopper.getElapsedTime();
    }

    public long getBMatrixTime() {
        return this.bMatStopper.getElapsedTime();
    }

    public long getMdTime() {
        return this.mdStopper.getElapsedTime();
    }
}

