/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.ForceField;
import chemaxon.marvin.modelling.md.Integrator;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.md.MDTools;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Iterator;

public class PositionVerlet
extends MDTools
implements Integrator {
    double[] c_next;
    double[] c_prev;
    double[] a;
    double[] grad;
    double potenergy = 0.0;
    double dt = 1.0;
    ForceField ff = null;

    public PositionVerlet(Molecule mol, ForceField forcefield) throws MDException {
        super(mol);
        if (forcefield == null) {
            throw new MDException("Force field must be initialized before intergrator called.");
        }
        this.a = new double[this.atomcount * 3];
        this.c_next = new double[this.atomcount * 3];
        this.c_prev = new double[this.atomcount * 3];
        this.grad = new double[this.atomcount * 3];
        this.ff = forcefield;
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.c_prev[i] = this.coords[i];
            this.c_next[i] = this.coords[i];
            this.grad[i] = 0.0;
            this.a[i] = 0.0;
        }
    }

    @Override
    public void setStepTime(double femtosectimestep) throws MDException {
        if (femtosectimestep <= 0.0) {
            throw new MDException("Time step should be positive.");
        }
        this.dt = femtosectimestep;
    }

    @Override
    public void setTemperature(double temperature) throws MDException {
        super.setTemperature(temperature);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Temperature position update");
        }
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.c_prev[i] = this.coords[i] - this.velocities[i] * this.dt;
        }
    }

    @Override
    public double getPotentialEnergy() {
        return this.potenergy;
    }

    @Override
    public Iterator Update() {
        return new UpdateData();
    }

    class UpdateData
    implements Iterator {
        UpdateData() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        public Object next() {
            double matommass;
            MolAtom matom;
            int i;
            if ((Debug.debuglevel & 1) > 0) {
                Debug.debugstream.println("NEXT MD step...");
                Debug.debugstream.println("Next atomcount:" + PositionVerlet.this.atomcount);
                Debug.debugstream.println("Next length:" + PositionVerlet.this.coords.length);
                Debug.debugstream.println("Step time: " + PositionVerlet.this.dt + " fs");
                Debug.debugstream.println("Previous coordinates (x y z) Angstrom");
                for (i = 0; i < PositionVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + "\t" + PositionVerlet.this.c_prev[i * 3] + "\t" + PositionVerlet.this.c_prev[i * 3 + 1] + "\t" + PositionVerlet.this.c_prev[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i = 0; i < PositionVerlet.this.atomcount; ++i) {
                    matom = PositionVerlet.this.mdmol.getAtom(i);
                    matommass = matom.getMass();
                    Debug.debugstream.println(i + ".\t" + matommass + "\t" + PositionVerlet.this.coords[i * 3] + "\t" + PositionVerlet.this.coords[i * 3 + 1] + "\t" + PositionVerlet.this.coords[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Next coordinates (x y z) Angstrom");
                for (i = 0; i < PositionVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + "\t" + PositionVerlet.this.c_next[i * 3] + "\t" + PositionVerlet.this.c_next[i * 3 + 1] + "\t" + PositionVerlet.this.c_next[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i = 0; i < PositionVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + PositionVerlet.this.velocities[i * 3] + "\t" + PositionVerlet.this.velocities[i * 3 + 1] + "\t" + PositionVerlet.this.velocities[i * 3 + 2]);
                }
                Debug.debugstream.println();
            }
            try {
                PositionVerlet.this.grad = PositionVerlet.this.ff.Force(PositionVerlet.this.coords);
                PositionVerlet.this.potenergy = PositionVerlet.this.ff.Energy(PositionVerlet.this.coords);
            }
            catch (MDException e) {
                return e;
            }
            for (i = 0; i < PositionVerlet.this.atomcount; ++i) {
                matom = PositionVerlet.this.mdmol.getAtom(i);
                matommass = matom.getMass();
                for (int j = 0; j < 3; ++j) {
                    PositionVerlet.this.a[i * 3 + j] = -4.1868E-4 * PositionVerlet.this.grad[i * 3 + j] / matommass;
                }
            }
            if ((Debug.debuglevel & 1) > 0) {
                Debug.debugstream.println("Accelerations (x y z) Angstrom/femtosecond^2");
                for (i = 0; i < PositionVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + PositionVerlet.this.a[i * 3] + "\t" + PositionVerlet.this.a[i * 3 + 1] + "\t" + PositionVerlet.this.a[i * 3 + 2]);
                }
                Debug.debugstream.println();
            }
            for (i = 0; i < PositionVerlet.this.atomcount; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int ctmp = 3 * i + j;
                    PositionVerlet.this.c_next[ctmp] = 2.0 * PositionVerlet.this.coords[ctmp] - PositionVerlet.this.c_prev[ctmp] + PositionVerlet.this.a[ctmp] * PositionVerlet.this.dt * PositionVerlet.this.dt;
                    PositionVerlet.this.velocities[ctmp] = (PositionVerlet.this.c_next[ctmp] - PositionVerlet.this.c_prev[ctmp]) / (2.0 * PositionVerlet.this.dt);
                }
            }
            System.arraycopy(PositionVerlet.this.coords, 0, PositionVerlet.this.c_prev, 0, PositionVerlet.this.coords.length);
            try {
                PositionVerlet.this.setCoordinates(PositionVerlet.this.c_next);
            }
            catch (MDException e) {
                return e;
            }
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("After MD step...");
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i = 0; i < PositionVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + PositionVerlet.this.coords[i * 3] + "\t" + PositionVerlet.this.coords[i * 3 + 1] + "\t" + PositionVerlet.this.coords[i * 3 + 2]);
                }
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i = 0; i < PositionVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + PositionVerlet.this.velocities[i * 3] + "\t" + PositionVerlet.this.velocities[i * 3 + 1] + "\t" + PositionVerlet.this.velocities[i * 3 + 2]);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

