/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.ForceField;
import chemaxon.marvin.modelling.md.Integrator;
import chemaxon.marvin.modelling.md.InternalCoordinateProjection;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.md.MDTools;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Iterator;

public class ProjectedVelocityVerlet
extends MDTools
implements Integrator {
    double[] a;
    double[] grad;
    double potenergy = 0.0;
    double accelScale = 1.0;
    ForceField ff = null;

    public ProjectedVelocityVerlet(Molecule mol, ForceField forcefield) throws MDException {
        super(mol);
        if (forcefield == null) {
            throw new MDException("Force field must be initialized before intergrator called.");
        }
        this.setActiveTermostat(true, 1.0);
        this.setTranslationRotationProjection(true);
        this.setInternalProjection(true);
        this.a = new double[this.atomcount * 3];
        this.grad = new double[this.atomcount * 3];
        this.ff = forcefield;
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.grad[i] = 0.0;
            this.a[i] = 0.0;
        }
        this.icp = new InternalCoordinateProjection(mol);
    }

    @Override
    public void setStepTime(double femtosectimestep) throws MDException {
        if (femtosectimestep <= 0.0) {
            throw new MDException("Time step should be positive.");
        }
        this.dt = femtosectimestep;
    }

    @Override
    public double getPotentialEnergy() {
        return this.potenergy;
    }

    @Override
    public Iterator Update() {
        return new UpdateData();
    }

    @Override
    public void setTemperature(double temp) throws MDException {
        super.setTemperature(temp);
        if ((Debug.debuglevel & 1) > 0) {
            int i;
            Debug.debugstream.println("Input:");
            Debug.debugstream.println("Step time: " + this.dt + " fs");
            Debug.debugstream.println();
            Debug.debugstream.println("Coordinates (x y z) Angstrom");
            for (i = 0; i < this.atomcount; ++i) {
                MolAtom matom = this.mdmol.getAtom(i);
                double matommass = matom.getMass();
                Debug.debugstream.println(i + ".\t" + matommass + "\t" + this.coords[i * 3] + "\t" + this.coords[i * 3 + 1] + "\t" + this.coords[i * 3 + 2]);
            }
            Debug.debugstream.println();
            Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
            for (i = 0; i < this.atomcount; ++i) {
                Debug.debugstream.println(i + ".\t" + this.velocities[i * 3] + "\t" + this.velocities[i * 3 + 1] + "\t" + this.velocities[i * 3 + 2]);
            }
            Debug.debugstream.println();
        }
        double[] newvelocities = this.getProjectedVelocities(this.velocities);
        this.tt.scaleTemperature(newvelocities);
        if ((Debug.debuglevel & 1) > 0) {
            Debug.debugstream.println();
            Debug.debugstream.println("Projected velocities (x y z) Angstrom/femtosecond");
            for (int i = 0; i < this.atomcount; ++i) {
                Debug.debugstream.println(i + ".\t" + this.velocities[i * 3] + "\t" + this.velocities[i * 3 + 1] + "\t" + this.velocities[i * 3 + 2]);
            }
            Debug.debugstream.println();
        }
    }

    class UpdateData
    implements Iterator {
        UpdateData() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        public Object next() {
            int i;
            int i2;
            if ((Debug.debuglevel & 1) > 0) {
                Debug.debugstream.println("NEXT MD step...");
                Debug.debugstream.println("Next atomcount:" + ProjectedVelocityVerlet.this.atomcount);
                Debug.debugstream.println("Next length:" + ProjectedVelocityVerlet.this.coords.length);
                Debug.debugstream.println("Step time: " + ProjectedVelocityVerlet.this.dt + " fs");
                Debug.debugstream.println();
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i2 = 0; i2 < ProjectedVelocityVerlet.this.atomcount; ++i2) {
                    MolAtom matom = ProjectedVelocityVerlet.this.mdmol.getAtom(i2);
                    double matommass = matom.getMass();
                    Debug.debugstream.println(i2 + ".\t" + matommass + "\t" + ProjectedVelocityVerlet.this.coords[i2 * 3] + "\t" + ProjectedVelocityVerlet.this.coords[i2 * 3 + 1] + "\t" + ProjectedVelocityVerlet.this.coords[i2 * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i2 = 0; i2 < ProjectedVelocityVerlet.this.atomcount; ++i2) {
                    Debug.debugstream.println(i2 + ".\t" + ProjectedVelocityVerlet.this.velocities[i2 * 3] + "\t" + ProjectedVelocityVerlet.this.velocities[i2 * 3 + 1] + "\t" + ProjectedVelocityVerlet.this.velocities[i2 * 3 + 2]);
                }
                Debug.debugstream.println();
            }
            for (i2 = 0; i2 < ProjectedVelocityVerlet.this.atomcount * 3; ++i2) {
                ProjectedVelocityVerlet.this.coords[i2] = ProjectedVelocityVerlet.this.coords[i2] + ProjectedVelocityVerlet.this.velocities[i2] * ProjectedVelocityVerlet.this.dt + ProjectedVelocityVerlet.this.a[i2] * ProjectedVelocityVerlet.this.dt * ProjectedVelocityVerlet.this.dt / 2.0;
                ProjectedVelocityVerlet.this.velocities[i2] = ProjectedVelocityVerlet.this.velocities[i2] + ProjectedVelocityVerlet.this.a[i2] * ProjectedVelocityVerlet.this.dt / 2.0;
            }
            ProjectedVelocityVerlet.this.mdStopper.start();
            try {
                ProjectedVelocityVerlet.this.grad = ProjectedVelocityVerlet.this.ff.Force(ProjectedVelocityVerlet.this.coords);
                ProjectedVelocityVerlet.this.potenergy = ProjectedVelocityVerlet.this.ff.Energy();
            }
            catch (MDException e) {
                return e;
            }
            ProjectedVelocityVerlet.this.mdStopper.stop();
            if (ProjectedVelocityVerlet.this.accelScale != 1.0) {
                double[] constrainedGrad = ProjectedVelocityVerlet.this.icp.projectVelocities(ProjectedVelocityVerlet.this.matrixB, ProjectedVelocityVerlet.this.grad);
                double[] unconstrainedGrad = JLinAlg.vectSubtract(ProjectedVelocityVerlet.this.grad, constrainedGrad);
                JLinAlg.VectScaleAndAdd(unconstrainedGrad, ProjectedVelocityVerlet.this.accelScale, constrainedGrad, ProjectedVelocityVerlet.this.grad);
            }
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("Temperature before projection: " + ProjectedVelocityVerlet.this.tt.getTemperature(ProjectedVelocityVerlet.this.velocities));
            }
            double[] newvelocities = ProjectedVelocityVerlet.this.getProjectedVelocities(ProjectedVelocityVerlet.this.velocities);
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("Temperature after projection: " + ProjectedVelocityVerlet.this.tt.getTemperature(newvelocities));
            }
            if (ProjectedVelocityVerlet.this.activeTermostat) {
                ProjectedVelocityVerlet.this.tt.scaleTemperature(newvelocities);
            } else if (newvelocities != ProjectedVelocityVerlet.this.velocities) {
                JLinAlg.VectCopy(newvelocities, ProjectedVelocityVerlet.this.velocities);
            }
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("Temperature after termostate: " + ProjectedVelocityVerlet.this.tt.getTemperature(ProjectedVelocityVerlet.this.velocities));
            }
            if (ProjectedVelocityVerlet.this.virtualResistance) {
                for (int i3 = 0; i3 < ProjectedVelocityVerlet.this.atomcount; ++i3) {
                    double v2 = Math.sqrt(JLinAlg.VDot(3, ProjectedVelocityVerlet.this.velocities, i3 * 3, ProjectedVelocityVerlet.this.velocities, i3 * 3));
                    double Sc = v2 * ProjectedVelocityVerlet.this.resistanceCoeff;
                    JLinAlg.VectScaleAndAdd(3, ProjectedVelocityVerlet.this.grad, i3 * 3, Sc, ProjectedVelocityVerlet.this.velocities, i3 * 3, ProjectedVelocityVerlet.this.grad, i3 * 3);
                }
            }
            for (i = 0; i < ProjectedVelocityVerlet.this.atomcount; ++i) {
                MolAtom matom = ProjectedVelocityVerlet.this.mdmol.getAtom(i);
                double matommass = matom.getMass();
                for (int j = 0; j < 3; ++j) {
                    ProjectedVelocityVerlet.this.a[i * 3 + j] = -4.1868E-4 * ProjectedVelocityVerlet.this.grad[i * 3 + j] / matommass;
                    ProjectedVelocityVerlet.this.velocities[i * 3 + j] = ProjectedVelocityVerlet.this.velocities[i * 3 + j] + ProjectedVelocityVerlet.this.a[i * 3 + j] * ProjectedVelocityVerlet.this.dt / 2.0;
                }
            }
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("After MD step...");
                Debug.debugstream.println("Accelerations (x y z) Angstrom/femtosecond^2");
                for (i = 0; i < ProjectedVelocityVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + ProjectedVelocityVerlet.this.a[i * 3] + "\t" + ProjectedVelocityVerlet.this.a[i * 3 + 1] + "\t" + ProjectedVelocityVerlet.this.a[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i = 0; i < ProjectedVelocityVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + ProjectedVelocityVerlet.this.coords[i * 3] + "\t" + ProjectedVelocityVerlet.this.coords[i * 3 + 1] + "\t" + ProjectedVelocityVerlet.this.coords[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i = 0; i < ProjectedVelocityVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + ProjectedVelocityVerlet.this.velocities[i * 3] + "\t" + ProjectedVelocityVerlet.this.velocities[i * 3 + 1] + "\t" + ProjectedVelocityVerlet.this.velocities[i * 3 + 2]);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

