/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class Thermostat {
    private Molecule mdmol;
    private int atomcount;
    private double[] atommass;
    private double[] velocities = null;
    private double targetTemperature = 300.0;
    private double currentTemperature = 300.0;
    private double scalingFactor = 1.0;

    Thermostat(Molecule mol, double[] velocities, double temperature) throws MDException {
        this.fillAtomMassTable(mol);
        this.velocities = velocities;
        this.setTemperature(this.targetTemperature);
    }

    Thermostat(Molecule mol, double[] velocities) {
        this.fillAtomMassTable(mol);
        this.velocities = velocities;
    }

    Thermostat(Molecule mol) {
        this.fillAtomMassTable(mol);
        this.velocities = null;
    }

    protected void setVelocities(double[] velocities) {
        this.velocities = velocities;
    }

    protected double getTargetTemperature() {
        return this.targetTemperature;
    }

    private void fillAtomMassTable(Molecule mol) {
        this.mdmol = mol;
        this.atomcount = this.mdmol.getAtomCount();
        this.atommass = new double[this.atomcount];
        for (int i = 0; i < this.atomcount; ++i) {
            MolAtom matom = this.mdmol.getAtom(i);
            this.atommass[i] = matom.getMass();
        }
    }

    public void setTemperature(double temp) throws MDException {
        if (temp < 0.0) {
            throw new MDException("Temperature can't be negative.");
        }
        if (this.velocities == null) {
            throw new MDException("Atom velocity array is null.");
        }
        this.targetTemperature = temp;
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Target temperature: " + temp);
        }
        for (int i = 0; i < this.atomcount; ++i) {
            for (int j = 0; j < 3; ++j) {
                double rsum = 0.0;
                for (int k = 0; k < 12; ++k) {
                    rsum += Math.random();
                }
                this.velocities[i * 3 + j] = (rsum -= 6.0) / this.atommass[i];
            }
        }
        double temptemp = this.getTemperature(this.velocities);
        double scale = Math.sqrt(temp / temptemp);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Temporary Temperature set to: " + temptemp);
            Debug.debugstream.println("Scaling: " + scale);
        }
        int i = 0;
        while (i < this.atomcount * 3) {
            int n = i++;
            this.velocities[n] = this.velocities[n] * scale;
        }
        this.currentTemperature = this.getTemperature(this.velocities);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Current temperature: " + this.currentTemperature + "K");
        }
    }

    public void scaleTemperature(double[] newvelocities) {
        this.scaleTemperature(newvelocities, this.currentTemperature);
    }

    public void scaleTemperature(double[] newvelocities, double targetTemperature) {
        double newtemp = this.getTemperature(newvelocities);
        double scale = Math.sqrt(targetTemperature / newtemp * this.scalingFactor);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Temperature of the molecule: " + newtemp + " K");
            Debug.debugstream.println("Target temperature: " + targetTemperature + "K");
            Debug.debugstream.println("Scaling: " + scale);
        }
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.velocities[i] = newvelocities[i] * scale;
        }
        this.currentTemperature = this.getTemperature(this.velocities);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Current temperature: " + this.currentTemperature + "K");
        }
    }

    public void scaleToTargetTemperature(double[] newvelocities) {
        double newtemp = this.getTemperature(newvelocities);
        double scale = Math.sqrt(this.targetTemperature / newtemp * this.scalingFactor);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Temperature of the molecule: " + newtemp + "K");
            Debug.debugstream.println("Target temperature: " + this.targetTemperature + "K");
            Debug.debugstream.println("Scaling: " + scale);
        }
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.velocities[i] = newvelocities[i] * scale;
        }
        this.currentTemperature = this.getTemperature(this.velocities);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Current temperature: " + this.currentTemperature + "K");
        }
    }

    public double getTemperature() {
        return this.getTemperature(this.velocities);
    }

    public double getTemperature(double[] atomvelo) {
        double temp = 2.0 * this.getKineticEnergy(atomvelo) * 4186.8 / 6.02214199E23 / 1.3806505E-23 / (double)(this.mdmol.getAtomCount() * 3);
        return temp;
    }

    public double getKineticEnergy() {
        return this.getKineticEnergy(this.velocities);
    }

    public double getKineticEnergy(double[] atomvelo) {
        double kinenergy = 0.0;
        for (int i = 0; i < this.atomcount; ++i) {
            double v2 = 0.0;
            for (int j = 0; j < 3; ++j) {
                v2 += atomvelo[i * 3 + j] * atomvelo[i * 3 + j];
            }
            kinenergy += this.atommass[i] * v2 / 2.0;
        }
        return kinenergy /= 4.1868E-4;
    }

    public void setStrength(double strength) {
        this.scalingFactor = strength;
    }
}

