/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.ForceField;
import chemaxon.marvin.modelling.md.Integrator;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.md.MDTools;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Iterator;

public class VelocityVerlet
extends MDTools
implements Integrator {
    double[] a;
    double[] grad;
    double potenergy = 0.0;
    double dt = 1.0;
    ForceField ff = null;

    public VelocityVerlet(Molecule mol, ForceField forcefield) throws MDException {
        super(mol);
        if (forcefield == null) {
            throw new MDException("Force field must be initialized before intergrator called.");
        }
        this.a = new double[this.atomcount * 3];
        this.grad = new double[this.atomcount * 3];
        this.ff = forcefield;
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.grad[i] = 0.0;
            this.a[i] = 0.0;
        }
    }

    @Override
    public void setStepTime(double femtosectimestep) throws MDException {
        if (femtosectimestep <= 0.0) {
            throw new MDException("Time step should be positive.");
        }
        this.dt = femtosectimestep;
    }

    @Override
    public double getPotentialEnergy() {
        return this.potenergy;
    }

    @Override
    public Iterator Update() {
        return new UpdateData();
    }

    class UpdateData
    implements Iterator {
        UpdateData() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        public Object next() {
            double matommass;
            MolAtom matom;
            int i;
            if ((Debug.debuglevel & 1) > 0) {
                Debug.debugstream.println("NEXT MD step...");
                Debug.debugstream.println("Next atomcount:" + VelocityVerlet.this.atomcount);
                Debug.debugstream.println("Next length:" + VelocityVerlet.this.coords.length);
                Debug.debugstream.println("Step time: " + VelocityVerlet.this.dt + " fs");
                Debug.debugstream.println();
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i = 0; i < VelocityVerlet.this.atomcount; ++i) {
                    matom = VelocityVerlet.this.mdmol.getAtom(i);
                    matommass = matom.getMass();
                    Debug.debugstream.println(i + ".\t" + matommass + "\t" + VelocityVerlet.this.coords[i * 3] + "\t" + VelocityVerlet.this.coords[i * 3 + 1] + "\t" + VelocityVerlet.this.coords[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i = 0; i < VelocityVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + VelocityVerlet.this.velocities[i * 3] + "\t" + VelocityVerlet.this.velocities[i * 3 + 1] + "\t" + VelocityVerlet.this.velocities[i * 3 + 2]);
                }
                Debug.debugstream.println();
            }
            for (i = 0; i < VelocityVerlet.this.atomcount * 3; ++i) {
                VelocityVerlet.this.velocities[i] = VelocityVerlet.this.velocities[i] + VelocityVerlet.this.a[i] * VelocityVerlet.this.dt / 2.0;
                VelocityVerlet.this.coords[i] = VelocityVerlet.this.coords[i] + VelocityVerlet.this.velocities[i] * VelocityVerlet.this.dt;
            }
            try {
                VelocityVerlet.this.grad = VelocityVerlet.this.ff.Force(VelocityVerlet.this.coords);
                VelocityVerlet.this.potenergy = VelocityVerlet.this.ff.Energy(VelocityVerlet.this.coords);
            }
            catch (MDException e) {
                return e;
            }
            for (i = 0; i < VelocityVerlet.this.atomcount; ++i) {
                matom = VelocityVerlet.this.mdmol.getAtom(i);
                matommass = matom.getMass();
                for (int j = 0; j < 3; ++j) {
                    VelocityVerlet.this.a[i * 3 + j] = -4.1868E-4 * VelocityVerlet.this.grad[i * 3 + j] / matommass;
                    VelocityVerlet.this.velocities[i * 3 + j] = VelocityVerlet.this.velocities[i * 3 + j] + VelocityVerlet.this.a[i * 3 + j] * VelocityVerlet.this.dt / 2.0;
                }
            }
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("After MD step...");
                Debug.debugstream.println("Accelerations (x y z) Angstrom/femtosecond^2");
                for (i = 0; i < VelocityVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + VelocityVerlet.this.a[i * 3] + "\t" + VelocityVerlet.this.a[i * 3 + 1] + "\t" + VelocityVerlet.this.a[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i = 0; i < VelocityVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + VelocityVerlet.this.coords[i * 3] + "\t" + VelocityVerlet.this.coords[i * 3 + 1] + "\t" + VelocityVerlet.this.coords[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i = 0; i < VelocityVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + VelocityVerlet.this.velocities[i * 3] + "\t" + VelocityVerlet.this.velocities[i * 3 + 1] + "\t" + VelocityVerlet.this.velocities[i * 3 + 2]);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

