/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.XtcTools;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class XtcExport
extends XtcTools {
    private int simstep;
    private int simtime;
    private int simatomcount;
    private float[] simbox = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private int[] simxtcints;
    private int simxtcintscount = 0;
    private float xtcprecision;
    private int xtccomplete = 0;
    private static final int XTC_NATOMS_SET = 1;
    private static final int XTC_STEP_SET = 2;
    private static final int XTC_TIME_SET = 4;
    private static final int XTC_BOX_SET = 8;
    private static final int XTC_COORDS_SET = 16;
    private static final int XTC_PRECISION_SET = 32;

    private void xtc_sendbits(long[] cbuf, int num_of_bits, long num) {
        int cnt = (int)(cbuf[0] + 3L);
        long lastbits = cbuf[1];
        long lastbyte = cbuf[2] & 0xFFFFFFFFL;
        if (num < 0L) {
            num += 0xFFFFFFE5L;
        }
        while (num_of_bits >= 8) {
            lastbyte = lastbyte << 8 | num >> num_of_bits - 8 & 0xFFL;
            cbuf[cnt++] = lastbyte >> (int)lastbits & 0xFFL;
            num_of_bits -= 8;
        }
        if (num_of_bits > 0) {
            lastbyte = lastbyte << num_of_bits | num;
            if ((lastbits += (long)num_of_bits) >= 8L) {
                cbuf[cnt++] = (int)(lastbyte >> (int)(lastbits -= 8L) & 0xFFL);
            }
        }
        cbuf[0] = cnt - 3;
        cbuf[1] = lastbits;
        cbuf[2] = lastbyte;
        if (lastbits > 0L) {
            cbuf[cnt] = lastbyte << (int)(8L - lastbits) & 0xFFL;
        }
    }

    private void xtc_sendints(long[] cbuf, int num_of_ints, int num_of_bits, long[] sizes, int[] nums, int numsidx) {
        int i;
        long[] bytes = new long[32];
        long tmp = nums[numsidx];
        int num_of_bytes = 0;
        do {
            bytes[num_of_bytes++] = tmp & 0xFFL;
        } while ((tmp >>= 8) != 0L);
        for (i = 1; i < num_of_ints; ++i) {
            int bytecnt;
            if ((long)nums[numsidx + i] >= sizes[i]) {
                Debug.debugstream.println("Major breakdown in sendints num " + nums[numsidx + i] + " doesn't match size " + sizes[i] + "\n");
                break;
            }
            tmp = nums[i + numsidx];
            for (bytecnt = 0; bytecnt < num_of_bytes; ++bytecnt) {
                tmp = bytes[bytecnt] * sizes[i] + tmp;
                bytes[bytecnt] = tmp & 0xFFL;
                tmp >>= 8;
            }
            while (tmp != 0L) {
                bytes[bytecnt++] = tmp & 0xFFL;
                tmp >>= 8;
            }
            num_of_bytes = bytecnt;
        }
        if (num_of_bits >= num_of_bytes * 8) {
            for (i = 0; i < num_of_bytes; ++i) {
                this.xtc_sendbits(cbuf, 8, bytes[i]);
            }
            this.xtc_sendbits(cbuf, num_of_bits - num_of_bytes * 8, 0L);
        } else {
            for (i = 0; i < num_of_bytes - 1; ++i) {
                this.xtc_sendbits(cbuf, 8, bytes[i]);
            }
            this.xtc_sendbits(cbuf, num_of_bits - (num_of_bytes - 1) * 8, bytes[i]);
        }
    }

    private int xtc_convertcoords(double[] fp, int[] rip, int size, float precision) {
        int smallidx;
        int bitsize;
        int i;
        int[] minint = new int[3];
        int[] maxint = new int[3];
        long[] sizeint = new long[3];
        long[] sizesmall = new long[3];
        float MAXABS = Float.MAX_VALUE;
        int LASTIDX = xtc_magicints.length;
        if (size == 0) {
            return 0;
        }
        int size3 = size * 3;
        if (size <= 9 && (i = 0) < size3) {
            rip[i] = Float.floatToIntBits(new Double(fp[i]).floatValue());
            return size;
        }
        long[] charbuf = new long[(int)((double)(size3 * 4) * 1.3)];
        int[] ip = new int[size3];
        int ipp = 0;
        rip[ipp++] = Float.floatToIntBits(precision);
        int[] bitsizeint = new int[3];
        charbuf[2] = 0L;
        charbuf[1] = 0L;
        charbuf[0] = 0L;
        minint[2] = Integer.MAX_VALUE;
        minint[1] = Integer.MAX_VALUE;
        minint[0] = Integer.MAX_VALUE;
        maxint[2] = Integer.MIN_VALUE;
        maxint[1] = Integer.MIN_VALUE;
        maxint[0] = Integer.MIN_VALUE;
        boolean errval = true;
        int prevrun = -1;
        int lfp = 0;
        int lip = 0;
        int mindiff = Integer.MAX_VALUE;
        int oldlint3 = 0;
        int oldlint2 = 0;
        int oldlint1 = 0;
        while (lfp < size3) {
            int lint3;
            int lint2;
            int lint1;
            float lf = fp[lfp] >= 0.0 ? (float)(fp[lfp] * (double)precision + 0.5) : (float)(fp[lfp] * (double)precision - 0.5);
            if (Math.abs(lf) > MAXABS) {
                errval = false;
            }
            if ((lint1 = (int)lf) < minint[0]) {
                minint[0] = lint1;
            }
            if (lint1 > maxint[0]) {
                maxint[0] = lint1;
            }
            ip[lip++] = lint1;
            if (Math.abs(lf = fp[++lfp] >= 0.0 ? (float)(fp[lfp] * (double)precision + 0.5) : (float)(fp[lfp] * (double)precision - 0.5)) > MAXABS) {
                errval = false;
            }
            if ((lint2 = (int)lf) < minint[1]) {
                minint[1] = lint2;
            }
            if (lint2 > maxint[1]) {
                maxint[1] = lint2;
            }
            ip[lip++] = lint2;
            if (Math.abs(lf = fp[++lfp] >= 0.0 ? (float)(fp[lfp] * (double)precision + 0.5) : (float)(fp[lfp] * (double)precision - 0.5)) > MAXABS) {
                errval = false;
            }
            if ((lint3 = (int)lf) < minint[2]) {
                minint[2] = lint3;
            }
            if (lint3 > maxint[2]) {
                maxint[2] = lint3;
            }
            ip[lip++] = lint3;
            int diff = Math.abs(oldlint1 - lint1) + Math.abs(oldlint2 - lint2) + Math.abs(oldlint3 - lint3);
            if (diff < mindiff && ++lfp > 3) {
                mindiff = diff;
            }
            oldlint1 = lint1;
            oldlint2 = lint2;
            oldlint3 = lint3;
        }
        rip[ipp++] = minint[0];
        rip[ipp++] = minint[1];
        rip[ipp++] = minint[2];
        rip[ipp++] = maxint[0];
        rip[ipp++] = maxint[1];
        rip[ipp++] = maxint[2];
        if ((float)maxint[0] - (float)minint[0] >= MAXABS || (float)maxint[1] - (float)minint[1] >= MAXABS || (float)maxint[2] - (float)minint[2] >= MAXABS) {
            errval = false;
        }
        sizeint[0] = maxint[0] - minint[0] + 1;
        sizeint[1] = maxint[1] - minint[1] + 1;
        sizeint[2] = maxint[2] - minint[2] + 1;
        if ((sizeint[0] | sizeint[1] | sizeint[2]) > 0xFFFFFFL) {
            bitsizeint[0] = this.xtc_sizeofint(sizeint[0]);
            bitsizeint[1] = this.xtc_sizeofint(sizeint[1]);
            bitsizeint[2] = this.xtc_sizeofint(sizeint[2]);
            bitsize = 0;
        } else {
            bitsize = this.xtc_sizeofints(3, sizeint);
        }
        lip = ipp;
        for (smallidx = 9; smallidx < LASTIDX && xtc_magicints[smallidx] < mindiff; ++smallidx) {
        }
        rip[ipp++] = smallidx;
        int maxidx = Math.min(LASTIDX, smallidx + 8);
        int minidx = maxidx - 8;
        int smaller = xtc_magicints[Math.max(9, smallidx - 1)] / 2;
        int small = xtc_magicints[smallidx] / 2;
        sizesmall[1] = sizesmall[2] = (long)xtc_magicints[smallidx];
        sizesmall[0] = sizesmall[2];
        int larger = xtc_magicints[maxidx] / 2;
        int[] tmpcoord = new int[30];
        int i2 = 0;
        int[] prevcoord = new int[]{0, 0, 0};
        while (i2 < size) {
            boolean is_small = false;
            int thiscoord = i2 * 3;
            int is_smaller = smallidx < maxidx && i2 >= 1 && Math.abs(ip[thiscoord] - prevcoord[0]) < larger && Math.abs(ip[thiscoord + 1] - prevcoord[1]) < larger && Math.abs(ip[thiscoord + 2] - prevcoord[2]) < larger ? 1 : (smallidx > minidx ? -1 : 0);
            if (i2 + 1 < size && Math.abs(ip[thiscoord] - ip[thiscoord + 3]) < small && Math.abs(ip[thiscoord + 1] - ip[thiscoord + 4]) < small && Math.abs(ip[thiscoord + 2] - ip[thiscoord + 5]) < small) {
                int tmp = ip[thiscoord];
                ip[thiscoord] = ip[thiscoord + 3];
                ip[thiscoord + 3] = tmp;
                tmp = ip[thiscoord + 1];
                ip[thiscoord + 1] = ip[thiscoord + 4];
                ip[thiscoord + 4] = tmp;
                tmp = ip[thiscoord + 2];
                ip[thiscoord + 2] = ip[thiscoord + 5];
                ip[thiscoord + 5] = tmp;
                is_small = true;
            }
            tmpcoord[0] = ip[thiscoord] - minint[0];
            tmpcoord[1] = ip[thiscoord + 1] - minint[1];
            tmpcoord[2] = ip[thiscoord + 2] - minint[2];
            if (bitsize == 0) {
                this.xtc_sendbits(charbuf, bitsizeint[0], tmpcoord[0]);
                this.xtc_sendbits(charbuf, bitsizeint[1], tmpcoord[1]);
                this.xtc_sendbits(charbuf, bitsizeint[2], tmpcoord[2]);
            } else {
                this.xtc_sendints(charbuf, 3, bitsize, sizeint, tmpcoord, 0);
            }
            prevcoord[0] = ip[thiscoord];
            prevcoord[1] = ip[thiscoord + 1];
            prevcoord[2] = ip[thiscoord + 2];
            thiscoord += 3;
            ++i2;
            int run = 0;
            if (!is_small && is_smaller == -1) {
                is_smaller = 0;
            }
            while (is_small && run < 24) {
                if (is_smaller == -1 && (ip[thiscoord] - prevcoord[0]) * (ip[thiscoord] - prevcoord[0]) + (ip[thiscoord + 1] - prevcoord[1]) * (ip[thiscoord + 1] - prevcoord[1]) + (ip[thiscoord + 2] - prevcoord[2]) * (ip[thiscoord + 2] - prevcoord[2]) >= smaller * smaller) {
                    is_smaller = 0;
                }
                tmpcoord[run++] = ip[thiscoord] - prevcoord[0] + small;
                tmpcoord[run++] = ip[thiscoord + 1] - prevcoord[1] + small;
                tmpcoord[run++] = ip[thiscoord + 2] - prevcoord[2] + small;
                prevcoord[0] = ip[thiscoord];
                prevcoord[1] = ip[thiscoord + 1];
                prevcoord[2] = ip[thiscoord + 2];
                is_small = false;
                if (++i2 >= size || Math.abs(ip[thiscoord += 3] - prevcoord[0]) >= small || Math.abs(ip[thiscoord + 1] - prevcoord[1]) >= small || Math.abs(ip[thiscoord + 2] - prevcoord[2]) >= small) continue;
                is_small = true;
            }
            if (run != prevrun || is_smaller != 0) {
                prevrun = run;
                this.xtc_sendbits(charbuf, 1, 1L);
                this.xtc_sendbits(charbuf, 5, run + is_smaller + 1);
            } else {
                this.xtc_sendbits(charbuf, 1, 0L);
            }
            for (int k = 0; k < run; k += 3) {
                this.xtc_sendints(charbuf, 3, smallidx, sizesmall, tmpcoord, k);
            }
            if (is_smaller == 0) continue;
            smallidx += is_smaller;
            if (is_smaller < 0) {
                small = smaller;
                smaller = xtc_magicints[smallidx - 1] / 2;
            } else {
                smaller = small;
                small = xtc_magicints[smallidx] / 2;
            }
            sizesmall[1] = sizesmall[2] = (long)xtc_magicints[smallidx];
            sizesmall[0] = sizesmall[2];
        }
        if (charbuf[1] != 0L) {
            charbuf[0] = charbuf[0] + 1L;
        }
        rip[ipp++] = (int)charbuf[0];
        if (!errval) {
            return 0;
        }
        int count = 0;
        int lastidx = (int)charbuf[0] + 3;
        for (i2 = 0; i2 < 4; ++i2) {
            charbuf[lastidx + i2] = 0L;
        }
        if (charbuf[0] % 4L != 0L) {
            lastidx = (int)((long)lastidx + (4L - charbuf[0] % 4L));
        }
        for (i2 = 3; i2 < lastidx; i2 += 4) {
            ++count;
            long tmp = (charbuf[i2] << 24) + (charbuf[i2 + 1] << 16) + (charbuf[i2 + 2] << 8) + charbuf[i2 + 3];
            if (tmp > Integer.MAX_VALUE) {
                tmp -= 0x100000000L;
            }
            rip[ipp++] = (int)tmp;
        }
        return ipp;
    }

    public void XtcSetSimulationBox(float[] vectors) {
        System.arraycopy(vectors, 0, this.simbox, 1, this.simbox.length);
        this.xtccomplete |= 8;
    }

    public void XtcSetStepNo(int step) {
        this.simstep = step;
        this.xtccomplete |= 2;
    }

    public void XtcSetStepTime(float time) {
        this.simtime = Float.floatToIntBits(time);
        this.xtccomplete |= 4;
    }

    public void XtcSetPrecision(float precision) {
        this.xtcprecision = precision;
        this.xtccomplete |= 0x20;
    }

    public void XtcSetCoords(Molecule mol) {
        int count;
        double[] fp = new double[mol.getAtomCount() * 3];
        this.simatomcount = mol.getAtomCount();
        for (int i = 0; i < this.simatomcount; ++i) {
            MolAtom matom = mol.getAtom(i);
            fp[3 * i] = matom.getX();
            fp[3 * i + 1] = matom.getY();
            fp[3 * i + 2] = matom.getZ();
        }
        this.simxtcints = new int[mol.getAtomCount() * 3 + 23];
        this.simxtcintscount = count = this.xtc_convertcoords(fp, this.simxtcints, mol.getAtomCount(), this.xtcprecision);
        this.xtccomplete |= 0x11;
    }

    public void XtcWriteMol(OutputStream outs, Molecule mol) throws IOException {
        int i;
        DataOutputStream dostream = new DataOutputStream(outs);
        this.XtcSetCoords(mol);
        dostream.writeInt(1995);
        dostream.writeInt(this.simatomcount);
        dostream.writeInt(this.simstep);
        dostream.writeInt(this.simtime);
        for (i = 0; i < 9; ++i) {
            dostream.writeInt(Float.floatToIntBits(this.simbox[i]));
        }
        dostream.writeInt(this.simatomcount);
        for (i = 0; i < this.simxtcintscount; ++i) {
            dostream.writeInt(this.simxtcints[i]);
        }
    }

    public void XtcWrite(int[] xtcints) {
        xtcints = new int[14 + this.simxtcintscount];
        xtcints[0] = 1995;
        xtcints[1] = this.simatomcount;
        xtcints[2] = this.simstep;
        xtcints[3] = this.simtime;
        for (int i = 0; i < 9; ++i) {
            xtcints[4 + i] = Float.floatToIntBits(this.simbox[i]);
        }
        xtcints[13] = this.simatomcount;
        System.arraycopy(this.simxtcints, 0, xtcints, 14, this.simxtcintscount);
    }
}

