/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm;

import chemaxon.marvin.modelling.mm.CXNForceField;
import chemaxon.struc.Molecule;

public class BMatrix
extends CXNForceField {
    CXNForceField.FFBond[] bonds;
    CXNForceField.FFAngle[] angles;
    CXNForceField.FFInversion[] inversions;
    CXNForceField.FFDihedral[] dihedrals;

    public BMatrix(Molecule m) {
        super(null);
        Object o;
        int i;
        this.wishDerivates = true;
        this.init(m);
        int bondC = 0;
        int angleC = 0;
        int dihedC = 0;
        int invC = 0;
        for (i = 0; i < this.ffComp.size(); ++i) {
            o = this.ffComp.get(i);
            if (o instanceof CXNForceField.FFBond) {
                ++bondC;
                continue;
            }
            if (o instanceof CXNForceField.FFAngle) {
                ++angleC;
                continue;
            }
            if (o instanceof CXNForceField.FFDihedral) {
                ++dihedC;
                continue;
            }
            if (!(o instanceof CXNForceField.FFInversion)) continue;
            ++invC;
        }
        this.bonds = new CXNForceField.FFBond[bondC];
        this.angles = new CXNForceField.FFAngle[angleC];
        this.dihedrals = new CXNForceField.FFDihedral[dihedC];
        this.inversions = new CXNForceField.FFInversion[invC];
        bondC = 0;
        angleC = 0;
        dihedC = 0;
        invC = 0;
        for (i = 0; i < this.ffComp.size(); ++i) {
            CXNForceField.FFComponent b;
            o = this.ffComp.get(i);
            if (o instanceof CXNForceField.FFBond) {
                b = (CXNForceField.FFBond)this.ffComp.get(i);
                this.bonds[bondC++] = b;
                continue;
            }
            if (o instanceof CXNForceField.FFAngle) {
                b = (CXNForceField.FFAngle)this.ffComp.get(i);
                this.angles[angleC++] = b;
                continue;
            }
            if (o instanceof CXNForceField.FFDihedral) {
                b = (CXNForceField.FFDihedral)this.ffComp.get(i);
                this.dihedrals[dihedC++] = b;
                continue;
            }
            if (!(o instanceof CXNForceField.FFInversion)) continue;
            b = (CXNForceField.FFInversion)this.ffComp.get(i);
            this.inversions[invC++] = b;
        }
    }

    @Override
    protected boolean isAcceptableVdw(int a1, int a2) {
        return false;
    }

    @Override
    protected CXNForceField.FFAtom createFFAtom(int atomSeqInMol) {
        return new CXNForceField.FFAtom(this, atomSeqInMol);
    }

    @Override
    protected CXNForceField.FFBond createFFBond(CXNForceField.FFAtom a1, CXNForceField.FFAtom a2, int type, int bondSeqInMol) {
        return new BMatrixBond(a1, a2, bondSeqInMol);
    }

    @Override
    protected CXNForceField.FFVector createFFLongRange() {
        return new BMatrixLongRange();
    }

    @Override
    protected CXNForceField.FFAngle createFFAngle(CXNForceField.FFBond b1, CXNForceField.FFBond b2) throws CXNForceField.FFComponentException {
        return new BMatrixAngle(b1, b2);
    }

    @Override
    protected CXNForceField.FFDihedral createFFDihedral(CXNForceField.FFAngle an1, CXNForceField.FFAngle an2) throws CXNForceField.FFComponentException {
        return new BMatrixDihedral(an1, an2);
    }

    @Override
    protected void calcFactorForDihedral(CXNForceField.FFDihedral d) {
    }

    @Override
    protected CXNForceField.FFInversion createFFInversion(CXNForceField.FFAngle an1, CXNForceField.FFAngle an2, CXNForceField.FFAngle an3) throws CXNForceField.FFComponentException {
        return new BMatrixInversion(an1, an2, an3);
    }

    private static void arrayCopy(double[] from, double[] to, int fromPos, int toPos, int count) {
        for (int i = 0; i < count; ++i) {
            to[toPos + i] = from[fromPos + i];
        }
    }

    public BMatrixAngle[] getAngles() {
        BMatrixAngle[] ret = new BMatrixAngle[this.angles.length];
        for (int i = 0; i < ret.length; ++i) {
            this.angles[i].flush();
            ret[i] = (BMatrixAngle)this.angles[i];
        }
        return ret;
    }

    public BMatrixBond[] getBonds() {
        BMatrixBond[] ret = new BMatrixBond[this.bonds.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (BMatrixBond)this.bonds[i];
        }
        return ret;
    }

    public BMatrixDihedral[] getDihedrals() {
        BMatrixDihedral[] ret = new BMatrixDihedral[this.dihedrals.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (BMatrixDihedral)this.dihedrals[i];
        }
        return ret;
    }

    public BMatrixInversion[] getInversions() {
        BMatrixInversion[] ret = new BMatrixInversion[this.inversions.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (BMatrixInversion)this.inversions[i];
        }
        return ret;
    }

    public BMatrixLongRange[] getLongRange() {
        throw new UnsupportedOperationException("Not yet implemeted");
    }

    public void calcBondGeom() {
        for (int i = 0; i < this.bonds.length; ++i) {
            this.bonds[i].flush();
            this.bonds[i].calcGeom();
        }
    }

    @Override
    public double getEqulibriumBondLength(int atom1, int atom2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected double vdwWeightOf(int a1, int a2) {
        return 0.0;
    }

    public class BMatrixLongRange
    extends CXNForceField.FFVector
    implements InternalCoordinate {
        double[] bMatrixComponent;

        public BMatrixLongRange() {
            super(BMatrix.this);
            this.bMatrixComponent = new double[6];
        }

        @Override
        protected void calc_E_dE() {
        }

        @Override
        public double[] getBMatrixRow() {
            for (int i = 0; i < BMatrix.this.gradient.length; ++i) {
                BMatrix.this.gradient[i] = 0.0;
            }
            this.calcFF();
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.a1.getPos(), 0, 3);
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.a2.getPos(), 3, 3);
            return this.bMatrixComponent;
        }
    }

    public class BMatrixInversion
    extends CXNForceField.FFInversion
    implements InternalCoordinate {
        double[] bMatrixComponent;

        public BMatrixInversion(CXNForceField.FFAngle a1, CXNForceField.FFAngle a2, CXNForceField.FFAngle a3) throws CXNForceField.FFComponentException {
            super(BMatrix.this, a1, a2, a3);
            this.bMatrixComponent = new double[12];
        }

        @Override
        protected void calc_E_dE() {
        }

        @Override
        public double[] getBMatrixRow() {
            for (int i = 0; i < BMatrix.this.gradient.length; ++i) {
                BMatrix.this.gradient[i] = 0.0;
            }
            this.calcFF();
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA1().getPos(), 0, 3);
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA2().getPos(), 3, 3);
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA3().getPos(), 6, 3);
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA4().getPos(), 9, 3);
            return this.bMatrixComponent;
        }
    }

    public class BMatrixDihedral
    extends CXNForceField.FFDihedral
    implements InternalCoordinate {
        double[] bMatrixComponent;

        public BMatrixDihedral(CXNForceField.FFAngle a1, CXNForceField.FFAngle a2) throws CXNForceField.FFComponentException {
            super(BMatrix.this, a1, a2);
            this.bMatrixComponent = new double[12];
        }

        @Override
        protected void calc_E_dE() {
        }

        @Override
        public double[] getBMatrixRow() {
            for (int i = 0; i < BMatrix.this.gradient.length; ++i) {
                BMatrix.this.gradient[i] = 0.0;
            }
            this.calcFF();
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA1().getPos(), 0, 3);
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA2().getPos(), 3, 3);
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA3().getPos(), 6, 3);
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA4().getPos(), 9, 3);
            return this.bMatrixComponent;
        }
    }

    public class BMatrixAngle
    extends CXNForceField.FFAngle
    implements InternalCoordinate {
        double[] bMatrixComponent;

        public BMatrixAngle(CXNForceField.FFBond b1, CXNForceField.FFBond b2) throws CXNForceField.FFComponentException {
            super(BMatrix.this, b1, b2);
            this.bMatrixComponent = new double[9];
        }

        @Override
        protected void calc_E_dE() {
        }

        @Override
        public double[] getBMatrixRow() {
            for (int i = 0; i < BMatrix.this.gradient.length; ++i) {
                BMatrix.this.gradient[i] = 0.0;
            }
            this.calcFF();
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA1().getPos(), 0, 3);
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA2().getPos(), 3, 3);
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.getA3().getPos(), 6, 3);
            return this.bMatrixComponent;
        }

        @Override
        public double getEqulibriumAngle() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public class BMatrixBond
    extends CXNForceField.FFBond
    implements InternalCoordinate {
        double[] bMatrixComponent;

        public BMatrixBond(CXNForceField.FFAtom atom1, CXNForceField.FFAtom atom2, int bondSeq) {
            super(BMatrix.this, atom1, atom2, 1, bondSeq);
            this.bMatrixComponent = new double[6];
        }

        @Override
        protected void calc_E_dE() {
        }

        @Override
        public double[] getBMatrixRow() {
            for (int i = 0; i < BMatrix.this.gradient.length; ++i) {
                BMatrix.this.gradient[i] = 0.0;
            }
            this.calcFF();
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.a1.getPos(), 0, 3);
            BMatrix.arrayCopy(BMatrix.this.gradient, this.bMatrixComponent, this.a2.getPos(), 3, 3);
            return this.bMatrixComponent;
        }
    }

    public static interface InternalCoordinate {
        public double[] getBMatrixRow();
    }
}

