/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm;

import chemaxon.calculations.TopologyAnalyser;
import chemaxon.core.util.BondTable;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.mm.ForceField;
import chemaxon.marvin.modelling.mm.MMDiagnosticObserver;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.util.ShortestPath;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Vector;

public abstract class CXNForceField
implements ForceField {
    private static final int ATOM_LABEL_SHIFT = 1;
    public static final int DISABLE_BOND = 0;
    public static final int DISABLE_ANGLE = 1;
    public static final int DISABLE_DIHEDRAL = 2;
    public static final int DISABLE_INVERSION = 3;
    public static final int DISABLE_VDW = 4;
    protected FFAtom[] atoms;
    public Vector ffComp;
    public FFVector vdw;
    protected Molecule mol;
    protected double[] crd;
    protected double[] gradient;
    protected double[] gradientScaled;
    protected int[][] ctab = null;
    protected BondTable btab = null;
    protected double totalEnergy = 0.0;
    private boolean coordinatesChanged = true;
    protected double cutOffForVDW = 1.4;
    protected double SCALE_FOR_OPTIMIZER = 0.0015936001019904065;
    private boolean aromatize = false;
    int ringsizeToExcludeFromVDW = 7;
    int AROMATIC_PATH_TO_EXCLUDE = 8;
    private int[][] ringsOfAtoms;
    private int[][] ringCtab;
    protected int[][] bondsOfAtom;
    private boolean wishCheckGradient = false;
    protected boolean wishDerivates = true;
    protected BitSet whatToCalc;
    int[][] atomPairsForLongRange;
    int atomPairCount = 0;
    protected MMDiagnosticObserver diagnosticObserver = null;
    private boolean gradientIsScaled = false;
    private double angleScaleAtDihedralsLimit = 2.6179938779914944;
    private double angleScaleAtInversionLimit = 2.6179938779914944;
    protected ShortestPath sp = null;
    double[] varOpt;
    double[] gradOpt;
    private int[] index;
    boolean vdwTopologySpeedUp = false;
    boolean useRingsAtSpeedup = false;
    protected int[] path;
    private boolean isInit = false;
    private SimpleCanceller canceller = null;
    private boolean forceFieldCorrupted = false;
    int step = 0;

    public void showSteps() {
    }

    public void updateCoords() {
    }

    public double getAngleScaleAtDihedralsLimit() {
        return this.angleScaleAtDihedralsLimit;
    }

    public boolean isAromatize() {
        return this.aromatize;
    }

    public void setAromatize(boolean aromatize) {
        this.aromatize = aromatize;
    }

    @Override
    public void setAngleScaleAtDihedralsLimit(double angleScaleAtDihedralsLimit) {
        this.angleScaleAtDihedralsLimit = angleScaleAtDihedralsLimit;
    }

    public double getAngleScaleAtInverionLimit() {
        return this.angleScaleAtInversionLimit;
    }

    @Override
    public void setAngleScaleAtInversionLimit(double angleScaleAtInversionLimit) {
        this.angleScaleAtInversionLimit = angleScaleAtInversionLimit;
    }

    public CXNForceField(MMDiagnosticObserver obs) {
        this.diagnosticObserver = obs;
    }

    @Override
    public abstract double getEqulibriumBondLength(int var1, int var2);

    public void calculateAtomTypes(Molecule molecule) {
        if (this.aromatize) {
            this.mol = (Molecule)molecule.clone();
            this.mol.aromatize();
        } else {
            this.mol = molecule;
        }
        this.ctab = this.mol.getCtab();
        this.btab = this.mol.getBondTable();
        this.calcBondsOfAtom();
        this.calcAtoms();
    }

    @Override
    public boolean isInit() {
        return this.isInit;
    }

    @Override
    public boolean init(Molecule molecule) {
        this.init(molecule, null);
        return true;
    }

    public void init(Molecule molecule, int[] atomIndex) {
        this.isInit = true;
        this.calculateAtomTypes(molecule);
        if (this.vdwTopologySpeedUp) {
            this.sp = new ShortestPath();
            this.sp.calculate(this.mol);
        }
        if (this.vdwTopologySpeedUp && this.useRingsAtSpeedup) {
            this.setupRings();
        }
        this.ffComp = new Vector();
        this.crd = new double[this.mol.getAtomCount() * 3];
        this.gradient = new double[this.mol.getAtomCount() * 3];
        this.gradientScaled = new double[this.mol.getAtomCount() * 3];
        int cc = 0;
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            this.crd[cc++] = this.mol.getAtom(i).getX();
            this.crd[cc++] = this.mol.getAtom(i).getY();
            this.crd[cc++] = this.mol.getAtom(i).getZ();
        }
        if (atomIndex != null) {
            this.varOpt = new double[atomIndex.length * 3];
            this.gradOpt = new double[atomIndex.length * 3];
            this.index = new int[atomIndex.length * 3];
            int c = 0;
            for (int i = 0; i < atomIndex.length; ++i) {
                this.index[c++] = atomIndex[i] * 3;
                this.index[c++] = atomIndex[i] * 3 + 1;
                this.index[c++] = atomIndex[i] * 3 + 2;
            }
        } else {
            this.varOpt = this.crd;
            this.gradOpt = this.gradientScaled;
        }
        try {
            int i;
            FFBond[] bonds = new FFBond[this.mol.getBondCount()];
            int c = 0;
            this.path = new int[this.mol.getAtomCount()];
            this.atomPairsForLongRange = new int[this.mol.getAtomCount() * this.mol.getAtomCount()][2];
            this.atomPairCount = 0;
            for (int i2 = 0; i2 < this.mol.getAtomCount() - 1; ++i2) {
                for (int j = i2 + 1; j < this.mol.getAtomCount(); ++j) {
                    if (this.btab.getBondIndex(i2, j) > -1) {
                        bonds[c] = this.createFFBond(this.atoms[i2], this.atoms[j], this.mol.getBond(this.btab.getBondIndex(i2, j)).getType(), this.btab.getBondIndex(i2, j));
                        this.ffComp.add(bonds[c++]);
                        continue;
                    }
                    if (!this.isAcceptableVdw(i2, j)) continue;
                    this.atomPairsForLongRange[this.atomPairCount][0] = i2;
                    this.atomPairsForLongRange[this.atomPairCount++][1] = j;
                }
            }
            this.vdw = this.createFFLongRange();
            Arrays.sort(bonds, new Comparator<FFBond>(){

                @Override
                public int compare(FFBond o1, FFBond o2) {
                    return o1.getBondSeqInMol() - o2.getBondSeqInMol();
                }
            });
            int anglesStart = this.ffComp.size();
            for (int i3 = 0; i3 < this.bondsOfAtom.length; ++i3) {
                if (this.bondsOfAtom[i3].length <= 1) continue;
                for (int j = 0; j < this.bondsOfAtom[i3].length - 1; ++j) {
                    for (int k = j + 1; k < this.bondsOfAtom[i3].length; ++k) {
                        FFBond b1 = bonds[this.bondsOfAtom[i3][j]];
                        FFBond b2 = bonds[this.bondsOfAtom[i3][k]];
                        FFAngle fa = this.createFFAngle(b1, b2);
                        if (fa == null) continue;
                        this.ffComp.add(fa);
                    }
                }
            }
            int anglesStop = this.ffComp.size();
            for (i = anglesStart; i < anglesStop - 1; ++i) {
                FFInversion inv;
                FFAngle angle1 = (FFAngle)this.ffComp.get(i);
                int a1 = angle1.getA2().getID();
                int a1b1 = angle1.getB1().getBondSeqInMol();
                int a1b2 = angle1.getB2().getBondSeqInMol();
                FFAngle angle2 = null;
                FFAngle angle3 = null;
                boolean invFound = false;
                for (int j = i + 1; j < anglesStop; ++j) {
                    FFDihedral fd;
                    FFAngle angle = (FFAngle)this.ffComp.get(j);
                    int a2 = angle.getA2().getID();
                    if (a1 == a2) {
                        if (this.ctab[a1].length != 3) continue;
                        if (angle2 == null) {
                            angle2 = angle;
                            continue;
                        }
                        if (angle3 == null) {
                            angle3 = angle;
                            invFound = true;
                            continue;
                        }
                        invFound = false;
                        continue;
                    }
                    int a2b1 = angle.getB1().getBondSeqInMol();
                    int a2b2 = angle.getB2().getBondSeqInMol();
                    if (a1b1 != a2b1 && a1b1 != a2b2 && a1b2 != a2b1 && a1b2 != a2b2 || (fd = this.createFFDihedral(angle1, angle)) == null) continue;
                    this.ffComp.add(fd);
                }
                if (!invFound || (inv = this.createFFInversion(angle1, angle2, angle3)) == null) continue;
                this.ffComp.add(inv);
                this.ffComp.add(this.createFFInversion(angle2, angle1, angle3));
                this.ffComp.add(this.createFFInversion(angle3, angle2, angle1));
            }
            for (i = anglesStop; i < this.ffComp.size(); ++i) {
                try {
                    FFDihedral d = (FFDihedral)this.ffComp.elementAt(i);
                    this.calcFactorForDihedral(d);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        catch (FFComponentException fFComponentException) {
            System.err.println(fFComponentException.getMessage());
        }
    }

    protected int neighAt(int atom, int atomicNum) {
        int b = 0;
        for (int j = 0; j < this.ctab[atom].length; ++j) {
            MolAtom a = this.mol.getAtom(this.ctab[atom][j]);
            if (a.getAtno() != atomicNum) continue;
            ++b;
        }
        return b;
    }

    protected double scale(double fi, double fi0) {
        if (fi < 0.0) {
            return 1.0;
        }
        double scale = 0.0;
        double a = 16.0 / (3.0 * fi0 * fi0 * fi0) * fi * fi * fi;
        if (fi >= 0.0 && fi < fi0 / 4.0) {
            scale = 1.0 - a;
        } else if (fi >= fi0 / 4.0 && fi < 0.75 * fi0) {
            scale = a - 8.0 / (fi0 * fi0) * fi * fi + 2.0 / fi0 * fi + 0.8333333333333334;
        } else if (fi >= 0.75 * fi0 && fi < fi0) {
            scale = -a + 16.0 / (fi0 * fi0) * fi * fi - 16.0 / fi0 * fi + 5.333333333333333;
        }
        if (scale < 0.0) {
            if (scale < -1.0E-12) {
                System.err.println("[INFO] scale < 0 scale=");
            }
            scale = 0.0;
        }
        if (scale == 0.0 && this.diagnosticObserver != null) {
            this.diagnosticObserver.isTuneEnabled(1);
        }
        return scale;
    }

    protected static double scaleGrad(double fi, double fi0) {
        double diff = 0.0;
        double a = 16.0 / (fi0 * fi0 * fi0) * fi * fi;
        if (fi < 0.0) {
            diff = 0.0;
        } else if (fi >= 0.0 && fi < fi0 / 4.0) {
            diff = -a;
        } else if (fi >= fi0 / 4.0 && fi < 0.75 * fi0) {
            diff = a - a * fi0 / fi + 2.0 / fi0;
        } else if (fi >= 0.75 * fi0 && fi < fi0) {
            diff = -a + 2.0 * a * fi0 / fi - 16.0 / fi0;
        }
        if (diff > 0.0) {
            diff = 0.0;
        }
        return diff;
    }

    protected int getHybr(int atomSeq) {
        int[] batom = this.bondsOfAtom[atomSeq];
        if (batom.length == 2 && this.mol.getBond(batom[0]).getType() == 2 && this.mol.getBond(batom[1]).getType() == 2) {
            return 1;
        }
        for (int j = 0; j < batom.length; ++j) {
            int b = this.mol.getBond(batom[j]).getType();
            if (b == 3) {
                return 1;
            }
            if (b != 2 && b != 4) continue;
            return b;
        }
        return 3;
    }

    protected static double intPow(double a, int e) {
        double r = 1.0;
        int ee = Math.abs(e);
        for (int i = 0; i < ee; ++i) {
            r *= a;
        }
        if (e < 0) {
            r = 1.0 / r;
        }
        return r;
    }

    protected void calcBondsOfAtom() {
        this.bondsOfAtom = new int[this.mol.getAtomCount()][];
        for (int i = 0; i < this.btab.getAtomCount(); ++i) {
            int j;
            int c = 0;
            for (j = 0; j < this.btab.getAtomCount(); ++j) {
                if (this.btab.getBondIndex(i, j) <= -1) continue;
                ++c;
            }
            this.bondsOfAtom[i] = new int[c];
            c = 0;
            for (j = 0; j < this.btab.getAtomCount(); ++j) {
                if (this.btab.getBondIndex(i, j) <= -1) continue;
                this.bondsOfAtom[i][c++] = this.btab.getBondIndex(i, j);
            }
        }
    }

    private void setupRings() {
        int j;
        int i;
        TopologyAnalyser top = new TopologyAnalyser();
        top.setMolecule(this.mol);
        int[][] r = top.rings();
        if (r == null) {
            return;
        }
        this.ringsOfAtoms = new int[this.mol.getAtomCount()][];
        int[] sizes = new int[this.mol.getAtomCount()];
        for (i = 0; i < r.length; ++i) {
            if (r[i].length >= this.ringsizeToExcludeFromVDW) continue;
            for (j = 0; j < r[i].length; ++j) {
                int n = r[i][j];
                sizes[n] = sizes[n] + 1;
            }
        }
        for (i = 0; i < this.ringsOfAtoms.length; ++i) {
            this.ringsOfAtoms[i] = new int[sizes[i]];
            sizes[i] = 0;
        }
        for (i = 0; i < r.length; ++i) {
            if (r[i].length >= this.ringsizeToExcludeFromVDW) continue;
            for (j = 0; j < r[i].length; ++j) {
                int n = r[i][j];
                int n2 = sizes[n];
                sizes[n] = n2 + 1;
                this.ringsOfAtoms[r[i][j]][n2] = i;
            }
        }
        for (i = 0; i < sizes.length; ++i) {
            sizes[i] = 0;
        }
        this.ringCtab = new int[r.length][];
        BitSet tmp = new BitSet();
        for (int i2 = 0; i2 < r.length; ++i2) {
            int j2;
            tmp.clear();
            for (int k = 0; k < r[i2].length; ++k) {
                for (j2 = 0; j2 < this.ringsOfAtoms[r[i2][k]].length; ++j2) {
                    tmp.set(this.ringsOfAtoms[r[i2][k]][j2], true);
                }
            }
            tmp.set(i2, false);
            this.ringCtab[i2] = new int[tmp.cardinality()];
            int count = 0;
            for (j2 = 0; j2 < tmp.length(); ++j2) {
                if (!tmp.get(j2)) continue;
                this.ringCtab[i2][count++] = j2;
            }
        }
    }

    private void markBond(int a1, int a2) {
    }

    protected boolean isAcceptableVdw(int a1, int a2) {
        if (this.vdwTopologySpeedUp) {
            if (!this.useRingsAtSpeedup) {
                int pathLen = this.sp.getPath(a1, a2, this.path);
                if (pathLen > this.AROMATIC_PATH_TO_EXCLUDE) {
                    return true;
                }
                for (int i = 0; i < pathLen - 1; ++i) {
                    if (this.mol.getBond(this.btab.getBondIndex(this.path[i], this.path[i + 1])).getType() == 4) continue;
                    return true;
                }
                this.markBond(a1, a2);
                return false;
            }
            if (this.useRingsAtSpeedup && this.ringsOfAtoms != null) {
                int i;
                if (!this.acceptVDWTop(a1, a2)) {
                    this.markBond(a1, a2);
                    return false;
                }
                for (i = 0; i < this.ctab[a1].length; ++i) {
                    if (this.acceptVDWTop(this.ctab[a1][i], a2)) continue;
                    this.markBond(a1, a2);
                    return false;
                }
                for (i = 0; i < this.ctab[a2].length; ++i) {
                    if (this.acceptVDWTop(this.ctab[a2][i], a1)) continue;
                    this.markBond(a1, a2);
                    return false;
                }
                for (i = 0; i < this.ctab[a1].length; ++i) {
                    for (int j = 0; j < this.ctab[a2].length; ++j) {
                        if (this.acceptVDWTop(this.ctab[a1][i], this.ctab[a2][j])) continue;
                        this.markBond(a1, a2);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean acceptVDWTop(int a1, int a2) {
        for (int i = 0; i < this.ringsOfAtoms[a1].length; ++i) {
            for (int j = 0; j < this.ringsOfAtoms[a2].length; ++j) {
                int ring1 = this.ringsOfAtoms[a1][i];
                int ring2 = this.ringsOfAtoms[a2][j];
                if (ring1 == ring2) {
                    return false;
                }
                for (int k = 0; k < this.ringCtab[ring1].length; ++k) {
                    if (this.ringCtab[ring1][k] != ring2) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected abstract FFAtom createFFAtom(int var1);

    protected abstract FFBond createFFBond(FFAtom var1, FFAtom var2, int var3, int var4);

    protected abstract FFAngle createFFAngle(FFBond var1, FFBond var2) throws FFComponentException;

    protected abstract FFDihedral createFFDihedral(FFAngle var1, FFAngle var2) throws FFComponentException;

    protected abstract void calcFactorForDihedral(FFDihedral var1);

    protected abstract FFVector createFFLongRange();

    protected abstract FFInversion createFFInversion(FFAngle var1, FFAngle var2, FFAngle var3) throws FFComponentException;

    protected void calcAtoms() {
        this.atoms = new FFAtom[this.mol.getAtomCount()];
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            this.atoms[i] = this.createFFAtom(i);
        }
    }

    protected static double myCos(double[] a, double[] b) {
        return CXNForceField.cleanTrig(V.dot(a, b));
    }

    protected static double cleanTrig(double trigonometric) {
        return Math.max(-1.0, Math.min(1.0, trigonometric));
    }

    @Override
    public double[] getNumericDerivates() {
        double[] numDer = new double[this.gradient.length];
        double small = 1.0E-5;
        boolean currentlyDerivates = this.wishDerivates;
        this.wishDerivates = false;
        int c = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            FFAtom at = this.atoms[i];
            for (int icrd = 0; icrd < 3; ++icrd) {
                double xyz = at.getCoordinate(icrd);
                at.setCoordinate(icrd, xyz + small);
                this.coordinatesChanged = true;
                double e1 = this.getEnergy();
                at.setCoordinate(icrd, xyz - small);
                this.coordinatesChanged = true;
                double e2 = this.getEnergy();
                numDer[c++] = (e1 - e2) / (2.0 * small);
                at.setCoordinate(icrd, xyz);
                this.coordinatesChanged = true;
            }
        }
        this.wishDerivates = currentlyDerivates;
        return numDer;
    }

    @Override
    public void disableEnergyComponent(BitSet whatToCalc) {
        this.whatToCalc = whatToCalc;
    }

    @Override
    public void setCrd(double[] crd1dim) {
        this.setVariables(crd1dim);
    }

    @Override
    public void setCanceller(SimpleCanceller c) {
        this.canceller = c;
    }

    @Override
    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this.atoms.length; ++i) {
            sb.append(this.atoms[i].toString());
        }
        if (this.ffComp != null) {
            for (i = 0; i < this.ffComp.size(); ++i) {
                FFComponent f = (FFComponent)this.ffComp.get(i);
                f.calcFF();
                sb.append(i + ".\t" + f.toString() + "\n");
            }
            if (this.whatToCalc == null || !this.whatToCalc.get(4)) {
                for (i = 0; i < this.atomPairCount; ++i) {
                    this.vdw.setA1(this.atoms[this.atomPairsForLongRange[i][0]]);
                    this.vdw.setA2(this.atoms[this.atomPairsForLongRange[i][1]]);
                    this.vdw.calcFF();
                    sb.append(this.vdw.toString() + "\n");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isCancelled() {
        if (this.canceller == null) {
            return false;
        }
        return this.canceller.isCancelled();
    }

    protected void setForceFieldCorrupted() {
        this.forceFieldCorrupted = true;
    }

    @Override
    public void clearForceFieldCorrupted() {
        this.forceFieldCorrupted = false;
    }

    @Override
    public boolean isForceFieldCorrupted() {
        return this.forceFieldCorrupted;
    }

    @Override
    public double[] getVariables() {
        if (this.index != null) {
            for (int i = 0; i < this.index.length; ++i) {
                this.varOpt[i] = this.crd[this.index[i]];
            }
        }
        ++this.step;
        return this.varOpt;
    }

    @Override
    public double getFunctionValue() {
        double f = this.getEnergy() * this.SCALE_FOR_OPTIMIZER;
        return f;
    }

    @Override
    public double getEnergy() {
        this.calc();
        return this.totalEnergy;
    }

    protected void calc() {
        FFComponent f;
        int i;
        if (!this.coordinatesChanged) {
            return;
        }
        if (!U.isDoubleOK(this.crd)) {
            this.setForceFieldCorrupted();
        }
        if (this.wishDerivates) {
            for (i = 0; i < this.gradient.length; ++i) {
                this.gradient[i] = 0.0;
            }
            this.gradientIsScaled = false;
        }
        this.totalEnergy = 0.0;
        for (i = 0; i < this.ffComp.size(); ++i) {
            f = (FFComponent)this.ffComp.get(i);
            f.flush();
        }
        for (i = 0; i < this.ffComp.size(); ++i) {
            f = (FFComponent)this.ffComp.get(i);
            f.calcFF();
        }
        if (this.whatToCalc == null || !this.whatToCalc.get(4)) {
            for (i = 0; i < this.atomPairCount; ++i) {
                this.vdw.setA1(this.atoms[this.atomPairsForLongRange[i][0]]);
                this.vdw.setA2(this.atoms[this.atomPairsForLongRange[i][1]]);
                this.vdw.calcFF();
            }
        }
        this.coordinatesChanged = false;
        if (this.wishDerivates && !U.isDoubleOK(this.gradient)) {
            this.setForceFieldCorrupted();
        }
        if (!U.isDoubleOK(this.totalEnergy)) {
            this.setForceFieldCorrupted();
        }
    }

    @Override
    public double[] getFunctionGradient() {
        int i;
        this.getForceFieldGradient();
        if (!this.gradientIsScaled) {
            for (i = 0; i < this.gradient.length; ++i) {
                this.gradientScaled[i] = this.gradient[i] * this.SCALE_FOR_OPTIMIZER;
            }
            this.gradientIsScaled = true;
        }
        if (this.index != null) {
            for (i = 0; i < this.index.length; ++i) {
                this.gradOpt[i] = this.gradientScaled[this.index[i]];
            }
        } else {
            this.gradOpt = this.gradientScaled;
        }
        return this.gradOpt;
    }

    private void centerCoordinates() {
        double cX = 0.0;
        double cY = 0.0;
        double cZ = 0.0;
        int l = this.crd.length / 3;
        int j = 0;
        for (int i = 0; i < l; ++i) {
            cX += this.crd[j++];
            cY += this.crd[j++];
            cZ += this.crd[j++];
        }
        cX /= (double)this.crd.length / 3.0;
        cY /= (double)this.crd.length / 3.0;
        cZ /= (double)this.crd.length / 3.0;
        j = 0;
        boolean j2 = false;
        for (int i = 0; i < l; ++i) {
            int n = j++;
            this.crd[n] = this.crd[n] - cX;
            int n2 = j++;
            this.crd[n2] = this.crd[n2] - cY;
            int n3 = j++;
            this.crd[n3] = this.crd[n3] - cZ;
        }
    }

    @Override
    public double[] getForceFieldGradient() {
        if (!this.wishDerivates) {
            throw new UnsupportedOperationException("wishDerivates is false !!!");
        }
        this.calc();
        if (this.wishCheckGradient) {
            double[] numDer = this.getNumericDerivates();
            for (int i = 0; i < this.gradient.length; ++i) {
                double a = numDer[i];
                double b = this.gradient[i];
                if (a < b) {
                    b = numDer[i];
                    a = this.gradient[i];
                }
                int atom = i / 3;
                if (b / a < 0.9 && a - b > 1.0E-4) {
                    System.err.println(atom + " Error: " + numDer[i] + "\t" + this.gradient[i] + "\t ratio: " + b / a + " " + this.step);
                    throw new UnsupportedOperationException("Analitic derivates mismatch at coordinate " + i);
                }
                if (U.isDoubleOK(this.gradient)) continue;
                this.setForceFieldCorrupted();
            }
        }
        return this.gradient;
    }

    public void copyCoordinatesFrom(double[] var) {
        this.coordinatesChanged = true;
        MolGeom.arrayCopy(var, this.crd);
    }

    @Override
    public boolean setVariables(double[] var) {
        this.updateCoords();
        if (!U.isDoubleOK(var)) {
            this.setForceFieldCorrupted();
        }
        this.coordinatesChanged = true;
        if (this.index != null) {
            this.varOpt = var;
            for (int i = 0; i < this.index.length; ++i) {
                this.crd[this.index[i]] = this.varOpt[i];
            }
        } else {
            this.crd = var;
        }
        return true;
    }

    @Override
    public void print() {
        this.print(null);
    }

    @Override
    public void print(String msg) {
    }

    public boolean isWishCheckGradient() {
        return this.wishCheckGradient;
    }

    public boolean isWishDerivates() {
        return this.wishDerivates;
    }

    public void setCheckGradient(boolean checkGradient) {
        this.wishCheckGradient = checkGradient;
    }

    public void setWishDerivates(boolean wishDerivates) {
        this.wishDerivates = wishDerivates;
    }

    public double getCutOffForVDW() {
        return this.cutOffForVDW;
    }

    public void setCutOffForVDW(double cutOffForVDW) {
        this.cutOffForVDW = cutOffForVDW;
    }

    @Override
    public double getScaleForOptimizer() {
        return this.SCALE_FOR_OPTIMIZER;
    }

    @Override
    public void setScaleForOptimizer(double scaleForOptimizer) {
        this.SCALE_FOR_OPTIMIZER = scaleForOptimizer;
    }

    @Override
    public Molecule getMoleculeWithLastUsedCoordinates() {
        int j = 0;
        for (int i = 0; i < this.mol.getAtomCount(); ++i) {
            this.mol.getAtom(i).setX(this.crd[j++]);
            this.mol.getAtom(i).setY(this.crd[j++]);
            this.mol.getAtom(i).setZ(this.crd[j++]);
        }
        return this.mol;
    }

    public void addPositionRestraint(int i) {
        MolAtom a = this.mol.getAtom(i);
        FFPosRestr p = new FFPosRestr(this.atoms[i], 1000.0, a.getX(), a.getY(), a.getZ());
        this.ffComp.add(p);
    }

    public void setVdwTopologySpeedUp(boolean vdwTopologySpeedUp) {
        this.vdwTopologySpeedUp = vdwTopologySpeedUp;
    }

    protected abstract class FFInversion
    extends FFComponent {
        protected FFAtom a1;
        protected FFAtom a2;
        protected FFAtom a3;
        protected FFAtom a4;
        private double[] v1;
        private double[] v2;
        private double[] v3;
        protected FFBond b1;
        protected FFBond b2;
        protected FFBond b3;
        protected FFAngle angle1;
        protected FFAngle angle2;
        protected FFAngle angle3;
        protected double invCos;
        protected double invSin;
        private double[][] tmp;
        private boolean invertV3Xv1;
        private boolean invertV2Xv3;

        public String toString() {
            return "Inversion around " + (this.a1.getID() + 1) + " " + (this.a2.getID() + 1) + " " + (this.a3.getID() + 1) + " " + (this.a4.getID() + 1) + " Angle(deg)= " + MolGeom.forHumans(Math.acos(this.invCos));
        }

        public FFInversion(FFAngle ang1, FFAngle ang2, FFAngle ang3) throws FFComponentException {
            this.a1 = null;
            this.a2 = null;
            this.a3 = null;
            this.a4 = null;
            this.v1 = null;
            this.v2 = null;
            this.v3 = null;
            this.invertV3Xv1 = false;
            this.invertV2Xv3 = false;
            this.angle1 = ang1;
            if (this.angle1.getA2().equals(ang2.getA2()) && this.angle1.getA2().equals(ang3.getA2())) {
                if (this.angle1.getA3().equals(ang2.getA1()) || this.angle1.getA3().equals(ang2.getA3())) {
                    this.angle3 = ang2;
                } else if (this.angle1.getA1().equals(ang2.getA1()) || this.angle1.getA1().equals(ang2.getA3())) {
                    this.angle2 = ang2;
                }
                if (this.angle1.getA3().equals(ang3.getA1()) || this.angle1.getA3().equals(ang3.getA3())) {
                    this.angle3 = ang3;
                } else if (this.angle1.getA1().equals(ang3.getA1()) || this.angle1.getA1().equals(ang3.getA3())) {
                    this.angle2 = ang3;
                }
                this.a1 = this.angle1.getA1();
                this.a2 = this.angle1.getA2();
                this.a3 = this.angle1.getA3();
                this.b1 = this.angle1.getB1();
                this.b2 = this.angle1.getB2();
                this.v1 = this.angle1.isInvertB1() ? this.b1.inormalizedVec : this.b1.normalizedVec;
                this.v2 = this.angle1.isInvertB2() ? this.b2.inormalizedVec : this.b2.normalizedVec;
                if (this.a1.equals(this.angle2.getA3()) && !this.a3.equals(this.angle2.getA1())) {
                    this.a4 = this.angle2.getA1();
                    this.b3 = this.angle2.getB1();
                    this.v3 = this.angle2.isInvertB1() ? this.b3.inormalizedVec : this.b3.normalizedVec;
                } else if (this.a1.equals(this.angle2.getA1()) && !this.a3.equals(this.angle2.getA3())) {
                    this.a4 = this.angle2.getA3();
                    this.b3 = this.angle2.getB2();
                    this.invertV3Xv1 = true;
                    this.v3 = this.angle2.isInvertB2() ? this.b3.inormalizedVec : this.b3.normalizedVec;
                }
                if (this.a3.equals(this.angle3.getA3()) && !this.a1.equals(this.angle3.getA1())) {
                    this.invertV2Xv3 = true;
                }
            } else {
                String s = "angle1.getA1(): " + this.angle1.getA1().getID() + "\n";
                s = s + "angle1.getA2(): " + this.angle1.getA2().getID() + "\n";
                s = s + "angle1.getA3(): " + this.angle1.getA3().getID() + "\n";
                s = s + "angle2.getA1(): " + this.angle2.getA1().getID() + "\n";
                s = s + "angle2.getA2(): " + this.angle2.getA2().getID() + "\n";
                s = s + "angle2.getA3(): " + this.angle2.getA3().getID() + "\n";
                throw new FFComponentException("Cannot form inversion form these two angles.\n" + s);
            }
            this.tmp = new double[3][3];
        }

        public FFAtom getA1() {
            return this.a1;
        }

        public FFAtom getA2() {
            return this.a2;
        }

        public FFAtom getA3() {
            return this.a3;
        }

        public FFAtom getA4() {
            return this.a4;
        }

        @Override
        public void calcFF() {
            double s1 = this.angle1.scaleForAngle(CXNForceField.this.angleScaleAtInversionLimit);
            if (CXNForceField.this.diagnosticObserver != null && s1 != 1.0 && !CXNForceField.this.diagnosticObserver.isTuneEnabled(3)) {
                s1 = 1.0;
            }
            if (s1 == 0.0) {
                return;
            }
            double[] norm_v1xv2 = this.tmp[0];
            MolGeom.cpVec(this.angle1.getV1Xv2(), norm_v1xv2);
            MolGeom.mul(norm_v1xv2, 1.0 / MolGeom.getLength(this.angle1.getV1Xv2()));
            this.invSin = CXNForceField.myCos(this.v3, norm_v1xv2);
            this.invCos = Math.sqrt(1.0 - this.invSin * this.invSin);
            double s2 = 1.0;
            double s2d = 0.0;
            double cos85 = 0.08715574274765818;
            if (this.invCos <= 0.08715574274765818) {
                double invAngleLimit = 1.4922565104551517;
                double invAngle = Math.asin(this.invSin);
                s2 = CXNForceField.this.scale(Math.abs(invAngle) - 1.4922565104551517, 0.07853981633974483);
                if (CXNForceField.this.wishDerivates) {
                    s2d = CXNForceField.scaleGrad(Math.abs(invAngle) - 1.4922565104551517, 0.07853981633974483);
                    if (invAngle < 0.0) {
                        s2d = -s2d;
                    }
                }
            }
            if (s2 == 0.0) {
                return;
            }
            this.calc_E_dE();
            double E = this.getE();
            if (CXNForceField.this.wishDerivates) {
                double[] v3v1;
                double[] v2v3;
                if (this.invertV2Xv3) {
                    v2v3 = this.tmp[1];
                    MolGeom.cpVec(this.angle3.getV1Xv2(), v2v3);
                    MolGeom.mul(v2v3, -1.0);
                } else {
                    v2v3 = this.angle3.getV1Xv2();
                }
                if (this.invertV3Xv1) {
                    v3v1 = this.tmp[2];
                    MolGeom.cpVec(this.angle2.getV1Xv2(), v3v1);
                    MolGeom.mul(v3v1, -1.0);
                } else {
                    v3v1 = this.angle2.getV1Xv2();
                }
                double t1 = 1.0 / (this.invCos * this.angle1.getAngleSin());
                double tanT = this.invSin / this.invCos;
                double t2 = tanT / this.angle1.getAngleSinSq();
                if (s1 < 1.0 || s2 < 1.0) {
                    double[] myGrad = new double[CXNForceField.this.gradient.length];
                    double[] s2g = new double[CXNForceField.this.gradient.length];
                    for (int i = 0; i < 3; ++i) {
                        double component_a4 = (t1 * this.angle1.getV1Xv2()[i] - tanT * this.v3[i]) / this.b3.getLength();
                        double component_a1 = (t1 * v2v3[i] - t2 * (this.v1[i] - this.angle1.getAngleCos() * this.v2[i])) / this.b1.getLength();
                        double component_a3 = (t1 * v3v1[i] - t2 * (this.v2[i] - this.angle1.getAngleCos() * this.v1[i])) / this.b2.getLength();
                        double component_a2 = -(component_a1 + component_a4 + component_a3);
                        this.a1.addD(i, component_a1 * this.getDE(), myGrad);
                        this.a2.addD(i, component_a2 * this.getDE(), myGrad);
                        this.a3.addD(i, component_a3 * this.getDE(), myGrad);
                        this.a4.addD(i, component_a4 * this.getDE(), myGrad);
                        this.a1.addD(i, component_a1 * s2d, s2g);
                        this.a2.addD(i, component_a2 * s2d, s2g);
                        this.a3.addD(i, component_a3 * s2d, s2g);
                        this.a4.addD(i, component_a4 * s2d, s2g);
                    }
                    double[] s1g = this.angle1.scaleGradientForAngle(CXNForceField.this.angleScaleAtInversionLimit);
                    V.dotWriteBackToA(s1 * s2, myGrad);
                    V.plusWriteBackToa(myGrad, V.dot(E, V.plus(V.dot(s2, s1g), V.dot(s1, s2g))));
                    V.plusWriteBackToa(CXNForceField.this.gradient, myGrad);
                } else {
                    for (int i = 0; i < 3; ++i) {
                        double component_a4 = (t1 * this.angle1.getV1Xv2()[i] - tanT * this.v3[i]) / this.b3.getLength();
                        double component_a1 = (t1 * v2v3[i] - t2 * (this.v1[i] - this.angle1.getAngleCos() * this.v2[i])) / this.b1.getLength();
                        double component_a3 = (t1 * v3v1[i] - t2 * (this.v2[i] - this.angle1.getAngleCos() * this.v1[i])) / this.b2.getLength();
                        double component_a2 = -(component_a1 + component_a4 + component_a3);
                        this.a1.addD(i, component_a1 * this.getDE());
                        this.a2.addD(i, component_a2 * this.getDE());
                        this.a3.addD(i, component_a3 * this.getDE());
                        this.a4.addD(i, component_a4 * this.getDE());
                    }
                }
            }
            CXNForceField.this.totalEnergy += E * s1 * s2;
        }

        @Override
        public void flush() {
        }
    }

    protected abstract class FFDihedral
    extends FFComponent {
        protected FFAtom a1;
        protected FFAtom a2;
        protected FFAtom a3;
        protected FFAtom a4;
        protected double[] v1;
        double[] v1v2;
        double[] v2v3;
        protected boolean invertForV1Xv2;
        protected boolean invertForV2Xv3;
        protected FFBond b1;
        protected FFBond b2;
        protected FFBond b3;
        protected double psi;
        protected FFAngle angle1;
        protected FFAngle angle2;
        private boolean v1v2filled;
        private boolean v2v3filled;

        @Override
        public void flush() {
            this.v1v2filled = false;
            this.v2v3filled = false;
        }

        public String toString() {
            return "Dihedral between: " + (this.a1.getID() + 1) + " " + (this.a2.getID() + 1) + " " + (this.a3.getID() + 1) + " " + (this.a4.getID() + 1) + " = " + MolGeom.forHumans(this.getPsi());
        }

        public FFDihedral() {
            this.a1 = null;
            this.a2 = null;
            this.a3 = null;
            this.a4 = null;
            this.v1 = null;
            this.v1v2 = null;
            this.v2v3 = null;
            this.invertForV1Xv2 = false;
            this.invertForV2Xv3 = false;
            this.v1v2filled = false;
            this.v2v3filled = false;
            this.v1v2 = new double[3];
            this.v2v3 = new double[3];
        }

        public FFDihedral(FFAngle angle1, FFAngle angle2) throws FFComponentException {
            this();
            this.init(angle1, angle2);
        }

        public void init(FFAngle angle1, FFAngle angle2) throws FFComponentException {
            this.angle1 = angle1;
            this.angle2 = angle2;
            if (angle1.getA1().equals(angle2.getA2()) && angle1.getA2().equals(angle2.getA1())) {
                this.a1 = angle2.getA3();
                this.a2 = angle2.getA2();
                this.a3 = angle1.getA2();
                this.a4 = angle1.getA3();
                this.b1 = angle2.getB2();
                this.b2 = angle2.getB1();
                this.b3 = angle1.getB2();
                this.invertForV2Xv3 = true;
                this.v1 = angle2.isInvertB2() ? this.b1.normalizedVec : this.b1.inormalizedVec;
            } else if (angle1.getA1().equals(angle2.getA2()) && angle1.getA2().equals(angle2.getA3())) {
                this.a1 = angle2.getA1();
                this.a2 = angle2.getA2();
                this.a3 = angle1.getA2();
                this.a4 = angle1.getA3();
                this.b1 = angle2.getB1();
                this.b2 = angle2.getB2();
                this.b3 = angle1.getB2();
                this.invertForV1Xv2 = true;
                this.invertForV2Xv3 = true;
                this.v1 = angle2.isInvertB1() ? this.b1.normalizedVec : this.b1.inormalizedVec;
            } else if (angle1.getA2().equals(angle2.getA1()) && angle1.getA3().equals(angle2.getA2())) {
                this.a1 = angle2.getA3();
                this.a2 = angle2.getA2();
                this.a3 = angle1.getA2();
                this.a4 = angle1.getA1();
                this.b1 = angle2.getB2();
                this.b2 = angle2.getB1();
                this.b3 = angle1.getB1();
                this.v1 = angle2.isInvertB2() ? this.b1.normalizedVec : this.b1.inormalizedVec;
            } else if (angle1.getA3().equals(angle2.getA2()) && angle1.getA2().equals(angle2.getA3())) {
                this.a1 = angle2.getA1();
                this.a2 = angle2.getA2();
                this.a3 = angle1.getA2();
                this.a4 = angle1.getA1();
                this.b1 = angle2.getB1();
                this.b2 = angle2.getB2();
                this.b3 = angle1.getB1();
                this.invertForV1Xv2 = true;
                this.v1 = angle2.isInvertB1() ? this.b1.normalizedVec : this.b1.inormalizedVec;
            } else {
                String s = "\n" + angle1.getB1().getBondSeqInMol() + " ";
                s = s + angle1.getB2().getBondSeqInMol() + " ";
                s = s + angle2.getB1().getBondSeqInMol() + " ";
                s = s + angle2.getB2().getBondSeqInMol() + "\n Angle1: \n";
                s = s + angle1.getA1().getID() + " ";
                s = s + angle1.getA2().getID() + " ";
                s = s + angle1.getA3().getID() + "\n Angle2: \n";
                s = s + angle2.getA1().getID() + " ";
                s = s + angle2.getA2().getID() + " ";
                s = s + angle2.getA3().getID() + "\n ";
                throw new FFComponentException("Cannot form dihedral form these two angles." + s);
            }
            this.b2.incDihedralCount();
        }

        public double[] getV1v2() {
            if (!this.v1v2filled) {
                int j = 1;
                if (this.invertForV1Xv2) {
                    j = -1;
                }
                this.v1v2[0] = (double)j * this.angle2.getV1Xv2()[0];
                this.v1v2[1] = (double)j * this.angle2.getV1Xv2()[1];
                this.v1v2[2] = (double)j * this.angle2.getV1Xv2()[2];
                this.v1v2filled = true;
            }
            return this.v1v2;
        }

        public double[] getV2v3() {
            if (!this.v2v3filled) {
                int j = 1;
                if (this.invertForV2Xv3) {
                    j = -1;
                }
                this.v2v3[0] = (double)j * this.angle1.getV1Xv2()[0];
                this.v2v3[1] = (double)j * this.angle1.getV1Xv2()[1];
                this.v2v3[2] = (double)j * this.angle1.getV1Xv2()[2];
                this.v2v3filled = true;
            }
            return this.v2v3;
        }

        public FFAtom getA1() {
            return this.a1;
        }

        public FFAtom getA2() {
            return this.a2;
        }

        public FFAtom getA3() {
            return this.a3;
        }

        public FFAtom getA4() {
            return this.a4;
        }

        public double getPsi() {
            return this.psi;
        }

        @Override
        public void calcFF() {
            double s1 = this.angle1.scaleForAngle(CXNForceField.this.angleScaleAtDihedralsLimit);
            double s2 = this.angle2.scaleForAngle(CXNForceField.this.angleScaleAtDihedralsLimit);
            if (!(CXNForceField.this.diagnosticObserver == null || s1 == 1.0 && s2 == 1.0 || CXNForceField.this.diagnosticObserver.isTuneEnabled(2))) {
                s1 = 1.0;
                s2 = 1.0;
            }
            if (s1 == 0.0 || s2 == 0.0) {
                return;
            }
            double y = V.dot(this.v1, this.getV2v3());
            double x = V.dot(this.getV1v2(), this.getV2v3());
            this.psi = Math.atan2(y, x);
            this.calc_E_dE();
            double E = this.getE();
            if (CXNForceField.this.wishDerivates) {
                double component1 = 0.0;
                double component2 = 0.0;
                double component3 = 0.0;
                double cosV1 = this.angle2.getAngleCos();
                double cosV3 = this.angle1.getAngleCos();
                double sinSqV1 = this.angle2.getAngleSinSq();
                double sinSqV3 = this.angle1.getAngleSinSq();
                if (s1 < 1.0 || s2 < 1.0) {
                    double[] myGrad = new double[CXNForceField.this.gradient.length];
                    for (int i = 0; i < 3; ++i) {
                        component1 = this.getV1v2()[i] / this.b1.getLength() / sinSqV1 * this.getDE();
                        component2 = this.getV2v3()[i] / this.b3.getLength() / sinSqV3 * this.getDE();
                        component3 = (this.getV1v2()[i] * cosV1 / (this.b2.getLength() * sinSqV1) + this.getV2v3()[i] * cosV3 / (this.b2.getLength() * sinSqV3)) * this.getDE();
                        this.a1.addD(i, -component1, myGrad);
                        this.a2.addD(i, component1 - component3, myGrad);
                        this.a3.addD(i, -component2 + component3, myGrad);
                        this.a4.addD(i, component2, myGrad);
                    }
                    if (s1 < 1.0) {
                        double[] s1g = this.angle1.scaleGradientForAngle(CXNForceField.this.angleScaleAtDihedralsLimit);
                        V.dotWriteBackToA(s1, myGrad);
                        V.plusWriteBackToa(myGrad, V.dot(E, s1g));
                        E *= s1;
                    }
                    if (s2 < 1.0) {
                        double[] s2g = this.angle2.scaleGradientForAngle(CXNForceField.this.angleScaleAtDihedralsLimit);
                        V.dotWriteBackToA(s2, myGrad);
                        V.plusWriteBackToa(myGrad, V.dot(E, s2g));
                        E *= s2;
                    }
                    V.plusWriteBackToa(CXNForceField.this.gradient, myGrad);
                } else {
                    for (int i = 0; i < 3; ++i) {
                        component1 = this.getV1v2()[i] / this.b1.getLength() / sinSqV1 * this.getDE();
                        component2 = this.getV2v3()[i] / this.b3.getLength() / sinSqV3 * this.getDE();
                        component3 = (this.getV1v2()[i] * cosV1 / (this.b2.getLength() * sinSqV1) + this.getV2v3()[i] * cosV3 / (this.b2.getLength() * sinSqV3)) * this.getDE();
                        this.a1.addD(i, -component1);
                        this.a2.addD(i, component1 - component3);
                        this.a3.addD(i, -component2 + component3);
                        this.a4.addD(i, component2);
                    }
                }
            } else {
                E *= s1 * s2;
            }
            CXNForceField.this.totalEnergy += E;
        }
    }

    protected abstract class FFAngle
    extends FFComponent {
        private FFAtom a1;
        private FFAtom a2;
        private FFAtom a3;
        private boolean invertB1;
        private boolean invertB2;
        private FFBond b1;
        private FFBond b2;
        protected double angle;
        protected double angleCosSq;
        protected double angleSinSq;
        protected double angleCos;
        protected double angleSin;
        protected boolean angleCosSqCalculated;
        protected boolean angleSinSqCalculated;
        protected boolean angleCosCalculated;
        protected boolean angleSinCalculated;
        protected boolean angleCalculated;
        protected double[] v1Xv2;
        protected boolean v1Xv2Calculated;
        boolean calculate;
        private double[][] tmp;
        double[] v1;
        double[] v2;

        public String toString() {
            return "Angle between: " + (this.a1.getID() + 1) + " " + (this.a2.getID() + 1) + " " + (this.a3.getID() + 1) + " = " + MolGeom.forHumans(this.getAngle());
        }

        public FFAngle(FFBond b1, FFBond b2) throws FFComponentException {
            this.a1 = null;
            this.a2 = null;
            this.a3 = null;
            this.invertB1 = false;
            this.invertB2 = false;
            this.angleCosSqCalculated = false;
            this.angleSinSqCalculated = false;
            this.angleCosCalculated = false;
            this.angleSinCalculated = false;
            this.angleCalculated = false;
            this.v1Xv2Calculated = false;
            this.calculate = true;
            this.b1 = b1;
            this.b2 = b2;
            if (b1.getA1().equals(b2.getA1())) {
                this.a1 = b1.getA2();
                this.a2 = b1.getA1();
                this.a3 = b2.getA2();
                this.v1 = b1.normalizedVec;
                this.v2 = b2.normalizedVec;
            } else if (b1.getA1().equals(b2.getA2())) {
                this.a1 = b1.getA2();
                this.a2 = b1.getA1();
                this.a3 = b2.getA1();
                this.v1 = b1.normalizedVec;
                this.v2 = b2.inormalizedVec;
                this.invertB2 = true;
            } else if (b1.getA2().equals(b2.getA1())) {
                this.a1 = b1.getA1();
                this.a2 = b1.getA2();
                this.a3 = b2.getA2();
                this.v1 = b1.inormalizedVec;
                this.v2 = b2.normalizedVec;
                this.invertB1 = true;
            } else if (b1.getA2().equals(b2.getA2())) {
                this.a1 = b1.getA1();
                this.a2 = b1.getA2();
                this.a3 = b2.getA1();
                this.v1 = b1.inormalizedVec;
                this.v2 = b2.inormalizedVec;
                this.invertB1 = true;
                this.invertB2 = true;
            } else {
                throw new FFComponentException("The two bond has no common atom");
            }
            this.v1Xv2 = new double[3];
            this.tmp = new double[3][3];
        }

        public abstract double getEqulibriumAngle();

        @Override
        public void flush() {
            this.angleCosSqCalculated = false;
            this.angleSinSqCalculated = false;
            this.angleCosCalculated = false;
            this.angleSinCalculated = false;
            this.angleCalculated = false;
            this.v1Xv2Calculated = false;
        }

        public boolean isA1A3Connected() {
            return CXNForceField.this.btab.getBondIndex(this.a1.getID(), this.a3.getID()) != -1;
        }

        public double scaleForAngle(double angleLimit) {
            if (angleLimit < 0.0) {
                return 1.0;
            }
            double fi0 = Math.PI - angleLimit;
            double aa = this.getAngle();
            double fi = aa - angleLimit;
            if (aa < fi0) {
                fi = fi0 - aa;
            }
            return CXNForceField.this.scale(fi, fi0);
        }

        public double[] scaleGradientForAngle(double angleLimit) {
            double[] ret = this.getAngleGradient();
            if (angleLimit < 0.0) {
                return ret;
            }
            double fi0 = Math.PI - angleLimit;
            double aa = this.getAngle();
            double fi = aa - angleLimit;
            boolean reversed = false;
            if (aa < fi0) {
                fi = fi0 - aa;
                reversed = true;
            }
            double diff = CXNForceField.scaleGrad(fi, fi0);
            if (reversed) {
                diff *= -1.0;
            }
            V.dotWriteBackToA(diff, ret);
            return ret;
        }

        public double[] getNormalizedV1() {
            return this.v1;
        }

        public double[] getNormalizedV2() {
            return this.v2;
        }

        public FFAtom getA1() {
            return this.a1;
        }

        public FFAtom getA2() {
            return this.a2;
        }

        public FFAtom getA3() {
            return this.a3;
        }

        public double getLength1() {
            return this.b1.getLength();
        }

        public double getLength2() {
            return this.b2.getLength();
        }

        public double getAngle() {
            if (!this.angleCalculated) {
                this.angle = Math.acos(this.getAngleCos());
                if (this.angle > Math.PI) {
                    this.angle = Math.PI;
                }
                if (this.angle < 0.0) {
                    this.angle = 0.0;
                }
                this.angleCalculated = true;
            }
            return this.angle;
        }

        public double getAngleCos() {
            if (!this.angleCosCalculated) {
                this.angleCos = CXNForceField.myCos(this.getNormalizedV1(), this.getNormalizedV2());
                this.angleCosCalculated = true;
            }
            return this.angleCos;
        }

        public double getAngleCosSq() {
            if (!this.angleCosSqCalculated) {
                this.angleCosSq = this.getAngleCos() * this.getAngleCos();
                this.angleCosSqCalculated = true;
            }
            return this.angleCosSq;
        }

        public double getAngleSin() {
            if (!this.angleSinCalculated) {
                this.angleSin = Math.sqrt(this.getAngleSinSq());
                this.angleSinCalculated = true;
            }
            return this.angleSin;
        }

        public double getAngleSinSq() {
            if (!this.angleSinSqCalculated) {
                this.angleSinSq = 1.0 - this.getAngleCosSq();
                this.angleSinSqCalculated = true;
            }
            return this.angleSinSq;
        }

        public double[] getV1Xv2() {
            if (!this.v1Xv2Calculated) {
                MolGeom.getVector3D(this.v1, this.v2, this.v1Xv2);
                this.v1Xv2Calculated = true;
            }
            return this.v1Xv2;
        }

        public boolean isLinear() {
            return Math.abs(this.getAngleCos()) >= 0.999999;
        }

        public FFBond getB1() {
            return this.b1;
        }

        public FFBond getB2() {
            return this.b2;
        }

        @Override
        public void calcFF() {
            this.calc_E_dE();
            CXNForceField.this.totalEnergy += this.getE();
            if (CXNForceField.this.wishDerivates) {
                double[] w = this.tmp[0];
                MolGeom.cpVec(this.getV1Xv2(), w);
                V.normalizeSafe(w);
                double[] v1w = this.tmp[1];
                double[] wv2 = this.tmp[2];
                MolGeom.getVector3D(this.v1, w, v1w);
                MolGeom.mul(v1w, 1.0 / this.getLength1());
                MolGeom.getVector3D(w, this.v2, wv2);
                MolGeom.mul(wv2, 1.0 / this.getLength2());
                for (int i = 0; i < 3; ++i) {
                    this.a1.addD(i, v1w[i] * this.getDE());
                    this.a2.addD(i, -(v1w[i] + wv2[i]) * this.getDE());
                    this.a3.addD(i, wv2[i] * this.getDE());
                }
            }
        }

        public double[] getAngleGradient() {
            double[] ret = new double[CXNForceField.this.gradient.length];
            double[] w = this.tmp[0];
            MolGeom.cpVec(this.getV1Xv2(), w);
            V.normalizeSafe(w);
            double[] v1w = this.tmp[1];
            double[] wv2 = this.tmp[2];
            MolGeom.getVector3D(this.v1, w, v1w);
            MolGeom.mul(v1w, 1.0 / this.getLength1());
            MolGeom.getVector3D(w, this.v2, wv2);
            MolGeom.mul(wv2, 1.0 / this.getLength2());
            for (int i = 0; i < 3; ++i) {
                this.a1.addD(i, v1w[i], ret);
                this.a2.addD(i, -(v1w[i] + wv2[i]), ret);
                this.a3.addD(i, wv2[i], ret);
            }
            return ret;
        }

        public boolean isInvertB1() {
            return this.invertB1;
        }

        public boolean isInvertB2() {
            return this.invertB2;
        }
    }

    protected abstract class FFBond
    extends FFVector {
        protected int bondSeqInMol;
        protected double[] ivec;
        protected double[] inormalizedVec;
        private int type;
        protected int dihedralCount;

        @Override
        public String toString() {
            String s = "Bond " + super.toString();
            s = s + " bondSeqInMol: " + this.bondSeqInMol + " Type: " + this.type + " dihedralCount: " + this.dihedralCount;
            return s;
        }

        public FFBond(FFAtom atom1, FFAtom atom2, int type, int bondSeq) {
            super(atom1, atom2);
            this.bondSeqInMol = -1;
            this.dihedralCount = 0;
            this.type = type;
            this.bondSeqInMol = bondSeq;
            this.ivec = new double[3];
            this.inormalizedVec = new double[3];
        }

        public int getDihedralCount() {
            return this.dihedralCount;
        }

        public void incDihedralCount() {
            ++this.dihedralCount;
        }

        public int getBondSeqInMol() {
            return this.bondSeqInMol;
        }

        public int getType() {
            return this.type;
        }

        void calcGeom() {
            if (this.valuesFilled) {
                return;
            }
            this.vec[0] = this.a2.getCoordinate(0) - this.a1.getCoordinate(0);
            this.vec[1] = this.a2.getCoordinate(1) - this.a1.getCoordinate(1);
            this.vec[2] = this.a2.getCoordinate(2) - this.a1.getCoordinate(2);
            this.length = MolGeom.getLength(this.vec);
            V.copyV(this.normalizedVec, this.vec);
            V.normalizeSafe(this.normalizedVec);
            MolGeom.cpVec(this.vec, this.ivec);
            MolGeom.cpVec(this.normalizedVec, this.inormalizedVec);
            MolGeom.mul(this.inormalizedVec, -1.0);
            MolGeom.mul(this.ivec, -1.0);
            this.valuesFilled = true;
        }

        @Override
        public void calcFF() {
            this.calcGeom();
            super.calcFF();
        }
    }

    protected abstract class FFVector
    extends FFComponent {
        protected FFAtom a1;
        protected FFAtom a2;
        protected double[] vec;
        protected double[] normalizedVec;
        protected double length;
        protected boolean valuesFilled;
        protected double weight;

        public String toString() {
            DecimalFormat f = new DecimalFormat("0.00");
            String s = "between: " + (this.a1.getID() + 1) + " " + (this.a2.getID() + 1) + " L:" + f.format(this.length) + " weight: " + this.weight;
            return s;
        }

        public FFVector() {
            this.length = -1.0;
            this.valuesFilled = false;
            this.weight = 1.0;
            this.vec = new double[3];
            this.normalizedVec = new double[3];
        }

        public FFVector(FFAtom atom1, FFAtom atom2) {
            this();
            this.a1 = atom1;
            this.a2 = atom2;
        }

        public void setA1(FFAtom a1) {
            this.a1 = a1;
        }

        public void setA2(FFAtom a2) {
            this.a2 = a2;
        }

        public FFAtom getA1() {
            return this.a1;
        }

        public FFAtom getA2() {
            return this.a2;
        }

        public double getLength() {
            return this.length;
        }

        @Override
        public void calcFF() {
            this.calc_E_dE();
            CXNForceField.this.totalEnergy += this.getE();
            if (CXNForceField.this.wishDerivates && this.getDE() != 0.0) {
                this.a2.addD(0, this.normalizedVec[0] * this.getDE());
                this.a2.addD(1, this.normalizedVec[1] * this.getDE());
                this.a2.addD(2, this.normalizedVec[2] * this.getDE());
                this.a1.addD(0, this.normalizedVec[0] * this.getDE() * -1.0);
                this.a1.addD(1, this.normalizedVec[1] * this.getDE() * -1.0);
                this.a1.addD(2, this.normalizedVec[2] * this.getDE() * -1.0);
            }
        }

        @Override
        public void flush() {
            this.valuesFilled = false;
        }

        private void setWeight(double d) {
            this.weight = d;
        }
    }

    protected class FFPosRestr
    extends FFComponent {
        protected FFAtom a1;
        protected double[] vec;
        protected double[] normalizedVec;
        protected double length;
        protected boolean valuesFilled;
        protected double weight;
        private double x;
        private double y;
        private double z;

        public String toString() {
            DecimalFormat f = new DecimalFormat("0.00");
            String s = "Position restraint on: " + (this.a1.getID() + 1) + " " + " L:" + f.format(this.length) + " weight: " + this.weight;
            return s;
        }

        public FFPosRestr(FFAtom atom1, double weight, double x, double y, double z) {
            this.length = -1.0;
            this.valuesFilled = false;
            this.weight = 1.0;
            this.vec = new double[3];
            this.normalizedVec = new double[3];
            this.a1 = atom1;
            this.weight = weight;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        void calcGeom() {
            if (this.valuesFilled) {
                return;
            }
            this.vec[0] = this.x - this.a1.getCoordinate(0);
            this.vec[1] = this.y - this.a1.getCoordinate(1);
            this.vec[2] = this.z - this.a1.getCoordinate(2);
            this.length = MolGeom.getLength(this.vec);
            V.copyV(this.normalizedVec, this.vec);
            V.normalizeSafe(this.normalizedVec);
            this.valuesFilled = true;
        }

        @Override
        public void calcFF() {
            this.calc_E_dE();
            CXNForceField.this.totalEnergy += this.getE();
            if (CXNForceField.this.wishDerivates && this.getDE() != 0.0) {
                this.a1.addD(0, this.normalizedVec[0] * this.getDE() * -1.0);
                this.a1.addD(1, this.normalizedVec[1] * this.getDE() * -1.0);
                this.a1.addD(2, this.normalizedVec[2] * this.getDE() * -1.0);
            }
        }

        @Override
        public void flush() {
            this.valuesFilled = false;
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            this.e = 0.5 * this.weight * this.length * this.length;
            if (CXNForceField.this.wishDerivates) {
                this.dE = this.weight * this.weight;
            }
        }
    }

    public class FFAtom {
        private int atomSeqInMol;

        public FFAtom(int atomSequenceInMol) {
            this.atomSeqInMol = atomSequenceInMol;
        }

        public int getID() {
            return this.atomSeqInMol;
        }

        public boolean equals(FFAtom a) {
            return this.atomSeqInMol == a.getID();
        }

        public void addD(int i, double d) {
            this.addD(i, d, CXNForceField.this.gradient);
        }

        public void addD(int i, double d, double[] myGradient) {
            int n = this.atomSeqInMol * 3 + i;
            myGradient[n] = myGradient[n] + d;
        }

        public double getCoordinate(int i) {
            return CXNForceField.this.crd[this.atomSeqInMol * 3 + i];
        }

        public void setCoordinate(int i, double c) {
            CXNForceField.this.crd[this.atomSeqInMol * 3 + i] = c;
        }

        public int getPos() {
            return this.atomSeqInMol * 3;
        }

        public String toString() {
            String s = "AtomSeq: " + (this.atomSeqInMol + 1);
            return s;
        }
    }

    protected abstract class FFComponent {
        double e;
        double dE;

        protected FFComponent() {
        }

        public abstract void calcFF();

        protected abstract void calc_E_dE();

        public abstract void flush();

        public double getDE() {
            return this.dE;
        }

        public double getE() {
            return this.e;
        }
    }

    public static class FFComponentException
    extends Exception {
        public FFComponentException(String string) {
            super(string);
        }
    }
}

