/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm;

import chemaxon.marvin.alignment.ForceFieldInterface;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.mm.CXNForceField;
import chemaxon.marvin.modelling.mm.Dreiding;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class DreidingFFI
implements ForceFieldInterface {
    private Dreiding d;
    private CXNForceField.FFDihedral[] dihedrals;

    public DreidingFFI() {
        System.err.println("MODIFIED FFI");
        this.d = new Dreiding();
        double limit = 2.6179938779914944;
        this.d.setAngleTreatment(4);
        this.d.setAngleScaleUpperInterval(limit);
        this.d.setAngleScaleLowerInterval(0.5235987755982988);
        this.d.setAngleScaleAtDihedralsLimit(limit);
        this.d.setUseCorrectedInversionForm(true);
        this.d.setAngleScaleAtInversionLimit(limit);
        this.d.setCutOffForVDW(1.4);
        this.d.setVdwType(2);
        this.d.setCheckGradient(false);
        this.d.setAromatize(false);
        this.d.setVdwTopologySpeedUp(false);
    }

    @Override
    public void init(Molecule m) {
        this.d.init(m);
        ArrayList<CXNForceField.FFDihedral> tmp = new ArrayList<CXNForceField.FFDihedral>();
        for (Object object : this.d.ffComp) {
            if (!(object instanceof CXNForceField.FFDihedral)) continue;
            tmp.add((CXNForceField.FFDihedral)object);
        }
        this.dihedrals = tmp.toArray(new CXNForceField.FFDihedral[tmp.size()]);
    }

    @Override
    public double[][] optimize() {
        GradientOptimization g = new GradientOptimization(this.d);
        g.setGradientRMSLimit(0.001);
        try {
            g.run();
        }
        catch (GradientOptimization.GradientOptimizationException gg) {
            throw new RuntimeException(gg);
        }
        if (!g.isOptimizationConverged()) {
            throw new RuntimeException("Optimization was not converged");
        }
        return MolGeom.getCoordniates(this.d.getMoleculeWithLastUsedCoordinates());
    }

    @Override
    public void setCoordinates(double[][] crd) {
        double[] var = new double[3 * crd.length];
        for (int i = 0; i < crd.length; ++i) {
            var[3 * i] = crd[i][0];
            var[3 * i + 1] = crd[i][1];
            var[3 * i + 2] = crd[i][2];
        }
        this.d.setCrd(var);
        this.d.calc();
    }

    @Override
    public double dihedralEnergy(int a1, int a2) {
        double energy = 0.0;
        for (int i = 0; i < this.dihedrals.length; ++i) {
            if ((this.dihedrals[i].a2.getID() != a1 || this.dihedrals[i].a3.getID() != a2) && (this.dihedrals[i].a2.getID() != a2 || this.dihedrals[i].a3.getID() != a1)) continue;
            this.dihedrals[i].calcFF();
            energy += this.dihedrals[i].getE();
        }
        return energy;
    }

    @Override
    public double longRangeEnergy(int a1, int a2) {
        CXNForceField.FFVector vdw = this.d.vdw;
        CXNForceField.FFAtom[] atoms = this.d.atoms;
        int[][] atomPairsForLongRange = this.d.atomPairsForLongRange;
        for (int i = 0; i < atomPairsForLongRange.length; ++i) {
            if ((atomPairsForLongRange[i][0] != a1 || atomPairsForLongRange[i][1] != a2) && (atomPairsForLongRange[i][1] != a1 || atomPairsForLongRange[i][0] != a2)) continue;
            vdw.flush();
            vdw.setA1(atoms[atomPairsForLongRange[i][0]]);
            vdw.setA2(atoms[atomPairsForLongRange[i][1]]);
            vdw.calcFF();
            return vdw.getE();
        }
        return 0.0;
    }

    @Override
    public double dihedralGradient(int a1, int a2) {
        double grad = 0.0;
        for (int i = 0; i < this.dihedrals.length; ++i) {
            if ((this.dihedrals[i].a2.getID() != a1 || this.dihedrals[i].a3.getID() != a2) && (this.dihedrals[i].a2.getID() != a2 || this.dihedrals[i].a3.getID() != a1)) continue;
            this.dihedrals[i].flush();
            this.dihedrals[i].calc_E_dE();
            grad += this.dihedrals[i].getDE();
        }
        return grad;
    }

    @Override
    public double longRangeGradient(int a1, int a2) {
        CXNForceField.FFVector vdw = this.d.vdw;
        CXNForceField.FFAtom[] atoms = this.d.atoms;
        int[][] atomPairsForLongRange = this.d.atomPairsForLongRange;
        for (int i = 0; i < atomPairsForLongRange.length; ++i) {
            if ((atomPairsForLongRange[i][0] != a1 || atomPairsForLongRange[i][1] != a2) && (atomPairsForLongRange[i][1] != a1 || atomPairsForLongRange[i][0] != a2)) continue;
            vdw.flush();
            vdw.setA1(atoms[atomPairsForLongRange[i][0]]);
            vdw.setA2(atoms[atomPairsForLongRange[i][1]]);
            vdw.calcFF();
            return vdw.getDE();
        }
        return 0.0;
    }
}

