/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm;

import java.lang.reflect.Field;
import java.util.Vector;

public class MMDiagnosticObserver {
    public static final int FFTUNE_ANGLESCALEZERO = 1;
    public static final int FFTUNE_DIHEDRALDOWNSCALED = 2;
    public static final int FFTUNE_INVERSIONDOWNSCALED = 3;
    public static final int DRTUNE_ANGLELOWERREGION = 4;
    public static final int DRTUNE_HIDRAZINEDIH = 5;
    private static final int PUSTFI = 25;

    public static final String getTuneDescription(int tuneID) {
        switch (tuneID) {
            case 1: {
                return "Angle scale value 0.0 found";
            }
            case 2: {
                return "Dihedral energy component downscale region reached. Downscale can be disabled.";
            }
            case 3: {
                return "Inversion energy component downscale region reached. Downscale can be disabled.";
            }
            case 4: {
                return "Bond angle energy component lower angle region reached. Modified energy term can be disabled.";
            }
            case 5: {
                return "Dreiding sp2 Nitrogene neighbouring dihedral parametes tuning in Dreiding";
            }
        }
        throw new UnsupportedOperationException("Internal error. tuneID=" + tuneID + " unknown.");
    }

    public boolean isTuneEnabled(int tuneID) {
        return true;
    }

    public boolean isTuneEnabled(int tuneID, int iParam1, int iParam2) {
        return this.isTuneEnabled(tuneID);
    }

    public void notifyAngleEvaluation(int a1, int a2, int a3, double fi, double fi0) {
    }

    public void notifyDihedralEvaluation(int a1, int a2, int a3, int a4, double psi, double psi0) {
    }

    public void notifyInversionEvaluation(int a1, int a2, int a3, int a4, double fi, double fi0) {
    }

    public static final String getTuneShortName(int tuneID) {
        String ret = null;
        Field[] f = MMDiagnosticObserver.class.getDeclaredFields();
        for (int i = 0; i < f.length; ++i) {
            try {
                if ((f[i].getModifiers() & 0x19) != 25 || f[i].getInt(null) != tuneID) continue;
                if (ret == null) {
                    ret = f[i].getName();
                    continue;
                }
                ret = ret + "?" + f[i].getName();
                System.err.println("Multiple fields found for tuneID=" + tuneID + " " + ret);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UnsupportedOperationException("Internal error: " + e.getMessage());
            }
        }
        if (ret == null) {
            throw new UnsupportedOperationException("Internal error. tuneID=" + tuneID + " unknown.");
        }
        return ret;
    }

    public static final int getTuneID(String tuneShortName) {
        try {
            Field f = MMDiagnosticObserver.class.getField(tuneShortName);
            return f.getInt(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Internal error. Tune short name not found: " + tuneShortName);
        }
    }

    public static final String[] getTuneShortNames() {
        Vector<String> v = new Vector<String>();
        Field[] f = MMDiagnosticObserver.class.getDeclaredFields();
        for (int i = 0; i < f.length; ++i) {
            if ((f[i].getModifiers() & 0x19) != 25) continue;
            v.add(f[i].getName());
        }
        String[] ret = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            ret[i] = (String)v.get(i);
        }
        return ret;
    }
}

