/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.mm.mmff94.BondParameters;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.FFProviderHM;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraBondParameters;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BondHashMap
extends FFProviderHM {
    @Deprecated
    public FFComponentProvider getParams(int iType, int jType) {
        if (this.getParams(iType + " " + jType) != null) {
            return this.getParams(iType + " " + jType);
        }
        if (this.getParams(jType + " " + iType) != null) {
            return this.getParams(jType + " " + iType);
        }
        return null;
    }

    @Override
    public void xmlImport(XMLParser xml) {
        NodeList nl = xml.readParameters("bond");
        for (int i = 0; i < nl.getLength(); ++i) {
            BondParameters bp = new BondParameters();
            bp.setBt(Integer.parseInt(((Element)nl.item(i)).getAttribute("BT")));
            bp.setI(Integer.parseInt(((Element)nl.item(i)).getAttribute("i")));
            bp.setJ(Integer.parseInt(((Element)nl.item(i)).getAttribute("j")));
            bp.setKb(Double.parseDouble(((Element)nl.item(i)).getAttribute("kb")));
            bp.setR0(Double.parseDouble(((Element)nl.item(i)).getAttribute("r0")));
            bp.setSource(((Element)nl.item(i)).getAttribute("source"));
            bp.setSmiles(((Element)nl.item(i)).getAttribute("smiles"));
            String key = bp.getI() + " " + bp.getJ();
            this.addParams(key, bp);
        }
    }

    public double getOptimalValues(int[] atomIndeces, MMFFMolecule mol) {
        if (this.getParams(atomIndeces, mol) instanceof ExtraBondParameters) {
            return this.getParams(atomIndeces, mol).getOptimalValues()[0];
        }
        BondParameters bp = (BondParameters)this.getParams(atomIndeces, mol);
        if (bp.isMultipleFFComponentProvider()) {
            for (int i = 0; i < bp.size(); ++i) {
                BondParameters bp2 = (BondParameters)bp.getFFComponentProvider(i);
                if (Tools.getBondType(atomIndeces, mol) != bp2.getBt()) continue;
                return bp2.getOptimalValues()[0];
            }
        }
        return bp.getOptimalValues()[0];
    }
}

