/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.mm.mmff94.BondComponent;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.MultipleFFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.Tools;

public class BondParameters
extends MultipleFFComponentProvider
implements FFComponentProvider {
    private int bt;
    private int i;
    private int j;
    private double kb;
    private double r0;
    private String source;
    private String smiles;

    public int getBt() {
        return this.bt;
    }

    public void setBt(int bt) {
        this.bt = bt;
    }

    public int getI() {
        return this.i;
    }

    public void setI(int i) {
        this.i = i;
    }

    public int getJ() {
        return this.j;
    }

    public void setJ(int j) {
        this.j = j;
    }

    public double getKb() {
        return this.kb;
    }

    public void setKb(double kb) {
        this.kb = kb;
    }

    public double getR0() {
        return this.r0;
    }

    public void setR0(double r0) {
        this.r0 = r0;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSmiles() {
        return this.smiles;
    }

    public void setSmiles(String smiles) {
        this.smiles = smiles;
    }

    @Override
    public MMFFComponent getComponent(InternalCoordinate q, MMFFMolecule mol) {
        BondComponent bc = new BondComponent();
        if (!this.isMultipleFFComponentProvider()) {
            bc.setKb(this.kb);
            bc.setR0(this.r0);
            bc.setInternalCoordinate(q);
            return bc;
        }
        for (int i = 0; i < this.size(); ++i) {
            String smiles = ((BondParameters)this.getFFComponentProvider(i)).getSmiles();
            if (smiles == "") {
                bc.setKb(((BondParameters)this.getFFComponentProvider(i)).getKb());
                bc.setR0(((BondParameters)this.getFFComponentProvider(i)).getR0());
                bc.setInternalCoordinate(q);
                continue;
            }
            if (!Tools.isMatch(smiles, q.getAtomIndeces(), mol)) continue;
            bc.setKb(((BondParameters)this.getFFComponentProvider(i)).getKb());
            bc.setR0(((BondParameters)this.getFFComponentProvider(i)).getR0());
            bc.setInternalCoordinate(q);
        }
        return bc;
    }

    @Override
    public double[] getOptimalValues() {
        double[] optVal = new double[]{this.r0};
        return optVal;
    }
}

