/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.marvin.modelling.mm.mmff94.FFAtomType;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.Vector;

public class FFAtomTypeArray {
    private static Vector<FFAtomType> atomtypes;
    private static double[] fcharge;

    private void addAtomType(Molecule m, int type) {
        FFAtomType atomtype = new FFAtomType(m, type);
        atomtypes.add(atomtype);
    }

    private void addAtomType(String smiles, int type) {
        SmilesImport si = new SmilesImport();
        Molecule m = new Molecule();
        try {
            si.readMol(smiles, m);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addAtomType(m, type);
    }

    private FFAtomType getAtomType(int index) {
        return atomtypes.get(index);
    }

    public boolean setMoleculeProp(MMFFMolecule mol) {
        Molecule m = mol.getMolecule();
        m.aromatize(1);
        int[] molAtomTypes = new int[m.getAtomCount()];
        double[] molFormalCharges = new double[m.getAtomCount()];
        Substructure3DSearch ss = new Substructure3DSearch();
        ss.setIgnoreCharge(false);
        ss.setIgnoreQueryProperties(false);
        ss.setTarget(m);
        Molecule qm = new Molecule();
        for (int i = 0; i < atomtypes.size(); ++i) {
            int[] map;
            qm = this.getAtomType(i).getMolecule();
            ss.setQuery(qm.cloneMolecule());
            if (!ss.findFirst()) continue;
            while ((map = ss.getResult()) != null) {
                int iLabel = this.getAtomType(i).getLabel();
                molAtomTypes[map[iLabel]] = this.getAtomType(i).getType();
                molFormalCharges[map[iLabel]] = fcharge[i];
                if (ss.findNext()) continue;
            }
        }
        mol.setAtomTypes(molAtomTypes);
        mol.setFormalCharges(molFormalCharges);
        boolean allTypeisValid = true;
        for (int i = 0; i < molAtomTypes.length; ++i) {
            if (molAtomTypes[i] != 0) continue;
            allTypeisValid = false;
        }
        return allTypeisValid;
    }

    public FFAtomTypeArray(XMLParser xml) {
        atomtypes = new Vector();
        xml.readAtomtypes();
        for (int i = 0; i < xml.smiles.length; ++i) {
            this.addAtomType(xml.smiles[i], xml.type[i]);
        }
        fcharge = xml.fcharge;
    }

    public FFAtomTypeArray() {
        atomtypes = new Vector();
    }
}

