/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.mm.ForceField;
import chemaxon.marvin.modelling.mm.mmff94.MMFF94Exception;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.Parameters;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Vector;

public class MMFF94
implements ForceField {
    public static final int BOND_STRETCHING = 0;
    public static final int ANGLE_BENDING = 1;
    public static final int STRETCH_BENDING = 2;
    public static final int OUT_OF_PLANE = 3;
    public static final int TORSION = 4;
    public static final int COULOMB = 5;
    public static final int VAN_DER_WAALS = 6;
    private double SCALE_FOR_OPTIMIZER = 0.0015936001019904065;
    private double gradientRMSLimit = 1.0E-4;
    private static Parameters MMFF94_PARAMETERS;
    private Vector<MMFFMolecule> molecules = null;
    private MMFFMolecule calcMol;
    private static BitSet enabledEnergyComponent;
    private SimpleCanceller canceller = null;
    private boolean forceFieldCorrupted = false;

    public MMFF94() {
        MMFF94_PARAMETERS = Parameters.getMMFFParameters();
        MMFF94.enableAllEnergyComp();
    }

    public boolean init(Molecule[] mols) {
        this.molecules = new Vector();
        for (int i = 0; i < mols.length; ++i) {
            try {
                this.molecules.add(this.createMMFFMolecule(mols[i]));
                continue;
            }
            catch (MMFF94Exception e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean init(Molecule m) {
        try {
            this.calcMol = this.createMMFFMolecule(m);
        }
        catch (MMFF94Exception e) {
            return false;
        }
        return true;
    }

    private MMFFMolecule createMMFFMolecule(Molecule m) throws MMFF94Exception {
        MMFFMolecule mmffMol = new MMFFMolecule(m);
        mmffMol.setAllComponents(this.getAllComponents(mmffMol));
        mmffMol.setUsedComponents();
        if (mmffMol.isDummy()) {
            System.err.println("Warning!!! Dummy parameters!");
        }
        return mmffMol;
    }

    public static void enableAllEnergyComp() {
        enabledEnergyComponent.set(0, 7);
    }

    public static BitSet getEnabledComponent() {
        return enabledEnergyComponent;
    }

    public static boolean isEnabled(int component) {
        return enabledEnergyComponent.get(component);
    }

    public static void enable(int component) {
        enabledEnergyComponent.set(component, true);
    }

    public static void disable(int component) {
        enabledEnergyComponent.set(component, false);
    }

    @Override
    public void disableEnergyComponent(BitSet whatToCalc) {
        throw new UnsupportedOperationException("Not supported!");
    }

    private Vector<MMFFComponent> getAllComponents(MMFFMolecule calcMol) throws MMFF94Exception {
        Vector<MMFFComponent> allComponents = new Vector<MMFFComponent>();
        allComponents.clear();
        InternalCoordinate[] intCoords = calcMol.getIntCoordSystem().getInternalCoordinates();
        block7: for (int i = 0; i < intCoords.length; ++i) {
            int[] atomIndeces = intCoords[i].getAtomIndeces();
            switch (intCoords[i].getType()) {
                case 1: {
                    if (MMFF94_PARAMETERS.getBondHashMap().getParams(atomIndeces, calcMol) != null) {
                        allComponents.add(MMFF94_PARAMETERS.getBondHashMap().getParams(atomIndeces, calcMol).getComponent(intCoords[i], calcMol));
                        continue block7;
                    }
                    throw new MMFF94Exception("This bond parameter is not specified! Indeces: " + atomIndeces[0] + " " + atomIndeces[1]);
                }
                case 2: {
                    int at = Tools.getAngleType(atomIndeces, calcMol);
                    allComponents.add(MMFF94_PARAMETERS.getAngleHashMap().getParams(at, atomIndeces, calcMol).getComponent(intCoords[i], calcMol));
                    continue block7;
                }
                case 6: {
                    int at = Tools.getAngleType(atomIndeces, calcMol);
                    allComponents.add(MMFF94_PARAMETERS.getAngleHashMap().getParams(at, atomIndeces, calcMol).getComponent(intCoords[i], calcMol));
                    continue block7;
                }
                case 3: {
                    int torsType = Tools.getTorsionType(atomIndeces, calcMol);
                    if (MMFF94_PARAMETERS.getTorsionHashMap().getParams(torsType, atomIndeces, calcMol) == null) {
                        calcMol.getIntCoordSystem().removeInternalCoordinate(intCoords[i]);
                        continue block7;
                    }
                    allComponents.add(MMFF94_PARAMETERS.getTorsionHashMap().getParams(torsType, atomIndeces, calcMol).getComponent(intCoords[i], calcMol));
                    continue block7;
                }
                case 4: {
                    if (MMFF94_PARAMETERS.getOutOfPlanHashMap().getParams(atomIndeces, calcMol) != null) {
                        allComponents.add(MMFF94_PARAMETERS.getOutOfPlanHashMap().getParams(atomIndeces, calcMol).getComponent(intCoords[i], calcMol));
                        continue block7;
                    }
                    if (MMFF94_PARAMETERS.getOutOfPlanHashMap().getParams(0, Tools.getAtomType(atomIndeces[1], calcMol), 0, 0) != null) {
                        allComponents.add(MMFF94_PARAMETERS.getOutOfPlanHashMap().getParams(0, Tools.getAtomType(atomIndeces[1], calcMol), 0, 0).getComponent(intCoords[i], calcMol));
                        continue block7;
                    }
                    calcMol.getIntCoordSystem().removeInternalCoordinate(intCoords[i]);
                    continue block7;
                }
                default: {
                    calcMol.getIntCoordSystem().removeInternalCoordinate(intCoords[i]);
                }
            }
        }
        InternalCoordinate[] ic = calcMol.getIntCoordSystem().getInternalsForType(2);
        for (int i = 0; i < ic.length; ++i) {
            if (MMFF94_PARAMETERS.getStretchBendHashMap().getParams(ic[i].getAtomIndeces(), calcMol) != null) {
                int[] ai = ic[i].getAtomIndeces();
                int[][] ctab = calcMol.getMolecule().getCtab();
                if (Tools.getRing(ai, calcMol).length == 3 && calcMol.getMolecule().getAtom(ai[0]).getAtno() == 6 && calcMol.getMolecule().getAtom(ai[1]).getAtno() == 6 && calcMol.getMolecule().getAtom(ai[2]).getAtno() == 6 && ctab[ai[0]].length == 4 && ctab[ai[1]].length == 4 && ctab[ai[2]].length == 4) continue;
                int sbt = Tools.getStretchBendType(ic[i].getAtomIndeces(), calcMol);
                allComponents.add(MMFF94_PARAMETERS.getStretchBendHashMap().getParams(sbt, ic[i].getAtomIndeces(), calcMol).getComponent(ic[i], calcMol));
                continue;
            }
            throw new MMFF94Exception("A stretch bend parameter is not specified!");
        }
        allComponents.add(calcMol.getCharges());
        allComponents.add(calcMol.getVanDerWaals());
        return allComponents;
    }

    protected void calc() {
        if (this.calcMol.isCrdChanged()) {
            int i;
            this.calcMol.E = 0.0;
            for (i = 0; i < this.calcMol.grad.length; ++i) {
                this.calcMol.grad[i] = 0.0;
            }
            for (i = 0; i < this.calcMol.getUsedComponents().size(); ++i) {
                MMFFComponent comp = this.calcMol.getUsedComponents().get(i);
                this.calcMol.E += comp.getEnergy();
                comp.addGradient(this.calcMol.grad);
            }
            if (!U.isDoubleOK(this.calcMol.E) || !U.isDoubleOK(this.calcMol.grad)) {
                this.calcMol.E = Double.NaN;
                for (i = 0; i < this.calcMol.grad.length; ++i) {
                    this.calcMol.grad[i] = Double.NaN;
                }
            }
            this.calcMol.setCrdChanged(false);
        }
    }

    public boolean optimize() throws GradientOptimization.GradientOptimizationException {
        if (!this.calcMol.getMolecule().isEmpty()) {
            GradientOptimization g = new GradientOptimization(this);
            g.setGradientRMSLimit(this.gradientRMSLimit);
            return g.run();
        }
        return true;
    }

    public boolean optimizeAll() throws GradientOptimization.GradientOptimizationException {
        if (this.molecules == null) {
            return this.optimize();
        }
        boolean convAll = true;
        Iterator<MMFFMolecule> i$ = this.molecules.iterator();
        while (i$.hasNext()) {
            MMFFMolecule calcMol;
            this.calcMol = calcMol = i$.next();
            if (this.optimize()) continue;
            convAll = false;
        }
        return convAll;
    }

    @Override
    public double getEnergy() {
        this.calc();
        return this.calcMol.E;
    }

    @Override
    public double[] getForceFieldGradient() {
        this.calc();
        return this.calcMol.grad;
    }

    @Override
    public Molecule getMoleculeWithLastUsedCoordinates() {
        double[] crd = this.calcMol.getIntCoordSystem().getCartesianCoordinates();
        int j = 0;
        Molecule m = this.calcMol.getMolecule();
        for (int i = 0; i < m.getAtomCount(); ++i) {
            m.getAtom(i).setX(crd[j++]);
            m.getAtom(i).setY(crd[j++]);
            m.getAtom(i).setZ(crd[j++]);
        }
        return m;
    }

    public Molecule[] getMolecules(boolean withLastUsedCoordinates) {
        if (this.molecules == null) {
            return new Molecule[]{this.getMoleculeWithLastUsedCoordinates()};
        }
        Molecule[] ret = new Molecule[this.molecules.size()];
        if (withLastUsedCoordinates) {
            for (int i = 0; i < ret.length; ++i) {
                this.calcMol = this.molecules.get(i);
                ret[i] = this.getMoleculeWithLastUsedCoordinates();
            }
        } else {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.molecules.get(i).getMolecule();
            }
        }
        return ret;
    }

    public Vector<MMFFComponent> getMMFFComponents(int type) {
        return this.calcMol.getMMFFComponents(type);
    }

    public MMFFMolecule getMMFFMolecule() {
        return this.calcMol;
    }

    @Override
    public double[] getNumericDerivates() {
        return null;
    }

    @Override
    public double getScaleForOptimizer() {
        return this.SCALE_FOR_OPTIMIZER;
    }

    @Override
    public boolean isInit() {
        System.err.println("Not supported!!");
        return false;
    }

    @Override
    public void setAngleScaleAtDihedralsLimit(double angleScaleAtDihedralsLimit) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public void setAngleScaleAtInversionLimit(double angleScaleAtInversionLimit) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public double getEqulibriumBondLength(int atom1, int atom2) {
        double l = this.calcMol.getEqBondLength(atom1, atom2);
        System.err.println("INFO - getEqulibriumBondLength: " + atom1 + " " + atom2 + " - " + l);
        return l;
    }

    @Override
    public boolean isForceFieldCorrupted() {
        return this.forceFieldCorrupted;
    }

    @Override
    public void clearForceFieldCorrupted() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public void setCanceller(SimpleCanceller canceller) {
        this.canceller = canceller;
    }

    @Override
    public boolean isCancelled() {
        if (this.canceller == null) {
            return false;
        }
        return this.canceller.isCancelled();
    }

    public void copyCoordinatesFrom(double[] var) {
        this.calcMol.setCrdChanged(true);
        MolGeom.arrayCopy(var, this.calcMol.getCoordinates());
    }

    @Override
    public void setCrd(double[] crd) {
        this.calcMol.getIntCoordSystem().setCartesianCoordinates(crd);
    }

    @Override
    public void setScaleForOptimizer(double scale) {
        this.SCALE_FOR_OPTIMIZER = scale;
    }

    public void setGradientRMSLimit(double gradientRMSLimit) {
        this.gradientRMSLimit = gradientRMSLimit;
    }

    @Override
    public double[] getFunctionGradient() {
        this.calc();
        return JLinAlg.VectScale(this.calcMol.grad, this.SCALE_FOR_OPTIMIZER);
    }

    @Override
    public double getFunctionValue() {
        this.calc();
        return this.calcMol.E * this.SCALE_FOR_OPTIMIZER;
    }

    @Override
    public double[] getVariables() {
        return this.calcMol.getCoordinates();
    }

    @Override
    public void print() {
    }

    @Override
    public void print(String comment) {
    }

    @Override
    public boolean setVariables(double[] var) {
        this.calcMol.getIntCoordSystem().setCartesianCoordinates(var);
        this.calcMol.setCrdChanged(true);
        return true;
    }

    public double getLongRange_E(int a1, int a2) {
        return this.calcMol.getElectr_E(a1, a2) + this.calcMol.getVDW_E(a1, a2);
    }

    public double getLongRange_dE(int a1, int a2) {
        return this.calcMol.getElectr_dE(a1, a2) + this.calcMol.getVDW_dE(a1, a2);
    }

    static {
        enabledEnergyComponent = new BitSet();
    }
}

